/*
 * Decompiled with CFR 0.152.
 */
package soot.hj.HjToJimple.jimple;

import java.util.ArrayList;
import java.util.List;
import soot.Local;
import soot.RefType;
import soot.SootClass;
import soot.SootMethod;
import soot.Type;
import soot.Value;
import soot.ValueBox;
import soot.factory.LocalGenerator;
import soot.hj.HjToJimple.jimple.HjAbstractDistOper;
import soot.hj.HjToJimple.jimple.HjArrayOper;
import soot.hj.HjToJimple.util.HjValueBox;
import soot.jimple.AssignStmt;
import soot.jimple.Jimple;
import soot.jimple.Stmt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HjArrayOr
extends HjAbstractDistOper
implements HjArrayOper {
    protected ValueBox arrayValueBox;
    protected ValueBox rValBox;

    public HjArrayOr() {
    }

    public HjArrayOr(Value arrayValue, Value rVal) {
        this.arrayValueBox = new HjValueBox(arrayValue);
        this.rValBox = new HjValueBox(rVal);
    }

    @Override
    public List getUseBoxes() {
        ArrayList<ValueBox> useBoxes = new ArrayList<ValueBox>();
        List valUseBoxes = this.rValBox.getValue().getUseBoxes();
        if (valUseBoxes.size() == 0) {
            useBoxes.add(this.rValBox);
        } else {
            useBoxes.addAll(valUseBoxes);
        }
        useBoxes.add(this.arrayValueBox);
        valUseBoxes = this.arrayValueBox.getValue().getUseBoxes();
        if (valUseBoxes.size() == 0) {
            useBoxes.add(this.arrayValueBox);
        } else {
            useBoxes.addAll(valUseBoxes);
        }
        return useBoxes;
    }

    @Override
    public List<Stmt> generateStmts(LocalGenerator lg) {
        return this.generateStmts(null, lg);
    }

    @Override
    public List<Stmt> generateStmts(Value retValue, LocalGenerator lg) {
        Local arrayLocal;
        ArrayList<Stmt> stmts = new ArrayList<Stmt>();
        if (this.arrayValueBox.getValue() instanceof Local) {
            arrayLocal = (Local)this.arrayValueBox.getValue();
        } else {
            arrayLocal = lg.generateLocal(this.arrayValueBox.getValue().getType());
            stmts.add((Stmt)Jimple.v().newAssignStmt((Value)arrayLocal, this.arrayValueBox.getValue()));
        }
        ArrayList<Value> paramList = new ArrayList<Value>();
        ArrayList<Type> typeList = new ArrayList<Type>();
        paramList.add(this.rValBox.getValue());
        typeList.add(this.rValBox.getValue().getType());
        SootClass arrayClass = ((RefType)arrayLocal.getType()).getSootClass();
        SootMethod restMethod = arrayClass.getMethodFromCH("restriction", typeList, retValue.getType());
        AssignStmt assignStmt = Jimple.v().newAssignStmt(retValue, (Value)Jimple.v().newVirtualInvokeExpr(arrayLocal, restMethod.makeRef(), paramList));
        stmts.add((Stmt)assignStmt);
        return stmts;
    }

    @Override
    public Object clone() {
        return new HjArrayOr(this.arrayValueBox.getValue(), this.rValBox.getValue());
    }

    @Override
    public String toString() {
        return "HjArrayOr: " + this.arrayValueBox.getValue() + " | " + this.rValBox.getValue();
    }
}

