/*
 * Decompiled with CFR 0.152.
 */
package soot.hj.HjToJimple.jimple;

import java.util.ArrayList;
import java.util.List;
import soot.ArrayType;
import soot.Local;
import soot.NullType;
import soot.Type;
import soot.Unit;
import soot.UnitPrinter;
import soot.UnknownType;
import soot.Value;
import soot.ValueBox;
import soot.factory.LocalGenerator;
import soot.hj.HjToJimple.jimple.factory.HjMethodFactory;
import soot.hj.HjToJimple.jimple.utils.ArrayViewUtils;
import soot.hj.HjToJimple.util.HjValueBox;
import soot.hj.HjToJimple.util.Point;
import soot.jimple.ArrayRef;
import soot.jimple.AssignStmt;
import soot.jimple.InvokeExpr;
import soot.jimple.Jimple;
import soot.jimple.JimpleToBafContext;
import soot.jimple.Stmt;
import soot.jimple.internal.JArrayRef;
import soot.util.Switch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HjArrayRef
extends JArrayRef {
    protected Point point;

    public HjArrayRef(Value base, Point point) {
        super(base, null);
        this.baseBox = new HjValueBox(base);
        this.point = point;
    }

    public Object clone() {
        return new HjArrayRef(Jimple.v().cloneIfNecessary(this.getBase()), (Point)this.point.clone());
    }

    public boolean equivTo(Object o) {
        if (o instanceof ArrayRef) {
            ArrayRef other = (ArrayRef)o;
            return this.getBase().equivTo((Object)other.getBase()) && this.getIndex().equivTo((Object)other.getIndex());
        }
        return false;
    }

    public int equivHashCode() {
        return this.getBase().equivHashCode() * 101 + this.getIndex().equivHashCode() + 18;
    }

    public String toString() {
        if (this.indexBox != null) {
            return "HjArrayRef: " + this.baseBox.getValue().toString() + "[" + this.indexBox.getValue().toString() + "]";
        }
        return "HjArrayRef: " + this.baseBox.getValue().toString() + "[" + this.point.toString() + "]";
    }

    public void toString(UnitPrinter up) {
        up.literal(this.toString());
    }

    public Value getBase() {
        return this.baseBox.getValue();
    }

    public void setBase(Local base) {
        this.baseBox.setValue((Value)base);
    }

    public ValueBox getBaseBox() {
        return this.baseBox;
    }

    public Value getIndex() {
        return this.point.getIndexList().get(0);
    }

    public void setIndex(Value index) {
        this.point.getIndexBoxes().get(0).setValue(index);
    }

    public ValueBox getIndexBox() {
        return (ValueBox)this.point.getIndexBoxes().get(0);
    }

    public List getUseBoxes() {
        ArrayList<Object> useBoxes = new ArrayList<Object>();
        useBoxes.addAll(this.baseBox.getValue().getUseBoxes());
        useBoxes.add(this.baseBox);
        useBoxes.addAll(this.point.getIndexBoxes());
        return useBoxes;
    }

    public List<Stmt> genLeftOpStmts(Value leftOp, LocalGenerator lg) {
        Local arrayLocal;
        ArrayList<Stmt> stmts = new ArrayList<Stmt>();
        Value leftValue = leftOp;
        Value arrayValue = this.baseBox.getValue();
        if (arrayValue instanceof Local) {
            arrayLocal = (Local)arrayValue;
        } else {
            arrayLocal = lg.generateLocal(arrayValue.getType());
            stmts.add((Stmt)Jimple.v().newAssignStmt((Value)arrayLocal, arrayValue));
        }
        InvokeExpr invokeExpr = HjMethodFactory.getArrayValueMth(arrayLocal, this.point);
        AssignStmt assignStmt = Jimple.v().newAssignStmt(leftValue, (Value)invokeExpr);
        stmts.add((Stmt)assignStmt);
        return stmts;
    }

    public List<Stmt> genRightOpStmts(Value rightOp, LocalGenerator lg) {
        Local arrayLocal;
        Local rightLocal;
        ArrayList<Stmt> stmts = new ArrayList<Stmt>();
        if (rightOp instanceof Local) {
            rightLocal = (Local)rightOp;
        } else {
            rightLocal = lg.generateLocal(rightOp.getType());
            stmts.add((Stmt)Jimple.v().newAssignStmt((Value)rightLocal, rightOp));
        }
        Value arrayValue = this.baseBox.getValue();
        if (arrayValue instanceof Local) {
            arrayLocal = (Local)arrayValue;
        } else {
            arrayLocal = lg.generateLocal(arrayValue.getType());
            stmts.add((Stmt)Jimple.v().newAssignStmt((Value)arrayLocal, arrayValue));
        }
        InvokeExpr invokeExpr = HjMethodFactory.setArrayValueMth(arrayLocal, rightLocal, this.point, rightLocal.getType());
        stmts.add((Stmt)Jimple.v().newInvokeStmt((Value)invokeExpr));
        return stmts;
    }

    public Type getType() {
        Type type = this.getNormalType();
        type = ArrayViewUtils.getHjArrayViewPrimitiveType(type);
        return type;
    }

    protected Type getNormalType() {
        Value base = this.baseBox.getValue();
        Type type = base.getType();
        if (type.equals(UnknownType.v())) {
            return UnknownType.v();
        }
        if (type.equals(NullType.v())) {
            return NullType.v();
        }
        if (type instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)type;
            if (arrayType.numDimensions == 1) {
                return arrayType.baseType;
            }
            return ArrayType.v((Type)arrayType.baseType, (int)(arrayType.numDimensions - 1));
        }
        return type;
    }

    public void apply(Switch sw) {
        throw new RuntimeException("This should not happen " + (Object)((Object)this));
    }

    public void convertToBaf(JimpleToBafContext context, List<Unit> out) {
        throw new RuntimeException("This should not happen");
    }
}

