/*
 * Decompiled with CFR 0.152.
 */
package soot.hj.HjToJimple.jimple;

import soot.ArrayType;
import soot.Type;
import soot.TypeSwitch;
import soot.UnitPrinter;
import soot.util.Switch;

public class HjArrayType
extends ArrayType {
    public HjArrayType(Type baseType, int numDimensions) {
        super(baseType, numDimensions);
    }

    public static HjArrayType v(Type baseType, int numDimensions) {
        if (numDimensions < 1) {
            throw new RuntimeException("attempt to create array with " + numDimensions + " dimensions");
        }
        Object elementType = numDimensions == 1 ? baseType : HjArrayType.v(baseType, numDimensions - 1);
        ArrayType ret = elementType.getArrayType();
        if (ret == null || !(ret instanceof HjArrayType)) {
            ret = new HjArrayType(baseType, numDimensions);
            elementType.setArrayType(ret);
        }
        return (HjArrayType)ret;
    }

    public void toString(UnitPrinter up) {
        up.type(this.baseType);
        for (int i = 0; i < this.numDimensions; ++i) {
            up.literal("[]");
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.baseType.toString());
        for (int i = 0; i < this.numDimensions; ++i) {
            sb.append("[]");
        }
        return sb.toString();
    }

    public int hashCode() {
        return this.baseType.hashCode() + 1127088961 * this.numDimensions;
    }

    public void apply(Switch sw) {
        ((TypeSwitch)sw).caseArrayType((ArrayType)this);
    }

    public Type getArrayElementType() {
        return this.getElementType();
    }

    public Type getElementType() {
        return this.baseType;
    }

    public ArrayType makeArrayType() {
        return ArrayType.v((Type)this.baseType, (int)(this.numDimensions + 1));
    }
}

