/*
 * Decompiled with CFR 0.152.
 */
package soot.hj.HjToJimple.jimple;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import soot.ArrayType;
import soot.Local;
import soot.RefType;
import soot.SootClass;
import soot.SootMethod;
import soot.Type;
import soot.Value;
import soot.ValueBox;
import soot.factory.LocalGenerator;
import soot.hj.HjToJimple.jimple.HjAbstractArrayOper;
import soot.hj.HjToJimple.jimple.HjArrayOper;
import soot.hj.HjToJimple.jimple.Region;
import soot.hj.HjToJimple.jimple.utils.ArrayViewUtils;
import soot.hj.HjToJimple.util.Region_c;
import soot.jimple.AssignStmt;
import soot.jimple.InvokeStmt;
import soot.jimple.Jimple;
import soot.jimple.Stmt;
import soot.jimple.internal.ImmediateBox;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HjArrayViewConstructor
extends HjAbstractArrayOper
implements HjArrayOper {
    protected ValueBox baseArray;
    protected ValueBox offset;
    protected Region_c region;
    protected SootClass runtimeArrayViewClass;

    public HjArrayViewConstructor(Region region) {
        this.region = (Region_c)((Object)region);
    }

    public HjArrayViewConstructor(Value baseArray, Value offset, Value region, SootClass runtimeArrayViewClass) {
        this.baseArray = new ImmediateBox(baseArray);
        this.offset = new ImmediateBox(offset);
        this.region = new Region_c(region);
        this.runtimeArrayViewClass = runtimeArrayViewClass;
    }

    private HjArrayViewConstructor(ValueBox baseArray, ValueBox offset, Region_c region, SootClass runtimeArrayViewClass) {
        this.baseArray = baseArray;
        this.offset = offset;
        this.region = region;
        this.runtimeArrayViewClass = runtimeArrayViewClass;
    }

    @Override
    public Object clone() {
        return new HjArrayViewConstructor(this.baseArray, this.offset, this.region, this.runtimeArrayViewClass);
    }

    @Override
    public List getUseBoxes() {
        ArrayList<ValueBox> useBoxesList = new ArrayList<ValueBox>();
        ValueBox distVB = this.region.getLocalValueBox();
        List valUseBoxes = distVB.getValue().getUseBoxes();
        if (valUseBoxes.size() == 0) {
            useBoxesList.add(distVB);
        } else {
            useBoxesList.addAll(valUseBoxes);
        }
        useBoxesList.add(this.baseArray);
        useBoxesList.addAll(this.baseArray.getValue().getUseBoxes());
        useBoxesList.add(this.offset);
        useBoxesList.addAll(this.offset.getValue().getUseBoxes());
        return useBoxesList;
    }

    @Override
    public List getDefBoxes() {
        return Collections.emptyList();
    }

    @Override
    public Stmt generateStmt() {
        return this.generateStmt(null);
    }

    @Override
    public List<Stmt> generateStmts(LocalGenerator lg) {
        return this.generateStmts(null, lg);
    }

    @Override
    public List<Stmt> generateStmts(Value retValue, LocalGenerator lg) {
        ArrayList<Stmt> stmts = new ArrayList<Stmt>();
        SootMethod ccall = this.getArrayViewConstructor();
        List parameterList = this.getArgs();
        RefType arrayViewType = this.runtimeArrayViewClass.getType();
        Local arrayViewInstance = this.generateConstructorCall(lg, stmts, arrayViewType, ccall, parameterList);
        if (retValue != null) {
            stmts.add((Stmt)Jimple.v().newAssignStmt(retValue, (Value)arrayViewInstance));
        }
        return stmts;
    }

    private Local generateConstructorCall(LocalGenerator lg, ArrayList<Stmt> stmts, RefType arrayViewType, SootMethod ccall, List parameterList) {
        Local runtimeArrayViewType = lg.generateLocal((Type)arrayViewType);
        AssignStmt assignStmt = Jimple.v().newAssignStmt((Value)runtimeArrayViewType, (Value)Jimple.v().newNewExpr(arrayViewType));
        stmts.add((Stmt)assignStmt);
        InvokeStmt invokeStmt = Jimple.v().newInvokeStmt((Value)Jimple.v().newSpecialInvokeExpr(runtimeArrayViewType, ccall.makeRef(), parameterList));
        stmts.add((Stmt)invokeStmt);
        return runtimeArrayViewType;
    }

    protected SootMethod getArrayViewConstructor() {
        ArrayType baseArrayType = ArrayViewUtils.getHjArrayViewRuntimeBaseType((Type)this.runtimeArrayViewClass.getType()).getArrayType();
        Type offsetType = this.offset.getValue().getType();
        Type regionType = this.region.getLocalValue().getType();
        ArrayList<Object> parameterType = new ArrayList<Object>();
        parameterType.add(baseArrayType);
        parameterType.add(offsetType);
        parameterType.add(regionType);
        SootMethod ccall = this.runtimeArrayViewClass.getMethod("<init>", parameterType);
        return ccall;
    }

    @Override
    public Value getArg(int index) {
        return (Value)this.getArgs().get(index);
    }

    @Override
    public int getArgCount() {
        return this.getArgs().size();
    }

    @Override
    public List getArgs() {
        ArrayList<Value> l = new ArrayList<Value>();
        l.add(this.baseArray.getValue());
        l.add(this.offset.getValue());
        l.add(this.region.getLocalValue());
        return l;
    }

    @Override
    public String toString() {
        String str = "new arrayView(" + this.baseArray + "," + this.offset + "," + this.region + ")";
        return str;
    }

    public Type getType() {
        return this.runtimeArrayViewClass.getType();
    }
}

