/*
 * Decompiled with CFR 0.152.
 */
package soot.hj.HjToJimple.jimple;

import java.util.ArrayList;
import java.util.List;
import soot.Local;
import soot.RefType;
import soot.SootClass;
import soot.SootMethod;
import soot.Type;
import soot.Value;
import soot.ValueBox;
import soot.factory.LocalGenerator;
import soot.hj.HjToJimple.jimple.HjAbstractDistOper;
import soot.hj.HjToJimple.jimple.HjDistOper;
import soot.hj.HjToJimple.jimple.HjOperator;
import soot.hj.HjToJimple.util.Dist;
import soot.hj.HjToJimple.util.Dist_c;
import soot.hj.HjToJimple.util.HjValueBox;
import soot.jimple.AssignStmt;
import soot.jimple.Jimple;
import soot.jimple.Stmt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HjDistOr
extends HjAbstractDistOper
implements HjDistOper {
    protected Dist lDist;
    protected ValueBox rValBox;

    public HjDistOr() {
    }

    public HjDistOr(Value lDistValue, Value rVal) {
        this.lDist = new Dist_c(lDistValue);
        this.rValBox = new HjValueBox(rVal);
    }

    @Override
    public List getUseBoxes() {
        ArrayList<ValueBox> useBoxes = new ArrayList<ValueBox>();
        useBoxes.addAll(this.lDist.getUseBoxes());
        List valUseBoxes = this.rValBox.getValue().getUseBoxes();
        if (valUseBoxes.size() == 0) {
            useBoxes.add(this.rValBox);
        } else {
            useBoxes.addAll(valUseBoxes);
        }
        return useBoxes;
    }

    @Override
    public List<Stmt> generateStmts(LocalGenerator lg) {
        return this.generateStmts(null, lg);
    }

    @Override
    public List<Stmt> generateStmts(Value retValue, LocalGenerator lg) {
        Local rightLocal;
        Local distLocal;
        ArrayList<Stmt> stmts = new ArrayList<Stmt>();
        Value distValue = this.lDist.getDistValue();
        if (distValue instanceof Local) {
            distLocal = (Local)distValue;
        } else {
            distLocal = lg.generateLocal(distValue.getType());
            this.checkNestedHjOper(distValue, distLocal, stmts, lg);
        }
        ArrayList<Local> paramList = new ArrayList<Local>();
        ArrayList<Type> typeList = new ArrayList<Type>();
        Value rightValue = this.rValBox.getValue();
        if (rightValue instanceof Local) {
            rightLocal = (Local)rightValue;
        } else {
            rightLocal = lg.generateLocal(rightValue.getType());
            this.checkNestedHjOper(rightValue, rightLocal, stmts, lg);
        }
        paramList.add(rightLocal);
        typeList.add(rightLocal.getType());
        SootClass distClass = ((RefType)distLocal.getType()).getSootClass();
        SootMethod restMethod = distClass.getMethodFromCH("restriction", typeList, retValue.getType());
        AssignStmt assignStmt = Jimple.v().newAssignStmt(retValue, (Value)Jimple.v().newVirtualInvokeExpr(distLocal, restMethod.makeRef(), paramList));
        stmts.add((Stmt)assignStmt);
        return stmts;
    }

    protected void checkNestedHjOper(Value distValue, Local retLocal, List<Stmt> stmts, LocalGenerator lg) {
        if (distValue instanceof HjOperator) {
            Stmt stmt = ((HjOperator)distValue).generateStmt((Value)retLocal);
            if (stmt != null) {
                stmts.add(stmt);
            } else {
                stmts.addAll(((HjOperator)distValue).generateStmts((Value)retLocal, lg));
            }
        } else {
            stmts.add((Stmt)Jimple.v().newAssignStmt((Value)retLocal, distValue));
        }
    }

    @Override
    public Object clone() {
        return new HjDistOr(this.lDist.getDistValue(), this.rValBox.getValue());
    }

    @Override
    public String toString() {
        return "HjDistOr(" + this.lDist + " | " + this.rValBox.getValue() + ")";
    }

    @Override
    public Type getType() {
        return this.lDist.getDistValue().getType();
    }
}

