/*
 * Decompiled with CFR 0.152.
 */
package soot.hj.HjToJimple.jimple;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import soot.Body;
import soot.BodyTransformer;
import soot.Local;
import soot.Singletons;
import soot.SootField;
import soot.SootMethod;
import soot.Unit;
import soot.Value;
import soot.ValueBox;
import soot.hj.HjSingletons;
import soot.hj.HjToJimple.jimple.RegionStmt;
import soot.hj.HjToJimple.jimple.utils.RSTNodeMap;
import soot.hj.HjToJimple.util.RSTNode;
import soot.jimple.AssignStmt;
import soot.jimple.FieldRef;
import soot.jimple.Jimple;
import soot.jimple.Stmt;

public class HjFEMotionTranslator
extends BodyTransformer {
    private HashSet usesSet = new HashSet();

    public HjFEMotionTranslator(Singletons.Global g) {
    }

    public static HjFEMotionTranslator v() {
        return HjSingletons.v().soot_hj_HjToJimple_jimple_HjFEMotionTranslator();
    }

    protected void internalTransform(Body body, String phaseName, Map opts) {
        SootMethod method = body.getMethod();
        this.hjFEMotionTransform(body, phaseName, opts);
    }

    private void hjFEMotionTransform(Body body, String phaseName, Map opts) {
        RSTNode rootNode = RSTNodeMap.getRstNode(body.getMethod());
        this.forEachMotion(rootNode, body);
    }

    private void forEachMotion(RSTNode rstNode, Body body) {
        Iterator<RSTNode> nodeIter = rstNode.getSubNodes().iterator();
        while (nodeIter.hasNext()) {
            this.forEachMotion(nodeIter.next(), body);
        }
        this.usesSet.clear();
        ArrayList<Stmt> motionStmts = null;
        if (rstNode.isForEachNode()) {
            RegionStmt entryStmt = rstNode.getRegionStmt();
            Stmt exitStmt = entryStmt.getConnect();
            Iterator stmtIter = body.getUnits().iterator((Unit)entryStmt, (Unit)exitStmt);
            while (stmtIter.hasNext()) {
                Stmt stmt = (Stmt)stmtIter.next();
                if (!(stmt instanceof AssignStmt)) continue;
                Value leftOp = ((AssignStmt)stmt).getLeftOp();
                Value rightOp = ((AssignStmt)stmt).getRightOp();
                if (!(rightOp instanceof FieldRef)) continue;
                SootField field = ((FieldRef)rightOp).getField();
                if (field.isStatic() && field.isFinal() && !this.usesSet.contains(leftOp)) {
                    if (motionStmts != null) {
                        motionStmts.add(stmt);
                        continue;
                    }
                    motionStmts = new ArrayList<Stmt>();
                    motionStmts.add(stmt);
                    continue;
                }
                Iterator usesBoxIter = stmt.getUseBoxes().iterator();
                while (usesBoxIter.hasNext()) {
                    Value value = ((ValueBox)usesBoxIter.next()).getValue();
                    if (!(value instanceof Local) || this.usesSet.contains(value)) continue;
                    this.usesSet.add(value);
                }
                Iterator defsBoxIter = stmt.getDefBoxes().iterator();
                while (defsBoxIter.hasNext()) {
                    Value value = ((ValueBox)defsBoxIter.next()).getValue();
                    if (!(value instanceof Local) || this.usesSet.contains(value)) continue;
                    this.usesSet.add(value);
                }
            }
            if (motionStmts != null) {
                Stmt predStmt = (Stmt)body.getUnits().getPredOf((Unit)entryStmt);
                Iterator motionStmtIter = motionStmts.iterator();
                while (stmtIter.hasNext()) {
                    Stmt motionStmt = (Stmt)motionStmtIter.next();
                    body.getUnits().insertAfter((Unit)Jimple.v().newNopStmt(), (Unit)motionStmt);
                    body.getUnits().remove((Object)motionStmt);
                    body.getUnits().insertAfter((Unit)motionStmt, (Unit)predStmt);
                }
            }
        }
    }
}

