/*
 * Decompiled with CFR 0.152.
 */
package soot.hj.HjToJimple.jimple;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import soot.RefType;
import soot.Type;
import soot.Value;
import soot.hj.HjToJimple.jimple.FinishRegionExpr;
import soot.hj.HjToJimple.jimple.HjRegionEntry;
import soot.hj.HjToJimple.jimple.RegionExit;
import soot.hj.HjToJimple.util.HjValueBox;
import soot.hj.HjToJimple.util.Place;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HjFinishRegionExpr
extends HjRegionEntry
implements FinishRegionExpr {
    protected List<Place> places;
    protected List<HjValueBox> accumulators;

    public HjFinishRegionExpr() {
        this.places = new ArrayList<Place>();
    }

    public HjFinishRegionExpr(List<Place> places) {
        this.places = places;
    }

    public HjFinishRegionExpr(List<Place> places, RegionExit regionExit) {
        this.places = places;
        this.regionExit = regionExit;
    }

    @Override
    public void setPlaces(List<Place> places) {
        this.places = places;
    }

    @Override
    public List<Place> getPlaces() {
        return this.places;
    }

    @Override
    public boolean addPlace(Place place) {
        if (this.places.contains(place)) {
            return false;
        }
        this.places.add(place);
        return true;
    }

    @Override
    public void addPlaces(List<Place> placeList) {
        this.places.addAll(placeList);
    }

    @Override
    public boolean removePlace(Place place) {
        if (!this.places.contains(place)) {
            return false;
        }
        this.places.remove(place);
        return true;
    }

    @Override
    public boolean hasPlace(Place place) {
        return this.places.contains(place);
    }

    @Override
    public void addAccumulator(Value accumulator) {
        if (this.accumulators == null) {
            this.accumulators = new ArrayList<HjValueBox>();
        }
        this.accumulators.add(new HjValueBox(accumulator));
    }

    @Override
    public void addAccumulators(List<Value> accuList) {
        if (this.accumulators == null) {
            this.accumulators = new ArrayList<HjValueBox>();
        }
        for (Value accuVal : accuList) {
            this.accumulators.add(new HjValueBox(accuVal));
        }
    }

    @Override
    public List<Value> getAccumulators() {
        if (this.accumulators != null) {
            ArrayList<Value> accuList = new ArrayList<Value>();
            for (HjValueBox valueBox : this.accumulators) {
                accuList.add(valueBox.getValue());
            }
            return accuList;
        }
        return null;
    }

    @Override
    public List getUseBoxes() {
        ArrayList<HjValueBox> useBoxesList = new ArrayList<HjValueBox>();
        if (this.accumulators != null) {
            useBoxesList.addAll(this.accumulators);
        }
        Iterator<Place> placeIter = this.places.iterator();
        while (placeIter.hasNext()) {
            useBoxesList.addAll(placeIter.next().getUseBoxes());
        }
        return useBoxesList;
    }

    @Override
    public Type getType() {
        return RefType.v();
    }

    @Override
    public Object clone() {
        return new HjFinishRegionExpr(this.places, this.regionExit);
    }

    @Override
    public String toString() {
        return this.entryType() + "Region Entry";
    }

    @Override
    public String entryType() {
        return "Finish";
    }
}

