/*
 * Decompiled with CFR 0.152.
 */
package soot.hj.HjToJimple.jimple;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import polyglot.ast.Binary;
import soot.Body;
import soot.BodyTransformer;
import soot.BooleanType;
import soot.G;
import soot.IntType;
import soot.Local;
import soot.PatchingChain;
import soot.Scene;
import soot.Singletons;
import soot.SootClass;
import soot.SootFieldRef;
import soot.SootMethod;
import soot.Type;
import soot.Unit;
import soot.Value;
import soot.factory.LocalGenerator;
import soot.factory.SootFactory;
import soot.hj.HjSingletons;
import soot.hj.HjToJimple.HjUtil;
import soot.hj.HjToJimple.jimple.ActivityClassBuilder;
import soot.hj.HjToJimple.jimple.AsyncRegionExpr;
import soot.hj.HjToJimple.jimple.AtEachRegionExpr;
import soot.hj.HjToJimple.jimple.ForEachRegionExpr;
import soot.hj.HjToJimple.jimple.ForLoopRegionExpr;
import soot.hj.HjToJimple.jimple.HjJimple;
import soot.hj.HjToJimple.jimple.HjRegionStmt;
import soot.hj.HjToJimple.jimple.LoopRegionExpr;
import soot.hj.HjToJimple.jimple.NopRegionExpr;
import soot.hj.HjToJimple.jimple.Region;
import soot.hj.HjToJimple.jimple.RegionExit;
import soot.hj.HjToJimple.jimple.RegionStmt;
import soot.hj.HjToJimple.util.Dist;
import soot.hj.HjToJimple.util.LoopDomain;
import soot.hj.HjToJimple.util.Place_c;
import soot.hj.options.HjOptions;
import soot.jimple.AssignStmt;
import soot.jimple.CastExpr;
import soot.jimple.EqExpr;
import soot.jimple.GtExpr;
import soot.jimple.IfStmt;
import soot.jimple.IntConstant;
import soot.jimple.InterfaceInvokeExpr;
import soot.jimple.Jimple;
import soot.jimple.LeExpr;
import soot.jimple.NopStmt;
import soot.jimple.StaticFieldRef;
import soot.jimple.Stmt;
import soot.jimple.StmtBody;
import soot.jimple.VirtualInvokeExpr;
import soot.tagkit.Host;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HjHPIRToMPIRTranslator
extends BodyTransformer {
    public HjHPIRToMPIRTranslator(Singletons.Global g) {
    }

    public static HjHPIRToMPIRTranslator v() {
        return HjSingletons.v().soot_hj_HjToJimple_jimple_HjHPIRToMPIRTranslator();
    }

    protected void internalTransform(Body body, String phaseName, Map opts) {
        SootMethod method = body.getMethod();
        if (!body.getMethod().isStatic() && body.getThisLocal() == null) {
            throw new Error("H2M this local");
        }
        if (HjOptions.v().hjVerbose()) {
            G.v().out.println("HPIR: " + body);
        }
        this.hjHPIRToMPIRTransform(body, phaseName, opts);
        this.nopsElimination(body);
    }

    protected void nopsElimination(Body body) {
        Iterator unitIter = body.getUnits().snapshotIterator();
        while (unitIter.hasNext()) {
            RegionStmt regionStmt;
            Unit unit = (Unit)unitIter.next();
            if (unit instanceof NopStmt) {
                if (unit.getBoxesPointingToThis().size() != 0) continue;
                body.getUnits().remove((Object)unit);
                continue;
            }
            if (!(unit instanceof RegionStmt) || !((regionStmt = (RegionStmt)unit).getRegionExpr() instanceof NopRegionExpr)) continue;
            NopRegionExpr nopRegionExpr = (NopRegionExpr)regionStmt.getRegionExpr();
            if (unit.getBoxesPointingToThis().size() != 0 || nopRegionExpr.getNopValue() != null) continue;
            body.getUnits().remove((Object)unit);
        }
    }

    protected void hjHPIRToMPIRTransform(Body body, String phaseName, Map opts) {
        StmtBody stmtBody = (StmtBody)body;
        PatchingChain units = stmtBody.getUnits();
        HashMap<Stmt, ArrayList<Stmt>> rtStmtMap = new HashMap<Stmt, ArrayList<Stmt>>();
        ArrayList<Stmt> removeStmts = new ArrayList<Stmt>();
        Iterator stmtIt = units.iterator();
        while (stmtIt.hasNext()) {
            Stmt stmt = (Stmt)stmtIt.next();
            if (!(stmt instanceof RegionStmt)) continue;
            Region regionExpr = ((RegionStmt)stmt).getRegionExpr();
            if (regionExpr instanceof ForEachRegionExpr) {
                this.handleForEachRegion((RegionStmt)stmt, body, stmtIt, rtStmtMap, removeStmts);
                continue;
            }
            if (regionExpr instanceof ForLoopRegionExpr) {
                this.handleForLoopRegion((RegionStmt)stmt, body, stmtIt, rtStmtMap, removeStmts);
                continue;
            }
            if (regionExpr instanceof AtEachRegionExpr) {
                this.handleAtEachRegion((RegionStmt)stmt, body, stmtIt, rtStmtMap, removeStmts);
                continue;
            }
            if (!(regionExpr instanceof LoopRegionExpr)) continue;
            if (((LoopRegionExpr)regionExpr).isLabeled()) {
                this.handleLoopRegion((RegionStmt)stmt, body, stmtIt, rtStmtMap, removeStmts);
                continue;
            }
            this.handleIrregularLoopRegion((RegionStmt)stmt, body, stmtIt, rtStmtMap, removeStmts);
        }
        for (Stmt stmt : rtStmtMap.keySet()) {
            ArrayList rtStmts = (ArrayList)rtStmtMap.get(stmt);
            for (Stmt rtStmt : rtStmts) {
                body.getUnits().insertAfter((Unit)rtStmt, (Unit)stmt);
                stmt = rtStmt;
            }
        }
        Iterator stmtIter = removeStmts.iterator();
        while (stmtIter.hasNext()) {
            body.getUnits().remove(stmtIter.next());
        }
    }

    protected Local generateRegionCall(LoopDomain loopDomain, LocalGenerator lg, Local factoryLocal, SootClass hjRegionClass, SootClass hjRegionFactoryClass, SootMethod regionIntMethod, ArrayList<Stmt> stmtList) {
        AssignStmt assignStmt;
        Local regionLocal;
        VirtualInvokeExpr virtualInvoke;
        ArrayList<Local> paramsList = new ArrayList<Local>();
        ArrayList<Object> typesList = new ArrayList<Object>();
        if (loopDomain.hasSubDomains()) {
            Iterator<LoopDomain> domainIter = loopDomain.getSubDomains().iterator();
            while (domainIter.hasNext()) {
                paramsList.add(this.generateRegionCall(domainIter.next(), lg, factoryLocal, hjRegionClass, hjRegionFactoryClass, regionIntMethod, stmtList));
                typesList.add(hjRegionClass.getType());
            }
        } else {
            if (loopDomain.getDomainValue() != null) {
                return (Local)loopDomain.getDomainValue();
            }
            ArrayList<Value> regionParams = new ArrayList<Value>();
            regionParams.add(loopDomain.getInitialValue());
            regionParams.add(loopDomain.getTerminalValue());
            virtualInvoke = Jimple.v().newVirtualInvokeExpr(factoryLocal, regionIntMethod.makeRef(), regionParams);
            regionLocal = lg.generateLocal((Type)hjRegionClass.getType());
            assignStmt = Jimple.v().newAssignStmt((Value)regionLocal, (Value)virtualInvoke);
            stmtList.add((Stmt)assignStmt);
            paramsList.add(regionLocal);
            typesList.add(regionLocal.getType());
        }
        SootMethod regionRefMethod = hjRegionFactoryClass.getMethod("region", typesList, (Type)hjRegionClass.getType());
        virtualInvoke = Jimple.v().newVirtualInvokeExpr(factoryLocal, regionRefMethod.makeRef(), paramsList);
        regionLocal = lg.generateLocal((Type)hjRegionClass.getType());
        assignStmt = Jimple.v().newAssignStmt((Value)regionLocal, (Value)virtualInvoke);
        stmtList.add((Stmt)assignStmt);
        return regionLocal;
    }

    protected void generateRegionIterator(Iterator<Local> localIter, Body body, LocalGenerator lg, Local iterLocal, SootClass javaIterClass, ArrayList<Stmt> stmtList) {
        SootClass hjPointClass = Scene.v().getSootClass("hj.lang.point");
        SootClass objectClass = Scene.v().getSootClass("java.lang.Object");
        SootMethod nextMethod = javaIterClass.getMethod("next", Collections.EMPTY_LIST, (Type)objectClass.getType());
        InterfaceInvokeExpr interfaceInvoke = Jimple.v().newInterfaceInvokeExpr(iterLocal, nextMethod.makeRef(), Collections.EMPTY_LIST);
        Local objectLocal = lg.generateLocal((Type)objectClass.getType());
        AssignStmt assignStmt = Jimple.v().newAssignStmt((Value)objectLocal, (Value)interfaceInvoke);
        stmtList.add((Stmt)assignStmt);
        CastExpr castExpr = Jimple.v().newCastExpr((Value)objectLocal, (Type)hjPointClass.getType());
        Local pointLocal = lg.generateLocal(castExpr.getCastType());
        AssignStmt castAssign = Jimple.v().newAssignStmt((Value)pointLocal, (Value)castExpr);
        stmtList.add((Stmt)castAssign);
        ArrayList<IntType> typesList = new ArrayList<IntType>();
        typesList.add(IntType.v());
        SootMethod pointGetMethod = hjPointClass.getMethod("get", typesList, (Type)IntType.v());
        int dimCount = 0;
        while (localIter.hasNext()) {
            Local domainLocal = localIter.next();
            ArrayList<IntConstant> paramList = new ArrayList<IntConstant>();
            paramList.add(IntConstant.v((int)dimCount++));
            VirtualInvokeExpr virtualInvoke = Jimple.v().newVirtualInvokeExpr(pointLocal, pointGetMethod.makeRef(), paramList);
            assignStmt = Jimple.v().newAssignStmt((Value)domainLocal, (Value)virtualInvoke);
            stmtList.add((Stmt)assignStmt);
        }
    }

    protected void handleForEachRegion(RegionStmt forEachRegionStmt, Body body, Iterator<Stmt> stmtIt, HashMap<Stmt, ArrayList<Stmt>> rtStmtMap, ArrayList<Stmt> removeStmts) {
        ForEachRegionExpr forEachRegion = (ForEachRegionExpr)forEachRegionStmt.getRegionExpr();
        ArrayList<Stmt> predStmts = new ArrayList<Stmt>();
        ArrayList<RegionStmt> succStmts = new ArrayList<RegionStmt>();
        SootClass hjPointClass = Scene.v().getSootClass("hj.lang.point");
        SootClass hjRegionClass = Scene.v().getSootClass("hj.lang.region");
        SootClass hjRegionFactoryClass = Scene.v().getSootClass("hj.lang.region$factory");
        SootClass javaIterClass = Scene.v().getSootClass("java.util.Iterator");
        LocalGenerator lg = SootFactory.v().getLocalGenerator(body);
        ArrayList<IntType> regionIntParams = new ArrayList<IntType>();
        regionIntParams.add(IntType.v());
        regionIntParams.add(IntType.v());
        SootMethod regionIntMethod = hjRegionFactoryClass.getMethod("region", regionIntParams, (Type)hjRegionClass.getType());
        SootFieldRef sootField = Scene.v().makeFieldRef(hjRegionClass, "factory", (Type)hjRegionFactoryClass.getType(), true);
        StaticFieldRef fieldRef = Jimple.v().newStaticFieldRef(sootField);
        Local factoryLocal = lg.generateLocal((Type)hjRegionFactoryClass.getType());
        predStmts.add((Stmt)Jimple.v().newAssignStmt((Value)factoryLocal, (Value)fieldRef));
        Local regionLocal = this.generateRegionCall(forEachRegion.getDomains(), lg, factoryLocal, hjRegionClass, hjRegionFactoryClass, regionIntMethod, predStmts);
        ArrayList iterParams = new ArrayList();
        SootMethod iterMethod = hjRegionClass.getMethod("iterator", iterParams, (Type)javaIterClass.getType());
        VirtualInvokeExpr virtualInvoke = Jimple.v().newVirtualInvokeExpr(regionLocal, iterMethod.makeRef(), Collections.EMPTY_LIST);
        Local iterLocal = lg.generateLocal((Type)javaIterClass.getType());
        AssignStmt assignStmt = Jimple.v().newAssignStmt((Value)iterLocal, (Value)virtualInvoke);
        predStmts.add((Stmt)assignStmt);
        SootMethod hasNextMethod = javaIterClass.getMethod("hasNext", Collections.EMPTY_LIST, (Type)BooleanType.v());
        InterfaceInvokeExpr interfaceInvoke = Jimple.v().newInterfaceInvokeExpr(iterLocal, hasNextMethod.makeRef(), Collections.EMPTY_LIST);
        Local hasNextLocal = lg.generateLocal((Type)BooleanType.v());
        assignStmt = Jimple.v().newAssignStmt((Value)hasNextLocal, (Value)interfaceInvoke);
        predStmts.add((Stmt)assignStmt);
        AssignStmt loopEntryLabel = assignStmt;
        NopStmt loopExitLabel = Jimple.v().newNopStmt();
        EqExpr condExpr = Jimple.v().newEqExpr((Value)hasNextLocal, (Value)IntConstant.v((int)0));
        IfStmt ifStmt = Jimple.v().newIfStmt((Value)condExpr, (Unit)loopExitLabel);
        predStmts.add((Stmt)ifStmt);
        this.generateRegionIterator(forEachRegion.getLocals().iterator(), body, lg, iterLocal, javaIterClass, predStmts);
        AsyncRegionExpr asyncEntryExpr = ((HjJimple)Jimple.v()).newAsyncRegionExpr();
        RegionExit asyncExitExpr = ((HjJimple)Jimple.v()).newRegionExitExpr(asyncEntryExpr);
        asyncEntryExpr.setExit(asyncExitExpr);
        asyncExitExpr.setEntry(asyncEntryExpr);
        asyncEntryExpr.setPhasers(forEachRegion.getPhasers());
        asyncEntryExpr.setPlaces(forEachRegion.getPlaces());
        RegionStmt asyncEntryStmt = ((HjJimple)Jimple.v()).newRegionStmt(asyncEntryExpr);
        HjUtil.copyLnPosTags((Host)forEachRegionStmt, (Host)asyncEntryStmt);
        predStmts.add((Stmt)asyncEntryStmt);
        RegionExit regionExitExpr = forEachRegion.getExit();
        Stmt regionExitStmt = null;
        Stmt stmt = null;
        do {
            if (!((stmt = stmtIt.next()) instanceof RegionStmt)) continue;
            if (((RegionStmt)stmt).getRegionExpr() instanceof ForEachRegionExpr) {
                this.handleForEachRegion((RegionStmt)stmt, body, stmtIt, rtStmtMap, removeStmts);
                continue;
            }
            if (((RegionStmt)stmt).getRegionExpr() instanceof ForLoopRegionExpr) {
                this.handleForLoopRegion((RegionStmt)stmt, body, stmtIt, rtStmtMap, removeStmts);
                continue;
            }
            if (((RegionStmt)stmt).getRegionExpr() instanceof AtEachRegionExpr) {
                this.handleAtEachRegion((RegionStmt)stmt, body, stmtIt, rtStmtMap, removeStmts);
                continue;
            }
            if (!(((RegionStmt)stmt).getRegionExpr() instanceof LoopRegionExpr)) continue;
            Region regionExpr = ((RegionStmt)stmt).getRegionExpr();
            if (((LoopRegionExpr)regionExpr).isLabeled()) {
                this.handleLoopRegion((RegionStmt)stmt, body, stmtIt, rtStmtMap, removeStmts);
                continue;
            }
            this.handleIrregularLoopRegion((RegionStmt)stmt, body, stmtIt, rtStmtMap, removeStmts);
        } while (!(stmt instanceof RegionStmt) || ((RegionStmt)stmt).getRegionExpr() != regionExitExpr);
        regionExitStmt = stmt;
        RegionStmt asyncExitStmt = ((HjJimple)Jimple.v()).newRegionStmt(asyncExitExpr);
        HjRegionStmt.setConnect(asyncEntryStmt, asyncExitStmt);
        succStmts.add(asyncExitStmt);
        succStmts.add((RegionStmt)Jimple.v().newGotoStmt((Unit)loopEntryLabel));
        succStmts.add((RegionStmt)loopExitLabel);
        rtStmtMap.put((Stmt)forEachRegionStmt, predStmts);
        rtStmtMap.put(regionExitStmt, succStmts);
        removeStmts.add((Stmt)forEachRegionStmt);
        removeStmts.add(regionExitStmt);
    }

    protected Stmt generateRegionRanks(Iterator<Local> localIter, Body body, LocalGenerator lg, Local regionLocal, SootClass regionClass, SootMethod rankMethod, SootMethod lowMethod, SootMethod highMethod, int rankCount, ArrayList<Stmt> predStmts, ArrayList<Stmt> succStmts, Stmt loopExitLabel) {
        IfStmt loopEntryLabel = null;
        if (localIter.hasNext()) {
            ArrayList<IntConstant> rankParams = new ArrayList<IntConstant>();
            rankParams.add(IntConstant.v((int)rankCount++));
            VirtualInvokeExpr virtualInvoke = Jimple.v().newVirtualInvokeExpr(regionLocal, rankMethod.makeRef(), rankParams);
            Local rankLocal = lg.generateLocal((Type)regionClass.getType());
            AssignStmt assignStmt = Jimple.v().newAssignStmt((Value)rankLocal, (Value)virtualInvoke);
            predStmts.add((Stmt)assignStmt);
            virtualInvoke = Jimple.v().newVirtualInvokeExpr(rankLocal, lowMethod.makeRef(), Collections.EMPTY_LIST);
            Local loopIterLocal = lg.generateLocal((Type)IntType.v());
            assignStmt = Jimple.v().newAssignStmt((Value)loopIterLocal, (Value)virtualInvoke);
            predStmts.add((Stmt)assignStmt);
            virtualInvoke = Jimple.v().newVirtualInvokeExpr(rankLocal, highMethod.makeRef(), Collections.EMPTY_LIST);
            Local termLocal = lg.generateLocal((Type)IntType.v());
            assignStmt = Jimple.v().newAssignStmt((Value)termLocal, (Value)virtualInvoke);
            predStmts.add((Stmt)assignStmt);
            NopStmt newLoopExitLabel = Jimple.v().newNopStmt();
            GtExpr condExpr = Jimple.v().newGtExpr((Value)loopIterLocal, (Value)termLocal);
            IfStmt ifStmt = Jimple.v().newIfStmt((Value)condExpr, (Unit)loopExitLabel);
            predStmts.add((Stmt)ifStmt);
            loopEntryLabel = ifStmt;
            Local iterLocal = localIter.next();
            assignStmt = Jimple.v().newAssignStmt((Value)iterLocal, (Value)loopIterLocal);
            predStmts.add((Stmt)assignStmt);
            this.generateRegionRanks(localIter, body, lg, regionLocal, regionClass, rankMethod, lowMethod, highMethod, rankCount, predStmts, succStmts, (Stmt)newLoopExitLabel);
            succStmts.add((Stmt)newLoopExitLabel);
            assignStmt = Jimple.v().newAssignStmt((Value)loopIterLocal, (Value)Jimple.v().newAddExpr((Value)loopIterLocal, (Value)IntConstant.v((int)1)));
            succStmts.add((Stmt)assignStmt);
            succStmts.add((Stmt)Jimple.v().newGotoStmt((Unit)loopEntryLabel));
        }
        return loopEntryLabel;
    }

    protected void handleForLoopRegion(RegionStmt forLoopRegionStmt, Body body, Iterator<Stmt> stmtIt, HashMap<Stmt, ArrayList<Stmt>> rtStmtMap, ArrayList<Stmt> removeStmts) {
        ForLoopRegionExpr forLoopRegion = (ForLoopRegionExpr)forLoopRegionStmt.getRegionExpr();
        ArrayList<Stmt> predStmts = new ArrayList<Stmt>();
        ArrayList<Stmt> succStmts = new ArrayList<Stmt>();
        SootClass hjPointClass = Scene.v().getSootClass("hj.lang.point");
        SootClass hjRegionClass = Scene.v().getSootClass("hj.lang.region");
        SootClass hjRegionFactoryClass = Scene.v().getSootClass("hj.lang.region$factory");
        SootClass javaIterClass = Scene.v().getSootClass("java.util.Iterator");
        LocalGenerator lg = SootFactory.v().getLocalGenerator(body);
        ArrayList<IntType> regionIntParams = new ArrayList<IntType>();
        regionIntParams.add(IntType.v());
        regionIntParams.add(IntType.v());
        SootMethod regionIntMethod = hjRegionFactoryClass.getMethod("region", regionIntParams, (Type)hjRegionClass.getType());
        SootFieldRef sootField = Scene.v().makeFieldRef(hjRegionClass, "factory", (Type)hjRegionFactoryClass.getType(), true);
        StaticFieldRef fieldRef = Jimple.v().newStaticFieldRef(sootField);
        Local factoryLocal = lg.generateLocal((Type)hjRegionFactoryClass.getType());
        predStmts.add((Stmt)Jimple.v().newAssignStmt((Value)factoryLocal, (Value)fieldRef));
        Local regionLocal = this.generateRegionCall(forLoopRegion.getDomains(), lg, factoryLocal, hjRegionClass, hjRegionFactoryClass, regionIntMethod, predStmts);
        SootMethod sizeMethod = hjRegionClass.getMethod("size", Collections.EMPTY_LIST, (Type)IntType.v());
        VirtualInvokeExpr virtualInvoke = Jimple.v().newVirtualInvokeExpr(regionLocal, sizeMethod.makeRef(), Collections.EMPTY_LIST);
        Local sizeLocal = lg.generateLocal((Type)IntType.v());
        AssignStmt assignStmt = Jimple.v().newAssignStmt((Value)sizeLocal, (Value)virtualInvoke);
        predStmts.add((Stmt)assignStmt);
        Stmt loopExitLabel = forLoopRegion.getLoopExits().iterator().next();
        Stmt loopContLabel = forLoopRegion.getBackEdges().iterator().next();
        EqExpr condExpr = Jimple.v().newEqExpr((Value)sizeLocal, (Value)IntConstant.v((int)0));
        IfStmt ifStmt = Jimple.v().newIfStmt((Value)condExpr, (Unit)loopExitLabel);
        predStmts.add((Stmt)ifStmt);
        ArrayList<IntType> rankParams = new ArrayList<IntType>();
        rankParams.add(IntType.v());
        SootMethod rankMethod = hjRegionClass.getMethod("rank", rankParams, (Type)hjRegionClass.getType());
        SootMethod lowMethod = hjRegionClass.getMethod("low", Collections.EMPTY_LIST, (Type)IntType.v());
        SootMethod highMethod = hjRegionClass.getMethod("high", Collections.EMPTY_LIST, (Type)IntType.v());
        Stmt loopEntryLabel = this.generateRegionRanks(forLoopRegion.getLocals().iterator(), body, lg, regionLocal, hjRegionClass, rankMethod, lowMethod, highMethod, 0, predStmts, succStmts, loopExitLabel);
        RegionExit regionExitExpr = forLoopRegion.getExit();
        Stmt regionExitStmt = null;
        Stmt stmt = null;
        do {
            if (!((stmt = stmtIt.next()) instanceof RegionStmt)) continue;
            if (((RegionStmt)stmt).getRegionExpr() instanceof ForEachRegionExpr) {
                this.handleForEachRegion((RegionStmt)stmt, body, stmtIt, rtStmtMap, removeStmts);
                continue;
            }
            if (((RegionStmt)stmt).getRegionExpr() instanceof ForLoopRegionExpr) {
                this.handleForLoopRegion((RegionStmt)stmt, body, stmtIt, rtStmtMap, removeStmts);
                continue;
            }
            if (((RegionStmt)stmt).getRegionExpr() instanceof AtEachRegionExpr) {
                this.handleAtEachRegion((RegionStmt)stmt, body, stmtIt, rtStmtMap, removeStmts);
                continue;
            }
            if (!(((RegionStmt)stmt).getRegionExpr() instanceof LoopRegionExpr)) continue;
            Region regionExpr = ((RegionStmt)stmt).getRegionExpr();
            if (((LoopRegionExpr)regionExpr).isLabeled()) {
                this.handleLoopRegion((RegionStmt)stmt, body, stmtIt, rtStmtMap, removeStmts);
                continue;
            }
            this.handleIrregularLoopRegion((RegionStmt)stmt, body, stmtIt, rtStmtMap, removeStmts);
        } while (!(stmt instanceof RegionStmt) || ((RegionStmt)stmt).getRegionExpr() != regionExitExpr);
        regionExitStmt = stmt;
        rtStmtMap.put((Stmt)forLoopRegionStmt, predStmts);
        rtStmtMap.put(loopContLabel, succStmts);
        removeStmts.add(loopExitLabel);
        removeStmts.add(loopContLabel);
        removeStmts.add((Stmt)forLoopRegionStmt);
        removeStmts.add(regionExitStmt);
    }

    protected void handleAtEachRegion(RegionStmt atEachRegionStmt, Body body, Iterator stmtIt, HashMap<Stmt, ArrayList<Stmt>> rtStmtMap, ArrayList<Stmt> removeStmts) {
        AtEachRegionExpr atEachRegion = (AtEachRegionExpr)atEachRegionStmt.getRegionExpr();
        ArrayList<Object> predStmts = new ArrayList<Object>();
        ArrayList<RegionStmt> succStmts = new ArrayList<RegionStmt>();
        SootClass hjPointClass = ActivityClassBuilder.v().hjPointClass;
        SootClass javaIterClass = ActivityClassBuilder.v().javaIterClass;
        SootClass javaObjectClass = ActivityClassBuilder.v().javaObjectClass;
        SootClass hjLangPlaceClass = ActivityClassBuilder.v().hjLPlaceClass;
        LocalGenerator lg = SootFactory.v().getLocalGenerator(body);
        Local distLocal = null;
        Dist dist = atEachRegion.getDist();
        if (dist == null) {
            throw new RuntimeException("Can't find the dist object for AtEach loop");
        }
        Value distValue = dist.getDistValue();
        if (distValue instanceof Local) {
            distLocal = (Local)distValue;
        } else {
            distLocal = lg.generateLocal((Type)Scene.v().getSootClass("hj.lang.dist").getType());
            predStmts.add(Jimple.v().newAssignStmt((Value)distLocal, distValue));
        }
        VirtualInvokeExpr virtualInvoke = Jimple.v().newVirtualInvokeExpr(distLocal, ActivityClassBuilder.v().distIterMethod.makeRef(), Collections.EMPTY_LIST);
        Local iterLocal = lg.generateLocal((Type)javaIterClass.getType());
        AssignStmt assignStmt = Jimple.v().newAssignStmt((Value)iterLocal, (Value)virtualInvoke);
        predStmts.add(assignStmt);
        InterfaceInvokeExpr interfaceInvoke = Jimple.v().newInterfaceInvokeExpr(iterLocal, ActivityClassBuilder.v().iterHasNextMethod.makeRef(), Collections.EMPTY_LIST);
        Local hasNextLocal = lg.generateLocal((Type)BooleanType.v());
        assignStmt = Jimple.v().newAssignStmt((Value)hasNextLocal, (Value)interfaceInvoke);
        predStmts.add(assignStmt);
        AssignStmt loopEntryLabel = assignStmt;
        NopStmt loopExitLabel = Jimple.v().newNopStmt();
        EqExpr condExpr = Jimple.v().newEqExpr((Value)hasNextLocal, (Value)IntConstant.v((int)0));
        IfStmt ifStmt = Jimple.v().newIfStmt((Value)condExpr, (Unit)loopExitLabel);
        predStmts.add(ifStmt);
        interfaceInvoke = Jimple.v().newInterfaceInvokeExpr(iterLocal, ActivityClassBuilder.v().iterNextMethod.makeRef(), Collections.EMPTY_LIST);
        Local objectLocal = lg.generateLocal((Type)javaObjectClass.getType());
        assignStmt = Jimple.v().newAssignStmt((Value)objectLocal, (Value)interfaceInvoke);
        predStmts.add(assignStmt);
        CastExpr castExpr = Jimple.v().newCastExpr((Value)objectLocal, (Type)hjPointClass.getType());
        Local pointLocal = lg.generateLocal(castExpr.getCastType());
        AssignStmt castAssign = Jimple.v().newAssignStmt((Value)pointLocal, (Value)castExpr);
        predStmts.add(castAssign);
        List<IntType> typesList = Collections.singletonList(IntType.v());
        SootMethod pointGetMethod = hjPointClass.getMethod("get", typesList, (Type)IntType.v());
        Iterator<Local> localIter = atEachRegion.getLocals().iterator();
        int indexCounter = 0;
        while (localIter.hasNext()) {
            Local indexLocal = localIter.next();
            List<IntConstant> paramList = Collections.singletonList(IntConstant.v((int)indexCounter++));
            assignStmt = Jimple.v().newAssignStmt((Value)indexLocal, (Value)Jimple.v().newVirtualInvokeExpr(pointLocal, pointGetMethod.makeRef(), paramList));
            predStmts.add(assignStmt);
        }
        List<Local> getParamList = Collections.singletonList(pointLocal);
        virtualInvoke = Jimple.v().newVirtualInvokeExpr(distLocal, ActivityClassBuilder.v().distGetMethod.makeRef(), getParamList);
        Local langPlaceLocal = lg.generateLocal((Type)hjLangPlaceClass.getType());
        assignStmt = Jimple.v().newAssignStmt((Value)langPlaceLocal, (Value)virtualInvoke);
        predStmts.add(assignStmt);
        AsyncRegionExpr asyncEntryExpr = ((HjJimple)Jimple.v()).newAsyncRegionExpr();
        RegionExit asyncExitExpr = ((HjJimple)Jimple.v()).newRegionExitExpr(asyncEntryExpr);
        asyncEntryExpr.setExit(asyncExitExpr);
        asyncExitExpr.setEntry(asyncEntryExpr);
        asyncEntryExpr.setPhasers(atEachRegion.getPhasers());
        asyncEntryExpr.addPlace(new Place_c(langPlaceLocal));
        RegionStmt asyncEntryStmt = ((HjJimple)Jimple.v()).newRegionStmt(asyncEntryExpr);
        HjUtil.copyLnPosTags((Host)atEachRegionStmt, (Host)asyncEntryStmt);
        predStmts.add(asyncEntryStmt);
        RegionExit regionExitExpr = atEachRegion.getExit();
        Stmt regionExitStmt = null;
        Stmt stmt = null;
        do {
            if (!((stmt = (Stmt)stmtIt.next()) instanceof RegionStmt)) continue;
            if (((RegionStmt)stmt).getRegionExpr() instanceof ForEachRegionExpr) {
                this.handleForEachRegion((RegionStmt)stmt, body, stmtIt, rtStmtMap, removeStmts);
                continue;
            }
            if (((RegionStmt)stmt).getRegionExpr() instanceof ForLoopRegionExpr) {
                this.handleForLoopRegion((RegionStmt)stmt, body, stmtIt, rtStmtMap, removeStmts);
                continue;
            }
            if (((RegionStmt)stmt).getRegionExpr() instanceof AtEachRegionExpr) {
                this.handleAtEachRegion((RegionStmt)stmt, body, stmtIt, rtStmtMap, removeStmts);
                continue;
            }
            if (!(((RegionStmt)stmt).getRegionExpr() instanceof LoopRegionExpr)) continue;
            Region regionExpr = ((RegionStmt)stmt).getRegionExpr();
            if (((LoopRegionExpr)regionExpr).isLabeled()) {
                this.handleLoopRegion((RegionStmt)stmt, body, stmtIt, rtStmtMap, removeStmts);
                continue;
            }
            this.handleIrregularLoopRegion((RegionStmt)stmt, body, stmtIt, rtStmtMap, removeStmts);
        } while (!(stmt instanceof RegionStmt) || ((RegionStmt)stmt).getRegionExpr() != regionExitExpr);
        regionExitStmt = stmt;
        RegionStmt asyncExitStmt = ((HjJimple)Jimple.v()).newRegionStmt(asyncExitExpr);
        HjRegionStmt.setConnect(asyncEntryStmt, asyncExitStmt);
        succStmts.add(asyncExitStmt);
        succStmts.add((RegionStmt)Jimple.v().newGotoStmt((Unit)loopEntryLabel));
        succStmts.add((RegionStmt)loopExitLabel);
        rtStmtMap.put((Stmt)atEachRegionStmt, predStmts);
        rtStmtMap.put(regionExitStmt, succStmts);
        removeStmts.add((Stmt)atEachRegionStmt);
        removeStmts.add(regionExitStmt);
    }

    protected void handleLoopRegion(RegionStmt loopRegionStmt, Body body, Iterator stmtIt, HashMap<Stmt, ArrayList<Stmt>> rtStmtMap, ArrayList<Stmt> removeStmts) {
        LoopRegionExpr loopRegion = (LoopRegionExpr)loopRegionStmt.getRegionExpr();
        Stmt regionExitStmt = loopRegionStmt.getConnect();
        if (HjOptions.v().hjVerbose()) {
            G.v().out.println("Handle Loop Region 1: " + body.getMethod());
        }
        if (loopRegion.isLabeled()) {
            AssignStmt assignStmt;
            LeExpr condExpr;
            Local tempLocal;
            Stmt loopContLabel;
            if (HjOptions.v().hjVerbose()) {
                G.v().out.println("Handle Loop Regin: " + body.getMethod());
            }
            ArrayList<Object> predStmts = new ArrayList<Object>();
            ArrayList<Object> succStmts = new ArrayList<Object>();
            LocalGenerator lg = SootFactory.v().getLocalGenerator(body);
            Stmt loopExitLabel = loopRegion.getLoopExits().iterator().next();
            if (loopExitLabel == (loopContLabel = loopRegion.getBackEdges().iterator().next())) {
                loopExitLabel = (Stmt)body.getUnits().getSuccOf((Unit)loopContLabel);
            }
            LoopDomain domain = loopRegion.getDomains();
            Local iterLocal = loopRegion.getLocals().iterator().next();
            Value initVal = domain.getInitialValue();
            Value termVal = domain.getTerminalValue();
            Value strideVal = domain.getStrideValue();
            if (initVal instanceof Local) {
                tempLocal = lg.generateLocal(initVal.getType());
                predStmts.add(Jimple.v().newAssignStmt((Value)tempLocal, initVal));
                initVal = tempLocal;
            }
            if (termVal instanceof Local) {
                tempLocal = lg.generateLocal(termVal.getType());
                predStmts.add(Jimple.v().newAssignStmt((Value)tempLocal, termVal));
                termVal = tempLocal;
            }
            if (strideVal instanceof Local) {
                tempLocal = lg.generateLocal(strideVal.getType());
                predStmts.add(Jimple.v().newAssignStmt((Value)tempLocal, strideVal));
                strideVal = tempLocal;
            }
            predStmts.add(Jimple.v().newAssignStmt((Value)iterLocal, initVal));
            if (domain.getDomainOper() == Binary.GT) {
                condExpr = Jimple.v().newLeExpr((Value)iterLocal, termVal);
            } else if (domain.getDomainOper() == Binary.LT) {
                condExpr = Jimple.v().newGeExpr((Value)iterLocal, termVal);
            } else if (domain.getDomainOper() == Binary.EQ) {
                condExpr = Jimple.v().newNeExpr((Value)iterLocal, termVal);
            } else if (domain.getDomainOper() == Binary.LE) {
                condExpr = Jimple.v().newGtExpr((Value)iterLocal, termVal);
            } else if (domain.getDomainOper() == Binary.GE) {
                condExpr = Jimple.v().newLtExpr((Value)iterLocal, termVal);
            } else if (domain.getDomainOper() == Binary.NE) {
                condExpr = Jimple.v().newEqExpr((Value)iterLocal, termVal);
            } else {
                throw new RuntimeException("Unsupport loop bound operation: " + domain.getDomainOper());
            }
            IfStmt ifStmt = Jimple.v().newIfStmt((Value)condExpr, (Unit)loopExitLabel);
            predStmts.add(ifStmt);
            IfStmt loopEntryLabel = ifStmt;
            Stmt stmt = null;
            do {
                if (!((stmt = (Stmt)stmtIt.next()) instanceof RegionStmt)) continue;
                if (((RegionStmt)stmt).getRegionExpr() instanceof ForEachRegionExpr) {
                    this.handleForEachRegion((RegionStmt)stmt, body, stmtIt, rtStmtMap, removeStmts);
                    continue;
                }
                if (((RegionStmt)stmt).getRegionExpr() instanceof ForLoopRegionExpr) {
                    this.handleForLoopRegion((RegionStmt)stmt, body, stmtIt, rtStmtMap, removeStmts);
                    continue;
                }
                if (((RegionStmt)stmt).getRegionExpr() instanceof AtEachRegionExpr) {
                    this.handleAtEachRegion((RegionStmt)stmt, body, stmtIt, rtStmtMap, removeStmts);
                    continue;
                }
                if (!(((RegionStmt)stmt).getRegionExpr() instanceof LoopRegionExpr)) continue;
                Region regionExpr = ((RegionStmt)stmt).getRegionExpr();
                if (((LoopRegionExpr)regionExpr).isLabeled()) {
                    this.handleLoopRegion((RegionStmt)stmt, body, stmtIt, rtStmtMap, removeStmts);
                    continue;
                }
                this.handleIrregularLoopRegion((RegionStmt)stmt, body, stmtIt, rtStmtMap, removeStmts);
            } while (stmt != regionExitStmt);
            if (domain.getStrideOper() == Binary.ADD) {
                assignStmt = Jimple.v().newAssignStmt((Value)iterLocal, (Value)Jimple.v().newAddExpr((Value)iterLocal, strideVal));
            } else if (domain.getStrideOper() == Binary.SUB) {
                assignStmt = Jimple.v().newAssignStmt((Value)iterLocal, (Value)Jimple.v().newSubExpr((Value)iterLocal, strideVal));
            } else {
                throw new RuntimeException("Unsupported loop iteration operation: " + domain.getStrideOper());
            }
            succStmts.add(assignStmt);
            succStmts.add(Jimple.v().newGotoStmt((Unit)loopEntryLabel));
            rtStmtMap.put((Stmt)loopRegionStmt, predStmts);
            rtStmtMap.put(loopContLabel, succStmts);
            removeStmts.add(loopContLabel);
            removeStmts.add(loopExitLabel);
        }
        removeStmts.add((Stmt)loopRegionStmt);
        removeStmts.add(regionExitStmt);
    }

    protected void handleIrregularLoopRegion(RegionStmt loopRegionStmt, Body body, Iterator<Stmt> stmtIt, HashMap<Stmt, ArrayList<Stmt>> rtStmtMap, ArrayList<Stmt> removeStmts) {
        removeStmts.add((Stmt)loopRegionStmt);
        RegionStmt regionExitStmt = (RegionStmt)loopRegionStmt.getConnect();
        Stmt stmt = null;
        do {
            if (!((stmt = stmtIt.next()) instanceof RegionStmt)) continue;
            if (((RegionStmt)stmt).getRegionExpr() instanceof ForEachRegionExpr) {
                this.handleForEachRegion((RegionStmt)stmt, body, stmtIt, rtStmtMap, removeStmts);
                continue;
            }
            if (((RegionStmt)stmt).getRegionExpr() instanceof ForLoopRegionExpr) {
                this.handleForLoopRegion((RegionStmt)stmt, body, stmtIt, rtStmtMap, removeStmts);
                continue;
            }
            if (((RegionStmt)stmt).getRegionExpr() instanceof AtEachRegionExpr) {
                this.handleAtEachRegion((RegionStmt)stmt, body, stmtIt, rtStmtMap, removeStmts);
                continue;
            }
            if (!(((RegionStmt)stmt).getRegionExpr() instanceof LoopRegionExpr)) continue;
            Region regionExpr = ((RegionStmt)stmt).getRegionExpr();
            if (((LoopRegionExpr)regionExpr).isLabeled()) {
                this.handleLoopRegion((RegionStmt)stmt, body, stmtIt, rtStmtMap, removeStmts);
                continue;
            }
            this.handleIrregularLoopRegion((RegionStmt)stmt, body, stmtIt, rtStmtMap, removeStmts);
        } while (stmt != regionExitStmt);
        if (!(regionExitStmt.getRegionExpr() instanceof RegionExit)) {
            throw new Error("Can not find the exit of loop region");
        }
        removeStmts.add((Stmt)regionExitStmt);
    }
}

