/*
 * Decompiled with CFR 0.152.
 */
package soot.hj.HjToJimple.jimple;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import soot.Local;
import soot.RefType;
import soot.Type;
import soot.Unit;
import soot.Value;
import soot.hj.HjToJimple.jimple.HjRegionEntry;
import soot.hj.HjToJimple.jimple.LoopRegionExpr;
import soot.hj.HjToJimple.jimple.RegionExit;
import soot.hj.HjToJimple.jimple.RegionStmt;
import soot.hj.HjToJimple.util.HjValueBox;
import soot.hj.HjToJimple.util.LoopDomain;
import soot.jimple.Jimple;
import soot.jimple.Stmt;
import soot.jimple.internal.StmtBox;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HjLoopRegionExpr
extends HjRegionEntry
implements LoopRegionExpr {
    protected StmtBox entryStmtBox;
    protected List<Stmt> exitStmts;
    protected List<Stmt> backEdgeStmts;
    protected List<StmtBox> exitStmtBoxes;
    protected List<StmtBox> backEdgeStmtBoxes;
    protected List<Local> locals;
    protected LoopDomain domains;
    protected boolean hasBranch;

    public HjLoopRegionExpr() {
        this.exitStmts = new ArrayList<Stmt>();
        this.exitStmtBoxes = new ArrayList<StmtBox>();
        this.backEdgeStmts = new ArrayList<Stmt>();
        this.backEdgeStmtBoxes = new ArrayList<StmtBox>();
        this.locals = new ArrayList<Local>();
    }

    public HjLoopRegionExpr(Stmt entryStmt, List<Stmt> exitStmts, List<Stmt> backEdgeStmts) {
        this.entryStmtBox = (StmtBox)Jimple.v().newStmtBox((Unit)entryStmt);
        this.exitStmts = exitStmts;
        this.exitStmtBoxes = new ArrayList<StmtBox>();
        Iterator<Stmt> exitIter = exitStmts.iterator();
        while (exitIter.hasNext()) {
            this.exitStmtBoxes.add((StmtBox)Jimple.v().newStmtBox((Unit)exitIter.next()));
        }
        this.backEdgeStmts = backEdgeStmts;
        this.backEdgeStmtBoxes = new ArrayList<StmtBox>();
        Iterator<Stmt> backEdgeIter = backEdgeStmts.iterator();
        while (backEdgeIter.hasNext()) {
            this.backEdgeStmtBoxes.add((StmtBox)Jimple.v().newStmtBox((Unit)backEdgeIter.next()));
        }
    }

    public HjLoopRegionExpr(Stmt entryStmt, List<Stmt> exitStmts, List<Stmt> backEdgeStmts, RegionExit regionExit) {
        this(entryStmt, exitStmts, backEdgeStmts);
        this.regionExit = regionExit;
    }

    @Override
    public boolean isLabeled() {
        return this.domains != null;
    }

    @Override
    public void addLocal(Local local) {
        this.locals.add(local);
    }

    @Override
    public List<Local> getLocals() {
        return this.locals;
    }

    @Override
    public void addLocals(List<Local> localList) {
        this.locals.addAll(localList);
    }

    @Override
    public void setLocals(List<Local> localList) {
        this.locals = localList;
    }

    @Override
    public void setDomains(LoopDomain domains) {
        this.domains = domains;
    }

    @Override
    public LoopDomain getDomains() {
        return this.domains;
    }

    @Override
    public Stmt getLoopEntry() {
        return (Stmt)this.entryStmtBox.getUnit();
    }

    @Override
    public void setLoopEntry(Stmt entryStmt) {
        if (this.entryStmtBox == null) {
            this.entryStmtBox = (StmtBox)Jimple.v().newStmtBox((Unit)entryStmt);
        } else {
            this.entryStmtBox.setUnit((Unit)entryStmt);
        }
    }

    @Override
    public List<Stmt> getLoopExits() {
        ArrayList<Stmt> exitList = new ArrayList<Stmt>();
        Iterator<StmtBox> exitBoxIter = this.exitStmtBoxes.iterator();
        while (exitBoxIter.hasNext()) {
            exitList.add((Stmt)exitBoxIter.next().getUnit());
        }
        return exitList;
    }

    @Override
    public void addLoopExit(Stmt exitStmt) {
        this.exitStmts.add(exitStmt);
        this.exitStmtBoxes.add((StmtBox)Jimple.v().newStmtBox((Unit)exitStmt));
    }

    @Override
    public void setLoopExits(List<Stmt> exitList) {
        this.exitStmts = exitList;
        this.exitStmtBoxes.clear();
        Iterator<Stmt> exitIter = this.exitStmts.iterator();
        while (exitIter.hasNext()) {
            this.exitStmtBoxes.add((StmtBox)Jimple.v().newStmtBox((Unit)exitIter.next()));
        }
    }

    @Override
    public List<Stmt> getBackEdges() {
        ArrayList<Stmt> backEdgeList = new ArrayList<Stmt>();
        Iterator<StmtBox> backEdgeBoxIter = this.backEdgeStmtBoxes.iterator();
        while (backEdgeBoxIter.hasNext()) {
            backEdgeList.add((Stmt)backEdgeBoxIter.next().getUnit());
        }
        return backEdgeList;
    }

    @Override
    public void addBackEdge(Stmt backEdgeStmt) {
        this.backEdgeStmts.add(backEdgeStmt);
        this.backEdgeStmtBoxes.add((StmtBox)Jimple.v().newStmtBox((Unit)backEdgeStmt));
    }

    @Override
    public void setBackEdges(List<Stmt> backEdgeStmts) {
        this.backEdgeStmts = backEdgeStmts;
        this.backEdgeStmtBoxes.clear();
        Iterator<Stmt> backEdgeIter = backEdgeStmts.iterator();
        while (backEdgeIter.hasNext()) {
            this.backEdgeStmtBoxes.add((StmtBox)Jimple.v().newStmtBox((Unit)backEdgeIter.next()));
        }
    }

    @Override
    public boolean hasBranch() {
        return this.hasBranch;
    }

    @Override
    public void hasBranch(boolean value) {
        this.hasBranch = value;
    }

    @Override
    public List getUseBoxes() {
        if (this.domains != null) {
            ArrayList<HjValueBox> useBoxesList = new ArrayList<HjValueBox>();
            useBoxesList.addAll(this.domains.getUseBoxes());
            Iterator<Local> localIter = this.locals.iterator();
            while (localIter.hasNext()) {
                useBoxesList.add(new HjValueBox((Value)localIter.next()));
            }
            return useBoxesList;
        }
        return Collections.emptyList();
    }

    public List getUseUnits() {
        ArrayList<StmtBox> useBoxList = new ArrayList<StmtBox>();
        useBoxList.add(this.entryStmtBox);
        useBoxList.addAll(this.exitStmtBoxes);
        useBoxList.addAll(this.backEdgeStmtBoxes);
        return useBoxList;
    }

    @Override
    public Type getType() {
        return RefType.v();
    }

    @Override
    public Object clone() {
        return new HjLoopRegionExpr((Stmt)this.entryStmtBox.getUnit(), this.exitStmts, this.backEdgeStmts, this.regionExit);
    }

    @Override
    public String toString() {
        if (this.domains == null) {
            String str = this.entryType() + "Region Entry";
            Stmt stmt = (Stmt)this.entryStmtBox.getUnit();
            str = stmt instanceof RegionStmt ? str + "\n Entry Stmt: " + ((RegionStmt)stmt).entryType() : str + "\n Entry Stmt: " + stmt;
            str = str + "\n Exit Stmt: ";
            Iterator<StmtBox> exitBoxIter = this.exitStmtBoxes.iterator();
            while (exitBoxIter.hasNext()) {
                stmt = (Stmt)exitBoxIter.next().getUnit();
                if (stmt instanceof RegionStmt) {
                    str = str + ((RegionStmt)stmt).entryType() + " ";
                    continue;
                }
                str = str + stmt + " ";
            }
            str = str + "\n BackEdge Stmt: ";
            Iterator<StmtBox> backEdgeBoxIter = this.backEdgeStmtBoxes.iterator();
            while (backEdgeBoxIter.hasNext()) {
                stmt = (Stmt)backEdgeBoxIter.next().getUnit();
                if (stmt instanceof RegionStmt) {
                    str = str + ((RegionStmt)stmt).entryType() + " ";
                    continue;
                }
                str = str + stmt + " ";
            }
            return str;
        }
        String str = this.entryType() + "Region Entry Locals: ";
        Iterator<Local> localIter = this.locals.iterator();
        while (localIter.hasNext()) {
            str = str + localIter.next() + " ";
        }
        str = str + "\n Region Loop Domains: " + this.domains;
        Stmt stmt = (Stmt)this.entryStmtBox.getUnit();
        str = stmt instanceof RegionStmt ? str + "\n Entry Stmt: " + ((RegionStmt)stmt).entryType() : str + "\n Entry Stmt: " + stmt;
        str = str + "\n Exit Stmt: ";
        Iterator<StmtBox> exitBoxIter = this.exitStmtBoxes.iterator();
        while (exitBoxIter.hasNext()) {
            stmt = (Stmt)exitBoxIter.next().getUnit();
            if (stmt instanceof RegionStmt) {
                str = str + ((RegionStmt)stmt).entryType() + " ";
                continue;
            }
            str = str + stmt + " ";
        }
        str = str + "\n BackEdge Stmt: ";
        Iterator<StmtBox> backEdgeBoxIter = this.backEdgeStmtBoxes.iterator();
        while (backEdgeBoxIter.hasNext()) {
            stmt = (Stmt)backEdgeBoxIter.next().getUnit();
            if (stmt instanceof RegionStmt) {
                str = str + ((RegionStmt)stmt).entryType() + " ";
                continue;
            }
            str = str + stmt + " ";
        }
        return str;
    }

    @Override
    public String entryType() {
        return "Loop";
    }
}

