/*
 * Decompiled with CFR 0.152.
 */
package soot.hj.HjToJimple.jimple;

import java.util.Iterator;
import java.util.Map;
import soot.Body;
import soot.BodyTransformer;
import soot.PatchingChain;
import soot.Singletons;
import soot.Value;
import soot.hj.HjSingletons;
import soot.hj.HjToJimple.jimple.NopRegionExpr;
import soot.hj.HjToJimple.jimple.Region;
import soot.hj.HjToJimple.jimple.RegionEntry;
import soot.hj.HjToJimple.jimple.RegionStmt;
import soot.hj.HjToJimple.jimple.utils.RSTNodeMap;
import soot.hj.HjToJimple.util.RSTNode;
import soot.hj.HjToJimple.util.RSTNode_c;
import soot.jimple.AssignStmt;
import soot.jimple.InvokeExpr;
import soot.jimple.InvokeStmt;
import soot.jimple.Stmt;
import soot.jimple.StmtBody;

public class HjRSTTranslator
extends BodyTransformer {
    public HjRSTTranslator(Singletons.Global g) {
    }

    public static HjRSTTranslator v() {
        return HjSingletons.v().soot_hj_HjToJimple_jimple_HjRSTTranslator();
    }

    protected void internalTransform(Body body, String phaseName, Map opts) {
        this.hjRSTTransform(body, phaseName, opts);
    }

    public void hjRSTTransform(Body body, String phaseName, Map opts) {
        StmtBody stmtBody = (StmtBody)body;
        PatchingChain units = stmtBody.getUnits();
        if (RSTNodeMap.getRstNode(body.getMethod()) != null) {
            return;
        }
        RSTNode_c rstNode = new RSTNode_c(body.getMethod());
        this.buildRST(units.iterator(), rstNode, null);
        RSTNodeMap.setRstNode(body.getMethod(), rstNode);
    }

    public void rebuildRST(Body body, String phaseName, Map opts) {
        StmtBody stmtBody = (StmtBody)body;
        PatchingChain units = stmtBody.getUnits();
        RSTNode_c rstNode = new RSTNode_c(body.getMethod());
        this.buildRST(units.iterator(), rstNode, null);
        RSTNodeMap.setRstNode(body.getMethod(), rstNode);
        this.checkAll(rstNode);
    }

    private void checkAll(RSTNode rstNode) {
        for (RSTNode subNode : rstNode.getSubNodes()) {
            if (subNode.getSubNodes().size() <= 0) continue;
            this.checkAll(subNode);
        }
    }

    private void buildRST(Iterator stmtIt, RSTNode parentNode, RegionStmt regionStmt) {
        Stmt stmt;
        Stmt endStmt = null;
        if (regionStmt != null && (endStmt = regionStmt.getConnect()) == null) {
            return;
        }
        while (stmtIt.hasNext() && (stmt = (Stmt)stmtIt.next()) != endStmt) {
            Value value;
            RSTNode_c rstNode;
            if (stmt instanceof RegionStmt) {
                Region regionExpr = ((RegionStmt)stmt).getRegionExpr();
                if (!(regionExpr instanceof RegionEntry) || regionExpr instanceof NopRegionExpr) continue;
                rstNode = new RSTNode_c((Stmt)((RegionStmt)stmt), parentNode);
                ((RegionStmt)stmt).setRSTNode(rstNode);
                this.buildRST(stmtIt, rstNode, (RegionStmt)stmt);
                continue;
            }
            if (stmt instanceof InvokeStmt) {
                InvokeExpr invokeExpr = ((InvokeStmt)stmt).getInvokeExpr();
                rstNode = new RSTNode_c(stmt, invokeExpr.getMethod(), parentNode);
                continue;
            }
            if (!(stmt instanceof AssignStmt) || !((value = ((AssignStmt)stmt).getRightOp()) instanceof InvokeExpr)) continue;
            InvokeExpr invokeExpr = (InvokeExpr)value;
            RSTNode_c rstNode2 = new RSTNode_c(stmt, invokeExpr.getMethod(), parentNode);
        }
    }
}

