/*
 * Decompiled with CFR 0.152.
 */
package soot.hj.HjToJimple.jimple;

import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import soot.Body;
import soot.G;
import soot.Scene;
import soot.SceneTransformer;
import soot.Singletons;
import soot.SootClass;
import soot.SootMethod;
import soot.Unit;
import soot.hj.HjSingletons;
import soot.hj.HjToJimple.jimple.HjRSTTranslator;
import soot.hj.HjToJimple.jimple.RegionStmt;
import soot.hj.HjToJimple.jimple.utils.RSTNodeMap;
import soot.hj.HjToJimple.util.RSTNode;
import soot.hj.options.HjOptions;
import soot.jimple.Stmt;

public class HjRedundantAsyncElim
extends SceneTransformer {
    public HjRedundantAsyncElim(Singletons.Global g) {
    }

    public static HjRedundantAsyncElim v() {
        return HjSingletons.v().soot_hj_HjToJimple_jimple_HjRedundantAsyncElim();
    }

    protected void internalTransform(String phaseName, Map opts) {
        this.raeTransform(phaseName, opts);
    }

    protected void raeTransform(String phaseName, Map opts) {
        for (SootClass appClass : Scene.v().getApplicationClasses()) {
            ListIterator methodIter = appClass.getMethods().listIterator();
            while (methodIter.hasNext()) {
                this.eliminate((SootMethod)methodIter.next());
            }
        }
    }

    protected void eliminate(SootMethod method) {
        Body body = method.getActiveBody();
        HjRSTTranslator.v().rebuildRST(body, null, null);
        RSTNode rootRST = RSTNodeMap.getRstNode(method);
        this.eliminate(rootRST, body);
    }

    protected void eliminate(RSTNode rstNode, Body body) {
        Iterator<RSTNode> nodeIter = rstNode.getSubNodes().iterator();
        while (nodeIter.hasNext()) {
            this.eliminate(nodeIter.next(), body);
        }
        if (rstNode.isFinishNode()) {
            this.eliminateLastAsyncInFinish(rstNode, body);
        }
    }

    protected void eliminateLastAsyncInFinish(RSTNode rstNode, Body body) {
        List<RSTNode> subNodes = rstNode.getSubNodes();
        RSTNode lastSubNode = null;
        if (subNodes.size() > 0) {
            lastSubNode = subNodes.get(subNodes.size() - 1);
        }
        if (lastSubNode != null && lastSubNode.isAsyncNode()) {
            Stmt finishExitStmt = rstNode.getRegionStmt().getConnect();
            RegionStmt asyncEntryStmt = lastSubNode.getRegionStmt();
            Stmt asyncExitStmt = asyncEntryStmt.getConnect();
            if (body.getUnits().getSuccOf((Unit)asyncExitStmt) == finishExitStmt) {
                body.getUnits().remove((Object)asyncEntryStmt);
                body.getUnits().remove((Object)asyncExitStmt);
                if (HjOptions.v().hjVerbose()) {
                    G.v().out.println("rae: Removing last async in finish " + asyncEntryStmt.toString());
                }
            }
        }
    }
}

