/*
 * Decompiled with CFR 0.152.
 */
package soot.hj.HjToJimple.jimple;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import soot.ArrayType;
import soot.Body;
import soot.BodyTransformer;
import soot.BooleanType;
import soot.G;
import soot.IntType;
import soot.Local;
import soot.PatchingChain;
import soot.RefType;
import soot.Scene;
import soot.Singletons;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.SootMethodRef;
import soot.Trap;
import soot.Type;
import soot.Unit;
import soot.Value;
import soot.ValueBox;
import soot.VoidType;
import soot.factory.LocalGenerator;
import soot.factory.SootFactory;
import soot.hj.HjScene;
import soot.hj.HjSingletons;
import soot.hj.HjToJimple.jimple.ActivityClassBuilder;
import soot.hj.HjToJimple.jimple.AsyncRegionExpr;
import soot.hj.HjToJimple.jimple.AsyncRegionStmt;
import soot.hj.HjToJimple.jimple.FinishRegionExpr;
import soot.hj.HjToJimple.jimple.HjAsyncRegionStmt;
import soot.hj.HjToJimple.jimple.HjFutureReturn;
import soot.hj.HjToJimple.jimple.HjRegionStmt;
import soot.hj.HjToJimple.jimple.IsolatedRegionExpr;
import soot.hj.HjToJimple.jimple.LoopRegionExpr;
import soot.hj.HjToJimple.jimple.Region;
import soot.hj.HjToJimple.jimple.Region1TStmt;
import soot.hj.HjToJimple.jimple.RegionExit;
import soot.hj.HjToJimple.jimple.RegionStmt;
import soot.hj.HjToJimple.jimple.TargetedHjRuntime;
import soot.hj.HjToJimple.jimple.factory.HjClassFactory;
import soot.hj.HjToJimple.jimple.factory.HjMethodFactory;
import soot.hj.HjToJimple.jimple.factory.HjStmtFactory;
import soot.hj.HjToJimple.util.HjObject;
import soot.hj.HjToJimple.util.Phaser;
import soot.hj.options.HjOptions;
import soot.javaToJimple.Util;
import soot.jimple.AssignStmt;
import soot.jimple.ExitMonitorStmt;
import soot.jimple.GotoStmt;
import soot.jimple.IdentityStmt;
import soot.jimple.IfStmt;
import soot.jimple.InstanceFieldRef;
import soot.jimple.IntConstant;
import soot.jimple.InvokeStmt;
import soot.jimple.Jimple;
import soot.jimple.JimpleBody;
import soot.jimple.LookupSwitchStmt;
import soot.jimple.NewExpr;
import soot.jimple.NopStmt;
import soot.jimple.ParameterRef;
import soot.jimple.ReturnStmt;
import soot.jimple.ReturnVoidStmt;
import soot.jimple.SpecialInvokeExpr;
import soot.jimple.StaticInvokeExpr;
import soot.jimple.Stmt;
import soot.jimple.StmtBody;
import soot.jimple.StringConstant;
import soot.jimple.TableSwitchStmt;
import soot.jimple.ThrowStmt;
import soot.jimple.VirtualInvokeExpr;
import soot.tagkit.EnclosingTag;
import soot.tagkit.IntegerConstantValueTag;
import soot.tagkit.SourceLnPosTag;
import soot.tagkit.SyntheticTag;
import soot.tagkit.Tag;
import soot.util.Chain;
import soot.util.HashChain;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HjRuntimeTranslator
extends BodyTransformer {
    protected ArrayList<SootClass> extraClasses = new ArrayList();
    protected Body origBody;
    protected Local origThisLocal;
    public static final String JAVALANGOBJECT_CLASSNAME = "java.lang.Object";
    public static final String JAVALANGNOTIFYALL_METHODNAME = "notifyAll";

    public HjRuntimeTranslator(Singletons.Global g) {
    }

    public static HjRuntimeTranslator v() {
        return HjSingletons.v().soot_hj_HjToJimple_jimple_HjRuntimeTranslator();
    }

    protected static void createHjRuntimeTargetField(SootClass c) {
        SootField runtimeField = new SootField("HJ_RUNTIME_FLAG__", (Type)IntType.v(), 25);
        c.addField(runtimeField);
        int rtConstant = 0;
        if (TargetedHjRuntime.isRuntimeWorkSharingBlocking()) {
            rtConstant = 1;
        } else if (TargetedHjRuntime.isRuntimeWorkSharingCooperative()) {
            rtConstant = 2;
        } else if (TargetedHjRuntime.isRuntimeWorkStealingHelpFirst()) {
            rtConstant = 3;
        } else if (TargetedHjRuntime.isRuntimeWorkStealingWorkFirst()) {
            rtConstant = 4;
        } else if (TargetedHjRuntime.isRuntimeWorkStealingAdaptive()) {
            rtConstant = 5;
        }
        assert (rtConstant != 0);
        runtimeField.addTag((Tag)new IntegerConstantValueTag(rtConstant));
    }

    protected static void createRaceDetField(SootClass c) {
        SootField raceDetField = new SootField("HJ_RACE_DET_FLAG__", (Type)IntType.v(), 25);
        c.addField(raceDetField);
        raceDetField.addTag((Tag)new IntegerConstantValueTag(HjOptions.v().racedet() ? 1 : 0));
    }

    protected static void createOVDField(SootClass c) {
        SootField raceDetField = new SootField("HJ_OVD_FLAG__", (Type)IntType.v(), 25);
        c.addField(raceDetField);
        raceDetField.addTag((Tag)new IntegerConstantValueTag(HjOptions.v().ovd() ? 1 : 0));
    }

    protected void internalTransform(Body body, String phaseName, Map opts) {
        SootMethod method = body.getMethod();
        this.extraClasses.clear();
        if (HjOptions.v().hjVerbose()) {
            G.v().out.println("MPIR: " + body);
        }
        if (method.isMain() && TargetedHjRuntime.isRuntimeWorkSharing()) {
            SootClass c = body.getMethod().getDeclaringClass();
            this.createWshMainClass(body);
            HjRuntimeTranslator.createHjRuntimeTargetField(c);
            HjRuntimeTranslator.createRaceDetField(c);
            HjRuntimeTranslator.createOVDField(c);
        }
        this.origBody = body;
        if (!body.getMethod().isStatic()) {
            this.origThisLocal = body.getThisLocal();
        }
        this.hjRuntimeTransform(body, phaseName, opts, null);
        this.nopElimination(this.extraClasses.iterator());
        ((HjScene)Scene.v()).extraClasses.addAll(this.extraClasses);
    }

    protected void nopElimination(Iterator<SootClass> classIter) {
        ArrayList<Stmt> nopsList = new ArrayList<Stmt>();
        while (classIter.hasNext()) {
            Iterator methodIter = classIter.next().methodIterator();
            while (methodIter.hasNext()) {
                Body methodBody = ((SootMethod)methodIter.next()).retrieveActiveBody();
                StmtBody stmtBody = (StmtBody)methodBody;
                PatchingChain units = stmtBody.getUnits();
                HashMap rtStmtMap = new HashMap();
                ArrayList removeStmts = new ArrayList();
                ArrayList rtTraps = new ArrayList();
                for (Stmt stmt : units) {
                    if (!(stmt instanceof NopStmt)) continue;
                    nopsList.add(stmt);
                }
                Iterator nopsIter = nopsList.iterator();
                while (nopsIter.hasNext()) {
                    methodBody.getUnits().remove(nopsIter.next());
                }
                nopsList.clear();
            }
        }
    }

    protected void checkAll(Iterator<SootClass> classIter) {
        ArrayList nopsList = new ArrayList();
        while (classIter.hasNext()) {
            Iterator methodIter = classIter.next().methodIterator();
            while (methodIter.hasNext()) {
                if (!HjOptions.v().hjVerbose()) continue;
                G.v().out.println("Method Body: " + ((SootMethod)methodIter.next()).retrieveActiveBody());
            }
        }
    }

    protected SootClass createWshMainClass(Body body) {
        assert (body.getMethod().getParameterTypes().size() == 1);
        SootClass userMainClass = body.getMethod().getDeclaringClass();
        SootClass mainActivityClass = new SootClass(userMainClass.getName() + "$Main", 9);
        mainActivityClass.setOuterClass(userMainClass);
        mainActivityClass.setSuperclass(HjClassFactory.hjWshActivity());
        String mainArgsFieldName = "mainArgs";
        this.addGeneratedClassFlag(mainActivityClass);
        Type mainArgsType = body.getMethod().getParameterType(0);
        SootField mainArgsField = new SootField(mainArgsFieldName, mainArgsType, 18);
        mainArgsField.addTag((Tag)new SyntheticTag());
        mainActivityClass.addField(mainArgsField);
        JimpleBody runHjTaskBody = Jimple.v().newBody();
        SootMethod runHjTaskMethod = HjMethodFactory.createActivityTaskMethod();
        runHjTaskBody.setMethod(runHjTaskMethod);
        runHjTaskMethod.setActiveBody((Body)runHjTaskBody);
        runHjTaskMethod.setDeclaringClass(mainActivityClass);
        mainActivityClass.addMethod(runHjTaskMethod);
        LocalGenerator lg = SootFactory.v().getLocalGenerator((Body)runHjTaskBody);
        Local thisLocal = lg.generateLocal("tl", (Type)mainActivityClass.getType());
        runHjTaskBody.getUnits().add((Unit)Jimple.v().newIdentityStmt((Value)thisLocal, (Value)Jimple.v().newThisRef(mainActivityClass.getType())));
        Local mainArgsLocal = lg.generateLocal(mainArgsFieldName, mainArgsField.getType());
        InstanceFieldRef fieldRef = Jimple.v().newInstanceFieldRef((Value)thisLocal, mainArgsField.makeRef());
        AssignStmt assignStmt = Jimple.v().newAssignStmt((Value)mainArgsLocal, (Value)fieldRef);
        runHjTaskBody.getUnits().add((Unit)assignStmt);
        List<Local> mainParams = Collections.singletonList(mainArgsLocal);
        StaticInvokeExpr staticInvoke = Jimple.v().newStaticInvokeExpr(body.getMethod().makeRef(), mainParams);
        InvokeStmt invokeStmt = Jimple.v().newInvokeStmt((Value)staticInvoke);
        runHjTaskBody.getUnits().add((Unit)invokeStmt);
        runHjTaskBody.getUnits().add((Unit)Jimple.v().newReturnVoidStmt());
        this.createDefaultIsHjTaskReadyMethod(mainActivityClass);
        this.createWshMainInitMethod(mainActivityClass, mainArgsField);
        this.extraClasses.add(mainActivityClass);
        String mainActivityClassName = mainActivityClass.getName();
        String innerClassName = mainActivityClassName.substring(mainActivityClassName.lastIndexOf(36) + 1, mainActivityClassName.length());
        Util.addInnerClassTag((SootClass)mainActivityClass, (String)mainActivityClass.getName(), (String)userMainClass.getName(), (String)innerClassName, (int)mainActivityClass.getModifiers());
        return mainActivityClass;
    }

    protected void hjRuntimeTransform(Body body, String phaseName, Map opts, ArrayList outerBranchItems) {
        StmtBody stmtBody = (StmtBody)body;
        PatchingChain units = stmtBody.getUnits();
        HashMap<Stmt, ArrayList<Stmt>> rtStmtMap = new HashMap<Stmt, ArrayList<Stmt>>();
        ArrayList<Stmt> removeStmts = new ArrayList<Stmt>();
        ArrayList<Trap> rtTraps = new ArrayList<Trap>();
        ArrayList branchItems = outerBranchItems != null ? outerBranchItems : new ArrayList();
        Iterator stmtIt = units.iterator();
        while (stmtIt.hasNext()) {
            Stmt stmt = (Stmt)stmtIt.next();
            if (!(stmt instanceof RegionStmt)) continue;
            Region regionExpr = ((RegionStmt)stmt).getRegionExpr();
            if (regionExpr instanceof AsyncRegionExpr) {
                this.handleAsyncRegion((RegionStmt)stmt, body, stmtIt, rtStmtMap, removeStmts, branchItems);
                continue;
            }
            if (regionExpr instanceof FinishRegionExpr) {
                if (TargetedHjRuntime.isRuntimeWorkStealingHelpFirst()) {
                    this.handleHabFinishRegion((RegionStmt)stmt, body, stmtIt, rtStmtMap, removeStmts, rtTraps, branchItems);
                    continue;
                }
                this.handleFinishRegion((RegionStmt)stmt, body, stmtIt, rtStmtMap, removeStmts, rtTraps, branchItems);
                continue;
            }
            if (regionExpr instanceof IsolatedRegionExpr) {
                this.handleIsolatedRegion((RegionStmt)stmt, body, stmtIt, rtStmtMap, removeStmts, rtTraps, branchItems);
                continue;
            }
            if (!(regionExpr instanceof LoopRegionExpr)) continue;
            this.handleLoopRegion((RegionStmt)stmt, removeStmts);
        }
        for (Stmt stmt : rtStmtMap.keySet()) {
            ArrayList rtStmts = (ArrayList)rtStmtMap.get(stmt);
            for (Stmt rtStmt : rtStmts) {
                body.getUnits().insertBefore((Unit)rtStmt, (Unit)stmt);
            }
        }
        Iterator trapIter = rtTraps.iterator();
        while (trapIter.hasNext()) {
            this.sortAndAddTrap(body, (Trap)trapIter.next());
        }
        Iterator stmtIter = removeStmts.iterator();
        while (stmtIter.hasNext()) {
            body.getUnits().remove(stmtIter.next());
        }
        if (outerBranchItems == null) {
            Iterator branchItemIter = branchItems.iterator();
            while (branchItemIter.hasNext()) {
                Object branchItem = branchItemIter.next();
                if (!(branchItem instanceof Trap)) continue;
                Trap trap = (Trap)branchItem;
                trap.setBeginUnit((Unit)branchItemIter.next());
                trap.setEndUnit((Unit)branchItemIter.next());
                trap.setHandlerUnit((Unit)branchItemIter.next());
            }
        }
    }

    protected void sortAndAddTrap(Body body, Trap trap) {
        Iterator trapIter = body.getTraps().snapshotIterator();
        while (trapIter.hasNext()) {
            Trap currTrap = (Trap)trapIter.next();
            Unit begUnit = currTrap.getBeginUnit();
            Unit endUnit = currTrap.getEndUnit();
            Unit newBegUnit = trap.getBeginUnit();
            Unit newEndUnit = trap.getEndUnit();
            if (begUnit != newBegUnit && !body.getUnits().follows(newBegUnit, begUnit) || endUnit != newEndUnit && !body.getUnits().follows(endUnit, newEndUnit)) continue;
            body.getTraps().insertBefore((Object)trap, (Object)currTrap);
            return;
        }
        body.getTraps().add((Object)trap);
    }

    protected void checkUses(Stmt s, HashChain<Local> outerMethodLocals, HashChain<Local> methodLocals, HashMap<Local, SootField> classParams) {
        Object[] uses = s.getUseBoxes().toArray();
        for (int i = 0; i < uses.length; ++i) {
            Value v = ((ValueBox)uses[i]).getValue();
            if (methodLocals.contains((Object)v) || !outerMethodLocals.contains((Object)v)) continue;
            methodLocals.add((Object)((Local)v));
            classParams.put((Local)v, this.createField((Local)v));
        }
    }

    protected void checkDefs(Stmt s, HashChain<Local> outerMethodLocals, HashChain<Local> methodLocals, HashMap<Local, SootField> classParams) {
        Object[] defs = s.getDefBoxes().toArray();
        for (int i = 0; i < defs.length; ++i) {
            Value v = ((ValueBox)defs[i]).getValue();
            if (methodLocals.contains((Object)v) || !outerMethodLocals.contains((Object)v)) continue;
            methodLocals.add((Object)((Local)v));
        }
    }

    protected void handleAsyncRegion(RegionStmt asyncRegionStmt, Body body, Iterator stmtIt, HashMap<Stmt, ArrayList<Stmt>> rtStmtMap, ArrayList<Stmt> removeStmts, ArrayList branchItems) {
        Body taskMethodBody;
        if (HjOptions.v().hjVerbose()) {
            G.v().out.println("HjToJimple handle async region");
        }
        AsyncRegionExpr asyncRegion = (AsyncRegionExpr)asyncRegionStmt.getRegionExpr();
        ArrayList<Stmt> runtimeStmts = new ArrayList<Stmt>();
        Local retLocal = null;
        if (asyncRegionStmt instanceof AsyncRegionStmt) {
            retLocal = (Local)((AsyncRegionStmt)asyncRegionStmt).getLeftOp();
        }
        SootClass bodyClass = body.getMethod().getDeclaringClass();
        String activityInnerClassSuffix = this.getInnerClassSuffix(asyncRegionStmt, body);
        String activityClassName = bodyClass.getName() + "GenAsync$" + activityInnerClassSuffix;
        SootClass activityClass = new SootClass(activityClassName);
        this.addGeneratedClassFlag(activityClass);
        activityClass.setOuterClass(bodyClass);
        activityClass.setSuperclass(HjClassFactory.hjWshActivity());
        HashMap<Local, SootField> classParams = new HashMap<Local, SootField>();
        if (asyncRegionStmt instanceof Region1TStmt && ((Region1TStmt)asyncRegionStmt).getLabel() != null) {
            RegionStmt statusLabel = ((Region1TStmt)asyncRegionStmt).getLabel();
            ActivityClassBuilder.v().createCondIsHjTaskReadyMethod(activityClass, asyncRegionStmt, statusLabel, body, stmtIt, classParams, removeStmts, this.origThisLocal);
            taskMethodBody = this.createRunHjTaskMethod(activityClass, asyncRegionStmt, body, stmtIt, classParams, removeStmts, branchItems);
        } else {
            taskMethodBody = this.createRunHjTaskMethod(activityClass, asyncRegionStmt, body, stmtIt, classParams, removeStmts, branchItems);
            this.createDefaultIsHjTaskReadyMethod(activityClass);
        }
        Local outerThisLocal = body.getMethod().isStatic() ? null : body.getThisLocal();
        ArrayList<Value> phaserListClassParams = new ArrayList<Value>();
        SootClass phaserListClass = null;
        if (asyncRegion.isPhased()) {
            if (asyncRegion.hasDynamicPhaserList()) {
                phaserListClass = Scene.v().getSootClass("java.util.List");
                Phaser ph = asyncRegion.getPhasers().get(0);
                phaserListClassParams.add(ph.getLocalValue());
            } else {
                phaserListClass = ActivityClassBuilder.v().handlePhasers(asyncRegion.getPhasers(), body, runtimeStmts, outerThisLocal, phaserListClassParams, activityInnerClassSuffix);
                this.extraClasses.add(phaserListClass);
            }
            assert (phaserListClass != null);
        }
        ActivityClassBuilder.v().createInitMethod(activityClass, classParams, phaserListClass);
        this.extraClasses.add(activityClass);
        ActivityClassBuilder.v().createRuntimeStmts(asyncRegion, activityClass, phaserListClass, phaserListClassParams, body, classParams, asyncRegion.getPlace(), asyncRegion.getDDFs(), retLocal, runtimeStmts);
        rtStmtMap.put((Stmt)asyncRegionStmt, runtimeStmts);
        removeStmts.add((Stmt)asyncRegionStmt);
        this.hjRuntimeTransform(taskMethodBody, null, null, branchItems);
    }

    private String getInnerClassSuffix(RegionStmt asyncRegionStmt, Body body) {
        SourceLnPosTag srcLnPosTag = (SourceLnPosTag)asyncRegionStmt.getTag("SourceLnPosTag");
        String activityClassName = body.getMethod().getName() + "_" + srcLnPosTag.startLn() + "_" + srcLnPosTag.startPos();
        return activityClassName;
    }

    protected void checkTraps(Body body, Body methodBody, Chain<Trap> traps, Stmt regionEntryStmt, Stmt regionExitStmt, HashMap<Stmt, Stmt> branchMap, ArrayList branchItems) {
        for (Trap trap : traps) {
            Stmt beginStmt = (Stmt)trap.getBeginUnit();
            if (body.getUnits().contains((Object)beginStmt) && (!body.getUnits().follows((Unit)beginStmt, (Unit)regionEntryStmt) || !body.getUnits().follows((Unit)regionExitStmt, (Unit)beginStmt))) continue;
            methodBody.getTraps().add((Object)trap);
            branchItems.add(trap);
            Unit unit = trap.getBeginUnit();
            if (branchMap.containsKey((Stmt)unit)) {
                unit = (Unit)branchMap.get((Stmt)unit);
            }
            branchItems.add(unit);
            unit = trap.getEndUnit();
            if (branchMap.containsKey((Stmt)unit)) {
                unit = (Unit)branchMap.get((Stmt)unit);
            }
            branchItems.add(unit);
            branchItems.add(trap.getHandlerUnit());
        }
        Iterator trapIter = methodBody.getTraps().iterator();
        while (trapIter.hasNext()) {
            body.getTraps().remove(trapIter.next());
        }
    }

    protected Body createRunHjTaskMethod(SootClass activityClass, RegionStmt asyncRegionStmt, Body body, Iterator stmtIt, HashMap<Local, SootField> classParams, ArrayList<Stmt> removeStmts, ArrayList branchItems) {
        SootField field;
        JimpleBody methodBody = Jimple.v().newBody();
        SootMethod taskMethod = HjMethodFactory.createActivityTaskMethod();
        methodBody.setMethod(taskMethod);
        taskMethod.setActiveBody((Body)methodBody);
        taskMethod.setDeclaringClass(activityClass);
        activityClass.addMethod(taskMethod);
        LocalGenerator lg = SootFactory.v().getLocalGenerator((Body)methodBody);
        Local thisLocal = lg.generateLocal("tl", (Type)activityClass.getType());
        Local outerThisLocal = null;
        if (!body.getMethod().isStatic()) {
            outerThisLocal = body.getThisLocal();
        }
        RegionExit regionExitExpr = ((AsyncRegionExpr)asyncRegionStmt.getRegionExpr()).getExit();
        HashChain outerMethodLocals = (HashChain)body.getLocals();
        HashChain methodLocals = (HashChain)methodBody.getLocals();
        Stmt exitStmt = null;
        HashMap<Stmt, Stmt> branchMap = new HashMap<Stmt, Stmt>();
        int inAsync = 0;
        while (stmtIt.hasNext()) {
            NopStmt nopLabel;
            Stmt target;
            ArrayList<Object> targetList;
            Iterator targetIter;
            NopStmt nopLabel2;
            Stmt target2;
            Stmt stmt = (Stmt)stmtIt.next();
            Object newStmt = null;
            if (stmt instanceof HjAsyncRegionStmt) {
                ++inAsync;
            }
            if (stmt instanceof HjRegionStmt) {
                HjRegionStmt regionStmt = (HjRegionStmt)stmt;
                String toStringVal = regionStmt.regionExprBox.getValue().toString();
                if (toStringVal.equals("AsyncRegion Exit")) {
                    --inAsync;
                }
            }
            if (branchMap.containsKey(stmt)) {
                methodBody.getUnits().add((Unit)branchMap.get(stmt));
            }
            if (stmt instanceof RegionStmt) {
                if (((RegionStmt)stmt).getRegionExpr() == regionExitExpr) {
                    exitStmt = stmt;
                    removeStmts.add(stmt);
                    break;
                }
                NopStmt nopLabel3 = Jimple.v().newNopStmt();
                methodBody.getUnits().add((Unit)nopLabel3);
                branchMap.put(stmt, (Stmt)nopLabel3);
            } else if (stmt instanceof GotoStmt) {
                target2 = (Stmt)((GotoStmt)stmt).getTarget();
                if (branchMap.containsKey(target2)) {
                    ((GotoStmt)stmt).setTargetBox((Unit)branchMap.get(target2));
                } else if (methodBody.getUnits().contains((Object)target2)) {
                    nopLabel2 = Jimple.v().newNopStmt();
                    ((GotoStmt)stmt).setTarget((Unit)nopLabel2);
                    methodBody.getUnits().insertBefore((Unit)nopLabel2, (Unit)target2);
                    branchMap.put(target2, (Stmt)nopLabel2);
                } else {
                    nopLabel2 = Jimple.v().newNopStmt();
                    ((GotoStmt)stmt).setTarget((Unit)nopLabel2);
                    branchMap.put(target2, (Stmt)nopLabel2);
                }
            } else if (stmt instanceof IfStmt) {
                target2 = ((IfStmt)stmt).getTarget();
                if (branchMap.containsKey(target2)) {
                    ((IfStmt)stmt).setTarget((Unit)branchMap.get(target2));
                } else if (methodBody.getUnits().contains((Object)target2)) {
                    nopLabel2 = Jimple.v().newNopStmt();
                    ((IfStmt)stmt).setTarget((Unit)nopLabel2);
                    methodBody.getUnits().insertBefore((Unit)nopLabel2, (Unit)target2);
                    branchMap.put(target2, (Stmt)nopLabel2);
                } else {
                    nopLabel2 = Jimple.v().newNopStmt();
                    ((IfStmt)stmt).setTarget((Unit)nopLabel2);
                    branchMap.put(target2, (Stmt)nopLabel2);
                }
            } else if (stmt instanceof TableSwitchStmt) {
                targetIter = ((TableSwitchStmt)stmt).getTargets().iterator();
                targetList = new ArrayList<Object>();
                while (targetIter.hasNext()) {
                    target = (Stmt)targetIter.next();
                    if (branchMap.containsKey(target)) {
                        targetList.add(branchMap.get(target));
                        continue;
                    }
                    if (methodBody.getUnits().contains((Object)target)) {
                        nopLabel = Jimple.v().newNopStmt();
                        targetList.add(nopLabel);
                        methodBody.getUnits().insertBefore((Unit)nopLabel, (Unit)target);
                        branchMap.put(target, (Stmt)nopLabel);
                        continue;
                    }
                    nopLabel = Jimple.v().newNopStmt();
                    targetList.add(nopLabel);
                    branchMap.put(target, (Stmt)nopLabel);
                }
                ((TableSwitchStmt)stmt).setTargets(targetList);
                target = (Stmt)((TableSwitchStmt)stmt).getDefaultTarget();
                if (branchMap.containsKey(target)) {
                    ((TableSwitchStmt)stmt).setDefaultTarget((Unit)branchMap.get(target));
                } else if (methodBody.getUnits().contains((Object)target)) {
                    nopLabel = Jimple.v().newNopStmt();
                    ((TableSwitchStmt)stmt).setDefaultTarget((Unit)nopLabel);
                    methodBody.getUnits().insertBefore((Unit)nopLabel, (Unit)target);
                    branchMap.put(target, (Stmt)nopLabel);
                } else {
                    nopLabel = Jimple.v().newNopStmt();
                    ((TableSwitchStmt)stmt).setDefaultTarget((Unit)nopLabel);
                    branchMap.put(target, (Stmt)nopLabel);
                }
            } else if (stmt instanceof LookupSwitchStmt) {
                targetIter = ((LookupSwitchStmt)stmt).getTargets().iterator();
                targetList = new ArrayList();
                while (targetIter.hasNext()) {
                    target = (Stmt)targetIter.next();
                    if (branchMap.containsKey(target)) {
                        targetList.add(branchMap.get(target));
                        continue;
                    }
                    if (methodBody.getUnits().contains((Object)target)) {
                        nopLabel = Jimple.v().newNopStmt();
                        targetList.add(nopLabel);
                        methodBody.getUnits().insertBefore((Unit)nopLabel, (Unit)target);
                        branchMap.put(target, (Stmt)nopLabel);
                        continue;
                    }
                    nopLabel = Jimple.v().newNopStmt();
                    targetList.add(nopLabel);
                    branchMap.put(target, (Stmt)nopLabel);
                }
                ((LookupSwitchStmt)stmt).setTargets((Unit[])targetList.toArray());
                target = (Stmt)((LookupSwitchStmt)stmt).getDefaultTarget();
                if (branchMap.containsKey(target)) {
                    ((LookupSwitchStmt)stmt).setDefaultTarget((Unit)branchMap.get(target));
                } else if (methodBody.getUnits().contains((Object)target)) {
                    nopLabel = Jimple.v().newNopStmt();
                    ((LookupSwitchStmt)stmt).setDefaultTarget((Unit)nopLabel);
                    methodBody.getUnits().insertBefore((Unit)nopLabel, (Unit)target);
                    branchMap.put(target, (Stmt)nopLabel);
                } else {
                    nopLabel = Jimple.v().newNopStmt();
                    ((LookupSwitchStmt)stmt).setDefaultTarget((Unit)nopLabel);
                    branchMap.put(target, (Stmt)nopLabel);
                }
            } else if (stmt instanceof HjFutureReturn && inAsync == 0) {
                ActivityClassBuilder.v().addSetValueStmts(activityClass, (Body)methodBody, ((HjFutureReturn)stmt).getOp(), thisLocal);
                this.checkUses(stmt, (HashChain<Local>)outerMethodLocals, (HashChain<Local>)methodLocals, classParams);
                this.checkDefs(stmt, (HashChain<Local>)outerMethodLocals, (HashChain<Local>)methodLocals, classParams);
                removeStmts.add(stmt);
                continue;
            }
            methodBody.getUnits().add((Unit)stmt);
            this.checkUses(stmt, (HashChain<Local>)outerMethodLocals, (HashChain<Local>)methodLocals, classParams);
            this.checkDefs(stmt, (HashChain<Local>)outerMethodLocals, (HashChain<Local>)methodLocals, classParams);
            removeStmts.add(stmt);
        }
        this.createFields(activityClass, classParams);
        for (Local local : classParams.keySet()) {
            field = classParams.get(local);
            if (!methodBody.getLocals().contains((Object)local)) continue;
            InstanceFieldRef fieldRef = Jimple.v().newInstanceFieldRef((Value)thisLocal, field.makeRef());
            AssignStmt assignStmt = Jimple.v().newAssignStmt((Value)local, (Value)fieldRef);
            methodBody.getUnits().addFirst((Unit)assignStmt);
        }
        methodBody.getUnits().addFirst((Unit)Jimple.v().newIdentityStmt((Value)thisLocal, (Value)Jimple.v().newThisRef(activityClass.getType())));
        methodBody.getUnits().addLast((Unit)Jimple.v().newReturnVoidStmt());
        this.checkTraps(body, (Body)methodBody, (Chain<Trap>)body.getTraps(), (Stmt)asyncRegionStmt, exitStmt, branchMap, branchItems);
        SootMethod bodyMethod = body.getMethod();
        if (!bodyMethod.isStatic() && !classParams.containsKey(outerThisLocal)) {
            field = this.createField(outerThisLocal);
            classParams.put(outerThisLocal, field);
            activityClass.addField(field);
        }
        return methodBody;
    }

    protected ArrayList<Stmt> createRuntimeStmts(SootClass activityClass, Body body, HashMap<Local, SootField> classParams, ArrayList<Stmt> runtimeStmts) {
        LocalGenerator lg = SootFactory.v().getLocalGenerator(body);
        SootClass hjLPlaceClass = Scene.v().getSootClass("hj.lang.place");
        Local herePlaceLocal = lg.generateLocal((Type)hjLPlaceClass.getType());
        Stmt assignStmt = HjStmtFactory.here(herePlaceLocal);
        runtimeStmts.add(assignStmt);
        Local activityLocal = lg.generateLocal((Type)activityClass.getType());
        NewExpr newExpr = Jimple.v().newNewExpr(activityClass.getType());
        assignStmt = Jimple.v().newAssignStmt((Value)activityLocal, (Value)newExpr);
        runtimeStmts.add(assignStmt);
        ArrayList<Type> activityTypeList = new ArrayList<Type>();
        ArrayList<Local> activityParamList = new ArrayList<Local>();
        for (Local local : classParams.keySet()) {
            activityTypeList.add(local.getType());
            activityParamList.add(local);
        }
        SootMethodRef initInvoke = Scene.v().makeMethodRef(activityClass, "<init>", activityTypeList, (Type)VoidType.v(), false);
        SpecialInvokeExpr specInvokeExpr = Jimple.v().newSpecialInvokeExpr(activityLocal, initInvoke, activityParamList);
        InvokeStmt invokeStmt = Jimple.v().newInvokeStmt((Value)specInvokeExpr);
        runtimeStmts.add((Stmt)invokeStmt);
        ArrayList<RefType> runAsyncTypeList = new ArrayList<RefType>();
        ArrayList<Local> runAsyncParamList = new ArrayList<Local>();
        runAsyncTypeList.add(HjClassFactory.hjWshActivity().getType());
        runAsyncParamList.add(activityLocal);
        SootMethod runAsyncMethod = hjLPlaceClass.getMethod("runAsync", runAsyncTypeList, (Type)VoidType.v());
        VirtualInvokeExpr runAsyncInvoke = Jimple.v().newVirtualInvokeExpr(herePlaceLocal, runAsyncMethod.makeRef(), runAsyncParamList);
        invokeStmt = Jimple.v().newInvokeStmt((Value)runAsyncInvoke);
        runtimeStmts.add((Stmt)invokeStmt);
        return runtimeStmts;
    }

    protected void createWshMainInitMethod(SootClass activityClass, SootField mainArgs) {
        JimpleBody methodBody = Jimple.v().newBody();
        LocalGenerator lg = SootFactory.v().getLocalGenerator((Body)methodBody);
        Local thisLocal = lg.generateLocal((Type)activityClass.getType());
        methodBody.getUnits().add((Unit)Jimple.v().newIdentityStmt((Value)thisLocal, (Value)Jimple.v().newThisRef(activityClass.getType())));
        ParameterRef paramRef = Jimple.v().newParameterRef(mainArgs.getType(), 0);
        Local tmpLocal = lg.generateLocal(mainArgs.getType());
        IdentityStmt assignStmt = Jimple.v().newIdentityStmt((Value)tmpLocal, (Value)paramRef);
        assignStmt.addTag((Tag)new EnclosingTag());
        methodBody.getUnits().add((Unit)assignStmt);
        List<Type> typeList = Collections.singletonList(mainArgs.getType());
        SootMethod initMethod = new SootMethod("<init>", typeList, (Type)VoidType.v(), 1);
        methodBody.setMethod(initMethod);
        initMethod.setActiveBody((Body)methodBody);
        initMethod.setDeclaringClass(activityClass);
        activityClass.addMethod(initMethod);
        SootClass stringClass = Scene.v().getSootClass("java.lang.String");
        List<RefType> typesList = Collections.singletonList(stringClass.getType());
        List<StringConstant> paramsList = Collections.singletonList(StringConstant.v((String)activityClass.getName()));
        SootMethodRef initInvoke = Scene.v().makeMethodRef(HjClassFactory.hjWshActivity(), "<init>", typesList, (Type)VoidType.v(), false);
        SpecialInvokeExpr invokeExpr = Jimple.v().newSpecialInvokeExpr(thisLocal, initInvoke, paramsList);
        InvokeStmt invokeStmt = Jimple.v().newInvokeStmt((Value)invokeExpr);
        methodBody.getUnits().add((Unit)invokeStmt);
        InstanceFieldRef fieldRef = Jimple.v().newInstanceFieldRef((Value)thisLocal, mainArgs.makeRef());
        assignStmt = Jimple.v().newAssignStmt((Value)fieldRef, (Value)tmpLocal);
        methodBody.getUnits().add((Unit)assignStmt);
        methodBody.getUnits().add((Unit)Jimple.v().newReturnVoidStmt());
    }

    protected SootField createField(Local l) {
        SootField field = new SootField("val$" + l.getName(), l.getType(), 18);
        field.addTag((Tag)new SyntheticTag());
        return field;
    }

    protected void createFields_(SootClass activityClass, HashMap<Local, SootField> classParams) {
        Iterator<SootField> fields = classParams.values().iterator();
        while (fields.hasNext()) {
            activityClass.addField(fields.next());
        }
    }

    protected void createFields(SootClass activityClass, HashMap<Local, SootField> classParams) {
        Object[] locals = classParams.keySet().toArray();
        for (int i = 0; i < locals.length; ++i) {
            SootField field = classParams.get((Local)locals[i]);
            try {
                SootField oldField = activityClass.getField(field.getName(), field.getType());
                classParams.put((Local)locals[i], oldField);
                continue;
            }
            catch (Exception e) {
                activityClass.addField(field);
            }
        }
    }

    protected void addGeneratedClassFlag(SootClass activityClass) {
        SootField genField = new SootField("HJ_GENERATED_FLAG__", (Type)IntType.v(), 26);
        genField.addTag((Tag)new SyntheticTag());
        genField.addTag((Tag)new IntegerConstantValueTag(1));
        activityClass.addField(genField);
    }

    protected void createDefaultIsHjTaskReadyMethod(SootClass activityClass) {
        JimpleBody statusMethodBody = Jimple.v().newBody();
        SootMethod statusMethod = new SootMethod("isHjTaskReady", Collections.EMPTY_LIST, (Type)BooleanType.v(), 1);
        statusMethodBody.setMethod(statusMethod);
        statusMethod.setActiveBody((Body)statusMethodBody);
        statusMethod.setDeclaringClass(activityClass);
        activityClass.addMethod(statusMethod);
        statusMethodBody.getUnits().add((Unit)Jimple.v().newReturnStmt((Value)IntConstant.v((int)1)));
    }

    protected void handleFinishRegion(RegionStmt finishRegionStmt, Body body, Iterator stmtIt, HashMap<Stmt, ArrayList<Stmt>> rtStmtMap, ArrayList<Stmt> removeStmts, ArrayList<Trap> rtTraps, ArrayList branchItems) {
        FinishRegionExpr finishRegion = (FinishRegionExpr)finishRegionStmt.getRegionExpr();
        ArrayList<Stmt> prevRTStmts = new ArrayList<Stmt>();
        ArrayList<Stmt> succRTStmts = new ArrayList<Stmt>();
        LocalGenerator lg = SootFactory.v().getLocalGenerator(body);
        RegionExit regionExitExpr = finishRegion.getExit();
        Stmt regionExitStmt = null;
        Stmt stmt = null;
        do {
            if ((stmt = (Stmt)stmtIt.next()) instanceof RegionStmt) {
                Region regionExpr = ((RegionStmt)stmt).getRegionExpr();
                if (regionExpr instanceof AsyncRegionExpr) {
                    this.handleAsyncRegion((RegionStmt)stmt, body, stmtIt, rtStmtMap, removeStmts, branchItems);
                    continue;
                }
                if (regionExpr instanceof FinishRegionExpr) {
                    this.handleFinishRegion((RegionStmt)stmt, body, stmtIt, rtStmtMap, removeStmts, rtTraps, branchItems);
                    continue;
                }
                if (regionExpr instanceof IsolatedRegionExpr) {
                    this.handleIsolatedRegion((RegionStmt)stmt, body, stmtIt, rtStmtMap, removeStmts, rtTraps, branchItems);
                    continue;
                }
                if (!(regionExpr instanceof LoopRegionExpr)) continue;
                this.handleLoopRegion((RegionStmt)stmt, removeStmts);
                continue;
            }
            if (!(stmt instanceof ReturnStmt) && !(stmt instanceof ReturnVoidStmt)) continue;
            ArrayList<Stmt> stopFinishStmts = new ArrayList<Stmt>();
            Local activityLocal = lg.generateLocal((Type)ActivityClassBuilder.v().hjActivityClass.getType());
            stopFinishStmts.add(HjStmtFactory.getCurrentActivity_HjWshActivity(activityLocal));
            stopFinishStmts.add(ActivityClassBuilder.v().callStopFinish(activityLocal));
            rtStmtMap.put(stmt, stopFinishStmts);
        } while (!(stmt instanceof RegionStmt) || ((RegionStmt)stmt).getRegionExpr() != regionExitExpr);
        regionExitStmt = stmt;
        ActivityClassBuilder.v().createFinishRTStmts(prevRTStmts, succRTStmts, finishRegion.getAccumulators(), rtTraps, lg);
        rtStmtMap.put((Stmt)finishRegionStmt, prevRTStmts);
        rtStmtMap.put(regionExitStmt, succRTStmts);
        removeStmts.add((Stmt)finishRegionStmt);
        removeStmts.add(regionExitStmt);
    }

    protected void handleHabFinishRegion(RegionStmt finishRegionStmt, Body body, Iterator stmtIt, HashMap<Stmt, ArrayList<Stmt>> rtStmtMap, ArrayList<Stmt> removeStmts, ArrayList<Trap> rtTraps, ArrayList branchItems) {
        FinishRegionExpr finishRegion = (FinishRegionExpr)finishRegionStmt.getRegionExpr();
        ArrayList<Object> prevRTStmts = new ArrayList<Object>();
        ArrayList<Object> succRTStmts = new ArrayList<Object>();
        LocalGenerator lg = SootFactory.v().getLocalGenerator(body);
        SootClass hjRTClass = Scene.v().getSootClass("hj.lang.Runtime");
        SootClass hjActivityClass = HjClassFactory.hjWshActivity();
        SootMethod getCurrentActivityMethod = hjRTClass.getMethod("getCurrentActivity", Collections.EMPTY_LIST, (Type)hjActivityClass.getType());
        SootMethod startFinishMethod = hjActivityClass.getMethodFromCH("startFinish", Collections.EMPTY_LIST, (Type)VoidType.v());
        SootMethod stopFinishMethod = hjActivityClass.getMethodFromCH("stopFinish", Collections.EMPTY_LIST, (Type)VoidType.v());
        ArrayList<RefType> pushExceptionTypeList = new ArrayList<RefType>();
        SootClass throwableClass = Scene.v().getSootClass("java.lang.Throwable");
        pushExceptionTypeList.add(throwableClass.getType());
        SootMethod pushExceptionMethod = hjActivityClass.getMethodFromCH("pushException", pushExceptionTypeList, (Type)VoidType.v());
        RegionExit regionExitExpr = finishRegion.getExit();
        Stmt regionExitStmt = null;
        Stmt stmt = null;
        do {
            if (!((stmt = (Stmt)stmtIt.next()) instanceof RegionStmt)) continue;
            Region regionExpr = ((RegionStmt)stmt).getRegionExpr();
            if (regionExpr instanceof AsyncRegionExpr) {
                this.handleAsyncRegion((RegionStmt)stmt, body, stmtIt, rtStmtMap, removeStmts, branchItems);
                continue;
            }
            if (regionExpr instanceof FinishRegionExpr) {
                this.handleHabFinishRegion((RegionStmt)stmt, body, stmtIt, rtStmtMap, removeStmts, rtTraps, branchItems);
                continue;
            }
            if (regionExpr instanceof IsolatedRegionExpr) {
                this.handleIsolatedRegion((RegionStmt)stmt, body, stmtIt, rtStmtMap, removeStmts, rtTraps, branchItems);
                continue;
            }
            if (!(regionExpr instanceof LoopRegionExpr)) continue;
            this.handleLoopRegion((RegionStmt)stmt, removeStmts);
        } while (!(stmt instanceof RegionStmt) || ((RegionStmt)stmt).getRegionExpr() != regionExitExpr);
        regionExitStmt = stmt;
        Local langActivityLocal = lg.generateLocal((Type)HjClassFactory.hjLangActivity().getType());
        Local activityLocal = lg.generateLocal((Type)hjActivityClass.getType());
        Stmt langAssignStmt = HjStmtFactory.getCurrentActivity_HjLangActivity(langActivityLocal);
        prevRTStmts.add(langAssignStmt);
        Stmt assignStmt = HjStmtFactory.assignLangActivityToActivityWsh(activityLocal, langActivityLocal);
        prevRTStmts.add(assignStmt);
        VirtualInvokeExpr virtualInvoke = Jimple.v().newVirtualInvokeExpr(activityLocal, startFinishMethod.makeRef(), Collections.EMPTY_LIST);
        InvokeStmt invokeStmt = Jimple.v().newInvokeStmt((Value)virtualInvoke);
        prevRTStmts.add(invokeStmt);
        langActivityLocal = lg.generateLocal((Type)HjClassFactory.hjLangActivity().getType());
        activityLocal = lg.generateLocal((Type)hjActivityClass.getType());
        langAssignStmt = HjStmtFactory.getCurrentActivity_HjLangActivity(langActivityLocal);
        succRTStmts.add(langAssignStmt);
        assignStmt = HjStmtFactory.assignLangActivityToActivityWsh(activityLocal, langActivityLocal);
        succRTStmts.add(assignStmt);
        virtualInvoke = Jimple.v().newVirtualInvokeExpr(activityLocal, stopFinishMethod.makeRef(), Collections.EMPTY_LIST);
        invokeStmt = Jimple.v().newInvokeStmt((Value)virtualInvoke);
        succRTStmts.add(invokeStmt);
        rtStmtMap.put((Stmt)finishRegionStmt, prevRTStmts);
        rtStmtMap.put(regionExitStmt, succRTStmts);
        removeStmts.add((Stmt)finishRegionStmt);
        removeStmts.add(regionExitStmt);
    }

    protected ArrayList<Stmt> createRetStmts(Stmt startStmt, Stmt returnStmt, Local placeLocal, Stmt handler0Stmt, Stmt handler1Stmt, LocalGenerator lg, SootClass hjRTPlaceClass, SootClass throwableClass, SootMethod hereMethod, SootMethod notifyAllMethod, ArrayList<Trap> rtTraps) {
        ArrayList<Stmt> retStmts = new ArrayList<Stmt>();
        NopStmt startNopLabel = Jimple.v().newNopStmt();
        retStmts.add((Stmt)startNopLabel);
        Local notifyPlcLocal = lg.generateLocal((Type)hjRTPlaceClass.getType());
        StaticInvokeExpr staticInvoke = Jimple.v().newStaticInvokeExpr(hereMethod.makeRef(), Collections.EMPTY_LIST);
        AssignStmt assignStmt = Jimple.v().newAssignStmt((Value)notifyPlcLocal, (Value)staticInvoke);
        retStmts.add((Stmt)assignStmt);
        AssignStmt retNopLabel1 = assignStmt;
        VirtualInvokeExpr virtualInvoke = Jimple.v().newVirtualInvokeExpr(notifyPlcLocal, notifyAllMethod.makeRef(), Collections.EMPTY_LIST);
        InvokeStmt invokeStmt = Jimple.v().newInvokeStmt((Value)virtualInvoke);
        retStmts.add((Stmt)invokeStmt);
        ExitMonitorStmt exitMonStmt = Jimple.v().newExitMonitorStmt((Value)placeLocal);
        retStmts.add((Stmt)exitMonStmt);
        NopStmt retNopLabel2 = Jimple.v().newNopStmt();
        retStmts.add((Stmt)retNopLabel2);
        if (returnStmt != null) {
            retStmts.add((Stmt)Jimple.v().newGotoStmt((Unit)returnStmt));
        }
        rtTraps.add(Jimple.v().newTrap(throwableClass, (Unit)startNopLabel, (Unit)retNopLabel1, (Unit)handler0Stmt));
        rtTraps.add(Jimple.v().newTrap(throwableClass, (Unit)startNopLabel, (Unit)retNopLabel2, (Unit)handler1Stmt));
        return retStmts;
    }

    protected void handleIsolatedRegion(RegionStmt isolatedRegionStmt, Body body, Iterator stmtIt, HashMap<Stmt, ArrayList<Stmt>> rtStmtMap, ArrayList<Stmt> removeStmts, ArrayList<Trap> rtTraps, ArrayList branchItems) {
        Stmt regionExitStmt = isolatedRegionStmt.getConnect();
        Stmt startStmt = null;
        while (stmtIt.hasNext()) {
            Stmt stmt = (Stmt)stmtIt.next();
            if (startStmt == null) {
                startStmt = stmt;
            }
            if (stmt == regionExitStmt) break;
            if (stmt instanceof RegionStmt) {
                Region regionExpr = ((RegionStmt)stmt).getRegionExpr();
                if (regionExpr instanceof AsyncRegionExpr) {
                    this.handleAsyncRegion((RegionStmt)stmt, body, stmtIt, rtStmtMap, removeStmts, branchItems);
                    continue;
                }
                if (regionExpr instanceof FinishRegionExpr) {
                    if (TargetedHjRuntime.isRuntimeWorkStealingHelpFirst()) {
                        this.handleHabFinishRegion((RegionStmt)stmt, body, stmtIt, rtStmtMap, removeStmts, rtTraps, branchItems);
                        continue;
                    }
                    this.handleFinishRegion((RegionStmt)stmt, body, stmtIt, rtStmtMap, removeStmts, rtTraps, branchItems);
                    continue;
                }
                if (regionExpr instanceof IsolatedRegionExpr) {
                    this.handleIsolatedRegion((RegionStmt)stmt, body, stmtIt, rtStmtMap, removeStmts, rtTraps, branchItems);
                    continue;
                }
                if (!(regionExpr instanceof LoopRegionExpr)) continue;
                this.handleLoopRegion((RegionStmt)stmt, removeStmts);
                continue;
            }
            if (!(stmt instanceof ReturnStmt) && !(stmt instanceof ReturnVoidStmt)) continue;
        }
        ArrayList<Stmt> predStmts = new ArrayList<Stmt>();
        ArrayList<Stmt> succStmts = new ArrayList<Stmt>();
        ActivityClassBuilder.buildIsolatedRegion(body, isolatedRegionStmt, SootFactory.v().getLocalGenerator(body), predStmts, succStmts, removeStmts);
        rtStmtMap.put((Stmt)isolatedRegionStmt, predStmts);
        rtStmtMap.put(regionExitStmt, succStmts);
    }

    protected void handleIsolatedRegion_(RegionStmt isolatedRegionStmt, Body body, Iterator stmtIt, HashMap<Stmt, ArrayList<Stmt>> rtStmtMap, ArrayList<Stmt> removeStmts, ArrayList<Trap> rtTraps, ArrayList branchItems) {
        AssignStmt assignStmt;
        SootMethod startIsolationMethod;
        ArrayList<Value> paramList;
        ArrayList<RefType> typeList;
        LocalGenerator lg = SootFactory.v().getLocalGenerator(body);
        SootClass hjRTClass = Scene.v().getSootClass("hj.lang.Runtime");
        SootClass hjObjectClass = Scene.v().getSootClass("hj.lang.Object");
        SootClass throwableClass = Scene.v().getSootClass("java.lang.Throwable");
        ArrayList<Object> predStmts = new ArrayList<Object>();
        ArrayList<Object> succStmts = new ArrayList<Object>();
        IsolatedRegionExpr isolatedRegionExpr = (IsolatedRegionExpr)isolatedRegionStmt.getRegionExpr();
        List objectList = isolatedRegionExpr.getObjects();
        ArrayType intArrayType = ArrayType.v((Type)IntType.v(), (int)1);
        Local placeID = null;
        Local placeIDs = null;
        NopStmt labelEntryTry = Jimple.v().newNopStmt();
        predStmts.add(labelEntryTry);
        if (objectList == null || objectList.size() == 0) {
            SootMethod startIsolationMethod2 = hjRTClass.getMethod("startIsolation", Collections.EMPTY_LIST, (Type)VoidType.v());
            InvokeStmt invokeStmt = Jimple.v().newInvokeStmt((Value)Jimple.v().newStaticInvokeExpr(startIsolationMethod2.makeRef(), Collections.EMPTY_LIST));
            predStmts.add(invokeStmt);
        } else if (objectList.size() == 1) {
            typeList = new ArrayList<RefType>();
            paramList = new ArrayList<Value>();
            typeList.add(hjObjectClass.getType());
            paramList.add(((HjObject)objectList.get(0)).getLocalValue());
            startIsolationMethod = hjRTClass.getMethod("startIsolation", typeList, (Type)IntType.v());
            placeID = lg.generateLocal((Type)IntType.v());
            assignStmt = Jimple.v().newAssignStmt((Value)placeID, (Value)Jimple.v().newStaticInvokeExpr(startIsolationMethod.makeRef(), paramList));
            predStmts.add(assignStmt);
        } else if (objectList.size() == 2) {
            typeList = new ArrayList();
            paramList = new ArrayList();
            typeList.add(hjObjectClass.getType());
            typeList.add(hjObjectClass.getType());
            paramList.add(((HjObject)objectList.get(0)).getLocalValue());
            paramList.add(((HjObject)objectList.get(1)).getLocalValue());
            startIsolationMethod = hjRTClass.getMethod("startIsolation", typeList, (Type)intArrayType);
            placeIDs = lg.generateLocal((Type)intArrayType);
            assignStmt = Jimple.v().newAssignStmt((Value)placeIDs, (Value)Jimple.v().newStaticInvokeExpr(startIsolationMethod.makeRef(), paramList));
            predStmts.add(assignStmt);
        } else {
            ArrayType hjObjsType = ArrayType.v((Type)hjObjectClass.getType(), (int)1);
            Local objsLocal = lg.generateLocal((Type)hjObjsType);
            AssignStmt assignStmt2 = Jimple.v().newAssignStmt((Value)objsLocal, (Value)Jimple.v().newNewArrayExpr((Type)hjObjectClass.getType(), (Value)IntConstant.v((int)objectList.size())));
            predStmts.add(assignStmt2);
            for (int i = 0; i < objectList.size(); ++i) {
                HjObject hjObj = (HjObject)objectList.get(i);
                Value objValue = hjObj.getLocalValue();
                AssignStmt arrayStmt = Jimple.v().newAssignStmt((Value)Jimple.v().newArrayRef((Value)objsLocal, (Value)IntConstant.v((int)i)), objValue);
            }
            ArrayList<ArrayType> typeList2 = new ArrayList<ArrayType>();
            ArrayList<Local> paramList2 = new ArrayList<Local>();
            typeList2.add(hjObjsType);
            paramList2.add(objsLocal);
            SootMethod startIsolationMethod3 = hjRTClass.getMethod("startIsolation", typeList2, (Type)intArrayType);
            assignStmt2 = Jimple.v().newAssignStmt((Value)placeIDs, (Value)Jimple.v().newStaticInvokeExpr(startIsolationMethod3.makeRef(), paramList2));
            predStmts.add(assignStmt2);
        }
        Stmt regionExitStmt = isolatedRegionStmt.getConnect();
        Stmt startStmt = null;
        while (stmtIt.hasNext()) {
            Stmt stmt = (Stmt)stmtIt.next();
            if (startStmt == null) {
                startStmt = stmt;
            }
            if (stmt == regionExitStmt) break;
            if (stmt instanceof RegionStmt) {
                Region regionExpr = ((RegionStmt)stmt).getRegionExpr();
                if (regionExpr instanceof AsyncRegionExpr) {
                    this.handleAsyncRegion((RegionStmt)stmt, body, stmtIt, rtStmtMap, removeStmts, branchItems);
                    continue;
                }
                if (regionExpr instanceof FinishRegionExpr) {
                    if (TargetedHjRuntime.isRuntimeWorkStealingHelpFirst()) {
                        this.handleHabFinishRegion((RegionStmt)stmt, body, stmtIt, rtStmtMap, removeStmts, rtTraps, branchItems);
                        continue;
                    }
                    this.handleFinishRegion((RegionStmt)stmt, body, stmtIt, rtStmtMap, removeStmts, rtTraps, branchItems);
                    continue;
                }
                if (regionExpr instanceof IsolatedRegionExpr) {
                    this.handleIsolatedRegion((RegionStmt)stmt, body, stmtIt, rtStmtMap, removeStmts, rtTraps, branchItems);
                    continue;
                }
                if (!(regionExpr instanceof LoopRegionExpr)) continue;
                this.handleLoopRegion((RegionStmt)stmt, removeStmts);
                continue;
            }
            if (!(stmt instanceof ReturnStmt) && !(stmt instanceof ReturnVoidStmt)) continue;
        }
        NopStmt endStmt = Jimple.v().newNopStmt();
        Stmt label1 = ActivityClassBuilder.v().createStopIsolation(placeID, placeIDs, hjRTClass);
        succStmts.add(label1);
        succStmts.add(Jimple.v().newGotoStmt((Unit)endStmt));
        Local excpLocal = lg.generateLocal((Type)throwableClass.getType());
        IdentityStmt label2 = Jimple.v().newIdentityStmt((Value)excpLocal, (Value)Jimple.v().newCaughtExceptionRef());
        succStmts.add(label2);
        Stmt label3 = ActivityClassBuilder.v().createStopIsolation(placeID, placeIDs, hjRTClass);
        succStmts.add(label3);
        ThrowStmt label4 = Jimple.v().newThrowStmt((Value)excpLocal);
        succStmts.add(label4);
        succStmts.add(endStmt);
        rtTraps.add(Jimple.v().newTrap(throwableClass, (Unit)labelEntryTry, (Unit)label1, (Unit)label2));
        rtTraps.add(Jimple.v().newTrap(throwableClass, (Unit)label3, (Unit)label4, (Unit)label2));
        rtStmtMap.put((Stmt)isolatedRegionStmt, predStmts);
        rtStmtMap.put(regionExitStmt, succStmts);
        removeStmts.add((Stmt)isolatedRegionStmt);
        removeStmts.add(regionExitStmt);
    }

    protected void handleLoopRegion(RegionStmt loopRegionStmt, ArrayList<Stmt> removeStmts) {
        removeStmts.add((Stmt)loopRegionStmt);
        RegionStmt regionExitStmt = (RegionStmt)loopRegionStmt.getConnect();
        if (!(regionExitStmt.getRegionExpr() instanceof RegionExit)) {
            throw new Error("Can not find the exit of loop region");
        }
        removeStmts.add((Stmt)regionExitStmt);
    }
}

