/*
 * Decompiled with CFR 0.152.
 */
package soot.hj.HjToJimple.jimple;

import java.util.Iterator;
import java.util.List;
import soot.Body;
import soot.Local;
import soot.Unit;
import soot.Value;
import soot.ValueBox;
import soot.hj.HjToJimple.jimple.NopRegionExpr;
import soot.hj.HjToJimple.jimple.RegionStmt;
import soot.hj.HjToJimple.jimple.utils.HjMHGDominatorsFinder;
import soot.hj.HjToJimple.jimple.utils.HjMHGPostDominatorsFinder;
import soot.jimple.GotoStmt;
import soot.jimple.IfStmt;
import soot.jimple.JimpleBody;
import soot.jimple.NopStmt;
import soot.jimple.Stmt;
import soot.toolkits.graph.BriefUnitGraph;
import soot.toolkits.graph.CompleteUnitGraph;
import soot.toolkits.graph.DirectedGraph;
import soot.toolkits.graph.SimpleDominatorsFinder;
import soot.toolkits.graph.UnitGraph;
import soot.toolkits.scalar.SimpleLocalDefs;

public class HjWSTool {
    protected JimpleBody body;
    protected SimpleLocalDefs localDefs;
    protected HjMHGDominatorsFinder mhgDominator;
    protected HjMHGPostDominatorsFinder mhgPostDominator;
    protected SimpleDominatorsFinder sDominator;

    public HjWSTool(Body body) {
        this.body = (JimpleBody)body;
        this.eliminateNops(body);
        this.localDefs = new SimpleLocalDefs((UnitGraph)new CompleteUnitGraph(body));
        this.mhgDominator = new HjMHGDominatorsFinder(new BriefUnitGraph(body));
        this.mhgPostDominator = new HjMHGPostDominatorsFinder((DirectedGraph)new BriefUnitGraph(body));
    }

    protected void eliminateNops(Body body) {
        Iterator unitIter = body.getUnits().snapshotIterator();
        while (unitIter.hasNext()) {
            RegionStmt regionStmt;
            Unit unit = (Unit)unitIter.next();
            if (!(unit instanceof RegionStmt) || !((regionStmt = (RegionStmt)unit).getRegionExpr() instanceof NopRegionExpr)) continue;
            body.getUnits().remove((Object)unit);
        }
    }

    public Body getBody() {
        return this.body;
    }

    protected Stmt seekDom(Stmt stmt) {
        if (stmt instanceof IfStmt || stmt instanceof NopStmt) {
            return (Stmt)this.body.getUnits().getPredOf((Unit)stmt);
        }
        List ptt = stmt.getBoxesPointingToThis();
        if (ptt.size() > 1) {
            for (Unit unit : this.body.getUnits()) {
                if (!(unit instanceof IfStmt ? ((IfStmt)unit).getTarget() == stmt : unit instanceof GotoStmt && ((GotoStmt)unit).getTarget() == stmt)) continue;
                return (Stmt)unit;
            }
        }
        return null;
    }

    public boolean shouldSave(Stmt labelStmt, Local local) {
        List dominators = this.mhgDominator.getOldDominators(labelStmt);
        while (dominators == null || dominators.size() == 0) {
            try {
                labelStmt = (Stmt)this.body.getUnits().getPredOf((Unit)labelStmt);
                dominators = this.mhgDominator.getOldDominators(labelStmt);
            }
            catch (Exception e) {
                return false;
            }
        }
        Stmt immDom = (Stmt)this.mhgDominator.getImmediateDominator(labelStmt);
        if (immDom == null) {
            immDom = this.seekDom(labelStmt);
        }
        while (immDom != null) {
            Stmt nextDom;
            if (immDom != labelStmt) {
                Iterator defBoxes = immDom.getDefBoxes().iterator();
                while (defBoxes.hasNext()) {
                    Value defValue = ((ValueBox)defBoxes.next()).getValue();
                    if (defValue != local) continue;
                    return true;
                }
            }
            if ((nextDom = (Stmt)this.mhgDominator.getImmediateDominator(immDom)) == null) {
                immDom = this.seekDom(immDom);
                continue;
            }
            immDom = nextDom;
        }
        return false;
    }

    public RegionStmt getRegionEntry(RegionStmt regionExit) {
        RegionStmt predStmt = regionExit;
        RegionStmt regionEntry = (RegionStmt)regionExit.getConnect();
        while (predStmt != null) {
            try {
                predStmt = (Stmt)this.body.getUnits().getPredOf((Unit)predStmt);
                if (!(predStmt instanceof RegionStmt)) continue;
                if (predStmt != null) {
                    throw new Error("region: " + predStmt);
                }
                RegionStmt regionStmt = predStmt;
                if (!regionStmt.isRegionEntry() || !regionStmt.getRegionExpr().getType().equals(regionEntry.getRegionExpr().getType())) continue;
                return regionStmt;
            }
            catch (Exception e) {
            }
        }
        return null;
    }

    public boolean shouldSave_(Stmt labelStmt, Local local) {
        List dominators = this.mhgDominator.getOldDominators(labelStmt);
        while (dominators == null || dominators.size() == 1) {
            try {
                labelStmt = (Stmt)this.body.getUnits().getPredOf((Unit)labelStmt);
                if (labelStmt instanceof GotoStmt) {
                    return false;
                }
                dominators = this.mhgDominator.getOldDominators(labelStmt);
            }
            catch (Exception e) {
                return false;
            }
        }
        Iterator domIter = this.mhgDominator.getOldDominators(labelStmt).iterator();
        Stmt stmt = null;
        while (domIter.hasNext()) {
            stmt = (Stmt)domIter.next();
            Iterator defBoxes = stmt.getDefBoxes().iterator();
            while (defBoxes.hasNext()) {
                Value defValue = ((ValueBox)defBoxes.next()).getValue();
                if (defValue != local) continue;
                return true;
            }
        }
        if (this.body.getFirstNonIdentityStmt() == null) {
            return false;
        }
        List postDoms = this.mhgPostDominator.getOldDominators(this.body.getFirstNonIdentityStmt());
        postDoms.add(this.body.getFirstNonIdentityStmt());
        while (stmt != null) {
            try {
                stmt = (Stmt)this.body.getUnits().getPredOf((Unit)stmt);
                if (stmt == labelStmt || !postDoms.contains(stmt)) continue;
                Iterator defBoxes = stmt.getDefBoxes().iterator();
                while (defBoxes.hasNext()) {
                    Value defValue = ((ValueBox)defBoxes.next()).getValue();
                    if (defValue != local) continue;
                    return true;
                }
            }
            catch (Exception e) {
                stmt = null;
            }
        }
        return false;
    }
}

