/*
 * Decompiled with CFR 0.152.
 */
package soot.hj.HjToJimple.jimple;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import soot.Body;
import soot.MethodOrMethodContext;
import soot.RefType;
import soot.Scene;
import soot.SceneTransformer;
import soot.Singletons;
import soot.SootClass;
import soot.SootMethod;
import soot.hj.HjSingletons;
import soot.hj.HjToJimple.jimple.HabAttrBox;
import soot.hj.HjToJimple.jimple.HabRTAdaptClassBuilder;
import soot.hj.HjToJimple.jimple.HabRTClassBuilder;
import soot.hj.HjToJimple.jimple.HabRTWFClassBuilder;
import soot.hj.HjToJimple.jimple.HjRSTTranslator;
import soot.hj.HjToJimple.jimple.HjRuntimeTranslator;
import soot.hj.HjToJimple.jimple.TargetedHjRuntime;
import soot.hj.HjToJimple.jimple.utils.RSTNodeMap;
import soot.hj.HjToJimple.util.RSTNode;
import soot.hj.workstealing.WstExceptionInjector;
import soot.jimple.JimpleBody;
import soot.jimple.toolkits.callgraph.CallGraph;
import soot.jimple.toolkits.callgraph.Edge;
import soot.util.Chain;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HjWSTranslator
extends SceneTransformer {
    protected ArrayList<SootClass> extraClasses = new ArrayList();
    protected HabRTClassBuilder habRTClassBuilder;

    public HjWSTranslator(Singletons.Global g) {
    }

    public static HjWSTranslator v() {
        return HjSingletons.v().soot_hj_HjToJimple_jimple_HjWSTranslator();
    }

    protected void internalTransform(String phaseName, Map opts) {
        if (TargetedHjRuntime.isRuntimeWorkStealingWorkFirst()) {
            this.habRTClassBuilder = HabRTWFClassBuilder.v();
        } else if (TargetedHjRuntime.isRuntimeWorkStealingHelpFirst()) {
            this.habRTClassBuilder = HabRTClassBuilder.v();
        } else if (TargetedHjRuntime.isRuntimeWorkStealingAdaptive()) {
            this.habRTClassBuilder = HabRTAdaptClassBuilder.v();
        } else {
            throw new RuntimeException("Unrecognized work-stealing code generation policy");
        }
        this.hjWSTransform(phaseName, opts);
    }

    protected void hjWSTransform(String phaseName, Map opts) {
        HashSet<SootMethod> appMethodSet = new HashSet<SootMethod>();
        HashMap<SootMethod, HabAttrBox> contMethodMap = new HashMap<SootMethod, HabAttrBox>();
        HashSet<SootMethod> methodContSet = new HashSet<SootMethod>();
        this.collectAppMethods(appMethodSet);
        this.rewriteTryCatch(appMethodSet);
        this.rebuildRST(appMethodSet);
        int size = 0;
        do {
            size = contMethodMap.keySet().size();
            this.collectContMethods(appMethodSet, contMethodMap, methodContSet);
            this.collectAbstractConts(contMethodMap);
        } while (size == contMethodMap.keySet().size());
        this.extractAsyncs(contMethodMap);
        this.extractUnhandledIsolated(contMethodMap, appMethodSet);
        HashMap local2FieldMap = new HashMap();
        HashMap field2LocalMap = new HashMap();
        for (SootMethod method : contMethodMap.keySet()) {
            if (!method.isConcrete()) continue;
            HabAttrBox habBox = contMethodMap.get(method);
            if (this.habRTClassBuilder.hasContinuation(RSTNodeMap.getRstNode(method), contMethodMap, false) || habBox.isExecMethod()) {
                // empty if block
            }
            if (habBox.isExecMethod()) {
                HjRSTTranslator.v().rebuildRST(method.retrieveActiveBody(), null, null);
                if (!TargetedHjRuntime.isRuntimeWorkStealingAdaptive() || !this.habRTClassBuilder.hasAsync(RSTNodeMap.getRstNode(method))) {
                    // empty if block
                }
            }
            local2FieldMap.clear();
            field2LocalMap.clear();
            SootClass frameClass = this.habRTClassBuilder.buildFrameClass(method, contMethodMap, habBox, local2FieldMap, field2LocalMap);
            habBox.setFrameClass(frameClass);
            if (!method.isMain()) continue;
            HjRuntimeTranslator.createHjRuntimeTargetField(method.getDeclaringClass());
            HjRuntimeTranslator.createRaceDetField(method.getDeclaringClass());
            HjRuntimeTranslator.createOVDField(method.getDeclaringClass());
        }
        this.cleanMethods(contMethodMap);
        this.refineNoContMethods(appMethodSet, contMethodMap);
    }

    private void rewriteTryCatch(HashSet<SootMethod> appMethodSet) {
        WstExceptionInjector exceptionInjector = null;
        for (SootMethod sootMethod : appMethodSet) {
            Body methodBody = sootMethod.getActiveBody();
            if (!WstExceptionInjector.needExceptionInjection(methodBody)) continue;
            if (exceptionInjector == null) {
                exceptionInjector = new WstExceptionInjector();
            }
            exceptionInjector.injectWstException(methodBody);
        }
    }

    protected void extractAsyncs(HashMap<SootMethod, HabAttrBox> contMethodMap) {
        Iterator<Object> methodIter = contMethodMap.keySet().iterator();
        ArrayList<SootMethod> methodList = new ArrayList<SootMethod>();
        while (methodIter.hasNext()) {
            methodList.add(methodIter.next());
        }
        methodIter = methodList.iterator();
        int methodCounter = 0;
        while (methodIter.hasNext()) {
            SootMethod method = (SootMethod)methodIter.next();
            if (!method.isConcrete()) continue;
            this.habRTClassBuilder.identityLocals(method);
            this.habRTClassBuilder.extractAsync(method, method, RSTNodeMap.getRstNode(method), contMethodMap, methodCounter += 10);
        }
    }

    protected void extractUnhandledIsolated(HashMap<SootMethod, HabAttrBox> contMethodMap, HashSet<SootMethod> appMethodSet) {
        for (SootMethod m : appMethodSet) {
            if (contMethodMap.containsKey(m)) continue;
            this.habRTClassBuilder.extractIsolated(m, RSTNodeMap.getRstNode(m));
        }
    }

    protected void cleanMethods(HashMap<SootMethod, HabAttrBox> contMethodMap) {
        for (SootMethod method : contMethodMap.keySet()) {
            HabAttrBox habBox = contMethodMap.get(method);
            if (habBox.isExecMethod()) continue;
            method.releaseActiveBody();
            method.getDeclaringClass().removeMethod(method);
        }
    }

    protected void rebuildRST(HashSet<SootMethod> appMethodSet) {
        Iterator<SootMethod> methodIter = appMethodSet.iterator();
        while (methodIter.hasNext()) {
            HjRSTTranslator.v().rebuildRST(methodIter.next().retrieveActiveBody(), null, null);
        }
    }

    protected void collectAppMethods(HashSet<SootMethod> appMethodSet) {
        for (SootClass appClass : Scene.v().getApplicationClasses()) {
            ListIterator methodIter = appClass.getMethods().listIterator();
            while (methodIter.hasNext()) {
                SootMethod method = (SootMethod)methodIter.next();
                if (method.getName().startsWith("<init>") || !method.hasActiveBody() || this.isConcreteMethod(method, appClass.getSuperclass())) continue;
                appMethodSet.add(method);
            }
        }
    }

    protected void collectAbstractConts(HashMap<SootMethod, HabAttrBox> contMethodMap) {
        HashMap<SootMethod, HabAttrBox> tmpContMap = new HashMap<SootMethod, HabAttrBox>();
        Iterator<SootMethod> methodIter = contMethodMap.keySet().iterator();
        ArrayList<SootClass> list = new ArrayList<SootClass>();
        while (methodIter.hasNext()) {
            SootMethod method = methodIter.next();
            SootClass sc = method.getDeclaringClass();
            this.collectInterfacesAndAbstract(sc, list);
            Iterator classIter = list.iterator();
            while (classIter.hasNext()) {
                this.checkInterfaces((SootClass)classIter.next(), method, tmpContMap);
            }
        }
        contMethodMap.putAll(tmpContMap);
    }

    public void collectInterfacesAndAbstract(SootClass sootClass, List<SootClass> classesList) {
        Chain chain = Scene.v().getApplicationClasses();
        if (chain.contains((Object)sootClass)) {
            if (sootClass.hasSuperclass() && !classesList.contains(sootClass)) {
                this.collectInterfacesAndAbstract(sootClass.getSuperclass(), classesList);
            }
            classesList.add(sootClass);
            for (SootClass newInterface : sootClass.getInterfaces()) {
                this.collectInterfacesAndAbstract(newInterface, classesList);
            }
        }
    }

    protected void checkInterfaces(SootClass classToCheck, SootMethod method, HashMap<SootMethod, HabAttrBox> tmpContMap) {
        if ((classToCheck.isInterface() || classToCheck.isAbstract()) && classToCheck.declaresMethod(method.getName(), method.getParameterTypes())) {
            ArrayList<RefType> typeList = new ArrayList<RefType>();
            typeList.add(HabRTClassBuilder.v().habHFWorker.getType());
            typeList.addAll(method.getParameterTypes());
            if (!classToCheck.declaresMethod(method.getName(), typeList)) {
                SootMethod abstractMethod = classToCheck.getMethod(method.getName(), method.getParameterTypes());
                int modifiers = abstractMethod.getModifiers();
                SootMethod newMethod = new SootMethod(method.getName(), typeList, method.getReturnType(), modifiers);
                newMethod.setDeclaringClass(classToCheck);
                classToCheck.addMethod(newMethod);
                HabAttrBox habBox = new HabAttrBox();
                habBox.setFastClone(newMethod);
                tmpContMap.put(abstractMethod, habBox);
                HabRTClassBuilder.v().addContMethod(abstractMethod);
            }
        }
    }

    protected void refineNoContMethods(HashSet<SootMethod> appMethodSet, HashMap<SootMethod, HabAttrBox> contMethodMap) {
        for (SootMethod method : appMethodSet) {
            SootClass declClass;
            if (contMethodMap.containsKey(method) || (declClass = method.getDeclaringClass()).getInterfaces().size() == 0 && !declClass.getSuperclass().isAbstract()) continue;
            ArrayList<RefType> typeList = new ArrayList<RefType>();
            typeList.add(HabRTClassBuilder.v().habHFWorker.getType());
            typeList.addAll(method.getParameterTypes());
            boolean reset = false;
            for (SootClass interfaceClass : declClass.getInterfaces()) {
                if (!interfaceClass.declaresMethod(method.getName(), typeList, method.getReturnType())) continue;
                this.createFakeMethod(declClass, typeList, method);
                reset = true;
                break;
            }
            if (reset) continue;
            typeList = new ArrayList();
            typeList.add(HabRTClassBuilder.v().habHFWorker.getType());
            typeList.addAll(method.getParameterTypes());
            SootClass superClass = declClass.getSuperclass();
            if (!superClass.declaresMethod(method.getName(), typeList, method.getReturnType())) continue;
            this.createFakeMethod(declClass, typeList, method);
        }
    }

    protected void createFakeMethod(SootClass declClass, ArrayList typeList, SootMethod method) {
        SootMethod fakeMethod = new SootMethod(method.getName(), (List)typeList, method.getReturnType(), method.getModifiers());
        fakeMethod.setDeclaringClass(declClass);
        declClass.addMethod(fakeMethod);
        JimpleBody methodBody = (JimpleBody)method.getActiveBody().clone();
        fakeMethod.setActiveBody((Body)methodBody);
    }

    protected void collectContMethods(HashSet<SootMethod> appMethodSet, HashMap<SootMethod, HabAttrBox> contMethodMap, HashSet<SootMethod> methodContSet) {
        for (SootMethod method : appMethodSet) {
            SootMethod fcMethod;
            HabAttrBox habBox;
            if (contMethodMap.containsKey(method)) continue;
            if (appMethodSet.contains(method) && this.checkFinishAsync(RSTNodeMap.getRstNode(method))) {
                habBox = new HabAttrBox();
                fcMethod = this.habRTClassBuilder.createFCMethod(method, habBox);
                habBox.setFastClone(fcMethod);
                contMethodMap.put(method, habBox);
                methodContSet.add(method);
                continue;
            }
            if (!method.getSubSignature().equals("void main(java.lang.String[])")) continue;
            habBox = new HabAttrBox();
            fcMethod = this.habRTClassBuilder.createFCMethod(method, habBox);
            habBox.setFastClone(fcMethod);
            contMethodMap.put(method, habBox);
            methodContSet.add(method);
        }
        CallGraph cg = Scene.v().getCallGraph();
        boolean change = true;
        while (change) {
            change = false;
            block2: for (SootMethod method : appMethodSet) {
                if (contMethodMap.containsKey(method)) continue;
                Iterator edgeIter = cg.edgesOutOf((MethodOrMethodContext)method);
                while (edgeIter.hasNext()) {
                    Edge edge = (Edge)edgeIter.next();
                    if (!contMethodMap.containsKey(edge.tgt())) continue;
                    HabAttrBox habBox = new HabAttrBox();
                    SootMethod fcMethod = this.habRTClassBuilder.createFCMethod(method, habBox);
                    habBox.setFastClone(fcMethod);
                    contMethodMap.put(method, habBox);
                    change = true;
                    continue block2;
                }
            }
        }
    }

    protected boolean checkFinishAsync(RSTNode rstNode) {
        return this.habRTClassBuilder.hasContinuation(rstNode, false);
    }

    protected boolean isConcreteMethod(SootMethod method, SootClass checkClass) {
        if (checkClass.declaresMethod(method.getSubSignature())) {
            return checkClass.getMethod(method.getSubSignature()).isConcrete();
        }
        return false;
    }
}

