/*
 * Decompiled with CFR 0.152.
 */
package soot.hj.HjToJimple.jimple.ext.cooperative;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import soot.Body;
import soot.Local;
import soot.Scene;
import soot.SceneTransformer;
import soot.Singletons;
import soot.SootClass;
import soot.SootMethod;
import soot.Type;
import soot.Value;
import soot.hj.HjSingletons;
import soot.hj.HjToJimple.jimple.factory.HjClassFactory;
import soot.hj.HjToJimple.jimple.utils.StmtUtils;
import soot.hj.options.HjOptions;
import soot.jimple.AssignStmt;
import soot.jimple.CastExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.Jimple;
import soot.jimple.Stmt;
import soot.jimple.VirtualInvokeExpr;

public class HjCooperativeFutureGetTranslator
extends SceneTransformer {
    public static HjCooperativeFutureGetTranslator v() {
        return HjSingletons.v().soot_hj_HjToJimple_jimple_ext_cooperative_HjCooperativeFutureGetTranslator();
    }

    public HjCooperativeFutureGetTranslator(Singletons.Global g) {
    }

    protected void internalTransform(String phaseName, Map opts) {
        for (SootClass appClass : Scene.v().getApplicationClasses()) {
            for (SootMethod sootMethod : appClass.getMethods()) {
                if (!sootMethod.isConcrete()) continue;
                this.internalBodyTransform(sootMethod.getActiveBody(), phaseName, opts);
            }
        }
    }

    protected void internalBodyTransform(Body body, String phaseName, Map opts) {
        Iterator stmtIt = body.getUnits().snapshotIterator();
        while (stmtIt.hasNext()) {
            Stmt stmt = (Stmt)stmtIt.next();
            if (!stmt.containsInvokeExpr()) continue;
            this.handleInvoke(body, stmt);
        }
    }

    protected void handleInvoke(Body body, Stmt stmt) {
        InvokeExpr invokeExpr = stmt.getInvokeExpr();
        if (this.isInvokeOnFutureGet(invokeExpr)) {
            if (HjOptions.v().hjVerbose()) {
                System.out.println("Transforming future.get call [" + invokeExpr + "] in " + body.getMethod());
            }
            VirtualInvokeExpr virtualInvokeExpr = (VirtualInvokeExpr)invokeExpr;
            if (stmt instanceof AssignStmt) {
                this.invokeWithReturn(virtualInvokeExpr, body, (AssignStmt)stmt);
            } else {
                throw new RuntimeException("Unsupported future.get() stmt: " + stmt);
            }
        }
    }

    protected boolean isInvokeOnFutureGet(InvokeExpr invokeExpr) {
        if (invokeExpr instanceof VirtualInvokeExpr) {
            SootMethod sootMethod = invokeExpr.getMethod();
            SootClass baseClass = sootMethod.getDeclaringClass();
            SootClass hjLangFutureClass = HjClassFactory.hjLangFuture();
            if (HjClassFactory.isAssignableFrom(hjLangFutureClass, baseClass) && "get".equals(sootMethod.getName())) {
                return true;
            }
        }
        return false;
    }

    protected void invokeWithReturn(VirtualInvokeExpr invokeExpr, Body body, AssignStmt stmt) {
        LinkedList<Stmt> newStmtList = new LinkedList<Stmt>();
        SootClass wshFutureClass = HjClassFactory.hjWshFuture();
        String newLocalName = stmt.getLeftOp().toString() + "_future";
        Local wshFutureLocal = Jimple.v().newLocal(newLocalName, (Type)wshFutureClass.getType());
        body.getLocals().add((Object)wshFutureLocal);
        Value invokeExprBase = invokeExpr.getBase();
        CastExpr castExpr = Jimple.v().newCastExpr(invokeExprBase, wshFutureLocal.getType());
        AssignStmt newLocalAssignStmt = Jimple.v().newAssignStmt((Value)wshFutureLocal, (Value)castExpr);
        newStmtList.add((Stmt)newLocalAssignStmt);
        SootMethod futureGetMethod = wshFutureClass.getMethod("pausableGet", Collections.emptyList());
        VirtualInvokeExpr virtualInvokeExpr = Jimple.v().newVirtualInvokeExpr(wshFutureLocal, futureGetMethod.makeRef(), Collections.emptyList());
        AssignStmt newAssignStmt = Jimple.v().newAssignStmt(stmt.getLeftOp(), (Value)virtualInvokeExpr);
        newStmtList.add((Stmt)newAssignStmt);
        StmtUtils.replaceStmt(body, (Stmt)stmt, newStmtList);
    }
}

