/*
 * Decompiled with CFR 0.152.
 */
package soot.hj.HjToJimple.jimple.ext.cooperative;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import soot.CompilationDeathException;
import soot.Scene;
import soot.SceneTransformer;
import soot.Singletons;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.hj.HjSingletons;
import soot.hj.HjToJimple.HjUtil;
import soot.hj.HjToJimple.jimple.ext.cooperative.MethodManager;
import soot.hj.HjToJimple.jimple.factory.HjClassFactory;
import soot.jimple.InvokeExpr;
import soot.jimple.Stmt;
import soot.tagkit.Host;
import soot.util.Chain;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HjPausableMethodMarker
extends SceneTransformer {
    public static HjPausableMethodMarker v() {
        return HjSingletons.v().soot_hj_HjToJimple_jimple_ext_cooperative_HjPausableMethodMarker();
    }

    public HjPausableMethodMarker(Singletons.Global g) {
    }

    protected void internalTransform(String phaseName, Map opts) {
        this.annotatePausableMethods();
    }

    private void annotatePausableMethods() {
        MethodManager methodManager = this.buildMethodManager();
        this.handleInterfaceMethods(methodManager);
        this.handlePausableMethodsFromOverride(methodManager);
        this.handlePausableMethodsFromBody(methodManager);
        this.handleDefaultNonPausableMethods(methodManager);
        this.handleUnmarkedMethods(methodManager);
        this.verifyNonPausableOverrides(methodManager);
    }

    private MethodManager buildMethodManager() {
        LinkedList<SootMethod> allMethods = new LinkedList<SootMethod>();
        LinkedList<SootClass> appClassesSorted = this.getAppClassesSortedByHierarchy((Chain<SootClass>)Scene.v().getApplicationClasses());
        for (SootClass appClass : appClassesSorted) {
            if (this.isGeneratedClass(appClass)) continue;
            allMethods.addAll(appClass.getMethods());
        }
        return new MethodManager(allMethods);
    }

    protected LinkedList<SootClass> getAppClassesSortedByHierarchy(Chain<SootClass> applicationClasses) {
        LinkedList<SootClass> resultList = new LinkedList<SootClass>((Collection<SootClass>)applicationClasses);
        Collections.sort(resultList, new Comparator<SootClass>(){

            @Override
            public int compare(SootClass firstClass, SootClass secondClass) {
                return this.getHierarchyLength(firstClass) - this.getHierarchyLength(secondClass);
            }

            private int getHierarchyLength(SootClass sootClass) {
                int count = 0;
                SootClass c = sootClass;
                while (c.hasSuperclass()) {
                    ++count;
                    c = c.getSuperclass();
                }
                return count;
            }
        });
        return resultList;
    }

    protected void handleInterfaceMethods(MethodManager methodManager) {
        for (SootMethod sootMethod : methodManager.unmarkedMethods()) {
            if (methodManager.isMarked(sootMethod) || !sootMethod.getDeclaringClass().isInterface()) continue;
            if (HjPausableMethodMarker.isPausable(sootMethod)) {
                methodManager.markNonPausable(sootMethod, "interface method declared pausable");
                continue;
            }
            methodManager.markNonPausable(sootMethod, "interface methods non-pausable");
        }
    }

    protected void handlePausableMethodsFromOverride(MethodManager methodManager) {
        Chain applicationClasses = Scene.v().getApplicationClasses();
        for (SootMethod sootMethod : methodManager.unmarkedMethods()) {
            if (methodManager.isMarked(sootMethod) || sootMethod.isStatic() || sootMethod.isPrivate() || sootMethod.isConstructor()) continue;
            this.processForOverrides((Chain<SootClass>)applicationClasses, sootMethod.getDeclaringClass(), sootMethod, methodManager);
        }
    }

    protected void processForOverrides(Chain<SootClass> applicationClasses, SootClass appClass, SootMethod sootMethod, MethodManager methodManager) {
        SootMethod parentMethod = HjPausableMethodMarker.findParentMethod(appClass, sootMethod);
        if (parentMethod != null) {
            if (HjPausableMethodMarker.isPausable(parentMethod)) {
                methodManager.markPausable(sootMethod, "extends pausable method");
            } else if (!applicationClasses.contains((Object)parentMethod.getDeclaringClass())) {
                methodManager.markNonPausable(sootMethod, "overrides non-pausable method");
                methodManager.registerNonPausableOverride(sootMethod);
            }
        }
    }

    protected static SootMethod findParentMethod(SootClass appClass, SootMethod sootMethod) {
        for (SootClass loopInterface : appClass.getInterfaces()) {
            List<SootClass> intfClasses = HjPausableMethodMarker.findAllInterfaces(loopInterface);
            for (SootClass intfClass : intfClasses) {
                SootMethod intfMethod = HjPausableMethodMarker.lookupMethodInClass(sootMethod, intfClass);
                if (intfMethod == null) continue;
                return intfMethod;
            }
        }
        if (appClass.hasSuperclass()) {
            SootClass superClass = appClass.getSuperclass();
            SootMethod parentMethod = HjPausableMethodMarker.lookupMethodInClass(sootMethod, superClass);
            if (parentMethod != null) {
                return parentMethod;
            }
            return HjPausableMethodMarker.findParentMethod(superClass, sootMethod);
        }
        return null;
    }

    private static List<SootClass> findAllInterfaces(SootClass rootInterface) {
        ArrayList<SootClass> interfaces = new ArrayList<SootClass>();
        Stack<SootClass> worklist = new Stack<SootClass>();
        worklist.add(rootInterface);
        while (!worklist.isEmpty()) {
            SootClass sootClass = (SootClass)worklist.pop();
            interfaces.add(sootClass);
            Chain sootClassInterfaces = sootClass.getInterfaces();
            for (SootClass sootClassInterface : sootClassInterfaces) {
                worklist.add(sootClassInterface);
            }
        }
        return interfaces;
    }

    private static SootMethod lookupMethodInClass(SootMethod sootMethod, SootClass sootClass) {
        try {
            return sootClass.getMethod(sootMethod.getName(), sootMethod.getParameterTypes());
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected boolean handlePausableMethodsFromBody(MethodManager methodManager) {
        boolean newMethodMarked = false;
        for (SootMethod sootMethod : methodManager.unmarkedMethods()) {
            if (methodManager.isMarked(sootMethod) || !sootMethod.isConcrete()) continue;
            boolean methodMarkedPausable = this.markMethodsUsingBody(sootMethod, methodManager);
            if (newMethodMarked) continue;
            newMethodMarked = methodMarkedPausable;
        }
        return newMethodMarked;
    }

    private boolean markMethodsUsingBody(SootMethod sootMethod, MethodManager methodManager) {
        boolean methodMarkedPausable = false;
        Iterator stmtIt = sootMethod.getActiveBody().getUnits().snapshotIterator();
        while (stmtIt.hasNext()) {
            Stmt stmt = (Stmt)stmtIt.next();
            if (!stmt.containsInvokeExpr()) continue;
            InvokeExpr invokeExpr = stmt.getInvokeExpr();
            SootMethod invokeExprMethod = invokeExpr.getMethod();
            if (methodManager.isUnmarked(invokeExprMethod)) {
                methodManager.markDependency(invokeExprMethod, sootMethod);
                continue;
            }
            if (!HjPausableMethodMarker.isPausable(invokeExprMethod)) continue;
            methodManager.markPausable(sootMethod, "calls " + invokeExprMethod);
            methodMarkedPausable = true;
        }
        return methodMarkedPausable;
    }

    protected void handleDefaultNonPausableMethods(MethodManager methodManager) {
        for (SootMethod sootMethod : methodManager.unmarkedMethods()) {
            if (!methodManager.isUnmarked(sootMethod)) continue;
            if (sootMethod.isConstructor()) {
                methodManager.markNonPausable(sootMethod, "constructor - nonpausable by default");
                continue;
            }
            if (sootMethod.isNative()) {
                methodManager.markNonPausable(sootMethod, "native - nonpausable by default");
                continue;
            }
            if (this.isFinal(sootMethod)) {
                methodManager.markNonPausable(sootMethod, "final - nonpausable by default");
                continue;
            }
            if (sootMethod.isStatic()) {
                methodManager.markNonPausable(sootMethod, "static - nonpausable by default");
                continue;
            }
            if (sootMethod.isPrivate()) {
                methodManager.markNonPausable(sootMethod, "private - nonpausable by default");
                continue;
            }
            if (sootMethod.isProtected()) {
                methodManager.markNonPausable(sootMethod, "protected - nonpausable by default");
                continue;
            }
            if (sootMethod.isPublic()) {
                methodManager.markNonPausable(sootMethod, "public - nonpausable by default");
                continue;
            }
            if (!sootMethod.isDeclared()) continue;
            methodManager.markNonPausable(sootMethod, "package protected - nonpausable by default");
        }
    }

    protected void handleUnmarkedMethods(MethodManager methodManager) {
        for (SootMethod sootMethod : methodManager.unmarkedMethods()) {
            if (methodManager.isMarked(sootMethod)) continue;
            methodManager.markPausable(sootMethod, "conservative choice");
        }
    }

    protected void verifyNonPausableOverrides(MethodManager methodManager) {
        for (SootMethod sootMethod : methodManager.nonPausableOverrideMethods()) {
            if (!sootMethod.isConcrete()) continue;
            this.verifyNonPausableOverride(sootMethod);
        }
    }

    private void verifyNonPausableOverride(SootMethod sootMethod) {
        Iterator stmtIt = sootMethod.getActiveBody().getUnits().snapshotIterator();
        while (stmtIt.hasNext()) {
            InvokeExpr invokeExpr;
            SootMethod invokeExprMethod;
            Stmt stmt = (Stmt)stmtIt.next();
            if (!stmt.containsInvokeExpr() || !HjPausableMethodMarker.isPausable(invokeExprMethod = (invokeExpr = stmt.getInvokeExpr()).getMethod())) continue;
            throw new CompilationDeathException(0, HjUtil.getSourceInfoString((Host)sootMethod) + sootMethod + " invokes pausable method: " + invokeExprMethod);
        }
    }

    private boolean isGeneratedClass(SootClass appClass) {
        try {
            SootField generatedFlag = appClass.getFieldByName("HJ_GENERATED_FLAG__");
            return generatedFlag != null;
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected static boolean isPausable(SootMethod sootMethod) {
        SootClass kilimPausable = HjClassFactory.kilimPausable();
        return sootMethod.getExceptions().contains(kilimPausable);
    }

    private boolean isFinal(SootMethod sootMethod) {
        int finalModifier = sootMethod.getModifiers() & 0x10;
        return 16 == finalModifier;
    }
}

