/*
 * Decompiled with CFR 0.152.
 */
package soot.hj.HjToJimple.jimple.ext.cooperative;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import soot.CompilationDeathException;
import soot.Scene;
import soot.SootClass;
import soot.SootMethod;
import soot.hj.HjToJimple.HjUtil;
import soot.hj.HjToJimple.jimple.ext.cooperative.HjPausableMethodMarker;
import soot.hj.HjToJimple.jimple.factory.HjClassFactory;
import soot.hj.options.HjOptions;
import soot.tagkit.Host;
import soot.util.Chain;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MethodManager {
    private final Set<SootMethod> partition;
    private final Map<SootMethod, Set<SootMethod>> dependencies;
    private final SootClass kilimPausable;
    private final List<SootMethod> unmarkedMethods;
    private final List<SootMethod> markedMethods;
    private final List<SootMethod> nonPausableOverrides;

    MethodManager(List<SootMethod> allMethods) {
        this.unmarkedMethods = new LinkedList<SootMethod>(allMethods);
        this.markedMethods = new LinkedList<SootMethod>();
        this.nonPausableOverrides = new LinkedList<SootMethod>();
        this.kilimPausable = HjClassFactory.kilimPausable();
        this.partition = new HashSet<SootMethod>();
        this.dependencies = new HashMap<SootMethod, Set<SootMethod>>();
        for (SootMethod loopMethod : allMethods) {
            this.partition.add(loopMethod);
            this.dependencies.put(loopMethod, new HashSet());
        }
    }

    protected List<SootMethod> unmarkedMethods() {
        return new LinkedList<SootMethod>(this.unmarkedMethods);
    }

    protected List<SootMethod> nonPausableOverrideMethods() {
        return new LinkedList<SootMethod>(this.nonPausableOverrides);
    }

    protected void markDependency(SootMethod firstMethod, SootMethod secondMethod) {
        if (!firstMethod.equals(secondMethod) && this.dependencies.containsKey(firstMethod)) {
            this.dependencies.get(firstMethod).add(secondMethod);
        }
    }

    protected boolean isMarked(SootMethod sootMethod) {
        return !this.isUnmarked(sootMethod);
    }

    protected boolean isUnmarked(SootMethod sootMethod) {
        return this.unmarkedMethods.contains(sootMethod);
    }

    protected boolean clearMarked(SootMethod sootMethod) {
        return this.markedMethods.remove(sootMethod);
    }

    protected void markPausable(SootMethod sootMethod, String cause) {
        if (this.checkMarked(sootMethod, true)) {
            this.checkPausableOverride(sootMethod);
            SootMethod methodPartition = this.findPartition(sootMethod);
            methodPartition.addExceptionIfAbsent(this.kilimPausable);
            this.printMessage(methodPartition, "marked Pausable: " + cause);
            this.registerMethodAsMarked(this.unmarkedMethods, this.markedMethods, methodPartition);
            for (SootMethod loopMethod : this.dependencies.get(sootMethod)) {
                this.markPausable(loopMethod, "dependency-" + methodPartition);
            }
        }
    }

    private void checkPausableOverride(SootMethod sootMethod) {
        SootClass declaringClass = sootMethod.getDeclaringClass();
        SootMethod parentMethod = HjPausableMethodMarker.findParentMethod(declaringClass, sootMethod);
        if (parentMethod != null && !HjPausableMethodMarker.isPausable(parentMethod)) {
            Chain applicationClasses = Scene.v().getApplicationClasses();
            if (applicationClasses.contains((Object)parentMethod.getDeclaringClass())) {
                this.clearMarked(parentMethod);
                this.markPausable(parentMethod, "child method impementation in " + declaringClass.getName() + " is pausable");
            } else {
                throw new CompilationDeathException(0, HjUtil.getSourceInfoString((Host)sootMethod) + sootMethod + "  is an overriden method, can't be marked pausable!");
            }
        }
    }

    protected void markNonPausable(SootMethod sootMethod, String cause) {
        if (this.checkMarked(sootMethod, false)) {
            SootMethod methodPartition = this.findPartition(sootMethod);
            this.printMessage(methodPartition, "marked Non-pausable: " + cause);
            this.registerMethodAsMarked(this.unmarkedMethods, this.markedMethods, methodPartition);
            for (SootMethod loopMethod : this.dependencies.get(sootMethod)) {
                if (this.isMarked(sootMethod) || this.isMarked(sootMethod)) continue;
                this.markNonPausable(loopMethod, "dependency-" + methodPartition);
            }
        }
    }

    protected void registerNonPausableOverride(SootMethod sootMethod) {
        this.nonPausableOverrides.add(sootMethod);
    }

    private boolean checkMarked(SootMethod sootMethod, boolean pausable) {
        if (this.markedMethods.contains(sootMethod)) {
            if (pausable && !sootMethod.getExceptions().contains(this.kilimPausable)) {
                throw new CompilationDeathException(0, HjUtil.getSourceInfoString((Host)sootMethod) + "Method previously marked non-pausable: " + sootMethod);
            }
            if (!pausable && sootMethod.getExceptions().contains(this.kilimPausable)) {
                throw new CompilationDeathException(0, HjUtil.getSourceInfoString((Host)sootMethod) + "Method previously marked pausable: " + sootMethod);
            }
            return false;
        }
        return true;
    }

    protected void printMessage(SootMethod method, String message) {
        if (HjOptions.v().hjVerbose()) {
            System.out.println(method.getDeclaringClass() + "#" + method + " " + message);
        }
    }

    private void registerMethodAsMarked(List<SootMethod> unmarkedMethods, List<SootMethod> markedMethods, SootMethod sootMethod) {
        unmarkedMethods.remove(sootMethod);
        if (!markedMethods.contains(sootMethod)) {
            markedMethods.add(sootMethod);
        }
    }

    private SootMethod findPartition(SootMethod sootMethod) {
        if (this.partition.contains(sootMethod)) {
            return sootMethod;
        }
        throw new IllegalStateException("No partition found for " + sootMethod);
    }
}

