/*
 * Decompiled with CFR 0.152.
 */
package soot.hj.HjToJimple.jj.visit;

import java.util.Stack;
import polyglot.ast.Expr;
import polyglot.ast.MethodDecl;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.Return;
import polyglot.ast.TypeNode;
import polyglot.ext.hj.ast.Async;
import polyglot.ext.hj.ast.AsyncCall;
import polyglot.ext.hj.types.HjType;
import polyglot.ext.hj.visit.TypeAscriptionVisitor;
import polyglot.frontend.Job;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.Position;
import polyglot.visit.NodeVisitor;

public class HjToJimpleCaster
extends TypeAscriptionVisitor {
    private Stack<Type> returnTypeStack = new Stack();

    public HjToJimpleCaster(Job job, TypeSystem ts, NodeFactory nf) {
        super(job, ts, nf);
    }

    public NodeVisitor enterCall(Node parent, Node n) throws SemanticException {
        if (n instanceof MethodDecl) {
            MethodDecl decl = (MethodDecl)n;
            this.returnTypeStack.push((Type)decl.methodDef().returnType().get());
        }
        if (n instanceof Async) {
            Async async = (Async)n;
            this.returnTypeStack.push(async.baseType());
        }
        return super.enterCall(parent, n);
    }

    public Node leaveCall(Node parent, Node old, Node n, NodeVisitor v) throws SemanticException {
        n = super.leaveCall(parent, old, n, v);
        if (parent instanceof Return) {
            assert (n instanceof Expr);
            Expr retExpr = (Expr)n;
            Type returnType = this.returnTypeStack.peek();
            if (this.needCast(retExpr.type(), returnType)) {
                n = this.generateCast(retExpr.type(), returnType, retExpr);
            }
        }
        if (n instanceof MethodDecl || n instanceof AsyncCall) {
            this.returnTypeStack.pop();
        }
        return n;
    }

    public boolean needCast(Type fromType, Type toType) {
        return !fromType.typeEquals(toType, null) && toType.isPrimitive() && fromType.isPrimitive();
    }

    public Expr generateCast(Type fromType, Type toType, Expr e) {
        Position p = e.position();
        if (toType.isPrimitive() && fromType.isPrimitive()) {
            Expr newExpr = fromType.isFloat() || fromType.isLong() || fromType.isDouble() ? (toType.isFloat() || toType.isLong() || toType.isDouble() || toType.isInt() || ((HjType)toType).isComplex64() || ((HjType)toType).isComplex32() ? this.nf.Cast(p, (TypeNode)this.nf.CanonicalTypeNode(p, toType), e).type(toType) : this.nf.Cast(p, (TypeNode)this.nf.CanonicalTypeNode(p, toType), this.nf.Cast(p, (TypeNode)this.nf.CanonicalTypeNode(p, this.ts.Int()), e).type(this.ts.Int())).type(toType)) : this.nf.Cast(p, (TypeNode)this.nf.CanonicalTypeNode(p, toType), e).type(toType);
            return newExpr;
        }
        return e;
    }

    public Expr ascribe(Expr e, Type toType) throws SemanticException {
        Type fromType = e.type();
        if (toType == null || toType.isVoid()) {
            return e;
        }
        if (toType.typeEquals(fromType, null)) {
            return e;
        }
        if (toType.isPrimitive() && fromType.isPrimitive()) {
            Expr newExpr = this.generateCast(fromType, toType, e);
            return newExpr;
        }
        return e;
    }
}

