/*
 * Decompiled with CFR 0.152.
 */
package soot.hj.HjToJimple.jl5;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import soot.SootClass;
import soot.SootMethod;
import soot.hj.HjToJimple.jl5.MethodFilter;
import soot.hj.HjToJimple.jl5.OverridingMethodFilter;
import soot.hj.HjToJimple.jl5.SubstitutedMethod;
import soot.hj.HjToJimple.jl5.generics.BindingEnv;
import soot.hj.HjToJimple.jl5.generics.TypeClassSignature;
import soot.hj.HjToJimple.jl5.generics.TypeSignature;
import soot.hj.HjToJimple.jl5.generics.TypeVariableSignature;
import soot.hj.tagkit.ClassSignatureTag;
import soot.hj.tagkit.MethodSignatureTag;
import soot.hj.util.TypeHierarchyExplorer;
import soot.hj.util.TypeUtils;
import soot.tagkit.AbstractHost;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BridgeMethodExplorer
extends TypeHierarchyExplorer {
    private final boolean debug = false;
    private SootMethod sm;
    private Stack<List<TypeClassSignature>> taStack;
    private Stack<BindingEnv> envStack;
    private MethodFilter filters;
    private Set<SootMethod> found;
    private static final String ERROR_MSG = "Warning: error reporting in bridge generator";

    public BridgeMethodExplorer(SootMethod sm, MethodFilter filters) {
        this.sm = sm;
        this.filters = filters;
        this.taStack = new Stack();
        this.envStack = new Stack();
    }

    @Override
    public boolean explore(SootClass sc) {
        boolean continueExplore = true;
        BindingEnv env = BindingEnv.EMPTY_ENV;
        if (!this.taStack.isEmpty()) {
            List<TypeClassSignature> typeArguments = this.taStack.pop();
            ClassSignatureTag cst = TypeUtils.v().getClassSignatureTag((AbstractHost)sc);
            if (cst.getTypeVariables().size() != typeArguments.size()) {
                throw new RuntimeException(this.getStringError(" Missing Type Variable information in " + sc.getName()));
            }
            env = this.getBindingEnv(cst.getTypeVariables(), typeArguments);
        }
        this.envStack.push(env);
        List<SubstitutedMethod> substitutes = this.substituteTypesInMethodsClass(sc, env, this.filters);
        List<SootMethod> overridden = this.findOverriddenSubstitutedMethod(this.sm, substitutes);
        String targetSig = this.sm.getSubSignature();
        for (SootMethod candidate : overridden) {
            if (candidate.getSubSignature().equals(targetSig)) {
                continueExplore = false;
                continue;
            }
            this.add(candidate);
        }
        return continueExplore;
    }

    private BindingEnv getBindingEnv(List<TypeVariableSignature> typeVariables, List<TypeClassSignature> typeArguments) {
        assert (typeVariables.size() == typeArguments.size()) : this.getStringError("Type Variable size doesn't match type arguments size");
        return new BindingEnv(typeVariables, typeArguments);
    }

    private BindingEnv getBindingEnv(List<TypeVariableSignature> typeVariables) {
        BindingEnv newEnv = new BindingEnv();
        BindingEnv env = this.envStack.isEmpty() ? new BindingEnv() : this.envStack.peek();
        for (TypeVariableSignature tvSig : typeVariables) {
            TypeSignature subst = tvSig.substitute(env);
            assert (subst instanceof TypeClassSignature) : this.getStringError("substitute is not of type TypeClassSignature");
            TypeClassSignature substClass = (TypeClassSignature)subst;
            newEnv.add(tvSig, substClass);
        }
        return newEnv;
    }

    private String getStringError(String string) {
        return "Warning: error reporting in bridge generator : " + string;
    }

    private ClassSignatureTag getSubstitution(SootClass sc) {
        ClassSignatureTag cst = TypeUtils.v().getClassSignatureTag((AbstractHost)sc);
        BindingEnv env = this.getBindingEnv(cst.getTypeVariables());
        return this.applySubstitution(env, cst);
    }

    @Override
    protected void enterSuperClass(SootClass sc, SootClass superClass) {
        ClassSignatureTag subCst = this.getSubstitution(sc);
        TypeClassSignature superType = (TypeClassSignature)subCst.getSuperType();
        List<TypeSignature> typeArguments = superType.getTypeArguments();
        if (!typeArguments.isEmpty()) {
            this.taStack.push(typeArguments);
        }
    }

    @Override
    protected void exitSuperClass(SootClass sc, SootClass superClass) {
        super.exitSuperClass(sc, superClass);
        this.envStack.pop();
    }

    @Override
    protected void enterInterface(SootClass sc, SootClass itf) {
        ClassSignatureTag subCst = this.getSubstitution(sc);
        TypeClassSignature itfType = (TypeClassSignature)subCst.getInterface(itf.getName());
        assert (itfType != null) : this.getStringError("Couldn't find interface");
        this.taStack.push(itfType.getTypeArguments());
    }

    public List<SootMethod> getFound() {
        if (this.found == null) {
            return Collections.emptyList();
        }
        return new ArrayList<SootMethod>(this.found);
    }

    private void add(SootMethod candidate) {
        if (this.found == null) {
            this.found = new HashSet<SootMethod>();
        }
        this.found.add(candidate);
    }

    @Override
    public void endExplore(SootClass sc) {
    }

    public static List<SootMethod> findMethodsRequiringBridge(SootMethod sm) {
        SootClass sc = sm.getDeclaringClass();
        OverridingMethodFilter filters = new OverridingMethodFilter(sm.getName());
        BridgeMethodExplorer explorer = new BridgeMethodExplorer(sm, filters);
        explorer.exploreHierarchy(sc);
        List<SootMethod> scMethods = explorer.getFound();
        return scMethods;
    }

    protected List<SubstitutedMethod> substituteTypesInMethodsClass(SootClass sc, BindingEnv env, MethodFilter methodFilter) {
        LinkedList<SubstitutedMethod> subList = new LinkedList<SubstitutedMethod>();
        for (SootMethod method : sc.getMethods()) {
            if (!methodFilter.accept(method)) continue;
            MethodSignatureTag msa = TypeUtils.v().getMethodSignatureTag((AbstractHost)method);
            if (env != BindingEnv.EMPTY_ENV) {
                BindingEnv methodEnv = this.getBindingEnv(msa.getTypeVariables());
                env = env.addAll(methodEnv);
                msa = this.applySubstitution(env, msa);
            }
            String name = msa.getReturnType().toString();
            name = name + " " + method.getName() + "(";
            int i = 0;
            for (TypeSignature formalType : msa.getFormals()) {
                if (i != 0) {
                    name = name + ",";
                }
                name = name + formalType;
                ++i;
            }
            name = name + ")";
            subList.add(new SubstitutedMethod(method, name));
        }
        return subList;
    }

    public List<SootMethod> findOverriddenSubstitutedMethod(SootMethod sm, List<SubstitutedMethod> substitutes) {
        String smSig = sm.getSubSignature();
        LinkedList<SootMethod> res = new LinkedList<SootMethod>();
        for (SubstitutedMethod couple : substitutes) {
            String sig2;
            String subSig;
            String sig1;
            if (couple.getSootMethod() == this.sm || !(sig1 = (subSig = couple.getSubstituteName()).substring(subSig.indexOf(" "), subSig.length())).equals(sig2 = smSig.substring(smSig.indexOf(" "), smSig.length()))) continue;
            res.add(couple.getSootMethod());
        }
        return res;
    }

    private ClassSignatureTag applySubstitution(BindingEnv env, ClassSignatureTag cst) {
        List tvs = Collections.EMPTY_LIST;
        TypeSignature superType = cst.getSuperType();
        List<TypeSignature> interfacesTypes = cst.getInterfacesTypes();
        superType = superType.substitute(env);
        LinkedList<TypeSignature> newItf = new LinkedList<TypeSignature>();
        for (TypeSignature itfSig : interfacesTypes) {
            newItf.add(itfSig.substitute(env));
        }
        return new ClassSignatureTag(tvs, superType, newItf);
    }

    private MethodSignatureTag applySubstitution(BindingEnv env, MethodSignatureTag mst) {
        List tvList = Collections.EMPTY_LIST;
        List<TypeSignature> formals = mst.getFormals();
        TypeSignature returnType = mst.getReturnType();
        List<TypeSignature> typeThrown = mst.getTypeThrown();
        LinkedList<TypeSignature> newFormals = new LinkedList<TypeSignature>();
        for (TypeSignature formal : formals) {
            newFormals.add(formal.substitute(env));
        }
        returnType = returnType.substitute(env);
        LinkedList<TypeSignature> newThrown = new LinkedList<TypeSignature>();
        for (TypeSignature thrown : typeThrown) {
            newThrown.add(thrown.substitute(env));
        }
        return new MethodSignatureTag(tvList, newFormals, returnType, newThrown);
    }
}

