/*
 * Decompiled with CFR 0.152.
 */
package soot.hj.HjToJimple.jl5;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import soot.Body;
import soot.Local;
import soot.RefType;
import soot.Scene;
import soot.SceneTransformer;
import soot.Singletons;
import soot.SootClass;
import soot.SootMethod;
import soot.Type;
import soot.Unit;
import soot.Value;
import soot.VoidType;
import soot.factory.LocalGenerator;
import soot.factory.SootFactory;
import soot.hj.HjSingletons;
import soot.hj.HjToJimple.jl5.BridgeMethodExplorer;
import soot.jimple.IdentityStmt;
import soot.jimple.Jimple;
import soot.jimple.JimpleBody;
import soot.jimple.ParameterRef;
import soot.jimple.ThisRef;
import soot.jimple.VirtualInvokeExpr;
import soot.tagkit.SignatureTag;
import soot.tagkit.SyntheticTag;
import soot.tagkit.Tag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BridgeMethodGenerator
extends SceneTransformer {
    public BridgeMethodGenerator(Singletons.Global g) {
    }

    public static BridgeMethodGenerator v() {
        return HjSingletons.v().soot_hj_HjToJimple_jl5_BridgeMethodGenerator();
    }

    protected void internalTransform(String phaseName, Map options) {
        LinkedList<SootMethod> bridgeList = new LinkedList<SootMethod>();
        for (SootClass sc : Scene.v().getApplicationClasses()) {
            soot.hj.tagkit.SignatureTag tag = (soot.hj.tagkit.SignatureTag)sc.getTag("Signature");
            if (tag != null && tag.needsSignatureGeneration()) {
                String signatureAttribute = tag.toSignatureReference(sc.getName());
                sc.addTag((Tag)new SignatureTag(signatureAttribute));
            }
            try {
                for (SootMethod sm : sc.getMethods()) {
                    List<SootMethod> overriden;
                    soot.hj.tagkit.SignatureTag mtag = (soot.hj.tagkit.SignatureTag)sm.getTag("Signature");
                    if (mtag != null && mtag.needsSignatureGeneration()) {
                        String signatureAttribute = mtag.toSignatureReference(sm.getName());
                        sm.addTag((Tag)new SignatureTag(signatureAttribute));
                    }
                    if (!sc.hasSuperclass() && sc.getInterfaceCount() <= 0 || (overriden = BridgeMethodExplorer.findMethodsRequiringBridge(sm)).isEmpty()) continue;
                    for (SootMethod overridenMethod : overriden) {
                        SootMethod bridgeMethod = this.generateBridgeMethod(overridenMethod.getReturnType(), overridenMethod.getParameterTypes(), sm);
                        bridgeList.add(bridgeMethod);
                    }
                }
                if (bridgeList.isEmpty()) continue;
                this.addBridgeMethods(sc, bridgeList);
                bridgeList.clear();
            }
            catch (Throwable t) {
                System.out.println("Warning: error reporting in bridge generator, continuing... " + t.getMessage());
            }
        }
    }

    protected void addBridgeMethods(SootClass sc, List<SootMethod> bridge) {
        for (SootMethod sootMethod : bridge) {
            sc.addMethod(sootMethod);
        }
    }

    protected SootMethod generateBridgeMethod(Type returnType, List<Type> argumentsType, SootMethod target) {
        SootClass container = target.getDeclaringClass();
        SootMethod bridgeMethod = new SootMethod(target.getName(), argumentsType, returnType);
        bridgeMethod.setModifiers(1);
        JimpleBody body = Jimple.v().newBody(bridgeMethod);
        bridgeMethod.setActiveBody((Body)body);
        LocalGenerator lg = SootFactory.v().getLocalGenerator((Body)body);
        RefType containerType = container.getType();
        Local thisLocal = lg.generateLocal((Type)containerType);
        ThisRef thisRef = Jimple.v().newThisRef(containerType);
        IdentityStmt thisStmt = Jimple.v().newIdentityStmt((Value)thisLocal, (Value)thisRef);
        body.getUnits().add((Unit)thisStmt);
        List<Type> parameterTypes = argumentsType;
        LinkedList<Local> formalLocals = new LinkedList<Local>();
        int paramRefCount = 0;
        for (Type argType : parameterTypes) {
            Local paramLocal = lg.generateLocal(argType);
            formalLocals.add(paramLocal);
            ParameterRef paramRef = Jimple.v().newParameterRef(argType, paramRefCount++);
            IdentityStmt stmt = Jimple.v().newIdentityStmt((Value)paramLocal, (Value)paramRef);
            body.getUnits().add((Unit)stmt);
        }
        int i = 0;
        LinkedList argsLocals = new LinkedList();
        for (Type currentArgTypes : target.getParameterTypes()) {
            if (argumentsType.get(i).equals(target.getParameterType(i))) {
                argsLocals.add(formalLocals.get(i));
            } else {
                Local localArg = lg.generateLocal(currentArgTypes);
                body.getUnits().add((Unit)Jimple.v().newAssignStmt((Value)localArg, (Value)Jimple.v().newCastExpr((Value)formalLocals.get(i), currentArgTypes)));
                argsLocals.add(localArg);
            }
            ++i;
        }
        VirtualInvokeExpr call = Jimple.v().newVirtualInvokeExpr(thisLocal, target.makeRef(), argsLocals);
        if (returnType.equals(VoidType.v())) {
            body.getUnits().add((Unit)Jimple.v().newInvokeStmt((Value)call));
            body.getUnits().add((Unit)Jimple.v().newReturnVoidStmt());
        } else {
            Local callRetValue = lg.generateLocal(target.getReturnType());
            body.getUnits().add((Unit)Jimple.v().newAssignStmt((Value)callRetValue, (Value)call));
            body.getUnits().add((Unit)Jimple.v().newReturnStmt((Value)callRetValue));
        }
        bridgeMethod.addTag((Tag)new SyntheticTag());
        return bridgeMethod;
    }
}

