/*
 * Decompiled with CFR 0.152.
 */
package soot.hj.HjToJimple.jl5.generics;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import polyglot.ext.hj.types.HjArrayViewType;
import polyglot.ext.jl5.types.AnySubType;
import polyglot.ext.jl5.types.AnySuperType;
import polyglot.ext.jl5.types.AnyType;
import polyglot.ext.jl5.types.ParameterizedType;
import polyglot.ext.jl5.types.TypeVariable;
import polyglot.ext.jl5.types.attributes.ClassSignatureAttribute;
import polyglot.ext.jl5.types.attributes.MethodSignatureAttribute;
import polyglot.types.ArrayType;
import polyglot.types.ClassDef;
import polyglot.types.ClassType;
import polyglot.types.PrimitiveType;
import polyglot.types.Type;
import soot.RefType;
import soot.factory.SootFactory;
import soot.hj.HjToJimple.jimple.utils.ArrayViewUtils;
import soot.hj.HjToJimple.jl5.generics.TypeAnySignature;
import soot.hj.HjToJimple.jl5.generics.TypeAnySubSignature;
import soot.hj.HjToJimple.jl5.generics.TypeAnySuperSignature;
import soot.hj.HjToJimple.jl5.generics.TypeArraySignature;
import soot.hj.HjToJimple.jl5.generics.TypeClassSignature;
import soot.hj.HjToJimple.jl5.generics.TypePrimSignature;
import soot.hj.HjToJimple.jl5.generics.TypeSignature;
import soot.hj.HjToJimple.jl5.generics.TypeVariableSignature;
import soot.hj.tagkit.ClassSignatureTag;
import soot.hj.tagkit.MethodSignatureTag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolyglotTypeToLightType {
    public static ClassSignatureTag convertSignature(ClassSignatureAttribute csa) {
        TypeSignature superType = PolyglotTypeToLightType.convertToTypeSig(csa.getSuperType());
        List<TypeVariableSignature> tvs = PolyglotTypeToLightType.convertTvListToTypeSig(csa.getTypeVariablesTypes(), csa.getBoundsTypes());
        List<TypeSignature> interfacesTypes = PolyglotTypeToLightType.convertListToTypeSig(csa.getInterfacesTypes());
        return new ClassSignatureTag(tvs, superType, interfacesTypes);
    }

    private static List<TypeVariableSignature> convertTvListToTypeSig(List<Type> typeVariablesTypes, List<List<Type>> boundsTypes) {
        List<TypeSignature> tvs = PolyglotTypeToLightType.convertListToTypeSig(typeVariablesTypes);
        int i = 0;
        for (List<Type> bounds : boundsTypes) {
            ((TypeVariableSignature)tvs.get(i)).bounds(PolyglotTypeToLightType.convertListToTypeSig(bounds));
            ++i;
        }
        return tvs;
    }

    private static List<TypeSignature> convertListToTypeSig(List<Type> types) {
        if (types.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<TypeSignature> sig = new ArrayList<TypeSignature>(types.size());
        int i = 0;
        for (Type pType : types) {
            TypeSignature typeSig = PolyglotTypeToLightType.convertToTypeSig(pType);
            sig.add(i, typeSig);
            ++i;
        }
        return sig;
    }

    private static TypeSignature convertToTypeSig(Type pType) {
        if (pType instanceof TypeVariable) {
            TypeVariable tv = (TypeVariable)pType;
            return new TypeVariableSignature(tv.name().toString(), PolyglotTypeToLightType.convertListToTypeSig(tv.bounds()));
        }
        if (pType instanceof ClassType) {
            ClassType ct = (ClassType)pType;
            String name = ct.typeSystem().getTransformedClassName((ClassDef)ct.def()).toString();
            if (name.contains("$")) {
                name = name.replace(".$", "$");
            }
            List<TypeSignature> taList = Collections.EMPTY_LIST;
            if (ct instanceof ParameterizedType) {
                ParameterizedType pt = (ParameterizedType)ct;
                taList = PolyglotTypeToLightType.convertListToTypeSig(pt.typeArguments());
            }
            return new TypeClassSignature(name, taList);
        }
        if (pType instanceof PrimitiveType) {
            return new TypePrimSignature(((PrimitiveType)pType).name().toString());
        }
        if (pType instanceof ArrayType) {
            return new TypeArraySignature(PolyglotTypeToLightType.convertToTypeSig(((ArrayType)pType).base()));
        }
        if (pType instanceof AnySubType) {
            return new TypeAnySubSignature(PolyglotTypeToLightType.convertToTypeSig((Type)((AnySubType)pType).bound()));
        }
        if (pType instanceof AnySuperType) {
            return new TypeAnySuperSignature(PolyglotTypeToLightType.convertToTypeSig((Type)((AnySuperType)pType).bound()));
        }
        if (pType instanceof AnyType) {
            return new TypeAnySignature();
        }
        if (pType instanceof HjArrayViewType) {
            RefType viewImplType = (RefType)ArrayViewUtils.getHjArrayViewType(SootFactory.v().getSootType().getSootType(((HjArrayViewType)pType).base()));
            return new TypeClassSignature(viewImplType.getClassName(), Collections.EMPTY_LIST);
        }
        throw new RuntimeException("Polyglot to Light type converter does not support : " + pType.toString());
    }

    public static MethodSignatureTag convertSignature(MethodSignatureAttribute msa) {
        TypeSignature returnType = PolyglotTypeToLightType.convertToTypeSig(msa.getReturnType());
        List<TypeSignature> formalTypes = PolyglotTypeToLightType.convertListToTypeSig(msa.getFormalTypes());
        List<TypeSignature> thrownTypes = PolyglotTypeToLightType.convertListToTypeSig(msa.getThrownTypes());
        List<TypeVariableSignature> tvs = PolyglotTypeToLightType.convertTvListToTypeSig(msa.getTypeVariablesTypes(), msa.getBoundsTypes());
        return new MethodSignatureTag(tvs, formalTypes, returnType, thrownTypes);
    }
}

