/*
 * Decompiled with CFR 0.152.
 */
package soot.hj.HjToJimple.jl5.generics;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import soot.hj.HjToJimple.jl5.generics.TypeAnySignature;
import soot.hj.HjToJimple.jl5.generics.TypeAnySubSignature;
import soot.hj.HjToJimple.jl5.generics.TypeAnySuperSignature;
import soot.hj.HjToJimple.jl5.generics.TypeArraySignature;
import soot.hj.HjToJimple.jl5.generics.TypeClassSignature;
import soot.hj.HjToJimple.jl5.generics.TypePrimSignature;
import soot.hj.HjToJimple.jl5.generics.TypeSignature;
import soot.hj.HjToJimple.jl5.generics.TypeVariableSignature;
import soot.hj.tagkit.ClassSignatureTag;
import soot.hj.tagkit.MethodSignatureTag;

public class SignatureParser {
    protected ClassSignatureTag classSignature;
    protected MethodSignatureTag methodSignature;
    protected List<TypeVariableSignature> typeVars;
    private final char LEFT_ANGLE = (char)60;
    private final char RIGHT_ANGLE = (char)62;
    private final char COLON = (char)58;
    private final char L = (char)76;
    private final char SEMI_COLON = (char)59;
    private final char SLASH = (char)47;
    private final char DOT = (char)46;
    private final char T = (char)84;
    private final char STAR = (char)42;
    private final char PLUS = (char)43;
    private final char MINUS = (char)45;
    private final char LEFT_SQUARE = (char)91;
    private final char LEFT_BRACE = (char)40;
    private final char RIGHT_BRACE = (char)41;
    private final char V = (char)86;
    private final char HAT = (char)94;
    private final char B = (char)66;
    private final char C = (char)67;
    private final char D = (char)68;
    private final char F = (char)70;
    private final char I = (char)73;
    private final char J = (char)74;
    private final char S = (char)83;
    private final char Z = (char)90;
    private boolean createTypeVars;

    public ClassSignatureTag classSig(String value, int pos) {
        List typeFormals = Collections.EMPTY_LIST;
        char token = value.charAt(pos);
        Result fres = null;
        if (token == '<') {
            fres = this.formalTypeParamList(value, ++pos);
            pos = fres.pos();
            if (fres != null) {
                typeFormals = (List)fres.result();
            }
            this.typeVars = (List)fres.result();
        }
        Result sres = this.classTypeSig(value, pos);
        TypeSignature superType = (TypeSignature)sres.result();
        ArrayList<TypeSignature> superInterfaces = new ArrayList<TypeSignature>();
        pos = sres.pos();
        while (pos < value.length()) {
            Result ires = this.classTypeSig(value, pos);
            pos = ires.pos();
            superInterfaces.add((TypeSignature)ires.result());
        }
        return new ClassSignatureTag(typeFormals, superType, superInterfaces);
    }

    public Result formalTypeParamList(String value, int pos) {
        Result fres;
        this.typeVars = null;
        int oldpos = pos;
        this.createTypeVars = true;
        ArrayList<TypeVariableSignature> list = new ArrayList<TypeVariableSignature>();
        char token = value.charAt(pos);
        while (token != '>') {
            fres = this.formalTypeParam(value, pos);
            list.add((TypeVariableSignature)fres.result());
            pos = fres.pos();
            token = value.charAt(pos);
        }
        this.typeVars = list;
        pos = oldpos;
        this.createTypeVars = false;
        list = new ArrayList();
        token = value.charAt(pos);
        while (token != '>') {
            fres = this.formalTypeParam(value, pos);
            list.add((TypeVariableSignature)fres.result());
            pos = fres.pos();
            token = value.charAt(pos);
        }
        return new Result(list, ++pos);
    }

    public Result formalTypeParam(String value, int pos) {
        String id = "";
        char token = value.charAt(pos);
        while (token != ':') {
            id = id + token;
            token = value.charAt(++pos);
        }
        Result ires = this.classBound(value, pos);
        pos = ires.pos();
        ArrayList<TypeSignature> bounds = new ArrayList<TypeSignature>();
        bounds.add((TypeSignature)ires.result());
        token = value.charAt(pos);
        while (token != '>' && value.charAt(pos) == ':') {
            ires = this.classBound(value, pos);
            pos = ires.pos();
            bounds.add((TypeSignature)ires.result());
        }
        if (this.createTypeVars) {
            return new Result(new TypeVariableSignature(id, bounds), pos);
        }
        TypeVariableSignature tv = this.findTypeVar(id);
        tv.bounds(bounds);
        return new Result(tv, pos);
    }

    public Result classBound(String value, int pos) {
        return this.fieldTypeSig(value, ++pos);
    }

    public Result fieldTypeSig(String value, int pos) {
        Result res = null;
        char token = value.charAt(pos);
        switch (token) {
            case 'L': {
                res = this.classTypeSig(value, pos);
                break;
            }
            case '[': {
                res = this.arrayTypeSig(value, pos);
                break;
            }
            case 'T': {
                res = this.typeVarSig(value, pos);
                break;
            }
            case ':': {
                res = new Result(new TypeClassSignature("java.lang.Object"), pos);
            }
        }
        return res;
    }

    public Result classTypeSig(String value, int pos) {
        char token = value.charAt(pos);
        String className = "";
        String id = "";
        HashMap<String, List> classArgsMap = new HashMap<String, List>();
        token = value.charAt(++pos);
        block5: while (token != ';') {
            switch (token) {
                case '/': {
                    className = className + id;
                    className = className + ".";
                    id = "";
                    token = value.charAt(++pos);
                    continue block5;
                }
                case '.': {
                    className = className + id;
                    className = className + "$";
                    id = "";
                    token = value.charAt(++pos);
                    continue block5;
                }
                case '<': {
                    Result tres = this.typeArgList(value, pos);
                    pos = tres.pos();
                    classArgsMap.put(id, (List)tres.result());
                    token = value.charAt(pos);
                    continue block5;
                }
            }
            id = id + token;
            token = value.charAt(++pos);
        }
        className = className + id;
        List tvList = (List)classArgsMap.get(id);
        TypeClassSignature ct = new TypeClassSignature(className, tvList);
        return new Result(ct, ++pos);
    }

    public Result typeVarSig(String value, int pos) {
        Result res = null;
        char token = value.charAt(pos);
        switch (token) {
            case 'T': {
                String id = "";
                token = value.charAt(++pos);
                while (token != ';') {
                    id = id + token;
                    token = value.charAt(++pos);
                }
                res = new Result(this.findTypeVar(id), ++pos);
            }
        }
        return res;
    }

    public Result typeArgList(String value, int pos) {
        ArrayList<Object> typeArgs = new ArrayList<Object>();
        char token = value.charAt(pos++);
        while (token != '>') {
            Result tres = this.typeArg(value, pos);
            pos = tres.pos();
            typeArgs.add(tres.result());
            token = value.charAt(pos);
        }
        return new Result(typeArgs, ++pos);
    }

    public Result typeArg(String value, int pos) {
        Result res = null;
        char token = value.charAt(pos);
        switch (token) {
            case '+': {
                Result fres = this.fieldTypeSig(value, ++pos);
                res = new Result(new TypeAnySubSignature((TypeSignature)fres.result()), fres.pos());
                break;
            }
            case '-': {
                Result fres = this.fieldTypeSig(value, ++pos);
                res = new Result(new TypeAnySuperSignature((TypeSignature)fres.result()), fres.pos());
                break;
            }
            case '*': {
                res = new Result(new TypeAnySignature(), ++pos);
                break;
            }
            case 'L': 
            case 'T': 
            case '[': {
                res = this.fieldTypeSig(value, pos);
            }
        }
        return res;
    }

    public Result arrayTypeSig(String value, int pos) {
        Result res = null;
        char token = value.charAt(pos);
        switch (token) {
            case '[': {
                Result tres = this.typeSig(value, ++pos);
                TypeSignature type = (TypeSignature)tres.result();
                res = new Result(new TypeArraySignature(type), tres.pos());
                break;
            }
        }
        return res;
    }

    public Result typeSigList(String value, int pos) {
        ArrayList<Object> formals = new ArrayList<Object>();
        char token = value.charAt(pos);
        while (token != ')') {
            Result ares = this.typeSig(value, pos);
            pos = ares.pos();
            formals.add(ares.result());
            token = value.charAt(pos);
        }
        return new Result(formals, ++pos);
    }

    public Result typeSig(String value, int pos) {
        Result res = null;
        char token = value.charAt(pos);
        switch (token) {
            case 'L': 
            case 'T': 
            case '[': {
                res = this.fieldTypeSig(value, pos);
                break;
            }
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': 
            case 'Z': {
                res = this.baseType(value, pos);
            }
        }
        return res;
    }

    public MethodSignatureTag methodTypeSig(String value, int pos) {
        char token = value.charAt(pos);
        List<TypeVariableSignature> list = new ArrayList<TypeVariableSignature>();
        this.typeVars = list;
        List typeFormals = Collections.EMPTY_LIST;
        TypeSignature typeReturned = null;
        List typeThrown = Collections.EMPTY_LIST;
        if (token == '<') {
            Result fres = this.formalTypeParamList(value, ++pos);
            pos = fres.pos();
            if (fres != null) {
                list = (List)fres.result();
            }
            this.typeVars = list;
        }
        if ((token = value.charAt(pos)) == '(') {
            Result ares = this.typeSigList(value, ++pos);
            pos = ares.pos();
            if (ares != null) {
                typeFormals = (List)ares.result();
            }
        }
        Result rres = this.returnType(value, pos);
        typeReturned = (TypeSignature)rres.result();
        pos = rres.pos();
        if (pos < value.length() && (token = value.charAt(pos)) == '^') {
            Result tres = this.throwsSigList(value, pos);
            pos = tres.pos();
            if (typeThrown != null) {
                typeThrown = (List)tres.result();
            }
        }
        ArrayList<TypeVariableSignature> typeVarsList = new ArrayList<TypeVariableSignature>(list);
        return new MethodSignatureTag(typeVarsList, typeFormals, typeReturned, typeThrown);
    }

    public Result returnType(String value, int pos) {
        Result res = null;
        char token = value.charAt(pos);
        switch (token) {
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'L': 
            case 'S': 
            case 'T': 
            case 'Z': 
            case '[': {
                res = this.typeSig(value, pos);
                break;
            }
            case 'V': {
                res = new Result(new TypePrimSignature("void"), ++pos);
            }
        }
        return res;
    }

    public Result throwsSigList(String value, int pos) {
        ArrayList<Object> throwsList = new ArrayList<Object>();
        while (pos < value.length()) {
            Result tres = this.throwsSig(value, pos);
            pos = tres.pos();
            throwsList.add(tres.result());
        }
        return new Result(throwsList, pos);
    }

    public Result throwsSig(String value, int pos) {
        Result res = null;
        char token = value.charAt(pos);
        switch (token) {
            case '^': {
                token = value.charAt(++pos);
                switch (token) {
                    case 'L': {
                        res = this.classTypeSig(value, pos);
                    }
                    case 'T': {
                        res = this.typeVarSig(value, pos);
                    }
                }
            }
        }
        return res;
    }

    public Result baseType(String value, int pos) {
        Result res = null;
        char token = value.charAt(pos);
        switch (token) {
            case 'B': {
                res = new Result(new TypePrimSignature("byte"), ++pos);
                break;
            }
            case 'C': {
                res = new Result(new TypePrimSignature("char"), ++pos);
                break;
            }
            case 'D': {
                res = new Result(new TypePrimSignature("double"), ++pos);
                break;
            }
            case 'F': {
                res = new Result(new TypePrimSignature("float"), ++pos);
                break;
            }
            case 'I': {
                res = new Result(new TypePrimSignature("int"), ++pos);
                break;
            }
            case 'J': {
                res = new Result(new TypePrimSignature("long"), ++pos);
                break;
            }
            case 'S': {
                res = new Result(new TypePrimSignature("short"), ++pos);
                break;
            }
            case 'Z': {
                res = new Result(new TypePrimSignature("boolean"), ++pos);
            }
        }
        return res;
    }

    public ClassSignatureTag parseClassSignature(String stringSig) {
        return this.classSig(stringSig, 0);
    }

    public MethodSignatureTag parseMethodSignature(String stringSig) {
        return this.methodTypeSig(stringSig, 0);
    }

    private TypeVariableSignature findTypeVar(String next) {
        if (this.typeVars != null) {
            for (TypeVariableSignature tv : this.typeVars) {
                if (!tv.name().toString().equals(next)) continue;
                return tv;
            }
        }
        return new TypeVariableSignature(next);
    }

    class Result {
        protected int pos;
        protected Object result;

        public Result(Object result, int pos) {
            this.result = result;
            this.pos = pos;
        }

        public int pos() {
            return this.pos;
        }

        public Object result() {
            return this.result;
        }
    }
}

