/*
 * Decompiled with CFR 0.152.
 */
package soot.hj.HjToJimple.jl5.generics;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import soot.ArrayType;
import soot.PrimType;
import soot.RefType;
import soot.SootClass;
import soot.SootMethod;
import soot.Type;
import soot.VoidType;
import soot.hj.HjToJimple.jl5.generics.TypeArraySignature;
import soot.hj.HjToJimple.jl5.generics.TypeClassSignature;
import soot.hj.HjToJimple.jl5.generics.TypePrimSignature;
import soot.hj.HjToJimple.jl5.generics.TypeSignature;
import soot.hj.tagkit.ClassSignatureTag;
import soot.hj.tagkit.MethodSignatureTag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SootTypeToLightType {
    public static MethodSignatureTag getMethodSignatureTag(SootMethod sm) {
        return new MethodSignatureTag(Collections.EMPTY_LIST, SootTypeToLightType.convertSootType(sm.getParameterTypes()), SootTypeToLightType.convertSootType(sm.getReturnType()), SootTypeToLightType.convertSootClass(sm.getExceptions().iterator(), sm.getExceptions().size()));
    }

    public static ClassSignatureTag getClassSignatureTag(SootClass sc) {
        return new ClassSignatureTag(Collections.EMPTY_LIST, sc.hasSuperclass() ? new TypeClassSignature(sc.getSuperclass().getName()) : TypeClassSignature.Object(), SootTypeToLightType.convertSootClass(sc.getInterfaces().iterator(), sc.getInterfaceCount()));
    }

    private static List<TypeSignature> convertSootClass(Iterator<SootClass> it, int size) {
        ArrayList<TypeSignature> l = new ArrayList<TypeSignature>(size);
        int i = 0;
        while (it.hasNext()) {
            SootClass sc = it.next();
            l.add(i, new TypeClassSignature(sc.getName()));
        }
        return l;
    }

    private static List<TypeSignature> convertSootType(List<Type> list) {
        ArrayList<TypeSignature> l = new ArrayList<TypeSignature>(list.size());
        int i = 0;
        for (Type type : list) {
            l.add(i, SootTypeToLightType.convertSootType(type));
        }
        return l;
    }

    private static TypeSignature convertSootType(Type sType) {
        if (sType instanceof RefType) {
            return new TypeClassSignature(((RefType)sType).getClassName());
        }
        if (sType instanceof VoidType) {
            return new TypePrimSignature("void");
        }
        if (sType instanceof PrimType) {
            return new TypePrimSignature(((PrimType)sType).toString());
        }
        if (sType instanceof ArrayType) {
            return new TypeArraySignature(SootTypeToLightType.convertSootType(((ArrayType)sType).baseType));
        }
        throw new RuntimeException("Soot type to Light type converter doesn't support : " + sType.toString());
    }
}

