/*
 * Decompiled with CFR 0.152.
 */
package soot.hj.HjToJimple.jl5.generics;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import soot.hj.HjToJimple.jl5.generics.BindingEnv;
import soot.hj.HjToJimple.jl5.generics.TypeSignature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeClassSignature
extends TypeSignature {
    static final TypeSignature OBJECT = new TypeClassSignature("java.lang.Object");
    private List<TypeSignature> typeArguments;

    public TypeClassSignature(String name, List<TypeSignature> typeArguments) {
        super(name);
        this.typeArguments = typeArguments == null ? Collections.EMPTY_LIST : typeArguments;
    }

    public TypeClassSignature(String name) {
        this(name, Collections.EMPTY_LIST);
    }

    @Override
    public String javaToString() {
        String res = this.name();
        if (this.typeArguments != null && !this.typeArguments.isEmpty()) {
            res = res + "<";
            for (TypeSignature tv : this.typeArguments) {
                res = res + tv.javaToString() + ",";
            }
            res = res + ">";
        }
        return res;
    }

    public List<TypeSignature> getTypeArguments() {
        return this.typeArguments;
    }

    @Override
    public TypeSignature substitute(BindingEnv env) {
        if (this.typeArguments.isEmpty()) {
            return this;
        }
        LinkedList<TypeSignature> newTas = new LinkedList<TypeSignature>();
        for (TypeSignature ta : this.typeArguments) {
            newTas.add(ta.substitute(env));
        }
        return new TypeClassSignature(this.name(), newTas);
    }

    public static TypeSignature Object() {
        return OBJECT;
    }

    @Override
    public boolean hasGenericRef() {
        List<TypeSignature> tas = this.getTypeArguments();
        return tas != null && !tas.isEmpty();
    }

    @Override
    public String toStringBytecodeNameRef() {
        StringBuffer res = new StringBuffer();
        res.append("L");
        res.append(this.name().replace(".", "/"));
        List<TypeSignature> tas = this.getTypeArguments();
        if (tas != null && !tas.isEmpty()) {
            res.append("<");
            for (TypeSignature tvs : tas) {
                res.append(tvs.toStringBytecodeNameRef());
            }
            res.append(">");
        }
        res.append(";");
        return res.toString();
    }

    @Override
    public String toStringBytecodeNameDef() {
        assert (false) : "Class toStringBytecodeNameDef";
        return "";
    }
}

