/*
 * Decompiled with CFR 0.152.
 */
package soot.hj.HjToJimple.jl5.generics;

import java.util.List;
import soot.hj.HjToJimple.jl5.generics.BindingEnv;
import soot.hj.HjToJimple.jl5.generics.TypeClassSignature;
import soot.hj.HjToJimple.jl5.generics.TypeSignature;
import soot.jimple.toolkits.typing.fast.SingletonList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeVariableSignature
extends TypeSignature {
    private List<TypeSignature> bound;

    public TypeVariableSignature(String name) {
        super(name);
        this.bound = new SingletonList((Object)TypeClassSignature.OBJECT);
    }

    public TypeVariableSignature(String name, List<TypeSignature> bounds) {
        super(name);
        this.bound = bounds;
    }

    public void bounds(List<TypeSignature> bounds) {
        this.bound = bounds;
    }

    @Override
    public String javaToString() {
        String boundsStr = "(";
        for (TypeSignature sig : this.bound) {
            boundsStr = boundsStr + " " + sig.javaToString();
        }
        boundsStr = boundsStr + ")";
        return this.name() + " extends " + boundsStr;
    }

    public List<TypeSignature> bounds() {
        return this.bound;
    }

    @Override
    public boolean hasGenericRef() {
        return true;
    }

    @Override
    public String toStringBytecodeNameRef() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("T");
        buffer.append(this.name());
        buffer.append(";");
        return buffer.toString();
    }

    @Override
    public String toStringBytecodeNameDef() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.name());
        buffer.append(":");
        if (this.bound != null && !this.bound.isEmpty()) {
            int lg = this.bound.size();
            for (int i = 0; i < lg - 1; ++i) {
                buffer.append(this.bound.get(i).toStringBytecodeNameRef());
            }
            buffer.append(this.bound.get(lg - 1).toStringBytecodeNameRef());
        } else {
            buffer.append("Ljava/lang/Object");
        }
        return buffer.toString();
    }

    @Override
    public TypeSignature substitute(BindingEnv env) {
        if (this.bound.size() != 1) {
            System.out.println("Warning: TypeVariable has several bounds, bridge method generation may be inaccurate");
        }
        if (env.containsKey(this)) {
            return (TypeSignature)env.get(this);
        }
        return this.bound.get(0).substitute(env);
    }

    public boolean equals(Object arg) {
        return arg instanceof TypeVariableSignature && this.name().equals(((TypeVariableSignature)arg).name());
    }

    public int hashCode() {
        return this.name().hashCode();
    }
}

