/*
 * Decompiled with CFR 0.152.
 */
package soot.hj.HjToJimple.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import soot.Local;
import soot.Type;
import soot.UnitPrinter;
import soot.Value;
import soot.factory.SootType;
import soot.hj.HjToJimple.util.HjObject;
import soot.hj.HjToJimple.util.HjObject_c;
import soot.hj.HjToJimple.util.HjValueBox;
import soot.hj.HjToJimple.util.Point;
import soot.jimple.Jimple;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Point_c
extends HjObject_c
implements Point {
    protected List<HjValueBox> indexList;
    private boolean isPrimitiveIndex;

    public Point_c() {
    }

    public Point_c(Value pointValue) {
        super(pointValue);
    }

    public Point_c(Local pointLocal) {
        super(pointLocal);
    }

    public Point_c(List<Value> indexList) {
        this.indexList = new ArrayList<HjValueBox>();
        this.isPrimitiveIndex = true;
        for (Value index : indexList) {
            Type t = index.getType();
            this.isPrimitiveIndex &= SootType.v().isPrimitive(t);
            this.indexList.add(new HjValueBox(index));
        }
    }

    @Override
    public Local getPointLocal() {
        return (Local)this.getLocalValue();
    }

    @Override
    public void setPointLocal(Local pointLocal) {
        this.setLocalValue(pointLocal);
    }

    @Override
    public List getUseBoxes() {
        ArrayList<Object> useBoxesList = new ArrayList<Object>();
        if (this.getLocalValueBox() != null) {
            useBoxesList.add(this.getLocalValueBox());
        }
        useBoxesList.addAll(this.indexList);
        return useBoxesList;
    }

    @Override
    public List<Value> getIndexList() {
        ArrayList<Value> indexValueList = new ArrayList<Value>();
        Iterator<HjValueBox> indexBoxIter = this.indexList.iterator();
        while (indexBoxIter.hasNext()) {
            indexValueList.add(indexBoxIter.next().getValue());
        }
        return indexValueList;
    }

    @Override
    public void setIndexList(List<Value> indexList) {
        if (this.indexList == null) {
            this.indexList = new ArrayList<HjValueBox>();
        } else {
            this.indexList.clear();
        }
        Iterator<Value> indexIter = indexList.iterator();
        while (indexIter.hasNext()) {
            this.indexList.add(new HjValueBox(indexIter.next()));
        }
    }

    @Override
    public List<HjValueBox> getIndexBoxes() {
        if (this.indexList != null) {
            return this.indexList;
        }
        return Collections.emptyList();
    }

    @Override
    public void setIndexBoxes(List<HjValueBox> indexBoxList) {
        this.indexList = indexBoxList;
    }

    @Override
    public HjObject clone() {
        if (this.getLocalValue() != null) {
            return new Point_c(this.getLocalValue());
        }
        return new Point_c(this.cloneIndexList());
    }

    @Override
    public String toString() {
        if (this.indexList == null) {
            return "Point: " + this.getPointLocal();
        }
        String str = " ";
        Iterator<HjValueBox> indexIter = this.indexList.iterator();
        while (indexIter.hasNext()) {
            str = str + indexIter.next().getValue() + " ";
        }
        return str;
    }

    @Override
    public void toString(UnitPrinter up) {
        if (this.indexList == null) {
            up.literal("Point: " + this.getPointLocal());
        } else {
            String str = " ";
            Iterator<HjValueBox> indexIter = this.indexList.iterator();
            while (indexIter.hasNext()) {
                str = str + indexIter.next().getValue() + " ";
            }
            up.literal(str);
        }
    }

    private List<Value> cloneIndexList() {
        ArrayList<Value> copy = new ArrayList<Value>();
        for (Value indexVal : this.getIndexList()) {
            copy.add(Jimple.v().cloneIfNecessary(indexVal));
        }
        return copy;
    }

    @Override
    public List<Value> copyIndexList() {
        ArrayList<Value> copy = new ArrayList<Value>();
        for (Value indexVal : this.getIndexList()) {
            copy.add(indexVal);
        }
        return copy;
    }

    @Override
    public List<Type> copyIndexTypeList() {
        ArrayList<Type> copy = new ArrayList<Type>();
        for (Value indexVal : this.getIndexList()) {
            copy.add(indexVal.getType());
        }
        return copy;
    }

    @Override
    public boolean isPrimitiveIndex() {
        return this.isPrimitiveIndex;
    }

    @Override
    public int getRank() {
        return this.indexList.size();
    }
}

