/*
 * Decompiled with CFR 0.152.
 */
package soot.hj.HjToJimple.util;

import java.util.ArrayList;
import java.util.List;
import soot.Local;
import soot.PatchingChain;
import soot.RefType;
import soot.Scene;
import soot.SootClass;
import soot.Trap;
import soot.Type;
import soot.Unit;
import soot.Value;
import soot.VoidType;
import soot.factory.LocalGenerator;
import soot.hj.HjToJimple.jimple.factory.HjClassFactory;
import soot.hj.HjToJimple.jimple.factory.HjStmtFactory;
import soot.jimple.CaughtExceptionRef;
import soot.jimple.GotoStmt;
import soot.jimple.IdentityStmt;
import soot.jimple.Jimple;
import soot.jimple.NopStmt;
import soot.jimple.Stmt;
import soot.jimple.VirtualInvokeExpr;
import soot.tagkit.ParamNamesTag;
import soot.tagkit.Tag;
import soot.util.Chain;
import soot.util.HashChain;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TryCatchInserter {
    private Unit start;
    private Unit end;
    private PatchingChain<Unit> units;
    private Chain<Trap> bodyTraps;
    private List<CatchBlock> catchBlocks;
    private Unit lastStmt;

    public TryCatchInserter(Unit start, Unit end, PatchingChain<Unit> units, Chain<Trap> bodyTraps, List<CatchBlock> catchBlocks) {
        this.start = start;
        this.end = end;
        this.units = units;
        this.bodyTraps = bodyTraps;
        this.catchBlocks = catchBlocks;
        assert (catchBlocks.size() >= 1);
    }

    protected void insertAfterLastStmt(Unit stmt) {
        this.units.insertAfter(stmt, this.lastStmt);
        this.setLastStmt(stmt);
    }

    protected void insertAfterLastStmt(Chain<Unit> units) {
        this.units.insertAfter(units, this.lastStmt);
        this.setLastStmt(this.units.getLast());
    }

    protected void setLastStmt(Unit last) {
        this.lastStmt = last;
    }

    public void insertTryCatch() {
        NopStmt noop1 = Jimple.v().newNopStmt();
        this.units.insertBefore((Unit)noop1, this.start);
        this.setLastStmt(this.end);
        NopStmt noop2 = Jimple.v().newNopStmt();
        this.insertAfterLastStmt((Unit)noop2);
        NopStmt endNoop = Jimple.v().newNopStmt();
        GotoStmt tryEndGoto = Jimple.v().newGotoStmt((Unit)endNoop);
        this.insertAfterLastStmt((Unit)tryEndGoto);
        for (CatchBlock catchBlock : this.catchBlocks) {
            NopStmt noop3 = Jimple.v().newNopStmt();
            this.insertAfterLastStmt((Unit)noop3);
            this.insertCatchBlock(catchBlock, (Stmt)endNoop);
            String catchType = catchBlock.getCatchType().toString();
            this.addToExceptionList((Stmt)noop1, (Stmt)noop2, (Stmt)noop3, Scene.v().getSootClass(catchType));
        }
        this.insertAfterLastStmt((Unit)endNoop);
    }

    protected void insertCatchBlock(CatchBlock catchBlock, Stmt endNoop) {
        this.insertAfterLastStmt(catchBlock.getChain());
        this.insertAfterLastStmt((Unit)Jimple.v().newGotoStmt((Unit)endNoop));
    }

    protected void addToExceptionList(Stmt from, Stmt to, Stmt with, SootClass exceptionClass) {
        Trap trap = Jimple.v().newTrap(exceptionClass, (Unit)from, (Unit)to, (Unit)with);
        this.bodyTraps.add((Object)trap);
    }

    public static CatchBlock setExceptionCatchBlock(LocalGenerator lg, Local future, Type exceptionType) {
        PatchingChain chain = new PatchingChain((Chain)new HashChain());
        Local exception = lg.generateLocal(exceptionType);
        CaughtExceptionRef exceptRef = Jimple.v().newCaughtExceptionRef();
        IdentityStmt stmt = Jimple.v().newIdentityStmt((Value)exception, (Value)exceptRef);
        chain.add((Object)stmt);
        ArrayList<String> names = new ArrayList<String>();
        names.add(exception.getName());
        stmt.addTag((Tag)new ParamNamesTag(names));
        if (future != null) {
            RefType futureImplType = Scene.v().getSootClass("hj.runtime.wsh.WshFuture").getType();
            Local futureImpl = lg.generateLocal((Type)futureImplType);
            chain.add((Object)Jimple.v().newAssignStmt((Value)futureImpl, (Value)Jimple.v().newCastExpr((Value)future, (Type)futureImplType)));
            VirtualInvokeExpr call = HjStmtFactory.callFutureSetException(futureImpl, (Value)exception);
            Local retLocal = lg.generateLocal((Type)VoidType.v());
            chain.add((Object)Jimple.v().newAssignStmt((Value)retLocal, (Value)call));
            RefType wshActivityType = HjClassFactory.hjWshActivity().getType();
            Local activityLocal = lg.generateLocal((Type)wshActivityType);
            Stmt currentActivityStmt = HjStmtFactory.getCurrentActivity_HjWshActivity(activityLocal);
            chain.add((Object)currentActivityStmt);
            VirtualInvokeExpr callFail = HjStmtFactory.callRegisterFailedFuture(activityLocal, (Value)futureImpl);
            Local callLocal = lg.generateLocal((Type)VoidType.v());
            chain.add((Object)Jimple.v().newAssignStmt((Value)callLocal, (Value)callFail));
        } else {
            RefType wshActivityType = HjClassFactory.hjWshActivity().getType();
            Local activityLocal = lg.generateLocal((Type)wshActivityType);
            Stmt currentActivityStmt = HjStmtFactory.getCurrentActivity_HjWshActivity(activityLocal);
            chain.add((Object)currentActivityStmt);
            VirtualInvokeExpr call = HjStmtFactory.callPushException(activityLocal, (Value)exception);
            Local callLocal = lg.generateLocal((Type)VoidType.v());
            chain.add((Object)Jimple.v().newAssignStmt((Value)callLocal, (Value)call));
        }
        return new CatchBlock(exceptionType, (Chain<Unit>)chain);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CatchBlock {
        private Type catchType;
        private Chain<Unit> units;

        public CatchBlock(Type catchType, Chain<Unit> units) {
            this.catchType = catchType;
            this.units = units;
        }

        public Type getCatchType() {
            return this.catchType;
        }

        public Chain<Unit> getChain() {
            return this.units;
        }
    }
}

