/*
 * Decompiled with CFR 0.152.
 */
package soot.hj.tagkit;

import java.util.List;
import soot.hj.HjToJimple.jl5.generics.SignatureParser;
import soot.hj.HjToJimple.jl5.generics.TypeSignature;
import soot.hj.HjToJimple.jl5.generics.TypeVariableSignature;
import soot.hj.tagkit.SignatureTag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassSignatureTag
extends SignatureTag {
    private List<TypeVariableSignature> typeVariables;
    private TypeSignature superType;
    private List<TypeSignature> interfacesTypes;

    public ClassSignatureTag(List<TypeVariableSignature> tv, TypeSignature superType, List<TypeSignature> interfacesTypes) {
        this.typeVariables = tv;
        this.superType = superType;
        this.interfacesTypes = interfacesTypes;
    }

    public String javaToString() {
        String res = "class ";
        if (this.typeVariables != null && !this.typeVariables.isEmpty()) {
            res = res + "<";
            for (TypeVariableSignature tv : this.typeVariables) {
                res = res + ((TypeSignature)tv).javaToString() + ",";
            }
            res = res + ">";
        }
        res = res + " extends " + this.superType.name();
        if (this.interfacesTypes != null && !this.interfacesTypes.isEmpty()) {
            res = res + " implements ";
            for (TypeSignature itf : this.interfacesTypes) {
                res = res + itf.javaToString() + ",";
            }
        }
        return res;
    }

    public List<TypeVariableSignature> getTypeVariables() {
        return this.typeVariables;
    }

    public TypeSignature getSuperType() {
        return this.superType;
    }

    public List<TypeSignature> getInterfacesTypes() {
        return this.interfacesTypes;
    }

    public static ClassSignatureTag convertSignatureTag(soot.tagkit.SignatureTag sootTag) {
        ClassSignatureTag res = null;
        if (sootTag != null) {
            SignatureParser parser = new SignatureParser();
            res = parser.parseClassSignature(sootTag.getSignature());
        }
        return res;
    }

    public TypeSignature getInterface(String name) {
        for (TypeSignature itf : this.interfacesTypes) {
            if (!itf.name().equals(name)) continue;
            return itf;
        }
        return null;
    }

    @Override
    public boolean needsSignatureGeneration() {
        boolean genericInterface = false;
        for (TypeSignature itfType : this.interfacesTypes) {
            if (!itfType.hasGenericRef()) continue;
            genericInterface = true;
            break;
        }
        return this.typeVariables != null && !this.typeVariables.isEmpty() || this.superType.hasGenericRef() || genericInterface;
    }

    @Override
    public String toSignatureReference(String className) {
        if (this.needsSignatureGeneration()) {
            StringBuffer res = new StringBuffer();
            if (this.typeVariables != null && !this.typeVariables.isEmpty()) {
                res.append("<");
                for (TypeVariableSignature tvs : this.typeVariables) {
                    res.append(tvs.toStringBytecodeNameDef());
                }
                res.append(">");
            }
            String superSig = this.superType.toStringBytecodeNameRef();
            res.append(superSig);
            for (TypeSignature itfType : this.interfacesTypes) {
                String itfSig = itfType.toStringBytecodeNameRef();
                res.append(itfSig);
            }
            return res.toString();
        }
        return null;
    }
}

