/*
 * Decompiled with CFR 0.152.
 */
package soot.hj.tagkit;

import java.util.List;
import soot.hj.HjToJimple.jl5.generics.SignatureParser;
import soot.hj.HjToJimple.jl5.generics.TypeSignature;
import soot.hj.HjToJimple.jl5.generics.TypeVariableSignature;
import soot.hj.tagkit.SignatureTag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodSignatureTag
extends SignatureTag {
    private List<TypeVariableSignature> typeVariables;
    private List<TypeSignature> formals;
    private TypeSignature returnType;
    private List<TypeSignature> typeThrown;

    public MethodSignatureTag(List<TypeVariableSignature> tvList, List<TypeSignature> formals, TypeSignature typeReturned, List<TypeSignature> typeThrown) {
        this.typeVariables = tvList;
        this.formals = formals;
        this.returnType = typeReturned;
        this.typeThrown = typeThrown;
    }

    public List<TypeSignature> getFormals() {
        return this.formals;
    }

    public List<TypeSignature> getTypeThrown() {
        return this.typeThrown;
    }

    public String javaToString() {
        String res = this.returnType != null ? this.returnType.javaToString() : "";
        res = res + "(";
        if (this.formals != null && !this.formals.isEmpty()) {
            for (TypeSignature formal : this.formals) {
                res = res + formal.javaToString() + ",";
            }
        }
        res = res + ")";
        if (this.typeThrown != null && !this.typeThrown.isEmpty()) {
            res = res + " throws ";
            for (TypeSignature thr : this.typeThrown) {
                res = res + thr.javaToString() + ",";
            }
        }
        return res;
    }

    public static MethodSignatureTag convertSignatureTag(soot.tagkit.SignatureTag sootTag) {
        MethodSignatureTag res = null;
        if (sootTag != null) {
            SignatureParser parser = new SignatureParser();
            res = parser.parseMethodSignature(sootTag.getSignature());
        }
        return res;
    }

    public TypeSignature getReturnType() {
        return this.returnType;
    }

    public List<TypeVariableSignature> getTypeVariables() {
        return this.typeVariables;
    }

    @Override
    public boolean needsSignatureGeneration() {
        boolean genericFormals = false;
        if (this.formals != null && !this.formals.isEmpty()) {
            for (TypeSignature ts : this.formals) {
                if (!ts.hasGenericRef()) continue;
                genericFormals = true;
                break;
            }
        }
        boolean genericThrown = false;
        if (this.typeThrown != null && !this.typeThrown.isEmpty()) {
            for (TypeSignature ts : this.typeThrown) {
                if (!ts.hasGenericRef()) continue;
                genericThrown = true;
                break;
            }
        }
        return genericFormals || this.returnType.hasGenericRef() || genericThrown;
    }

    @Override
    public String toSignatureReference(String methodName) {
        if (this.needsSignatureGeneration()) {
            StringBuffer res = new StringBuffer();
            res.append("(");
            if (this.formals != null && !this.formals.isEmpty()) {
                for (int i = 0; i < this.formals.size(); ++i) {
                    res.append(this.formals.get(i).toStringBytecodeNameRef());
                }
            }
            res.append(")");
            res.append(this.returnType.toStringBytecodeNameRef());
            boolean genericThrown = false;
            if (this.typeThrown != null && !this.typeThrown.isEmpty()) {
                for (TypeSignature ts : this.typeThrown) {
                    if (!ts.hasGenericRef()) continue;
                    genericThrown = true;
                    break;
                }
            }
            if (genericThrown) {
                for (TypeSignature thrownType : this.typeThrown) {
                    res.append("^");
                    res.append(thrownType.toStringBytecodeNameRef());
                }
            }
            return res.toString();
        }
        return null;
    }
}

