/*
 * Decompiled with CFR 0.152.
 */
package soot.hj.util;

import soot.SootClass;
import soot.util.Chain;

public abstract class TypeHierarchyExplorer {
    public abstract boolean explore(SootClass var1);

    public abstract void endExplore(SootClass var1);

    public void exploreHierarchy(SootClass sc) {
        boolean continueExplore = this.explore(sc);
        if (continueExplore) {
            Chain interfaces = sc.getInterfaces();
            for (SootClass sci : interfaces) {
                this.enterInterface(sc, sci);
                this.exploreHierarchy(sci);
                this.exitInterface(sc, sci);
            }
            if (sc.hasSuperclass()) {
                SootClass superClass = sc.getSuperclass();
                this.enterSuperClass(sc, superClass);
                this.exploreHierarchy(superClass);
                this.exitSuperClass(sc, superClass);
            }
        }
        this.endExplore(sc);
    }

    protected void enterInterface(SootClass sc, SootClass sci) {
    }

    protected void exitInterface(SootClass sc, SootClass sci) {
    }

    protected void enterSuperClass(SootClass sc, SootClass superClass) {
    }

    protected void exitSuperClass(SootClass sc, SootClass superClass) {
    }
}

