/*
 * Decompiled with CFR 0.152.
 */
package soot.hj.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import polyglot.types.ArrayType;
import polyglot.types.ClassType;
import soot.FastHierarchy;
import soot.RefType;
import soot.Scene;
import soot.Singletons;
import soot.SootClass;
import soot.SootMethod;
import soot.Type;
import soot.hj.HjSingletons;
import soot.hj.HjToJimple.jl5.generics.SootTypeToLightType;
import soot.hj.tagkit.ClassSignatureTag;
import soot.hj.tagkit.MethodSignatureTag;
import soot.tagkit.AbstractHost;
import soot.tagkit.SignatureTag;
import soot.tagkit.Tag;
import soot.util.Chain;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeUtils {
    public TypeUtils(Singletons.Global g) {
    }

    public static TypeUtils v() {
        return HjSingletons.v().soot_hj_util_TypeUtils();
    }

    public boolean isSynthetic(AbstractHost host) {
        return host.hasTag("SyntheticTag") || host.hasTag("BridgeTag");
    }

    public ClassSignatureTag getClassSignatureTag(AbstractHost host) {
        SignatureTag st;
        ClassSignatureTag cst = (ClassSignatureTag)host.getTag("Signature");
        if (cst == null && (cst = ClassSignatureTag.convertSignatureTag(st = (SignatureTag)host.getTag("SignatureTag"))) == null) {
            SootClass sc = (SootClass)host;
            cst = SootTypeToLightType.getClassSignatureTag(sc);
            host.addTag((Tag)cst);
            return cst;
        }
        return cst;
    }

    public MethodSignatureTag getMethodSignatureTag(AbstractHost host) {
        SignatureTag st;
        MethodSignatureTag mst = (MethodSignatureTag)host.getTag("Signature");
        if (mst == null && (mst = MethodSignatureTag.convertSignatureTag(st = (SignatureTag)host.getTag("SignatureTag"))) == null) {
            SootMethod sm = (SootMethod)host;
            mst = SootTypeToLightType.getMethodSignatureTag(sm);
            host.addTag((Tag)mst);
            return mst;
        }
        return mst;
    }

    public boolean isSubType(Type child, Type parent) {
        assert (child instanceof RefType);
        assert (parent instanceof RefType);
        RefType childRef = (RefType)child;
        RefType parentRef = (RefType)parent;
        FastHierarchy fh = Scene.v().getOrMakeFastHierarchy();
        return fh.isSubclass(childRef.getSootClass(), parentRef.getSootClass());
    }

    public List<SootClass> buildClassHierarchy(SootClass sc) {
        sc.checkLevel(1);
        LinkedList<SootClass> classList = new LinkedList<SootClass>();
        while (sc.hasSuperclass()) {
            sc = sc.getSuperclass();
            classList.add(sc);
        }
        return classList;
    }

    public Set<SootClass> buildClosureForHierarchy(SootClass sc) {
        Set<SootClass> set = this.buildInterfacesClosure(sc);
        set.add(sc);
        if (sc.hasSuperclass()) {
            set.addAll(this.buildClosureForHierarchy(sc.getSuperclass()));
        }
        return set;
    }

    public Set<SootClass> buildInterfacesClosureForHierarchy(SootClass sc) {
        Set<SootClass> interfacesSet = this.buildInterfacesClosure(sc);
        if (sc.hasSuperclass()) {
            interfacesSet.addAll(this.buildInterfacesClosureForHierarchy(sc.getSuperclass()));
        }
        return interfacesSet;
    }

    public Set<SootClass> buildInterfacesClosure(SootClass sc) {
        sc.checkLevel(1);
        HashSet<SootClass> interfacesSet = new HashSet<SootClass>();
        LinkedList<SootClass> workList = new LinkedList<SootClass>();
        workList.add(sc);
        while (!workList.isEmpty()) {
            SootClass head = (SootClass)workList.remove(0);
            Chain interfaces = head.getInterfaces();
            interfaces.removeAll(interfacesSet);
            interfacesSet.addAll((Collection<SootClass>)interfaces);
            workList.addAll((Collection<SootClass>)interfaces);
        }
        return interfacesSet;
    }

    public String polyglotToSootStringType(String typeStr) {
        if (typeStr.contains("[.]")) {
            if (typeStr.equals("boolean[.]")) {
                return "hj.array.view.BooleanArrayView";
            }
            if (typeStr.equals("byte[.]")) {
                return "hj.array.view.ByteArrayView";
            }
            if (typeStr.equals("char[.]")) {
                return "hj.array.view.CharArrayView";
            }
            if (typeStr.equals("short[.]")) {
                return "hj.array.view.ShortArrayView";
            }
            if (typeStr.equals("int[.]")) {
                return "hj.array.view.IntArrayView";
            }
            if (typeStr.equals("long[.]")) {
                return "hj.array.view.LongArrayView";
            }
            if (typeStr.equals("float[.]")) {
                return "hj.array.view.FloatArrayView";
            }
            if (typeStr.equals("double[.]")) {
                return "hj.array.view.DoubleArrayView";
            }
            if (typeStr.equals("complex32[.]")) {
                return "hj.array.view.Complex32ArrayView";
            }
            if (typeStr.equals("complex64[.]")) {
                return "hj.array.view.Complex64ArrayView";
            }
            return "hj.array.view.ObjectArrayView";
        }
        return typeStr;
    }

    public String polyglotToSootStringType(polyglot.types.Type type) {
        String name = "";
        polyglot.types.Type baseType = type;
        if (type.isArray()) {
            ArrayType atype = (ArrayType)type;
            baseType = atype.ultimateBase();
            for (int dims = atype.dims(); dims > 0; --dims) {
                name = name + "[]";
            }
        }
        if (baseType.isClass()) {
            ClassType ct = (ClassType)baseType;
            do {
                name = ct.isNested() ? "$" + ct.name().toString() + name : ct.fullName().toString() + name;
            } while ((ct = ct.outer()) != null);
        } else {
            name = type.toString();
        }
        return this.polyglotToSootStringType(name);
    }
}

