/*
 * Decompiled with CFR 0.152.
 */
package soot.hj.workstealing;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import soot.ArrayType;
import soot.Body;
import soot.BooleanType;
import soot.IntType;
import soot.Local;
import soot.MethodOrMethodContext;
import soot.RefType;
import soot.Scene;
import soot.SceneTransformer;
import soot.SootClass;
import soot.SootMethod;
import soot.Type;
import soot.Unit;
import soot.Value;
import soot.ValueBox;
import soot.VoidType;
import soot.hj.workstealing.GenJimple;
import soot.hj.workstealing.MethodTransformer;
import soot.hj.workstealing.RuntimeReferences;
import soot.jimple.AssignStmt;
import soot.jimple.GotoStmt;
import soot.jimple.IdentityStmt;
import soot.jimple.IfStmt;
import soot.jimple.IntConstant;
import soot.jimple.InvokeExpr;
import soot.jimple.Jimple;
import soot.jimple.JimpleBody;
import soot.jimple.Stmt;
import soot.jimple.StringConstant;
import soot.jimple.toolkits.callgraph.CallGraph;
import soot.jimple.toolkits.callgraph.Edge;

public class FinishAsyncTransformer
extends SceneTransformer {
    private static FinishAsyncTransformer instance = new FinishAsyncTransformer();
    private Set applicationMethods;
    private Map methodTransformers;
    private MethodTransformer mainTransformer;
    private boolean hasMainTransformer;
    private Set methodsNeedingContinuations;
    private Set methodsContainingContinuations;

    private FinishAsyncTransformer() {
    }

    public static FinishAsyncTransformer v() {
        return instance;
    }

    protected void internalTransform(String phaseName, Map options) {
        MethodTransformer mT;
        RuntimeReferences.v().initialize();
        this.applicationMethods = new HashSet();
        this.methodTransformers = new HashMap();
        this.hasMainTransformer = false;
        this.methodsNeedingContinuations = new HashSet();
        this.methodsContainingContinuations = new HashSet();
        for (SootClass appClass : Scene.v().getApplicationClasses()) {
            ListIterator getMethodsIt = appClass.getMethods().listIterator();
            while (getMethodsIt.hasNext()) {
                SootMethod sMethod = (SootMethod)getMethodsIt.next();
                if (!this.doesMethodNeedTransformation(sMethod) || this.isMethodConcreteInClass(sMethod, appClass.getSuperclass())) continue;
                this.addApplicationMethod(sMethod);
                MethodTransformer mT2 = new MethodTransformer(sMethod);
                this.addMethodTransformer(sMethod, mT2);
                if (!this.isMainMethod(sMethod) || this.hasMainTransformer) continue;
                this.mainTransformer = mT2;
                this.hasMainTransformer = true;
            }
        }
        this.collectMethodsNeedingContinuations();
        for (SootMethod sMethod : this.methodsNeedingContinuations) {
            mT = this.getMethodTransformer(sMethod);
            mT.identityLocals();
        }
        for (SootMethod sMethod : this.methodsNeedingContinuations) {
            mT = this.getMethodTransformer(sMethod);
            mT.generateClones();
        }
        for (SootMethod sMethod : this.methodsNeedingContinuations) {
            mT = this.getMethodTransformer(sMethod);
            mT.generateFrameClass();
        }
        for (SootMethod sMethod : this.methodsNeedingContinuations) {
            mT = this.getMethodTransformer(sMethod);
            mT.transformFinishAsyncs();
        }
        for (SootMethod sMethod : this.methodsNeedingContinuations) {
            mT = this.getMethodTransformer(sMethod);
            mT.generateFrameClassMethods();
        }
        for (SootMethod sMethod : this.methodsNeedingContinuations) {
            mT = this.getMethodTransformer(sMethod);
            mT.cleanupMethodDeclarations();
        }
        for (SootMethod sMethod : this.methodsNeedingContinuations) {
            mT = this.getMethodTransformer(sMethod);
            mT.removeUnwantedHjMethodCalls();
        }
        for (SootMethod sMethod : this.methodsNeedingContinuations) {
            mT = this.getMethodTransformer(sMethod);
            mT.validateAllMethods();
        }
        if (this.methodsNeedingContinuations.iterator().hasNext()) {
            this.generateMainFunc(Scene.v().getMainClass());
        }
    }

    public void addApplicationMethod(SootMethod sMethod) {
        this.applicationMethods.add(sMethod);
    }

    public boolean isApplicationMethod(SootMethod sMethod) {
        return this.applicationMethods.contains(sMethod);
    }

    public void addMethodTransformer(SootMethod sMethod, MethodTransformer mTrans) {
        if (!this.methodTransformers.containsKey(sMethod)) {
            this.methodTransformers.put(sMethod, mTrans);
        }
    }

    public MethodTransformer getMethodTransformer(SootMethod sMethod) {
        if (!this.methodTransformers.containsKey(sMethod)) {
            throw new RuntimeException("No Transformer present for method : " + sMethod.getName());
        }
        return (MethodTransformer)this.methodTransformers.get(sMethod);
    }

    public boolean isAConstructor(SootMethod sMethod) {
        return sMethod.getName().equals("<init>");
    }

    public boolean isMainMethod(SootMethod sMethod) {
        return sMethod.getSubSignature().equals("void main(java.lang.String[])");
    }

    public boolean doesMethodNeedTransformation(SootMethod sMethod) {
        if (this.isAConstructor(sMethod)) {
            return false;
        }
        return sMethod.hasActiveBody();
    }

    public void generateMainFunc(SootClass sClass) {
        SootMethod sMethod = new SootMethod("main", Arrays.asList(ArrayType.v((Type)RefType.v((String)"java.lang.String"), (int)1)), (Type)VoidType.v(), 9);
        JimpleBody body = Jimple.v().newBody(sMethod);
        sMethod.setActiveBody((Body)body);
        System.out.println("Add method to class: " + sClass);
        sClass.addMethod(sMethod);
        Local args = GenJimple.v().addLocalAndParameterRefStmt((Body)body, "args", sMethod.getParameterType(0), 0);
        Local numProc = Jimple.v().newLocal("numProc", (Type)IntType.v());
        body.getLocals().add((Object)numProc);
        body.getUnits().add((Unit)Jimple.v().newAssignStmt((Value)numProc, (Value)IntConstant.v((int)0)));
        Local argsLength = Jimple.v().newLocal("argsLength", (Type)IntType.v());
        body.getLocals().add((Object)argsLength);
        AssignStmt argsLengthSt = Jimple.v().newAssignStmt((Value)argsLength, (Value)Jimple.v().newLengthExpr((Value)args));
        body.getUnits().add((Unit)argsLengthSt);
        Local arg0 = Jimple.v().newLocal("arg0", (Type)RefType.v((String)"java.lang.String"));
        body.getLocals().add((Object)arg0);
        body.getUnits().add((Unit)Jimple.v().newAssignStmt((Value)arg0, (Value)Jimple.v().newArrayRef((Value)args, (Value)IntConstant.v((int)0))));
        Local equalsCondition = Jimple.v().newLocal("equalsCondition", (Type)BooleanType.v());
        body.getLocals().add((Object)equalsCondition);
        AssignStmt equalsConditionSt = Jimple.v().newAssignStmt((Value)equalsCondition, (Value)Jimple.v().newVirtualInvokeExpr(arg0, Scene.v().getSootClass("java.lang.String").getMethod("boolean equals(java.lang.Object)").makeRef(), (Value)StringConstant.v((String)"--nproc")));
        body.getUnits().add((Unit)equalsConditionSt);
        Local arg1 = Jimple.v().newLocal("arg1", (Type)RefType.v((String)"java.lang.String"));
        body.getLocals().add((Object)arg1);
        body.getUnits().add((Unit)Jimple.v().newAssignStmt((Value)arg1, (Value)Jimple.v().newArrayRef((Value)args, (Value)IntConstant.v((int)1))));
        AssignStmt assignStParse = Jimple.v().newAssignStmt((Value)numProc, (Value)Jimple.v().newStaticInvokeExpr(Scene.v().getSootClass("java.lang.Integer").getMethod("int parseInt(java.lang.String)").makeRef(), new Value[]{arg1}));
        body.getUnits().add((Unit)assignStParse);
        Local restArgsLength = Jimple.v().newLocal("restArgsLength", (Type)IntType.v());
        body.getLocals().add((Object)restArgsLength);
        body.getUnits().add((Unit)Jimple.v().newAssignStmt((Value)restArgsLength, (Value)Jimple.v().newSubExpr((Value)argsLength, (Value)IntConstant.v((int)2))));
        Local restArgs = Jimple.v().newLocal("restArgs", sMethod.getParameterType(0));
        body.getLocals().add((Object)restArgs);
        body.getUnits().add((Unit)Jimple.v().newAssignStmt((Value)restArgs, (Value)Jimple.v().newNewArrayExpr((Type)RefType.v((String)"java.lang.String"), (Value)restArgsLength)));
        body.getUnits().add((Unit)Jimple.v().newInvokeStmt((Value)Jimple.v().newStaticInvokeExpr(Scene.v().getSootClass("java.lang.System").getMethodByName("arraycopy").makeRef(), Arrays.asList(args, IntConstant.v((int)2), restArgs, IntConstant.v((int)0), restArgsLength))));
        AssignStmt argsAssignSt = Jimple.v().newAssignStmt((Value)args, (Value)restArgs);
        body.getUnits().add((Unit)argsAssignSt);
        Local numberFormatExcep = Jimple.v().newLocal("numberFormatException", (Type)RefType.v((String)"java.lang.NumberFormatException"));
        body.getLocals().add((Object)numberFormatExcep);
        IdentityStmt caughtExcepSt = Jimple.v().newIdentityStmt((Value)numberFormatExcep, (Value)Jimple.v().newCaughtExceptionRef());
        body.getUnits().add((Unit)caughtExcepSt);
        AssignStmt assignSt1 = Jimple.v().newAssignStmt((Value)numProc, (Value)IntConstant.v((int)1));
        body.getUnits().add((Unit)assignSt1);
        AssignStmt thenLastSt = assignSt1;
        AssignStmt assignSt2 = Jimple.v().newAssignStmt((Value)numProc, (Value)IntConstant.v((int)2));
        body.getUnits().add((Unit)assignSt2);
        IfStmt firstIfSt = Jimple.v().newIfStmt((Value)Jimple.v().newLtExpr((Value)argsLength, (Value)IntConstant.v((int)2)), (Unit)assignSt2);
        body.getUnits().insertAfter((Unit)firstIfSt, (Unit)argsLengthSt);
        IfStmt secondIfSt = Jimple.v().newIfStmt((Value)Jimple.v().newEqExpr((Value)equalsCondition, (Value)IntConstant.v((int)0)), (Unit)assignSt2);
        body.getUnits().insertAfter((Unit)secondIfSt, (Unit)equalsConditionSt);
        Local runtime = Jimple.v().newLocal("runtime", (Type)RuntimeReferences.v().WSRuntime().getType());
        body.getLocals().add((Object)runtime);
        AssignStmt newRuntimeSt = Jimple.v().newAssignStmt((Value)runtime, (Value)Jimple.v().newNewExpr(RuntimeReferences.v().WSRuntime().getType()));
        body.getUnits().add((Unit)newRuntimeSt);
        GotoStmt gotoSt = Jimple.v().newGotoStmt((Unit)newRuntimeSt);
        body.getUnits().insertAfter((Unit)gotoSt, (Unit)argsAssignSt);
        body.getUnits().add((Unit)Jimple.v().newInvokeStmt((Value)Jimple.v().newSpecialInvokeExpr(runtime, RuntimeReferences.v().WSRuntime().getMethod("void <init>(int,boolean,boolean)").makeRef(), Arrays.asList(numProc, IntConstant.v((int)0), IntConstant.v((int)0)))));
        body.getUnits().insertAfter((Unit)Jimple.v().newGotoStmt((Unit)newRuntimeSt), (Unit)thenLastSt);
        if (!this.hasMainTransformer) {
            throw new RuntimeException("Could not find main function");
        }
        SootClass mainFrameClass = this.mainTransformer.frameClass();
        SootMethod mainFrameConstructor = this.mainTransformer.frameConstructor();
        Local mainFrame = Jimple.v().newLocal("mainFrame", (Type)mainFrameClass.getType());
        body.getLocals().add((Object)mainFrame);
        body.getUnits().add((Unit)Jimple.v().newAssignStmt((Value)mainFrame, (Value)Jimple.v().newNewExpr(mainFrameClass.getType())));
        body.getUnits().add((Unit)Jimple.v().newInvokeStmt((Value)Jimple.v().newSpecialInvokeExpr(mainFrame, mainFrameConstructor.makeRef(), (Value)args)));
        body.getUnits().add((Unit)Jimple.v().newInvokeStmt((Value)Jimple.v().newVirtualInvokeExpr(runtime, RuntimeReferences.v().runtimeStartWorkers().makeRef(), (Value)mainFrame)));
        body.getTraps().add((Object)Jimple.v().newTrap(Scene.v().getSootClass("java.lang.NumberFormatException"), (Unit)argsLengthSt, (Unit)gotoSt, (Unit)caughtExcepSt));
        body.getUnits().add((Unit)Jimple.v().newReturnVoidStmt());
    }

    public void printClassDetails(SootClass sClass) {
        System.out.println("Class : " + sClass.toString());
        System.out.println("Methods : ");
        Iterator methodIt = sClass.methodIterator();
        while (methodIt.hasNext()) {
            SootMethod sMethod = (SootMethod)methodIt.next();
            System.out.println("   " + sMethod.toString());
            System.out.println("   Locals : ");
            for (Local local : sMethod.getActiveBody().getLocals()) {
                System.out.println("      " + local.toString() + " : " + local.getType().toString());
            }
            System.out.println("   Units : ");
            for (Unit unit : sMethod.getActiveBody().getUnits()) {
                System.out.println(unit.toString());
            }
            System.out.println();
            System.out.println(" Checking use boxes");
            for (ValueBox vb : sMethod.getActiveBody().getUseBoxes()) {
                System.out.println("  Value = " + vb.getValue().toString() + " : " + vb.getValue().getType().toString());
            }
        }
    }

    public boolean isAUserSpecifiedLocal(Local local) {
        return local.getName().charAt(0) != '$';
    }

    public boolean isTheThisParameter(Local local) {
        return local.getName().equals("this");
    }

    public boolean isAThrowableObject(Local local) {
        return local.getType().equals(RefType.v((String)"java.lang.Throwable"));
    }

    public boolean isLocalNeededInFrame(Local local) {
        if (!this.isAUserSpecifiedLocal(local)) {
            return false;
        }
        if (this.isTheThisParameter(local)) {
            return false;
        }
        if (this.isAThrowableObject(local)) {
            return false;
        }
        return local.getType() != RuntimeReferences.v().WSWorker().getType();
    }

    public boolean isStartFinishMethod(SootMethod sMethod) {
        return sMethod.getName().equals("startFinish");
    }

    public boolean isStopFinishMethod(SootMethod sMethod) {
        return sMethod.getName().equals("stopFinish");
    }

    public boolean isAsyncMethod(SootMethod sMethod) {
        return sMethod.getName().equals("runAsync");
    }

    public boolean isARunHjTaskMethod(SootMethod sMethod) {
        return sMethod.getName().equals("runHjTask");
    }

    public boolean isMethodConcreteInClass(SootMethod sMethod, SootClass sClass) {
        if (sClass.declaresMethod(sMethod.getSubSignature())) {
            SootMethod classMethod = sClass.getMethod(sMethod.getSubSignature());
            return classMethod.isConcrete();
        }
        return false;
    }

    public boolean containsContinuation(SootMethod sMethod) {
        if (!this.isApplicationMethod(sMethod)) {
            return false;
        }
        if (this.isARunHjTaskMethod(sMethod)) {
            return false;
        }
        for (Stmt st : sMethod.getActiveBody().getUnits()) {
            if (!st.containsInvokeExpr()) continue;
            InvokeExpr invExpr = st.getInvokeExpr();
            if (this.isStopFinishMethod(invExpr.getMethod())) {
                return true;
            }
            if (!this.isAsyncMethod(invExpr.getMethod())) continue;
            return true;
        }
        return false;
    }

    public void collectMethodsNeedingContinuations() {
        for (SootMethod sMethod : this.applicationMethods) {
            if (!this.containsContinuation(sMethod)) continue;
            this.methodsNeedingContinuations.add(sMethod);
            this.methodsContainingContinuations.add(sMethod);
        }
        CallGraph cg = Scene.v().getCallGraph();
        boolean change = true;
        while (change) {
            change = false;
            block2: for (SootMethod sMethod : this.applicationMethods) {
                if (this.isARunHjTaskMethod(sMethod) || this.methodsNeedingContinuations.contains(sMethod)) continue;
                Iterator edgeIt = cg.edgesOutOf((MethodOrMethodContext)sMethod);
                while (edgeIt.hasNext()) {
                    Edge edge = (Edge)edgeIt.next();
                    if (!this.methodsNeedingContinuations.contains(edge.tgt())) continue;
                    this.methodsNeedingContinuations.add(sMethod);
                    change = true;
                    continue block2;
                }
            }
        }
    }

    public boolean doesMethodNeedContinuation(SootMethod sMethod) {
        return this.methodsNeedingContinuations.contains(sMethod);
    }

    public boolean isATransformedMethod(SootMethod sMethod) {
        return this.doesMethodNeedContinuation(sMethod);
    }

    public boolean doesMethodContainContinuation(SootMethod sMethod) {
        return this.methodsContainingContinuations.contains(sMethod);
    }
}

