/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import soot.AbstractJasminClass;
import soot.ArrayType;
import soot.Body;
import soot.BooleanType;
import soot.ByteType;
import soot.CharType;
import soot.DoubleType;
import soot.FloatType;
import soot.G;
import soot.IntType;
import soot.IntegerType;
import soot.Local;
import soot.LongType;
import soot.Modifier;
import soot.NullType;
import soot.PatchingChain;
import soot.RefType;
import soot.ShortType;
import soot.SootClass;
import soot.SootFieldRef;
import soot.SootMethod;
import soot.SootMethodRef;
import soot.StmtAddressType;
import soot.Timers;
import soot.Trap;
import soot.Type;
import soot.TypeSwitch;
import soot.Unit;
import soot.Value;
import soot.ValueBox;
import soot.VoidType;
import soot.grimp.AbstractGrimpValueSwitch;
import soot.grimp.NewInvokeExpr;
import soot.jimple.AbstractJimpleValueSwitch;
import soot.jimple.AbstractStmtSwitch;
import soot.jimple.AddExpr;
import soot.jimple.AndExpr;
import soot.jimple.ArrayRef;
import soot.jimple.AssignStmt;
import soot.jimple.BinopExpr;
import soot.jimple.BreakpointStmt;
import soot.jimple.CastExpr;
import soot.jimple.CaughtExceptionRef;
import soot.jimple.ClassConstant;
import soot.jimple.CmpExpr;
import soot.jimple.CmpgExpr;
import soot.jimple.CmplExpr;
import soot.jimple.DivExpr;
import soot.jimple.DoubleConstant;
import soot.jimple.EnterMonitorStmt;
import soot.jimple.EqExpr;
import soot.jimple.ExitMonitorStmt;
import soot.jimple.FloatConstant;
import soot.jimple.GeExpr;
import soot.jimple.GotoStmt;
import soot.jimple.GtExpr;
import soot.jimple.IdentityRef;
import soot.jimple.IdentityStmt;
import soot.jimple.IfStmt;
import soot.jimple.InstanceFieldRef;
import soot.jimple.InstanceOfExpr;
import soot.jimple.IntConstant;
import soot.jimple.InterfaceInvokeExpr;
import soot.jimple.InvokeStmt;
import soot.jimple.LeExpr;
import soot.jimple.LengthExpr;
import soot.jimple.LongConstant;
import soot.jimple.LookupSwitchStmt;
import soot.jimple.LtExpr;
import soot.jimple.MulExpr;
import soot.jimple.NeExpr;
import soot.jimple.NegExpr;
import soot.jimple.NewArrayExpr;
import soot.jimple.NewExpr;
import soot.jimple.NewMultiArrayExpr;
import soot.jimple.NopStmt;
import soot.jimple.NullConstant;
import soot.jimple.OrExpr;
import soot.jimple.ParameterRef;
import soot.jimple.RemExpr;
import soot.jimple.RetStmt;
import soot.jimple.ReturnStmt;
import soot.jimple.ReturnVoidStmt;
import soot.jimple.ShlExpr;
import soot.jimple.ShrExpr;
import soot.jimple.SpecialInvokeExpr;
import soot.jimple.StaticFieldRef;
import soot.jimple.StaticInvokeExpr;
import soot.jimple.Stmt;
import soot.jimple.StmtBody;
import soot.jimple.StringConstant;
import soot.jimple.SubExpr;
import soot.jimple.TableSwitchStmt;
import soot.jimple.ThisRef;
import soot.jimple.ThrowStmt;
import soot.jimple.UshrExpr;
import soot.jimple.VirtualInvokeExpr;
import soot.jimple.XorExpr;
import soot.jimple.internal.StmtBox;
import soot.options.Options;
import soot.tagkit.LineNumberTag;
import soot.tagkit.SourceLnPosTag;
import soot.toolkits.graph.ExceptionalUnitGraph;
import soot.toolkits.graph.UnitGraph;
import soot.toolkits.scalar.LiveLocals;
import soot.toolkits.scalar.LocalDefs;
import soot.toolkits.scalar.SimpleLiveLocals;
import soot.toolkits.scalar.SimpleLocalUses;
import soot.toolkits.scalar.SmartLocalDefs;
import soot.util.Switch;

public class HjJasminClass
extends AbstractJasminClass {
    Value plusPlusValue;
    Local plusPlusHolder;
    int plusPlusState;
    int plusPlusPlace;
    int plusPlusHeight;
    Stmt plusPlusIncrementer;

    void emit(String s, int stackChange) {
        this.modifyStackHeight(stackChange);
        this.okayEmit(s);
    }

    void modifyStackHeight(int stackChange) {
        if (this.currentStackHeight > this.maxStackHeight) {
            this.maxStackHeight = this.currentStackHeight;
        }
        this.currentStackHeight += stackChange;
        if (this.currentStackHeight < 0) {
            throw new RuntimeException("Stack height is negative!");
        }
        if (this.currentStackHeight > this.maxStackHeight) {
            this.maxStackHeight = this.currentStackHeight;
        }
    }

    public HjJasminClass(SootClass sootClass) {
        super(sootClass);
    }

    protected void emitMethodBody(SootMethod method) {
        boolean disablePeephole;
        Body activeBody;
        if (Options.v().time()) {
            Timers.v().buildJasminTimer.end();
        }
        if (!((activeBody = method.getActiveBody()) instanceof StmtBody)) {
            throw new RuntimeException("method: " + method.getName() + " has an invalid active body!");
        }
        StmtBody body = (StmtBody)activeBody;
        body.validate();
        if (body == null && Options.v().time()) {
            Timers.v().buildJasminTimer.start();
        }
        PatchingChain units = body.getUnits();
        ExceptionalUnitGraph stmtGraph = null;
        SmartLocalDefs ld = null;
        SimpleLocalUses lu = null;
        if (Options.v().verbose()) {
            G.v().out.println("[" + body.getMethod().getName() + "] Performing peephole optimizations...");
        }
        if (!(disablePeephole = true)) {
            stmtGraph = new ExceptionalUnitGraph((Body)body);
            ld = new SmartLocalDefs((UnitGraph)stmtGraph, (LiveLocals)new SimpleLiveLocals((UnitGraph)stmtGraph));
            lu = new SimpleLocalUses((UnitGraph)stmtGraph, (LocalDefs)ld);
        }
        int stackLimitIndex = -1;
        this.subroutineToReturnAddressSlot = new HashMap(10, 0.7f);
        Iterator boxIt = body.getUnitBoxes(true).iterator();
        this.unitToLabel = new HashMap(units.size() * 2 + 1, 0.7f);
        this.labelCount = 0;
        while (boxIt.hasNext()) {
            StmtBox box = (StmtBox)boxIt.next();
            if (this.unitToLabel.containsKey(box.getUnit())) continue;
            this.unitToLabel.put(box.getUnit(), "label" + this.labelCount++);
        }
        for (Trap trap : body.getTraps()) {
            if (trap.getBeginUnit() == trap.getEndUnit()) continue;
            this.emit(".catch " + HjJasminClass.slashify((String)trap.getException().getName()) + " from " + this.unitToLabel.get(trap.getBeginUnit()) + " to " + this.unitToLabel.get(trap.getEndUnit()) + " using " + this.unitToLabel.get(trap.getHandlerUnit()));
        }
        int localCount = 0;
        int[] paramSlots = new int[method.getParameterCount()];
        int thisSlot = 0;
        HashSet<Local> assignedLocals = new HashSet<Local>();
        HashMap groupColorPairToSlot = new HashMap(body.getLocalCount() * 2 + 1, 0.7f);
        this.localToSlot = new HashMap(body.getLocalCount() * 2 + 1, 0.7f);
        List paramTypes = method.getParameterTypes();
        if (!method.isStatic()) {
            thisSlot = 0;
            ++localCount;
        }
        for (int i = 0; i < paramTypes.size(); ++i) {
            paramSlots[i] = localCount;
            localCount += HjJasminClass.sizeOfType((Type)((Type)paramTypes.get(i)));
        }
        for (Stmt s : units) {
            if (!(s instanceof IdentityStmt) || !(((IdentityStmt)s).getLeftOp() instanceof Local)) continue;
            Local l = (Local)((IdentityStmt)s).getLeftOp();
            IdentityRef identity = (IdentityRef)((IdentityStmt)s).getRightOp();
            int slot = 0;
            if (identity instanceof ThisRef) {
                if (method.isStatic()) {
                    throw new RuntimeException("Attempting to use 'this' in static method");
                }
                slot = thisSlot;
            } else {
                if (!(identity instanceof ParameterRef)) continue;
                slot = paramSlots[((ParameterRef)identity).getIndex()];
            }
            this.localToSlot.put(l, new Integer(slot));
            assignedLocals.add(l);
        }
        for (Local local : body.getLocals()) {
            if (assignedLocals.contains(local)) continue;
            this.localToSlot.put(local, new Integer(localCount));
            localCount += HjJasminClass.sizeOfType((Type)local.getType());
            assignedLocals.add(local);
        }
        if (!Modifier.isNative((int)method.getModifiers()) && !Modifier.isAbstract((int)method.getModifiers())) {
            this.emit("    .limit stack ?");
            stackLimitIndex = this.code.size() - 1;
            this.emit("    .limit locals " + localCount);
        }
        Iterator codeIt = units.iterator();
        this.isEmittingMethodCode = true;
        this.maxStackHeight = 0;
        this.isNextGotoAJsr = false;
        while (codeIt.hasNext()) {
            boolean contFlag;
            Stmt s;
            block30: {
                Value rvalue;
                Value lvalue;
                Stmt nextNextStmt;
                AssignStmt nextStmt;
                AssignStmt stmt;
                block32: {
                    block31: {
                        Value added;
                        AddExpr addexp;
                        ValueBox box;
                        List l;
                        Stmt ns;
                        s = (Stmt)codeIt.next();
                        if (this.unitToLabel.containsKey(s)) {
                            this.emit(this.unitToLabel.get(s) + ":");
                        }
                        if (this.subroutineToReturnAddressSlot.containsKey(s)) {
                            AssignStmt assignStmt = (AssignStmt)s;
                            this.modifyStackHeight(1);
                            int slot = (Integer)this.localToSlot.get(assignStmt.getLeftOp());
                            if (slot >= 0 && slot <= 3) {
                                this.emit("astore_" + slot, -1);
                            } else {
                                this.emit("astore " + slot, -1);
                            }
                        }
                        contFlag = false;
                        if (disablePeephole || !(s instanceof AssignStmt)) break block30;
                        stmt = (AssignStmt)s;
                        if (!codeIt.hasNext() || !((ns = (Stmt)stmtGraph.getSuccsOf((Unit)stmt).get(0)) instanceof AssignStmt) || (l = stmtGraph.getSuccsOf((Unit)(nextStmt = (AssignStmt)ns))).size() != 1) break block30;
                        nextNextStmt = (Stmt)l.get(0);
                        lvalue = stmt.getLeftOp();
                        rvalue = stmt.getRightOp();
                        if (!(lvalue instanceof Local) || !(lvalue instanceof Local) || !nextStmt.getLeftOp().equivTo((Object)rvalue) || !(nextStmt.getRightOp() instanceof AddExpr)) break block30;
                        Iterator boxIt2 = nextNextStmt.getUseBoxes().iterator();
                        boolean foundExactlyOnce = false;
                        while (boxIt2.hasNext()) {
                            box = (ValueBox)boxIt2.next();
                            if (box.getValue() != lvalue) continue;
                            if (!foundExactlyOnce) {
                                foundExactlyOnce = true;
                                continue;
                            }
                            foundExactlyOnce = false;
                            break;
                        }
                        if (!foundExactlyOnce) break block30;
                        boxIt2 = nextNextStmt.getDefBoxes().iterator();
                        boolean found = false;
                        while (boxIt2.hasNext()) {
                            box = (ValueBox)boxIt2.next();
                            if (!box.getValue().equivTo((Object)rvalue)) continue;
                            found = true;
                        }
                        if (found || !(addexp = (AddExpr)nextStmt.getRightOp()).getOp1().equivTo((Object)lvalue) && !addexp.getOp1().equivTo((Object)rvalue) || !((added = addexp.getOp2()) instanceof IntConstant) || ((IntConstant)added).value != 1) break block30;
                        if (!addexp.getOp1().equivTo((Object)lvalue)) break block31;
                        if (lu.getUsesOf((Unit)stmt).size() != 2 || ld.getDefsOfAt((Local)lvalue, (Unit)nextStmt).size() != 1 || ld.getDefsOfAt((Local)lvalue, (Unit)nextNextStmt).size() != 1) break block30;
                        this.plusPlusState = 0;
                        break block32;
                    }
                    if (lu.getUsesOf((Unit)stmt).size() != 1 || ld.getDefsOfAt((Local)lvalue, (Unit)nextNextStmt).size() != 1) break block30;
                    this.plusPlusState = 10;
                }
                if (lvalue.getType() == IntType.v()) {
                    this.currentStackHeight = 0;
                    this.plusPlusValue = rvalue;
                    this.plusPlusHolder = (Local)lvalue;
                    this.plusPlusIncrementer = nextStmt;
                    this.emitStmt(nextNextStmt);
                    if (this.plusPlusHolder != null) {
                        this.emitStmt((Stmt)stmt);
                        this.emitStmt((Stmt)nextStmt);
                    }
                    if (this.currentStackHeight != 0) {
                        throw new RuntimeException("Stack has height " + this.currentStackHeight + " after execution of stmt: " + s);
                    }
                    contFlag = true;
                    codeIt.next();
                    codeIt.next();
                }
            }
            if (contFlag) continue;
            this.currentStackHeight = 0;
            this.emitStmt(s);
            if (this.currentStackHeight == 0) continue;
            throw new RuntimeException("Stack has height " + this.currentStackHeight + " after execution of stmt: " + s);
        }
        this.isEmittingMethodCode = false;
        if (!Modifier.isNative((int)method.getModifiers()) && !Modifier.isAbstract((int)method.getModifiers())) {
            this.code.set(stackLimitIndex, "    .limit stack " + this.maxStackHeight);
        }
    }

    void emitAssignStmt(AssignStmt stmt) {
        Value lvalue = stmt.getLeftOp();
        final Value rvalue = stmt.getRightOp();
        if (lvalue instanceof Local && (rvalue instanceof AddExpr || rvalue instanceof SubExpr)) {
            Local l = (Local)lvalue;
            BinopExpr expr = (BinopExpr)rvalue;
            Value op1 = expr.getOp1();
            Value op2 = expr.getOp2();
            if (lvalue == this.plusPlusHolder) {
                this.emitValue(lvalue);
                this.plusPlusHolder = null;
                this.plusPlusState = 0;
            }
            if (l.getType().equals(IntType.v())) {
                boolean isValidCase = false;
                int x = 0;
                if (op1 == l && op2 instanceof IntConstant) {
                    x = ((IntConstant)op2).value;
                    isValidCase = true;
                } else if (expr instanceof AddExpr && op2 == l && op1 instanceof IntConstant) {
                    x = ((IntConstant)op1).value;
                    isValidCase = true;
                }
                if (isValidCase && x >= Short.MIN_VALUE && x <= Short.MAX_VALUE) {
                    this.emit("iinc " + (Integer)this.localToSlot.get(l) + " " + (expr instanceof AddExpr ? x : -x), 0);
                    return;
                }
            }
        }
        lvalue.apply((Switch)new AbstractJimpleValueSwitch(){

            public void caseArrayRef(ArrayRef v) {
                HjJasminClass.this.emitValue(v.getBase());
                HjJasminClass.this.emitValue(v.getIndex());
                HjJasminClass.this.emitValue(rvalue);
                v.getType().apply((Switch)new TypeSwitch(){

                    public void caseArrayType(ArrayType t) {
                        HjJasminClass.this.emit("aastore", -3);
                    }

                    public void caseDoubleType(DoubleType t) {
                        HjJasminClass.this.emit("dastore", -4);
                    }

                    public void caseFloatType(FloatType t) {
                        HjJasminClass.this.emit("fastore", -3);
                    }

                    public void caseIntType(IntType t) {
                        HjJasminClass.this.emit("iastore", -3);
                    }

                    public void caseLongType(LongType t) {
                        HjJasminClass.this.emit("lastore", -4);
                    }

                    public void caseRefType(RefType t) {
                        HjJasminClass.this.emit("aastore", -3);
                    }

                    public void caseByteType(ByteType t) {
                        HjJasminClass.this.emit("bastore", -3);
                    }

                    public void caseBooleanType(BooleanType t) {
                        HjJasminClass.this.emit("bastore", -3);
                    }

                    public void caseCharType(CharType t) {
                        HjJasminClass.this.emit("castore", -3);
                    }

                    public void caseShortType(ShortType t) {
                        HjJasminClass.this.emit("sastore", -3);
                    }

                    public void defaultCase(Type t) {
                        throw new RuntimeException("Invalid type: " + t);
                    }
                });
            }

            public void caseInstanceFieldRef(InstanceFieldRef v) {
                HjJasminClass.this.emitValue(v.getBase());
                HjJasminClass.this.emitValue(rvalue);
                HjJasminClass.this.emit("putfield " + AbstractJasminClass.slashify((String)v.getFieldRef().declaringClass().getName()) + "/" + v.getFieldRef().name() + " " + AbstractJasminClass.jasminDescriptorOf((Type)v.getFieldRef().type()), -1 + -AbstractJasminClass.sizeOfType((Type)v.getFieldRef().type()));
            }

            public void caseLocal(Local v) {
                final int slot = (Integer)HjJasminClass.this.localToSlot.get(v);
                v.getType().apply((Switch)new TypeSwitch(){

                    private void handleIntegerType(IntegerType t) {
                        HjJasminClass.this.emitValue(rvalue);
                        if (slot >= 0 && slot <= 3) {
                            HjJasminClass.this.emit("istore_" + slot, -1);
                        } else {
                            HjJasminClass.this.emit("istore " + slot, -1);
                        }
                    }

                    public void caseBooleanType(BooleanType t) {
                        this.handleIntegerType((IntegerType)t);
                    }

                    public void caseByteType(ByteType t) {
                        this.handleIntegerType((IntegerType)t);
                    }

                    public void caseShortType(ShortType t) {
                        this.handleIntegerType((IntegerType)t);
                    }

                    public void caseCharType(CharType t) {
                        this.handleIntegerType((IntegerType)t);
                    }

                    public void caseIntType(IntType t) {
                        this.handleIntegerType((IntegerType)t);
                    }

                    public void caseArrayType(ArrayType t) {
                        HjJasminClass.this.emitValue(rvalue);
                        if (slot >= 0 && slot <= 3) {
                            HjJasminClass.this.emit("astore_" + slot, -1);
                        } else {
                            HjJasminClass.this.emit("astore " + slot, -1);
                        }
                    }

                    public void caseDoubleType(DoubleType t) {
                        HjJasminClass.this.emitValue(rvalue);
                        if (slot >= 0 && slot <= 3) {
                            HjJasminClass.this.emit("dstore_" + slot, -2);
                        } else {
                            HjJasminClass.this.emit("dstore " + slot, -2);
                        }
                    }

                    public void caseFloatType(FloatType t) {
                        HjJasminClass.this.emitValue(rvalue);
                        if (slot >= 0 && slot <= 3) {
                            HjJasminClass.this.emit("fstore_" + slot, -1);
                        } else {
                            HjJasminClass.this.emit("fstore " + slot, -1);
                        }
                    }

                    public void caseLongType(LongType t) {
                        HjJasminClass.this.emitValue(rvalue);
                        if (slot >= 0 && slot <= 3) {
                            HjJasminClass.this.emit("lstore_" + slot, -2);
                        } else {
                            HjJasminClass.this.emit("lstore " + slot, -2);
                        }
                    }

                    public void caseRefType(RefType t) {
                        HjJasminClass.this.emitValue(rvalue);
                        if (slot >= 0 && slot <= 3) {
                            HjJasminClass.this.emit("astore_" + slot, -1);
                        } else {
                            HjJasminClass.this.emit("astore " + slot, -1);
                        }
                    }

                    public void caseStmtAddressType(StmtAddressType t) {
                        HjJasminClass.this.isNextGotoAJsr = true;
                        HjJasminClass.this.returnAddressSlot = slot;
                    }

                    public void caseNullType(NullType t) {
                        HjJasminClass.this.emitValue(rvalue);
                        if (slot >= 0 && slot <= 3) {
                            HjJasminClass.this.emit("astore_" + slot, -1);
                        } else {
                            HjJasminClass.this.emit("astore " + slot, -1);
                        }
                    }

                    public void defaultCase(Type t) {
                        throw new RuntimeException("Invalid local type: " + t);
                    }
                });
            }

            public void caseStaticFieldRef(StaticFieldRef v) {
                SootFieldRef field = v.getFieldRef();
                HjJasminClass.this.emitValue(rvalue);
                HjJasminClass.this.emit("putstatic " + AbstractJasminClass.slashify((String)field.declaringClass().getName()) + "/" + field.name() + " " + AbstractJasminClass.jasminDescriptorOf((Type)field.type()), -AbstractJasminClass.sizeOfType((Type)v.getFieldRef().type()));
            }
        });
    }

    void emitIfStmt(IfStmt stmt) {
        Value cond = stmt.getCondition();
        final Value op1 = ((BinopExpr)cond).getOp1();
        Value op2 = ((BinopExpr)cond).getOp2();
        final String label = (String)this.unitToLabel.get(stmt.getTarget());
        if (op2 instanceof NullConstant || op1 instanceof NullConstant) {
            if (op2 instanceof NullConstant) {
                this.emitValue(op1);
            } else {
                this.emitValue(op2);
            }
            if (cond instanceof EqExpr) {
                this.emit("ifnull " + label, -1);
            } else if (cond instanceof NeExpr) {
                this.emit("ifnonnull " + label, -1);
            } else {
                throw new RuntimeException("invalid condition");
            }
            return;
        }
        if (op2 instanceof IntConstant && ((IntConstant)op2).value == 0) {
            this.emitValue(op1);
            cond.apply((Switch)new AbstractJimpleValueSwitch(){

                public void caseEqExpr(EqExpr expr) {
                    HjJasminClass.this.emit("ifeq " + label, -1);
                }

                public void caseNeExpr(NeExpr expr) {
                    HjJasminClass.this.emit("ifne " + label, -1);
                }

                public void caseLtExpr(LtExpr expr) {
                    HjJasminClass.this.emit("iflt " + label, -1);
                }

                public void caseLeExpr(LeExpr expr) {
                    HjJasminClass.this.emit("ifle " + label, -1);
                }

                public void caseGtExpr(GtExpr expr) {
                    HjJasminClass.this.emit("ifgt " + label, -1);
                }

                public void caseGeExpr(GeExpr expr) {
                    HjJasminClass.this.emit("ifge " + label, -1);
                }
            });
            return;
        }
        if (op1 instanceof IntConstant && ((IntConstant)op1).value == 0) {
            this.emitValue(op2);
            cond.apply((Switch)new AbstractJimpleValueSwitch(){

                public void caseEqExpr(EqExpr expr) {
                    HjJasminClass.this.emit("ifeq " + label, -1);
                }

                public void caseNeExpr(NeExpr expr) {
                    HjJasminClass.this.emit("ifne " + label, -1);
                }

                public void caseLtExpr(LtExpr expr) {
                    HjJasminClass.this.emit("ifgt " + label, -1);
                }

                public void caseLeExpr(LeExpr expr) {
                    HjJasminClass.this.emit("ifge " + label, -1);
                }

                public void caseGtExpr(GtExpr expr) {
                    HjJasminClass.this.emit("iflt " + label, -1);
                }

                public void caseGeExpr(GeExpr expr) {
                    HjJasminClass.this.emit("ifle " + label, -1);
                }
            });
            return;
        }
        this.emitValue(op1);
        this.emitValue(op2);
        cond.apply((Switch)new AbstractJimpleValueSwitch(){

            public void caseEqExpr(EqExpr expr) {
                op1.getType().apply((Switch)new TypeSwitch(){

                    public void caseIntType(IntType t) {
                        HjJasminClass.this.emit("if_icmpeq " + label, -2);
                    }

                    public void caseBooleanType(BooleanType t) {
                        HjJasminClass.this.emit("if_icmpeq " + label, -2);
                    }

                    public void caseShortType(ShortType t) {
                        HjJasminClass.this.emit("if_icmpeq " + label, -2);
                    }

                    public void caseCharType(CharType t) {
                        HjJasminClass.this.emit("if_icmpeq " + label, -2);
                    }

                    public void caseByteType(ByteType t) {
                        HjJasminClass.this.emit("if_icmpeq " + label, -2);
                    }

                    public void caseDoubleType(DoubleType t) {
                        HjJasminClass.this.emit("dcmpg", -3);
                        HjJasminClass.this.emit("ifeq " + label, -1);
                    }

                    public void caseLongType(LongType t) {
                        HjJasminClass.this.emit("lcmp", -3);
                        HjJasminClass.this.emit("ifeq " + label, -1);
                    }

                    public void caseFloatType(FloatType t) {
                        HjJasminClass.this.emit("fcmpg", -1);
                        HjJasminClass.this.emit("ifeq " + label, -1);
                    }

                    public void caseArrayType(ArrayType t) {
                        HjJasminClass.this.emit("if_acmpeq " + label, -2);
                    }

                    public void caseRefType(RefType t) {
                        HjJasminClass.this.emit("if_acmpeq " + label, -2);
                    }

                    public void caseNullType(NullType t) {
                        HjJasminClass.this.emit("if_acmpeq " + label, -2);
                    }

                    public void defaultCase(Type t) {
                        throw new RuntimeException("invalid type");
                    }
                });
            }

            public void caseNeExpr(NeExpr expr) {
                op1.getType().apply((Switch)new TypeSwitch(){

                    public void caseIntType(IntType t) {
                        HjJasminClass.this.emit("if_icmpne " + label, -2);
                    }

                    public void caseBooleanType(BooleanType t) {
                        HjJasminClass.this.emit("if_icmpne " + label, -2);
                    }

                    public void caseShortType(ShortType t) {
                        HjJasminClass.this.emit("if_icmpne " + label, -2);
                    }

                    public void caseCharType(CharType t) {
                        HjJasminClass.this.emit("if_icmpne " + label, -2);
                    }

                    public void caseByteType(ByteType t) {
                        HjJasminClass.this.emit("if_icmpne " + label, -2);
                    }

                    public void caseDoubleType(DoubleType t) {
                        HjJasminClass.this.emit("dcmpg", -3);
                        HjJasminClass.this.emit("ifne " + label, -1);
                    }

                    public void caseLongType(LongType t) {
                        HjJasminClass.this.emit("lcmp", -3);
                        HjJasminClass.this.emit("ifne " + label, -1);
                    }

                    public void caseFloatType(FloatType t) {
                        HjJasminClass.this.emit("fcmpg", -1);
                        HjJasminClass.this.emit("ifne " + label, -1);
                    }

                    public void caseArrayType(ArrayType t) {
                        HjJasminClass.this.emit("if_acmpne " + label, -2);
                    }

                    public void caseRefType(RefType t) {
                        HjJasminClass.this.emit("if_acmpne " + label, -2);
                    }

                    public void caseNullType(NullType t) {
                        HjJasminClass.this.emit("if_acmpne " + label, -2);
                    }

                    public void defaultCase(Type t) {
                        throw new RuntimeException("invalid type for NeExpr: " + t);
                    }
                });
            }

            public void caseLtExpr(LtExpr expr) {
                op1.getType().apply((Switch)new TypeSwitch(){

                    public void caseIntType(IntType t) {
                        HjJasminClass.this.emit("if_icmplt " + label, -2);
                    }

                    public void caseBooleanType(BooleanType t) {
                        HjJasminClass.this.emit("if_icmplt " + label, -2);
                    }

                    public void caseShortType(ShortType t) {
                        HjJasminClass.this.emit("if_icmplt " + label, -2);
                    }

                    public void caseCharType(CharType t) {
                        HjJasminClass.this.emit("if_icmplt " + label, -2);
                    }

                    public void caseByteType(ByteType t) {
                        HjJasminClass.this.emit("if_icmplt " + label, -2);
                    }

                    public void caseDoubleType(DoubleType t) {
                        HjJasminClass.this.emit("dcmpg", -3);
                        HjJasminClass.this.emit("iflt " + label, -1);
                    }

                    public void caseLongType(LongType t) {
                        HjJasminClass.this.emit("lcmp", -3);
                        HjJasminClass.this.emit("iflt " + label, -1);
                    }

                    public void caseFloatType(FloatType t) {
                        HjJasminClass.this.emit("fcmpg", -1);
                        HjJasminClass.this.emit("iflt " + label, -1);
                    }

                    public void defaultCase(Type t) {
                        throw new RuntimeException("invalid type");
                    }
                });
            }

            public void caseLeExpr(LeExpr expr) {
                op1.getType().apply((Switch)new TypeSwitch(){

                    public void caseIntType(IntType t) {
                        HjJasminClass.this.emit("if_icmple " + label, -2);
                    }

                    public void caseBooleanType(BooleanType t) {
                        HjJasminClass.this.emit("if_icmple " + label, -2);
                    }

                    public void caseShortType(ShortType t) {
                        HjJasminClass.this.emit("if_icmple " + label, -2);
                    }

                    public void caseCharType(CharType t) {
                        HjJasminClass.this.emit("if_icmple " + label, -2);
                    }

                    public void caseByteType(ByteType t) {
                        HjJasminClass.this.emit("if_icmple " + label, -2);
                    }

                    public void caseDoubleType(DoubleType t) {
                        HjJasminClass.this.emit("dcmpg", -3);
                        HjJasminClass.this.emit("ifle " + label, -1);
                    }

                    public void caseLongType(LongType t) {
                        HjJasminClass.this.emit("lcmp", -3);
                        HjJasminClass.this.emit("ifle " + label, -1);
                    }

                    public void caseFloatType(FloatType t) {
                        HjJasminClass.this.emit("fcmpg", -1);
                        HjJasminClass.this.emit("ifle " + label, -1);
                    }

                    public void defaultCase(Type t) {
                        throw new RuntimeException("invalid type");
                    }
                });
            }

            public void caseGtExpr(GtExpr expr) {
                op1.getType().apply((Switch)new TypeSwitch(){

                    public void caseIntType(IntType t) {
                        HjJasminClass.this.emit("if_icmpgt " + label, -2);
                    }

                    public void caseBooleanType(BooleanType t) {
                        HjJasminClass.this.emit("if_icmpgt " + label, -2);
                    }

                    public void caseShortType(ShortType t) {
                        HjJasminClass.this.emit("if_icmpgt " + label, -2);
                    }

                    public void caseCharType(CharType t) {
                        HjJasminClass.this.emit("if_icmpgt " + label, -2);
                    }

                    public void caseByteType(ByteType t) {
                        HjJasminClass.this.emit("if_icmpgt " + label, -2);
                    }

                    public void caseDoubleType(DoubleType t) {
                        HjJasminClass.this.emit("dcmpg", -3);
                        HjJasminClass.this.emit("ifgt " + label, -1);
                    }

                    public void caseLongType(LongType t) {
                        HjJasminClass.this.emit("lcmp", -3);
                        HjJasminClass.this.emit("ifgt " + label, -1);
                    }

                    public void caseFloatType(FloatType t) {
                        HjJasminClass.this.emit("fcmpg", -1);
                        HjJasminClass.this.emit("ifgt " + label, -1);
                    }

                    public void defaultCase(Type t) {
                        throw new RuntimeException("invalid type");
                    }
                });
            }

            public void caseGeExpr(GeExpr expr) {
                op1.getType().apply((Switch)new TypeSwitch(){

                    public void caseIntType(IntType t) {
                        HjJasminClass.this.emit("if_icmpge " + label, -2);
                    }

                    public void caseBooleanType(BooleanType t) {
                        HjJasminClass.this.emit("if_icmpge " + label, -2);
                    }

                    public void caseShortType(ShortType t) {
                        HjJasminClass.this.emit("if_icmpge " + label, -2);
                    }

                    public void caseCharType(CharType t) {
                        HjJasminClass.this.emit("if_icmpge " + label, -2);
                    }

                    public void caseByteType(ByteType t) {
                        HjJasminClass.this.emit("if_icmpge " + label, -2);
                    }

                    public void caseDoubleType(DoubleType t) {
                        HjJasminClass.this.emit("dcmpg", -3);
                        HjJasminClass.this.emit("ifge " + label, -1);
                    }

                    public void caseLongType(LongType t) {
                        HjJasminClass.this.emit("lcmp", -3);
                        HjJasminClass.this.emit("ifge " + label, -1);
                    }

                    public void caseFloatType(FloatType t) {
                        HjJasminClass.this.emit("fcmpg", -1);
                        HjJasminClass.this.emit("ifge " + label, -1);
                    }

                    public void defaultCase(Type t) {
                        throw new RuntimeException("invalid type");
                    }
                });
            }
        });
    }

    void emitStmt(Stmt stmt) {
        LineNumberTag lnTag = (LineNumberTag)stmt.getTag("LineNumberTag");
        if (lnTag != null) {
            this.emit(".line " + lnTag.getLineNumber());
        }
        SourceLnPosTag srcLnTag = (SourceLnPosTag)stmt.getTag("SourceLnPosTag");
        if (lnTag == null && srcLnTag != null) {
            this.emit(".line " + srcLnTag.startLn());
        }
        stmt.apply((Switch)new AbstractStmtSwitch(){

            public void caseAssignStmt(AssignStmt s) {
                HjJasminClass.this.emitAssignStmt(s);
            }

            public void caseIdentityStmt(IdentityStmt s) {
                if (s.getRightOp() instanceof CaughtExceptionRef && s.getLeftOp() instanceof Local) {
                    int slot = (Integer)HjJasminClass.this.localToSlot.get(s.getLeftOp());
                    HjJasminClass.this.modifyStackHeight(1);
                    if (slot >= 0 && slot <= 3) {
                        HjJasminClass.this.emit("astore_" + slot, -1);
                    } else {
                        HjJasminClass.this.emit("astore " + slot, -1);
                    }
                }
            }

            public void caseBreakpointStmt(BreakpointStmt s) {
                HjJasminClass.this.emit("breakpoint", 0);
            }

            public void caseInvokeStmt(InvokeStmt s) {
                HjJasminClass.this.emitValue((Value)s.getInvokeExpr());
                Type returnType = s.getInvokeExpr().getMethodRef().returnType();
                if (!returnType.equals(VoidType.v())) {
                    if (AbstractJasminClass.sizeOfType((Type)returnType) == 1) {
                        HjJasminClass.this.emit("pop", -1);
                    } else {
                        HjJasminClass.this.emit("pop2", -2);
                    }
                }
            }

            public void caseEnterMonitorStmt(EnterMonitorStmt s) {
                HjJasminClass.this.emitValue(s.getOp());
                HjJasminClass.this.emit("monitorenter", -1);
            }

            public void caseExitMonitorStmt(ExitMonitorStmt s) {
                HjJasminClass.this.emitValue(s.getOp());
                HjJasminClass.this.emit("monitorexit", -1);
            }

            public void caseGotoStmt(GotoStmt s) {
                if (HjJasminClass.this.isNextGotoAJsr) {
                    HjJasminClass.this.emit("jsr " + HjJasminClass.this.unitToLabel.get(s.getTarget()));
                    HjJasminClass.this.isNextGotoAJsr = false;
                    HjJasminClass.this.subroutineToReturnAddressSlot.put(s.getTarget(), new Integer(HjJasminClass.this.returnAddressSlot));
                } else {
                    HjJasminClass.this.emit("goto " + HjJasminClass.this.unitToLabel.get(s.getTarget()));
                }
            }

            public void caseIfStmt(IfStmt s) {
                HjJasminClass.this.emitIfStmt(s);
            }

            public void caseLookupSwitchStmt(LookupSwitchStmt s) {
                HjJasminClass.this.emitValue(s.getKey());
                HjJasminClass.this.emit("lookupswitch", -1);
                List lookupValues = s.getLookupValues();
                List targets = s.getTargets();
                for (int i = 0; i < lookupValues.size(); ++i) {
                    HjJasminClass.this.emit("  " + lookupValues.get(i) + " : " + HjJasminClass.this.unitToLabel.get(targets.get(i)));
                }
                HjJasminClass.this.emit("  default : " + HjJasminClass.this.unitToLabel.get(s.getDefaultTarget()));
            }

            public void caseNopStmt(NopStmt s) {
                HjJasminClass.this.emit("nop", 0);
            }

            public void caseRetStmt(RetStmt s) {
                HjJasminClass.this.emit("ret " + HjJasminClass.this.localToSlot.get(s.getStmtAddress()), 0);
            }

            public void caseReturnStmt(ReturnStmt s) {
                HjJasminClass.this.emitValue(s.getOp());
                Value returnValue = s.getOp();
                returnValue.getType().apply((Switch)new TypeSwitch(){

                    public void defaultCase(Type t) {
                        throw new RuntimeException("invalid return type " + t.toString());
                    }

                    public void caseDoubleType(DoubleType t) {
                        HjJasminClass.this.emit("dreturn", -2);
                    }

                    public void caseFloatType(FloatType t) {
                        HjJasminClass.this.emit("freturn", -1);
                    }

                    public void caseIntType(IntType t) {
                        HjJasminClass.this.emit("ireturn", -1);
                    }

                    public void caseByteType(ByteType t) {
                        HjJasminClass.this.emit("ireturn", -1);
                    }

                    public void caseShortType(ShortType t) {
                        HjJasminClass.this.emit("ireturn", -1);
                    }

                    public void caseCharType(CharType t) {
                        HjJasminClass.this.emit("ireturn", -1);
                    }

                    public void caseBooleanType(BooleanType t) {
                        HjJasminClass.this.emit("ireturn", -1);
                    }

                    public void caseLongType(LongType t) {
                        HjJasminClass.this.emit("lreturn", -2);
                    }

                    public void caseArrayType(ArrayType t) {
                        HjJasminClass.this.emit("areturn", -1);
                    }

                    public void caseRefType(RefType t) {
                        HjJasminClass.this.emit("areturn", -1);
                    }

                    public void caseNullType(NullType t) {
                        HjJasminClass.this.emit("areturn", -1);
                    }
                });
            }

            public void caseReturnVoidStmt(ReturnVoidStmt s) {
                HjJasminClass.this.emit("return", 0);
            }

            public void caseTableSwitchStmt(TableSwitchStmt s) {
                HjJasminClass.this.emitValue(s.getKey());
                HjJasminClass.this.emit("tableswitch " + s.getLowIndex() + " ; high = " + s.getHighIndex(), -1);
                List targets = s.getTargets();
                for (int i = 0; i < targets.size(); ++i) {
                    HjJasminClass.this.emit("  " + HjJasminClass.this.unitToLabel.get(targets.get(i)));
                }
                HjJasminClass.this.emit("default : " + HjJasminClass.this.unitToLabel.get(s.getDefaultTarget()));
            }

            public void caseThrowStmt(ThrowStmt s) {
                HjJasminClass.this.emitValue(s.getOp());
                HjJasminClass.this.emit("athrow", -1);
            }
        });
    }

    void emitLocal(Local v) {
        final int slot = (Integer)this.localToSlot.get(v);
        final Local vAlias = v;
        v.getType().apply((Switch)new TypeSwitch(){

            public void caseArrayType(ArrayType t) {
                if (slot >= 0 && slot <= 3) {
                    HjJasminClass.this.emit("aload_" + slot, 1);
                } else {
                    HjJasminClass.this.emit("aload " + slot, 1);
                }
            }

            public void defaultCase(Type t) {
                throw new RuntimeException("invalid local type to load" + t);
            }

            public void caseDoubleType(DoubleType t) {
                if (slot >= 0 && slot <= 3) {
                    HjJasminClass.this.emit("dload_" + slot, 2);
                } else {
                    HjJasminClass.this.emit("dload " + slot, 2);
                }
            }

            public void caseFloatType(FloatType t) {
                if (slot >= 0 && slot <= 3) {
                    HjJasminClass.this.emit("fload_" + slot, 1);
                } else {
                    HjJasminClass.this.emit("fload " + slot, 1);
                }
            }

            public void caseBooleanType(BooleanType t) {
                this.handleIntegerType((IntegerType)t);
            }

            public void caseByteType(ByteType t) {
                this.handleIntegerType((IntegerType)t);
            }

            public void caseShortType(ShortType t) {
                this.handleIntegerType((IntegerType)t);
            }

            public void caseCharType(CharType t) {
                this.handleIntegerType((IntegerType)t);
            }

            public void caseIntType(IntType t) {
                this.handleIntegerType((IntegerType)t);
            }

            public void handleIntegerType(IntegerType t) {
                if (vAlias.equals(HjJasminClass.this.plusPlusHolder)) {
                    switch (HjJasminClass.this.plusPlusState) {
                        case 0: {
                            HjJasminClass.this.plusPlusState = 1;
                            HjJasminClass.this.emitStmt(HjJasminClass.this.plusPlusIncrementer);
                            int diff = HjJasminClass.this.plusPlusHeight - HjJasminClass.this.currentStackHeight + 1;
                            if (diff > 0) {
                                HjJasminClass.this.code.set(HjJasminClass.this.plusPlusPlace, "    dup_x" + diff);
                            }
                            HjJasminClass.this.plusPlusHolder = null;
                            return;
                        }
                        case 1: {
                            HjJasminClass.this.plusPlusHeight = HjJasminClass.this.currentStackHeight;
                            HjJasminClass.this.plusPlusHolder = null;
                            HjJasminClass.this.emitValue(HjJasminClass.this.plusPlusValue);
                            HjJasminClass.this.plusPlusPlace = HjJasminClass.this.code.size();
                            HjJasminClass.this.emit("dup", 1);
                            return;
                        }
                        case 10: {
                            HjJasminClass.this.plusPlusState = 11;
                            HjJasminClass.this.plusPlusHolder = (Local)HjJasminClass.this.plusPlusValue;
                            HjJasminClass.this.emitStmt(HjJasminClass.this.plusPlusIncrementer);
                            int diff = HjJasminClass.this.plusPlusHeight - HjJasminClass.this.currentStackHeight + 1;
                            if (diff > 0 && HjJasminClass.this.plusPlusState == 11) {
                                HjJasminClass.this.code.set(HjJasminClass.this.plusPlusPlace, "    dup_x" + diff);
                            }
                            HjJasminClass.this.plusPlusHolder = null;
                            return;
                        }
                        case 11: {
                            HjJasminClass.this.plusPlusHeight = HjJasminClass.this.currentStackHeight;
                            HjJasminClass.this.plusPlusHolder = null;
                            HjJasminClass.this.emitValue(HjJasminClass.this.plusPlusValue);
                            if (HjJasminClass.this.plusPlusState != 11) {
                                HjJasminClass.this.emit("dup", 1);
                            }
                            HjJasminClass.this.plusPlusPlace = HjJasminClass.this.code.size();
                            return;
                        }
                    }
                }
                if (slot >= 0 && slot <= 3) {
                    HjJasminClass.this.emit("iload_" + slot, 1);
                } else {
                    HjJasminClass.this.emit("iload " + slot, 1);
                }
            }

            public void caseLongType(LongType t) {
                if (slot >= 0 && slot <= 3) {
                    HjJasminClass.this.emit("lload_" + slot, 2);
                } else {
                    HjJasminClass.this.emit("lload " + slot, 2);
                }
            }

            public void caseRefType(RefType t) {
                if (slot >= 0 && slot <= 3) {
                    HjJasminClass.this.emit("aload_" + slot, 1);
                } else {
                    HjJasminClass.this.emit("aload " + slot, 1);
                }
            }

            public void caseNullType(NullType t) {
                if (slot >= 0 && slot <= 3) {
                    HjJasminClass.this.emit("aload_" + slot, 1);
                } else {
                    HjJasminClass.this.emit("aload " + slot, 1);
                }
            }
        });
    }

    void emitValue(Value value) {
        value.apply((Switch)new AbstractGrimpValueSwitch(){

            public void caseAddExpr(AddExpr v) {
                HjJasminClass.this.emitValue(v.getOp1());
                HjJasminClass.this.emitValue(v.getOp2());
                v.getType().apply((Switch)new TypeSwitch(){

                    private void handleIntCase() {
                        HjJasminClass.this.emit("iadd", -1);
                    }

                    public void caseIntType(IntType t) {
                        this.handleIntCase();
                    }

                    public void caseBooleanType(BooleanType t) {
                        this.handleIntCase();
                    }

                    public void caseShortType(ShortType t) {
                        this.handleIntCase();
                    }

                    public void caseCharType(CharType t) {
                        this.handleIntCase();
                    }

                    public void caseByteType(ByteType t) {
                        this.handleIntCase();
                    }

                    public void caseLongType(LongType t) {
                        HjJasminClass.this.emit("ladd", -2);
                    }

                    public void caseDoubleType(DoubleType t) {
                        HjJasminClass.this.emit("dadd", -2);
                    }

                    public void caseFloatType(FloatType t) {
                        HjJasminClass.this.emit("fadd", -1);
                    }

                    public void defaultCase(Type t) {
                        throw new RuntimeException("Invalid argument type for add");
                    }
                });
            }

            public void caseAndExpr(AndExpr v) {
                HjJasminClass.this.emitValue(v.getOp1());
                HjJasminClass.this.emitValue(v.getOp2());
                v.getType().apply((Switch)new TypeSwitch(){

                    private void handleIntCase() {
                        HjJasminClass.this.emit("iand", -1);
                    }

                    public void caseIntType(IntType t) {
                        this.handleIntCase();
                    }

                    public void caseBooleanType(BooleanType t) {
                        this.handleIntCase();
                    }

                    public void caseShortType(ShortType t) {
                        this.handleIntCase();
                    }

                    public void caseCharType(CharType t) {
                        this.handleIntCase();
                    }

                    public void caseByteType(ByteType t) {
                        this.handleIntCase();
                    }

                    public void caseLongType(LongType t) {
                        HjJasminClass.this.emit("land", -2);
                    }

                    public void defaultCase(Type t) {
                        throw new RuntimeException("Invalid argument type for and");
                    }
                });
            }

            public void caseArrayRef(ArrayRef v) {
                HjJasminClass.this.emitValue(v.getBase());
                HjJasminClass.this.emitValue(v.getIndex());
                v.getType().apply((Switch)new TypeSwitch(){

                    public void caseArrayType(ArrayType ty) {
                        HjJasminClass.this.emit("aaload", -1);
                    }

                    public void caseBooleanType(BooleanType ty) {
                        HjJasminClass.this.emit("baload", -1);
                    }

                    public void caseByteType(ByteType ty) {
                        HjJasminClass.this.emit("baload", -1);
                    }

                    public void caseCharType(CharType ty) {
                        HjJasminClass.this.emit("caload", -1);
                    }

                    public void defaultCase(Type ty) {
                        throw new RuntimeException("invalid base type");
                    }

                    public void caseDoubleType(DoubleType ty) {
                        HjJasminClass.this.emit("daload", 0);
                    }

                    public void caseFloatType(FloatType ty) {
                        HjJasminClass.this.emit("faload", -1);
                    }

                    public void caseIntType(IntType ty) {
                        HjJasminClass.this.emit("iaload", -1);
                    }

                    public void caseLongType(LongType ty) {
                        HjJasminClass.this.emit("laload", 0);
                    }

                    public void caseNullType(NullType ty) {
                        HjJasminClass.this.emit("aaload", -1);
                    }

                    public void caseRefType(RefType ty) {
                        HjJasminClass.this.emit("aaload", -1);
                    }

                    public void caseShortType(ShortType ty) {
                        HjJasminClass.this.emit("saload", -1);
                    }
                });
            }

            public void caseCastExpr(final CastExpr v) {
                final Type toType = v.getCastType();
                final Type fromType = v.getOp().getType();
                HjJasminClass.this.emitValue(v.getOp());
                if (toType instanceof RefType) {
                    HjJasminClass.this.emit("checkcast " + AbstractJasminClass.slashify((String)toType.toString()), 0);
                } else if (toType instanceof ArrayType) {
                    HjJasminClass.this.emit("checkcast " + AbstractJasminClass.jasminDescriptorOf((Type)toType), 0);
                } else {
                    fromType.apply((Switch)new TypeSwitch(){

                        public void defaultCase(Type ty) {
                            throw new RuntimeException("invalid fromType " + fromType);
                        }

                        public void caseDoubleType(DoubleType ty) {
                            if (toType.equals(IntType.v())) {
                                HjJasminClass.this.emit("d2i", -1);
                            } else if (toType.equals(LongType.v())) {
                                HjJasminClass.this.emit("d2l", 0);
                            } else if (toType.equals(FloatType.v())) {
                                HjJasminClass.this.emit("d2f", -1);
                            } else {
                                throw new RuntimeException("invalid toType from double: " + toType);
                            }
                        }

                        public void caseFloatType(FloatType ty) {
                            if (toType.equals(IntType.v())) {
                                HjJasminClass.this.emit("f2i", 0);
                            } else if (toType.equals(LongType.v())) {
                                HjJasminClass.this.emit("f2l", 1);
                            } else if (toType.equals(DoubleType.v())) {
                                HjJasminClass.this.emit("f2d", 1);
                            } else {
                                throw new RuntimeException("invalid toType from float: " + toType);
                            }
                        }

                        public void caseIntType(IntType ty) {
                            this.emitIntToTypeCast();
                        }

                        public void caseBooleanType(BooleanType ty) {
                            this.emitIntToTypeCast();
                        }

                        public void caseByteType(ByteType ty) {
                            this.emitIntToTypeCast();
                        }

                        public void caseCharType(CharType ty) {
                            this.emitIntToTypeCast();
                        }

                        public void caseShortType(ShortType ty) {
                            this.emitIntToTypeCast();
                        }

                        private void emitIntToTypeCast() {
                            if (toType.equals(ByteType.v())) {
                                HjJasminClass.this.emit("i2b", 0);
                            } else if (toType.equals(CharType.v())) {
                                HjJasminClass.this.emit("i2c", 0);
                            } else if (toType.equals(ShortType.v())) {
                                HjJasminClass.this.emit("i2s", 0);
                            } else if (toType.equals(FloatType.v())) {
                                HjJasminClass.this.emit("i2f", 0);
                            } else if (toType.equals(LongType.v())) {
                                HjJasminClass.this.emit("i2l", 1);
                            } else if (toType.equals(DoubleType.v())) {
                                HjJasminClass.this.emit("i2d", 1);
                            } else if (!toType.equals(IntType.v()) && !toType.equals(BooleanType.v())) {
                                throw new RuntimeException("invalid toType from int: " + toType + " " + v.toString());
                            }
                        }

                        public void caseLongType(LongType ty) {
                            if (toType.equals(IntType.v())) {
                                HjJasminClass.this.emit("l2i", -1);
                            } else if (toType.equals(FloatType.v())) {
                                HjJasminClass.this.emit("l2f", -1);
                            } else if (toType.equals(DoubleType.v())) {
                                HjJasminClass.this.emit("l2d", 0);
                            } else if (toType.equals(ByteType.v())) {
                                HjJasminClass.this.emit("l2i", -1);
                                this.emitIntToTypeCast();
                            } else if (toType.equals(ShortType.v())) {
                                HjJasminClass.this.emit("l2i", -1);
                                this.emitIntToTypeCast();
                            } else if (toType.equals(CharType.v())) {
                                HjJasminClass.this.emit("l2i", -1);
                                this.emitIntToTypeCast();
                            } else if (toType.equals(BooleanType.v())) {
                                HjJasminClass.this.emit("l2i", -1);
                                this.emitIntToTypeCast();
                            } else {
                                throw new RuntimeException("invalid toType from long: " + toType);
                            }
                        }
                    });
                }
            }

            public void caseCmpExpr(CmpExpr v) {
                HjJasminClass.this.emitValue(v.getOp1());
                HjJasminClass.this.emitValue(v.getOp2());
                HjJasminClass.this.emit("lcmp", -3);
            }

            public void caseCmpgExpr(CmpgExpr v) {
                HjJasminClass.this.emitValue(v.getOp1());
                HjJasminClass.this.emitValue(v.getOp2());
                if (v.getOp1().getType().equals(FloatType.v())) {
                    HjJasminClass.this.emit("fcmpg", -1);
                } else {
                    HjJasminClass.this.emit("dcmpg", -3);
                }
            }

            public void caseCmplExpr(CmplExpr v) {
                HjJasminClass.this.emitValue(v.getOp1());
                HjJasminClass.this.emitValue(v.getOp2());
                if (v.getOp1().getType().equals(FloatType.v())) {
                    HjJasminClass.this.emit("fcmpl", -1);
                } else {
                    HjJasminClass.this.emit("dcmpl", -3);
                }
            }

            public void caseDivExpr(DivExpr v) {
                HjJasminClass.this.emitValue(v.getOp1());
                HjJasminClass.this.emitValue(v.getOp2());
                v.getType().apply((Switch)new TypeSwitch(){

                    private void handleIntCase() {
                        HjJasminClass.this.emit("idiv", -1);
                    }

                    public void caseIntType(IntType t) {
                        this.handleIntCase();
                    }

                    public void caseBooleanType(BooleanType t) {
                        this.handleIntCase();
                    }

                    public void caseShortType(ShortType t) {
                        this.handleIntCase();
                    }

                    public void caseCharType(CharType t) {
                        this.handleIntCase();
                    }

                    public void caseByteType(ByteType t) {
                        this.handleIntCase();
                    }

                    public void caseLongType(LongType t) {
                        HjJasminClass.this.emit("ldiv", -2);
                    }

                    public void caseDoubleType(DoubleType t) {
                        HjJasminClass.this.emit("ddiv", -2);
                    }

                    public void caseFloatType(FloatType t) {
                        HjJasminClass.this.emit("fdiv", -1);
                    }

                    public void defaultCase(Type t) {
                        throw new RuntimeException("Invalid argument type for div");
                    }
                });
            }

            public void caseDoubleConstant(DoubleConstant v) {
                if (v.value == 0.0 && 1.0 / v.value > 0.0) {
                    HjJasminClass.this.emit("dconst_0", 2);
                } else if (v.value == 1.0) {
                    HjJasminClass.this.emit("dconst_1", 2);
                } else {
                    String s = v.toString();
                    if (s.equals("#Infinity")) {
                        s = "+DoubleInfinity";
                    }
                    if (s.equals("#-Infinity")) {
                        s = "-DoubleInfinity";
                    }
                    if (s.equals("#NaN")) {
                        s = "+DoubleNaN";
                    }
                    HjJasminClass.this.emit("ldc2_w " + s, 2);
                }
            }

            public void caseFloatConstant(FloatConstant v) {
                if (v.value == 0.0f && 1.0f / v.value > 0.0f) {
                    HjJasminClass.this.emit("fconst_0", 1);
                } else if (v.value == 1.0f) {
                    HjJasminClass.this.emit("fconst_1", 1);
                } else if (v.value == 2.0f) {
                    HjJasminClass.this.emit("fconst_2", 1);
                } else {
                    String s = v.toString();
                    if (s.equals("#InfinityF")) {
                        s = "+FloatInfinity";
                    }
                    if (s.equals("#-InfinityF")) {
                        s = "-FloatInfinity";
                    }
                    if (s.equals("#NaNF")) {
                        s = "+FloatNaN";
                    }
                    HjJasminClass.this.emit("ldc " + s, 1);
                }
            }

            public void caseInstanceFieldRef(InstanceFieldRef v) {
                HjJasminClass.this.emitValue(v.getBase());
                HjJasminClass.this.emit("getfield " + AbstractJasminClass.slashify((String)v.getFieldRef().declaringClass().getName()) + "/" + v.getFieldRef().name() + " " + AbstractJasminClass.jasminDescriptorOf((Type)v.getFieldRef().type()), -1 + AbstractJasminClass.sizeOfType((Type)v.getFieldRef().type()));
            }

            public void caseInstanceOfExpr(InstanceOfExpr v) {
                HjJasminClass.this.emitValue(v.getOp());
                Type checkType = v.getCheckType();
                if (checkType instanceof RefType) {
                    HjJasminClass.this.emit("instanceof " + AbstractJasminClass.slashify((String)checkType.toString()), 0);
                } else if (checkType instanceof ArrayType) {
                    HjJasminClass.this.emit("instanceof " + AbstractJasminClass.jasminDescriptorOf((Type)checkType), 0);
                }
            }

            public void caseIntConstant(IntConstant v) {
                if (v.value == -1) {
                    HjJasminClass.this.emit("iconst_m1", 1);
                } else if (v.value >= 0 && v.value <= 5) {
                    HjJasminClass.this.emit("iconst_" + v.value, 1);
                } else if (v.value >= -128 && v.value <= 127) {
                    HjJasminClass.this.emit("bipush " + v.value, 1);
                } else if (v.value >= Short.MIN_VALUE && v.value <= Short.MAX_VALUE) {
                    HjJasminClass.this.emit("sipush " + v.value, 1);
                } else {
                    HjJasminClass.this.emit("ldc " + v.toString(), 1);
                }
            }

            public void caseInterfaceInvokeExpr(InterfaceInvokeExpr v) {
                SootMethodRef m = v.getMethodRef();
                HjJasminClass.this.emitValue(v.getBase());
                for (int i = 0; i < m.parameterTypes().size(); ++i) {
                    HjJasminClass.this.emitValue(v.getArg(i));
                }
                HjJasminClass.this.emit("invokeinterface " + AbstractJasminClass.slashify((String)m.declaringClass().getName()) + "/" + m.name() + AbstractJasminClass.jasminDescriptorOf((SootMethodRef)m) + " " + (AbstractJasminClass.argCountOf((SootMethodRef)m) + 1), -(AbstractJasminClass.argCountOf((SootMethodRef)m) + 1) + AbstractJasminClass.sizeOfType((Type)m.returnType()));
            }

            public void caseLengthExpr(LengthExpr v) {
                HjJasminClass.this.emitValue(v.getOp());
                HjJasminClass.this.emit("arraylength", 0);
            }

            public void caseLocal(Local v) {
                HjJasminClass.this.emitLocal(v);
            }

            public void caseLongConstant(LongConstant v) {
                if (v.value == 0L) {
                    HjJasminClass.this.emit("lconst_0", 2);
                } else if (v.value == 1L) {
                    HjJasminClass.this.emit("lconst_1", 2);
                } else {
                    HjJasminClass.this.emit("ldc2_w " + v.toString(), 2);
                }
            }

            public void caseMulExpr(MulExpr v) {
                HjJasminClass.this.emitValue(v.getOp1());
                HjJasminClass.this.emitValue(v.getOp2());
                v.getType().apply((Switch)new TypeSwitch(){

                    private void handleIntCase() {
                        HjJasminClass.this.emit("imul", -1);
                    }

                    public void caseIntType(IntType t) {
                        this.handleIntCase();
                    }

                    public void caseBooleanType(BooleanType t) {
                        this.handleIntCase();
                    }

                    public void caseShortType(ShortType t) {
                        this.handleIntCase();
                    }

                    public void caseCharType(CharType t) {
                        this.handleIntCase();
                    }

                    public void caseByteType(ByteType t) {
                        this.handleIntCase();
                    }

                    public void caseLongType(LongType t) {
                        HjJasminClass.this.emit("lmul", -2);
                    }

                    public void caseDoubleType(DoubleType t) {
                        HjJasminClass.this.emit("dmul", -2);
                    }

                    public void caseFloatType(FloatType t) {
                        HjJasminClass.this.emit("fmul", -1);
                    }

                    public void defaultCase(Type t) {
                        throw new RuntimeException("Invalid argument type for mul");
                    }
                });
            }

            public void caseLtExpr(LtExpr v) {
                HjJasminClass.this.emitValue(v.getOp1());
                HjJasminClass.this.emitValue(v.getOp2());
                v.getOp1().getType().apply((Switch)new TypeSwitch(){

                    public void caseDoubleType(DoubleType t) {
                        HjJasminClass.this.emit("dcmpg", -3);
                        HjJasminClass.this.emitBooleanBranch("iflt");
                    }

                    public void caseFloatType(FloatType t) {
                        HjJasminClass.this.emit("fcmpg", -1);
                        HjJasminClass.this.emitBooleanBranch("iflt");
                    }

                    private void handleIntCase() {
                        HjJasminClass.this.emit("if_icmplt", -2);
                    }

                    public void caseIntType(IntType t) {
                        this.handleIntCase();
                    }

                    public void caseBooleanType(BooleanType t) {
                        this.handleIntCase();
                    }

                    public void caseShortType(ShortType t) {
                        this.handleIntCase();
                    }

                    public void caseCharType(CharType t) {
                        this.handleIntCase();
                    }

                    public void caseByteType(ByteType t) {
                        this.handleIntCase();
                    }

                    public void caseLongType(LongType t) {
                        HjJasminClass.this.emit("lcmp", -3);
                        HjJasminClass.this.emitBooleanBranch("iflt");
                    }

                    public void defaultCase(Type t) {
                        throw new RuntimeException("invalid type");
                    }
                });
            }

            public void caseLeExpr(LeExpr v) {
                HjJasminClass.this.emitValue(v.getOp1());
                HjJasminClass.this.emitValue(v.getOp2());
                v.getOp1().getType().apply((Switch)new TypeSwitch(){

                    public void caseDoubleType(DoubleType t) {
                        HjJasminClass.this.emit("dcmpg", -3);
                        HjJasminClass.this.emitBooleanBranch("ifle");
                    }

                    public void caseFloatType(FloatType t) {
                        HjJasminClass.this.emit("fcmpg", -1);
                        HjJasminClass.this.emitBooleanBranch("ifle");
                    }

                    private void handleIntCase() {
                        HjJasminClass.this.emit("if_icmple", -2);
                    }

                    public void caseIntType(IntType t) {
                        this.handleIntCase();
                    }

                    public void caseBooleanType(BooleanType t) {
                        this.handleIntCase();
                    }

                    public void caseShortType(ShortType t) {
                        this.handleIntCase();
                    }

                    public void caseCharType(CharType t) {
                        this.handleIntCase();
                    }

                    public void caseByteType(ByteType t) {
                        this.handleIntCase();
                    }

                    public void caseLongType(LongType t) {
                        HjJasminClass.this.emit("lcmp", -3);
                        HjJasminClass.this.emitBooleanBranch("ifle");
                    }

                    public void defaultCase(Type t) {
                        throw new RuntimeException("invalid type");
                    }
                });
            }

            public void caseGtExpr(GtExpr v) {
                HjJasminClass.this.emitValue(v.getOp1());
                HjJasminClass.this.emitValue(v.getOp2());
                v.getOp1().getType().apply((Switch)new TypeSwitch(){

                    public void caseDoubleType(DoubleType t) {
                        HjJasminClass.this.emit("dcmpg", -3);
                        HjJasminClass.this.emitBooleanBranch("ifgt");
                    }

                    public void caseFloatType(FloatType t) {
                        HjJasminClass.this.emit("fcmpg", -1);
                        HjJasminClass.this.emitBooleanBranch("ifgt");
                    }

                    private void handleIntCase() {
                        HjJasminClass.this.emit("if_icmpgt", -2);
                    }

                    public void caseIntType(IntType t) {
                        this.handleIntCase();
                    }

                    public void caseBooleanType(BooleanType t) {
                        this.handleIntCase();
                    }

                    public void caseShortType(ShortType t) {
                        this.handleIntCase();
                    }

                    public void caseCharType(CharType t) {
                        this.handleIntCase();
                    }

                    public void caseByteType(ByteType t) {
                        this.handleIntCase();
                    }

                    public void caseLongType(LongType t) {
                        HjJasminClass.this.emit("lcmp", -3);
                        HjJasminClass.this.emitBooleanBranch("ifgt");
                    }

                    public void defaultCase(Type t) {
                        throw new RuntimeException("invalid type");
                    }
                });
            }

            public void caseGeExpr(GeExpr v) {
                HjJasminClass.this.emitValue(v.getOp1());
                HjJasminClass.this.emitValue(v.getOp2());
                v.getOp1().getType().apply((Switch)new TypeSwitch(){

                    public void caseDoubleType(DoubleType t) {
                        HjJasminClass.this.emit("dcmpg", -3);
                        HjJasminClass.this.emitBooleanBranch("ifge");
                    }

                    public void caseFloatType(FloatType t) {
                        HjJasminClass.this.emit("fcmpg", -1);
                        HjJasminClass.this.emitBooleanBranch("ifge");
                    }

                    private void handleIntCase() {
                        HjJasminClass.this.emit("if_icmpge", -2);
                    }

                    public void caseIntType(IntType t) {
                        this.handleIntCase();
                    }

                    public void caseBooleanType(BooleanType t) {
                        this.handleIntCase();
                    }

                    public void caseShortType(ShortType t) {
                        this.handleIntCase();
                    }

                    public void caseCharType(CharType t) {
                        this.handleIntCase();
                    }

                    public void caseByteType(ByteType t) {
                        this.handleIntCase();
                    }

                    public void caseLongType(LongType t) {
                        HjJasminClass.this.emit("lcmp", -3);
                        HjJasminClass.this.emitBooleanBranch("ifge");
                    }

                    public void defaultCase(Type t) {
                        throw new RuntimeException("invalid type");
                    }
                });
            }

            public void caseNeExpr(NeExpr v) {
                HjJasminClass.this.emitValue(v.getOp1());
                HjJasminClass.this.emitValue(v.getOp2());
                v.getOp1().getType().apply((Switch)new TypeSwitch(){

                    public void caseDoubleType(DoubleType t) {
                        HjJasminClass.this.emit("dcmpg", -3);
                        HjJasminClass.this.emit("iconst_0", 1);
                        HjJasminClass.this.emitBooleanBranch("if_icmpne");
                    }

                    public void caseFloatType(FloatType t) {
                        HjJasminClass.this.emit("fcmpg", -1);
                        HjJasminClass.this.emit("iconst_0", 1);
                        HjJasminClass.this.emitBooleanBranch("if_icmpne");
                    }

                    private void handleIntCase() {
                        HjJasminClass.this.emit("if_icmpne", -2);
                    }

                    public void caseIntType(IntType t) {
                        this.handleIntCase();
                    }

                    public void caseBooleanType(BooleanType t) {
                        this.handleIntCase();
                    }

                    public void caseShortType(ShortType t) {
                        this.handleIntCase();
                    }

                    public void caseCharType(CharType t) {
                        this.handleIntCase();
                    }

                    public void caseByteType(ByteType t) {
                        this.handleIntCase();
                    }

                    public void caseLongType(LongType t) {
                        HjJasminClass.this.emit("lcmp", -3);
                        HjJasminClass.this.emit("iconst_0", 1);
                        HjJasminClass.this.emitBooleanBranch("if_icmpne");
                    }

                    public void caseArrayType(ArrayType t) {
                        HjJasminClass.this.emitBooleanBranch("if_acmpne");
                    }

                    public void caseRefType(RefType t) {
                        HjJasminClass.this.emitBooleanBranch("if_acmpne");
                    }

                    public void defaultCase(Type t) {
                        throw new RuntimeException("invalid type");
                    }
                });
            }

            public void caseEqExpr(EqExpr v) {
                HjJasminClass.this.emitValue(v.getOp1());
                HjJasminClass.this.emitValue(v.getOp2());
                v.getOp1().getType().apply((Switch)new TypeSwitch(){

                    public void caseDoubleType(DoubleType t) {
                        HjJasminClass.this.emit("dcmpg", -3);
                        HjJasminClass.this.emit("iconst_0", 1);
                        HjJasminClass.this.emitBooleanBranch("if_icmpeq");
                    }

                    public void caseFloatType(FloatType t) {
                        HjJasminClass.this.emit("fcmpg", -3);
                        HjJasminClass.this.emit("iconst_0", 1);
                        HjJasminClass.this.emitBooleanBranch("if_icmpeq");
                    }

                    private void handleIntCase() {
                        HjJasminClass.this.emit("if_icmpeq", -2);
                    }

                    public void caseIntType(IntType t) {
                        this.handleIntCase();
                    }

                    public void caseBooleanType(BooleanType t) {
                        this.handleIntCase();
                    }

                    public void caseShortType(ShortType t) {
                        this.handleIntCase();
                    }

                    public void caseCharType(CharType t) {
                        this.handleIntCase();
                    }

                    public void caseByteType(ByteType t) {
                        this.handleIntCase();
                    }

                    public void caseLongType(LongType t) {
                        HjJasminClass.this.emit("lcmp", -3);
                        HjJasminClass.this.emit("iconst_0", 1);
                        HjJasminClass.this.emitBooleanBranch("if_icmpeq");
                    }

                    public void caseArrayType(ArrayType t) {
                        HjJasminClass.this.emitBooleanBranch("if_acmpeq");
                    }

                    public void defaultCase(Type t) {
                        throw new RuntimeException("invalid type");
                    }
                });
            }

            public void caseNegExpr(final NegExpr v) {
                HjJasminClass.this.emitValue(v.getOp());
                v.getType().apply((Switch)new TypeSwitch(){

                    private void handleIntCase() {
                        HjJasminClass.this.emit("ineg", 0);
                    }

                    public void caseIntType(IntType t) {
                        this.handleIntCase();
                    }

                    public void caseBooleanType(BooleanType t) {
                        this.handleIntCase();
                    }

                    public void caseShortType(ShortType t) {
                        this.handleIntCase();
                    }

                    public void caseCharType(CharType t) {
                        this.handleIntCase();
                    }

                    public void caseByteType(ByteType t) {
                        this.handleIntCase();
                    }

                    public void caseLongType(LongType t) {
                        HjJasminClass.this.emit("lneg", 0);
                    }

                    public void caseDoubleType(DoubleType t) {
                        HjJasminClass.this.emit("dneg", 0);
                    }

                    public void caseFloatType(FloatType t) {
                        HjJasminClass.this.emit("fneg", 0);
                    }

                    public void defaultCase(Type t) {
                        throw new RuntimeException("Invalid argument type for neg: " + t + ": " + v);
                    }
                });
            }

            public void caseNewArrayExpr(NewArrayExpr v) {
                Value size = v.getSize();
                HjJasminClass.this.emitValue(size);
                if (v.getBaseType() instanceof RefType) {
                    HjJasminClass.this.emit("anewarray " + AbstractJasminClass.slashify((String)v.getBaseType().toString()), 0);
                } else if (v.getBaseType() instanceof ArrayType) {
                    HjJasminClass.this.emit("anewarray " + AbstractJasminClass.jasminDescriptorOf((Type)v.getBaseType()), 0);
                } else {
                    HjJasminClass.this.emit("newarray " + v.getBaseType().toString(), 0);
                }
            }

            public void caseNewMultiArrayExpr(NewMultiArrayExpr v) {
                List sizes = v.getSizes();
                for (int i = 0; i < sizes.size(); ++i) {
                    HjJasminClass.this.emitValue((Value)sizes.get(i));
                }
                HjJasminClass.this.emit("multianewarray " + AbstractJasminClass.jasminDescriptorOf((Type)v.getBaseType()) + " " + sizes.size(), -sizes.size() + 1);
            }

            public void caseNewExpr(NewExpr v) {
                HjJasminClass.this.emit("new " + AbstractJasminClass.slashify((String)v.getBaseType().toString()), 1);
            }

            public void caseNewInvokeExpr(NewInvokeExpr v) {
                HjJasminClass.this.emit("new " + AbstractJasminClass.slashify((String)v.getBaseType().toString()), 1);
                HjJasminClass.this.emit("dup", 1);
                SootMethodRef m = v.getMethodRef();
                for (int i = 0; i < m.parameterTypes().size(); ++i) {
                    HjJasminClass.this.emitValue(v.getArg(i));
                }
                HjJasminClass.this.emit("invokespecial " + AbstractJasminClass.slashify((String)m.declaringClass().getName()) + "/" + m.name() + AbstractJasminClass.jasminDescriptorOf((SootMethodRef)m), -(AbstractJasminClass.argCountOf((SootMethodRef)m) + 1) + AbstractJasminClass.sizeOfType((Type)m.returnType()));
            }

            public void caseNullConstant(NullConstant v) {
                HjJasminClass.this.emit("aconst_null", 1);
            }

            public void caseOrExpr(OrExpr v) {
                HjJasminClass.this.emitValue(v.getOp1());
                HjJasminClass.this.emitValue(v.getOp2());
                v.getType().apply((Switch)new TypeSwitch(){

                    private void handleIntCase() {
                        HjJasminClass.this.emit("ior", -1);
                    }

                    public void caseIntType(IntType t) {
                        this.handleIntCase();
                    }

                    public void caseBooleanType(BooleanType t) {
                        this.handleIntCase();
                    }

                    public void caseShortType(ShortType t) {
                        this.handleIntCase();
                    }

                    public void caseCharType(CharType t) {
                        this.handleIntCase();
                    }

                    public void caseByteType(ByteType t) {
                        this.handleIntCase();
                    }

                    public void caseLongType(LongType t) {
                        HjJasminClass.this.emit("lor", -2);
                    }

                    public void defaultCase(Type t) {
                        throw new RuntimeException("Invalid argument type for or");
                    }
                });
            }

            public void caseRemExpr(RemExpr v) {
                HjJasminClass.this.emitValue(v.getOp1());
                HjJasminClass.this.emitValue(v.getOp2());
                v.getType().apply((Switch)new TypeSwitch(){

                    private void handleIntCase() {
                        HjJasminClass.this.emit("irem", -1);
                    }

                    public void caseIntType(IntType t) {
                        this.handleIntCase();
                    }

                    public void caseBooleanType(BooleanType t) {
                        this.handleIntCase();
                    }

                    public void caseShortType(ShortType t) {
                        this.handleIntCase();
                    }

                    public void caseCharType(CharType t) {
                        this.handleIntCase();
                    }

                    public void caseByteType(ByteType t) {
                        this.handleIntCase();
                    }

                    public void caseLongType(LongType t) {
                        HjJasminClass.this.emit("lrem", -2);
                    }

                    public void caseDoubleType(DoubleType t) {
                        HjJasminClass.this.emit("drem", -2);
                    }

                    public void caseFloatType(FloatType t) {
                        HjJasminClass.this.emit("frem", -1);
                    }

                    public void defaultCase(Type t) {
                        throw new RuntimeException("Invalid argument type for rem");
                    }
                });
            }

            public void caseShlExpr(ShlExpr v) {
                HjJasminClass.this.emitValue(v.getOp1());
                HjJasminClass.this.emitValue(v.getOp2());
                v.getType().apply((Switch)new TypeSwitch(){

                    private void handleIntCase() {
                        HjJasminClass.this.emit("ishl", -1);
                    }

                    public void caseIntType(IntType t) {
                        this.handleIntCase();
                    }

                    public void caseBooleanType(BooleanType t) {
                        this.handleIntCase();
                    }

                    public void caseShortType(ShortType t) {
                        this.handleIntCase();
                    }

                    public void caseCharType(CharType t) {
                        this.handleIntCase();
                    }

                    public void caseByteType(ByteType t) {
                        this.handleIntCase();
                    }

                    public void caseLongType(LongType t) {
                        HjJasminClass.this.emit("lshl", -1);
                    }

                    public void defaultCase(Type t) {
                        throw new RuntimeException("Invalid argument type for shl");
                    }
                });
            }

            public void caseShrExpr(ShrExpr v) {
                HjJasminClass.this.emitValue(v.getOp1());
                HjJasminClass.this.emitValue(v.getOp2());
                v.getType().apply((Switch)new TypeSwitch(){

                    private void handleIntCase() {
                        HjJasminClass.this.emit("ishr", -1);
                    }

                    public void caseIntType(IntType t) {
                        this.handleIntCase();
                    }

                    public void caseBooleanType(BooleanType t) {
                        this.handleIntCase();
                    }

                    public void caseShortType(ShortType t) {
                        this.handleIntCase();
                    }

                    public void caseCharType(CharType t) {
                        this.handleIntCase();
                    }

                    public void caseByteType(ByteType t) {
                        this.handleIntCase();
                    }

                    public void caseLongType(LongType t) {
                        HjJasminClass.this.emit("lshr", -1);
                    }

                    public void defaultCase(Type t) {
                        throw new RuntimeException("Invalid argument type for shr");
                    }
                });
            }

            public void caseSpecialInvokeExpr(SpecialInvokeExpr v) {
                SootMethodRef m = v.getMethodRef();
                HjJasminClass.this.emitValue(v.getBase());
                for (int i = 0; i < m.parameterTypes().size(); ++i) {
                    HjJasminClass.this.emitValue(v.getArg(i));
                }
                HjJasminClass.this.emit("invokespecial " + AbstractJasminClass.slashify((String)m.declaringClass().getName()) + "/" + m.name() + AbstractJasminClass.jasminDescriptorOf((SootMethodRef)m), -(AbstractJasminClass.argCountOf((SootMethodRef)m) + 1) + AbstractJasminClass.sizeOfType((Type)m.returnType()));
            }

            public void caseStaticInvokeExpr(StaticInvokeExpr v) {
                SootMethodRef m = v.getMethodRef();
                for (int i = 0; i < m.parameterTypes().size(); ++i) {
                    HjJasminClass.this.emitValue(v.getArg(i));
                }
                HjJasminClass.this.emit("invokestatic " + AbstractJasminClass.slashify((String)m.declaringClass().getName()) + "/" + m.name() + AbstractJasminClass.jasminDescriptorOf((SootMethodRef)m), -AbstractJasminClass.argCountOf((SootMethodRef)m) + AbstractJasminClass.sizeOfType((Type)m.returnType()));
            }

            public void caseStaticFieldRef(StaticFieldRef v) {
                HjJasminClass.this.emit("getstatic " + AbstractJasminClass.slashify((String)v.getFieldRef().declaringClass().getName()) + "/" + v.getFieldRef().name() + " " + AbstractJasminClass.jasminDescriptorOf((Type)v.getFieldRef().type()), AbstractJasminClass.sizeOfType((Type)v.getFieldRef().type()));
            }

            public void caseStringConstant(StringConstant v) {
                HjJasminClass.this.emit("ldc " + v.toString(), 1);
            }

            public void caseClassConstant(ClassConstant v) {
                HjJasminClass.this.emit("ldc_w " + v.getValue(), 1);
            }

            public void caseSubExpr(SubExpr v) {
                HjJasminClass.this.emitValue(v.getOp1());
                HjJasminClass.this.emitValue(v.getOp2());
                v.getType().apply((Switch)new TypeSwitch(){

                    private void handleIntCase() {
                        HjJasminClass.this.emit("isub", -1);
                    }

                    public void caseIntType(IntType t) {
                        this.handleIntCase();
                    }

                    public void caseBooleanType(BooleanType t) {
                        this.handleIntCase();
                    }

                    public void caseShortType(ShortType t) {
                        this.handleIntCase();
                    }

                    public void caseCharType(CharType t) {
                        this.handleIntCase();
                    }

                    public void caseByteType(ByteType t) {
                        this.handleIntCase();
                    }

                    public void caseLongType(LongType t) {
                        HjJasminClass.this.emit("lsub", -2);
                    }

                    public void caseDoubleType(DoubleType t) {
                        HjJasminClass.this.emit("dsub", -2);
                    }

                    public void caseFloatType(FloatType t) {
                        HjJasminClass.this.emit("fsub", -1);
                    }

                    public void defaultCase(Type t) {
                        throw new RuntimeException("Invalid argument type for sub");
                    }
                });
            }

            public void caseUshrExpr(UshrExpr v) {
                HjJasminClass.this.emitValue(v.getOp1());
                HjJasminClass.this.emitValue(v.getOp2());
                v.getType().apply((Switch)new TypeSwitch(){

                    private void handleIntCase() {
                        HjJasminClass.this.emit("iushr", -1);
                    }

                    public void caseIntType(IntType t) {
                        this.handleIntCase();
                    }

                    public void caseBooleanType(BooleanType t) {
                        this.handleIntCase();
                    }

                    public void caseShortType(ShortType t) {
                        this.handleIntCase();
                    }

                    public void caseCharType(CharType t) {
                        this.handleIntCase();
                    }

                    public void caseByteType(ByteType t) {
                        this.handleIntCase();
                    }

                    public void caseLongType(LongType t) {
                        HjJasminClass.this.emit("lushr", -1);
                    }

                    public void defaultCase(Type t) {
                        throw new RuntimeException("Invalid argument type for ushr");
                    }
                });
            }

            public void caseVirtualInvokeExpr(VirtualInvokeExpr v) {
                SootMethodRef m = v.getMethodRef();
                HjJasminClass.this.emitValue(v.getBase());
                for (int i = 0; i < m.parameterTypes().size(); ++i) {
                    HjJasminClass.this.emitValue(v.getArg(i));
                }
                HjJasminClass.this.emit("invokevirtual " + AbstractJasminClass.slashify((String)m.declaringClass().getName()) + "/" + m.name() + AbstractJasminClass.jasminDescriptorOf((SootMethodRef)m), -(AbstractJasminClass.argCountOf((SootMethodRef)m) + 1) + AbstractJasminClass.sizeOfType((Type)m.returnType()));
            }

            public void caseXorExpr(XorExpr v) {
                HjJasminClass.this.emitValue(v.getOp1());
                HjJasminClass.this.emitValue(v.getOp2());
                v.getType().apply((Switch)new TypeSwitch(){

                    private void handleIntCase() {
                        HjJasminClass.this.emit("ixor", -1);
                    }

                    public void caseIntType(IntType t) {
                        this.handleIntCase();
                    }

                    public void caseBooleanType(BooleanType t) {
                        this.handleIntCase();
                    }

                    public void caseShortType(ShortType t) {
                        this.handleIntCase();
                    }

                    public void caseCharType(CharType t) {
                        this.handleIntCase();
                    }

                    public void caseByteType(ByteType t) {
                        this.handleIntCase();
                    }

                    public void caseLongType(LongType t) {
                        HjJasminClass.this.emit("lxor", -2);
                    }

                    public void defaultCase(Type t) {
                        throw new RuntimeException("Invalid argument type for xor");
                    }
                });
            }
        });
    }

    public void emitBooleanBranch(String s) {
        int count = s.indexOf("icmp") != -1 || s.indexOf("acmp") != -1 ? -2 : -1;
        this.emit(s + " label" + this.labelCount, count);
        this.emit("iconst_0", 1);
        this.emit("goto label" + this.labelCount + 1, 0);
        this.emit("label" + this.labelCount++ + ":");
        this.emit("iconst_1", 1);
        this.emit("label" + this.labelCount++ + ":");
    }
}

