/*
 * Decompiled with CFR 0.152.
 */
package hj.array;

import hj.array.ContiguousRange;
import hj.array.Distribution_c;
import hj.array.MultiDimRegion;
import hj.lang.Runtime;
import hj.lang.dist;
import hj.lang.place;
import hj.lang.point;
import hj.lang.region;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public class DistributionFactory
extends dist.factory {
    public dist cyclic(region r, Set qs) {
        assert (r.rank > 0);
        int dim_to_split = r.rank - 1;
        int sz = r.rank(dim_to_split).size();
        return this.blockCyclic(r, 1, qs);
    }

    public dist blockCyclic(region r, int p) {
        return this.blockCyclic(r, p, place.places);
    }

    public dist blockCyclic(region r, int n, Set qs) {
        Distribution_c ret;
        assert (n > 0);
        assert (r.rank > 0);
        boolean dim_splittable = r instanceof ContiguousRange || r instanceof MultiDimRegion;
        int dim_to_split = r.rank - 1;
        int sz = r.rank(dim_to_split).size();
        int qsize = qs.size();
        assert (qsize > 0);
        Object[] q = qs.toArray();
        assert (q[0] instanceof Comparable);
        Arrays.sort(q);
        if (qsize == 1) {
            place p = (place)q[0];
            ret = new Distribution_c.Constant(r, p);
        } else if (sz % (n * qsize) == 0 && dim_splittable) {
            int chunks;
            int n2 = chunks = sz % n == 0 || sz < n ? sz / n : sz / n + 1;
            assert (chunks > 0);
            Distribution_c[] dists = new Distribution_c[chunks];
            region[] sub = r.partition(chunks, dim_to_split);
            for (int i = 0; i < chunks; ++i) {
                dists[i] = new Distribution_c.Constant(sub[i], (place)q[i % q.length]);
            }
            ret = new Distribution_c.Combined(r, dists, q.length == 1 ? (place)q[0] : null);
        } else if (sz == n && dim_to_split > 0 && qsize == r.rank(dim_to_split - 1).size()) {
            int adjustment = 0;
            int[] adjustmentOffset = new int[Runtime.places().length];
            int chunks = r.rank(dim_to_split - 1).size();
            Distribution_c[] dists = new Distribution_c[chunks];
            region[] sub = r.partition(chunks, dim_to_split - 1);
            for (int i = 0; i < chunks; ++i) {
                int placeId = ((place)q[i % chunks]).id;
                adjustmentOffset[placeId] = adjustment;
                adjustment += sub[i].size();
                dists[i] = new Distribution_c.Constant(sub[i], (place)q[i % chunks]);
            }
            ret = new Distribution_c.Combined(r, dists, q.length == 1 ? (place)q[0] : null);
        } else {
            ret = this.blockCyclicHelper_(r, n, q);
        }
        return ret;
    }

    private Distribution_c.Arbitrary blockCyclicHelper_(region r, int bf, Object[] places) {
        assert (bf > 0);
        HashMap<point, Object> hm = new HashMap<point, Object>();
        int offset = 0;
        Iterator it = r.iterator();
        while (it.hasNext()) {
            point p = (point)it.next();
            hm.put(p, places[offset / bf % places.length]);
            ++offset;
        }
        Distribution_c.Arbitrary ret = new Distribution_c.Arbitrary(r, hm, places.length == 1 ? (place)places[0] : null);
        return ret;
    }

    public dist random(region r) {
        return this.cyclic(r);
    }

    public dist block(region r, Set q) {
        return this.block(r, q.size(), q);
    }

    public dist block(region base, region[] r, Set q) {
        return this.block(base, r, q.size(), q);
    }

    public dist block(region base, region[] r, int n, Set qs) {
        assert (n > 0);
        if (r.length != n) {
            throw new Error("Not implemented yet.");
        }
        Distribution_c[] dists = new Distribution_c[n];
        Object[] q = qs.toArray();
        for (int i = 0; i < n; ++i) {
            dists[i] = new Distribution_c.Constant(r[i], (place)q[i]);
        }
        return new Distribution_c.Combined(base, dists, null);
    }

    public dist block(region r, int n, Set qs) {
        assert (n <= qs.size());
        assert (n > 0);
        boolean dim_splittable = r instanceof ContiguousRange || r instanceof MultiDimRegion;
        boolean dim_to_split = false;
        Distribution_c ret = null;
        int sz = r.rank(0).size();
        Object[] q = qs.toArray();
        assert (q[0] instanceof Comparable);
        Arrays.sort(q);
        if (n == 1) {
            place p = (place)q[0];
            ret = new Distribution_c.Constant(r, p);
        } else if (sz >= n && sz % n == 0 && dim_splittable) {
            region[] sub = r.partition(n, 0);
            Distribution_c[] dists = new Distribution_c[n];
            int adjustment = 0;
            int[] adjustmentOffset = new int[Runtime.places().length];
            for (int i = 0; i < n; ++i) {
                int placeId = ((place)q[i]).id;
                adjustmentOffset[placeId] = adjustment;
                adjustment += sub[i].size();
                dists[i] = new Distribution_c.Constant(sub[i], (place)q[i]);
            }
            ret = new Distribution_c.Combined(r, dists, n == 1 ? (place)q[0] : null);
        } else {
            ret = this.blockHelper_(r, n, q);
        }
        return ret;
    }

    private Distribution_c.Arbitrary blockHelper_(region r, int nb, Object[] places) {
        assert (nb > 0 && nb <= places.length);
        int total_points = r.size();
        int p = total_points / nb;
        int q = total_points % nb;
        int adjustment = 0;
        int[] adjustmentOffset = new int[Runtime.places().length];
        HashMap<point, Object> hm = new HashMap<point, Object>();
        int offsWithinPlace = 0;
        int blockNum = 0;
        Iterator it = r.iterator();
        while (it.hasNext()) {
            point pt = (point)it.next();
            hm.put(pt, places[blockNum]);
            ++adjustment;
            if (++offsWithinPlace != p + (blockNum < q ? 1 : 0)) continue;
            offsWithinPlace = 0;
            if (++blockNum >= places.length) continue;
            adjustmentOffset[blockNum] = adjustment;
        }
        Distribution_c.Arbitrary ret = new Distribution_c.Arbitrary(r, hm, places.length == 1 ? (place)places[0] : null);
        return ret;
    }

    public dist arbitrary(region r) {
        int blocksize = r.size() / place.places.size();
        dist ret = blocksize == 0 ? this.constant(r, place.FIRST_PLACE) : this.blockCyclic(r, blocksize, place.places);
        return ret;
    }

    public dist constant(region r, place p) {
        int[] adjustmentOffset = new int[Runtime.places().length];
        Distribution_c.Constant newDist = new Distribution_c.Constant(r, p);
        return newDist;
    }

    public dist unique(Set p) {
        Object[] places = p.toArray();
        place[] ps = new place[places.length];
        for (int i = 0; i < places.length; ++i) {
            ps[i] = (place)places[i];
        }
        Distribution_c.Unique newDist = new Distribution_c.Unique(ps);
        return newDist;
    }
}

