/*
 * Decompiled with CFR 0.152.
 */
package hj.array.sharedmemory;

import hj.array.Distribution_c;
import hj.array.LongArray;
import hj.array.Operator;
import hj.array.lang.longArray;
import hj.base.UnsafeContainer;
import hj.lang.Indexable;
import hj.lang.Runtime;
import hj.lang.dist;
import hj.runtime.common.Configuration;

public class LongArray_c
extends LongArray
implements UnsafeContainer {
    public final long[] arr_;
    public final int[] descriptor_;

    public LongArray_c(dist d, long c, boolean mutable) {
        this(d, new longArray.Constant(c), mutable);
    }

    public LongArray_c(dist d, Operator.Pointwise c, boolean mutable, boolean ignored) {
        this(d, c, mutable);
    }

    protected LongArray_c(dist d, Operator.Pointwise c, boolean mutable) {
        this(d, mutable, null);
        if (c != null) {
            this.scan((LongArray)this, c);
        }
    }

    protected LongArray_c(dist d, boolean mutable, long[] a) {
        super(d, mutable);
        assert (d instanceof Distribution_c);
        int count = d.region.size();
        int rank = d.region.rank;
        this.descriptor_ = new int[rank + 1];
        this.descriptor_[0] = rank;
        for (int i = 1; i <= rank; ++i) {
            this.descriptor_[i] = d.region.rank(i - 1).size();
        }
        this.arr_ = a != null ? a : new long[count];
    }

    private LongArray_c(dist d, long[] a, boolean mutable) {
        this(d, mutable, a);
    }

    public static LongArray_c LongArray_c(long[] a, boolean mutable) {
        dist d = Runtime.factory.getDistributionFactory().local(a.length);
        return new LongArray_c(d, a, mutable);
    }

    public boolean valueEquals(Indexable other) {
        LongArray_c o = (LongArray_c)other;
        if (o.arr_.length != this.arr_.length) {
            return false;
        }
        for (int i = this.arr_.length - 1; i >= 0; --i) {
            if (this.arr_[i] == o.arr_[i]) continue;
            return false;
        }
        return true;
    }

    public long[] getBackingArray() {
        return this.arr_;
    }

    public int[] getDescriptor() {
        return this.descriptor_;
    }

    public long setOrdinal(long v, int rawIndex) {
        this.arr_[rawIndex] = v;
        return this.arr_[rawIndex];
    }

    public long getOrdinal(int rawIndex) {
        return this.arr_[rawIndex];
    }

    protected LongArray newInstance(dist d) {
        return new LongArray_c(d, (Operator.Pointwise)null, true);
    }

    protected LongArray newInstance(dist d, long c) {
        return new LongArray_c(d, c, true);
    }

    protected void assign(LongArray rhs) {
        assert (rhs.getClass() == this.getClass());
        LongArray_c rhs_t = (LongArray_c)rhs;
        if (!Configuration.BAD_PLACE_RUNTIME_CHECK && rhs.distribution.equals(this.distribution)) {
            int count = this.arr_.length;
            for (int i = 0; i < count; ++i) {
                this.arr_[i] = rhs_t.arr_[i];
            }
        } else {
            super.assign(rhs);
        }
    }

    public void reduction(Operator.Reduction op) {
        if (!Configuration.BAD_PLACE_RUNTIME_CHECK) {
            int count = this.arr_.length;
            for (int i = 0; i < count; ++i) {
                op.apply(this.arr_[i]);
            }
        } else {
            super.reduction(op);
        }
    }
}

