/*
 * Decompiled with CFR 0.152.
 */
package hj.array.view;

import hj.array.ContiguousRange;
import hj.array.RegionRectangular;
import hj.lang.ArrayView;
import hj.lang.region;

public class ComplexArrayView
extends ArrayView {
    public ComplexArrayView(int offset, region r) {
        super(offset * 2, ComplexArrayView.adaptBoundariesForComplex(r));
    }

    public static region adaptBoundariesForComplex(region r) {
        region[] dimensions = new region[r.rank];
        RegionRectangular rr = (RegionRectangular)r;
        if (r.rank == 1) {
            dimensions[0] = new ContiguousRange(rr.low_I, (rr.low_I + rr.lg_I) * 2 - 1);
        }
        if (r.rank == 2) {
            dimensions[0] = new ContiguousRange(rr.low_I, rr.low_I + rr.lg_I - 1);
            dimensions[1] = new ContiguousRange(rr.low_J, rr.low_J + rr.lg_J * 2 - 1);
        }
        if (r.rank == 3) {
            dimensions[0] = new ContiguousRange(rr.low_I, rr.low_I + rr.lg_I - 1);
            dimensions[1] = new ContiguousRange(rr.low_J, rr.low_J + rr.lg_J - 1);
            dimensions[2] = new ContiguousRange(rr.low_K, rr.low_K + rr.lg_K * 2 - 1);
        }
        if (r.rank == 4) {
            dimensions[0] = new ContiguousRange(rr.low_I, rr.low_I + rr.lg_I - 1);
            dimensions[1] = new ContiguousRange(rr.low_J, rr.low_J + rr.lg_J - 1);
            dimensions[2] = new ContiguousRange(rr.low_K, rr.low_K + rr.lg_K - 1);
            dimensions[3] = new ContiguousRange(rr.low_L, rr.low_L + rr.lg_L * 2 - 1);
        }
        if (r.rank == 5) {
            dimensions[0] = new ContiguousRange(rr.low_I, rr.low_I + rr.lg_I - 1);
            dimensions[1] = new ContiguousRange(rr.low_J, rr.low_J + rr.lg_J - 1);
            dimensions[2] = new ContiguousRange(rr.low_K, rr.low_K + rr.lg_K - 1);
            dimensions[3] = new ContiguousRange(rr.low_L, rr.low_L + rr.lg_L - 1);
            dimensions[4] = new ContiguousRange(rr.low_M, rr.low_M + rr.lg_M * 2 - 1);
        }
        RegionRectangular newRegion = new RegionRectangular(dimensions);
        return newRegion;
    }

    public int getRowOffset(int i) {
        return this.region.ordinal(i, this.region.low_J) / 2;
    }

    public int getRowOffset(int i, int j) {
        return this.region.ordinal(i, j, this.region.low_K) / 2;
    }
}

