/*
 * Decompiled with CFR 0.152.
 */
package hj.lang;

import hj.lang.place;
import hj.runtime.wsh.Activity;
import hj.runtime.wsh.Place;
import hj.runtime.wsh.WshRuntime_c;
import hj.runtime.wsh.actor.ActorRuntimeHelper;
import hj.runtime.wsh.actor.LingeringActivity;
import hj.runtime.wsh.actor.LinkedDdcNode;
import hj.runtime.wsh.actor.ResumableBlock;
import hj.runtime.wsh.cooperative.DataDrivenControl;
import hj.runtime.wsh.cooperative.ResumableTask;
import java.util.concurrent.atomic.AtomicBoolean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Actor<MessageType> {
    private final int batchLimit;
    private static final int BATCH_LIMIT = 500;
    private Place homePlace;
    private LingeringActivity lingeringActivity = null;
    private DataDrivenControl<Boolean> resumeDdc = null;
    private LinkedDdcNode<MessageType> firstMessageDdc = new LinkedDdcNode();
    private LinkedDdcNode<MessageType> currentDdc = this.firstMessageDdc;
    private AtomicBoolean currentDdcLock = new AtomicBoolean(false);
    private boolean hasStarted = false;
    private boolean hasExited = false;

    protected Actor() {
        this(500);
    }

    protected Actor(int batchLimit) {
        this.batchLimit = batchLimit;
    }

    public void start() {
        this.checkStart();
        this.homePlace = (Place)WshRuntime_c.here();
        this.helpWithStart();
    }

    public void start(place actorHome) {
        this.checkStart();
        this.homePlace = (Place)actorHome;
        this.helpWithStart();
    }

    private void checkStart() {
        if (this.hasStarted) {
            throw new RuntimeException("Actor has already started!");
        }
        this.hasStarted = true;
    }

    private void helpWithStart() {
        String activityName = "LingeringActivity";
        this.lingeringActivity = ActorRuntimeHelper.newLingeringActivity("LingeringActivity");
        this.actOn(this.firstMessageDdc);
        this.firstMessageDdc = null;
    }

    protected void exit() {
        if (!this.hasExited) {
            this.hasExited = true;
            ActorRuntimeHelper.resumeLingeringActivity(this.lingeringActivity);
            this.resumeDdc = null;
            this.lingeringActivity = null;
        }
    }

    protected abstract void process(MessageType var1);

    public final void send(MessageType msg) {
        if (this.hasExited) {
            return;
        }
        boolean keepLooping = true;
        do {
            boolean success;
            if (!(success = this.currentDdcLock.compareAndSet(false, true))) continue;
            LinkedDdcNode<MessageType> oldDdc = this.currentDdc;
            this.currentDdc = oldDdc.next();
            this.currentDdcLock.set(false);
            keepLooping = false;
            oldDdc.value().setValue(msg);
        } while (keepLooping);
    }

    private void actOn(LinkedDdcNode<MessageType> ddcNode) {
        this.resumeDdc = null;
        boolean keepLooping = true;
        LinkedDdcNode<MessageType> currentMessageNode = ddcNode;
        int batchCounter = 0;
        while (keepLooping) {
            ActorResumeRunnable runnableBlock;
            DataDrivenControl<MessageType> messageDdc = currentMessageNode.value();
            if (batchCounter > this.batchLimit || !messageDdc.valueAvailable()) {
                keepLooping = false;
                runnableBlock = new ActorResumeRunnable(this, currentMessageNode);
                Activity activity2 = ActorRuntimeHelper.newRunnableActivity(this.lingeringActivity, this.homePlace, "RunnableActivity", runnableBlock);
                ResumableTask resumableTask = new ResumableTask(activity2);
                messageDdc.addResumable(resumableTask);
            } else {
                try {
                    this.process(messageDdc.getValue());
                }
                catch (Throwable th) {
                    this.handleThrowable(th);
                }
                if (this.hasExited) {
                    keepLooping = false;
                } else if (this.resumeDdc != null) {
                    keepLooping = false;
                    runnableBlock = new ActorResumeRunnable(this, currentMessageNode.next());
                    this.resumeDdc.addResumable(new ResumableBlock(runnableBlock));
                }
            }
            if (keepLooping) {
                currentMessageNode = currentMessageNode.next();
            }
            ++batchCounter;
        }
    }

    protected void handleThrowable(Throwable th) {
        this.exit();
        throw new RuntimeException(th);
    }

    protected void pause() {
        if (this.resumeDdc == null) {
            this.resumeDdc = new DataDrivenControl();
        }
    }

    protected void resume() {
        if (this.resumeDdc == null) {
            throw new RuntimeException("called resume with nothing to resume");
        }
        this.resumeDdc.setValue(Boolean.TRUE);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ActorResumeRunnable<MessageType>
    implements Runnable {
        private final Actor<MessageType> actor;
        private final LinkedDdcNode<MessageType> ddcNode;

        private ActorResumeRunnable(Actor<MessageType> actor, LinkedDdcNode<MessageType> ddcNode) {
            this.ddcNode = ddcNode;
            this.actor = actor;
        }

        @Override
        public void run() {
            ((Actor)this.actor).actOn(this.ddcNode);
        }
    }
}

