/*
 * Decompiled with CFR 0.152.
 */
package hj.lang.MapReduce;

import hj.lang.MapReduce.MapTask;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class MapReduceBase {
    protected int _numMapTasks;
    protected int _numReduceTasks;
    protected Map[][] _intermediate;
    protected Map[] _final;
    protected Map _result;

    public MapReduceBase(int numMapTasks, int numReduceTasks) {
        int i;
        this._numMapTasks = numMapTasks;
        this._numReduceTasks = numReduceTasks;
        this._intermediate = new Map[numMapTasks][numReduceTasks];
        for (i = 0; i < this._intermediate.length; ++i) {
            for (int j = 0; j < this._intermediate[i].length; ++j) {
                this._intermediate[i][j] = new HashMap();
            }
        }
        this._final = new Map[numReduceTasks];
        for (i = 0; i < this._final.length; ++i) {
            this._final[i] = new HashMap();
        }
        this._result = new HashMap();
    }

    public abstract MapTask splitter();

    public abstract Object reduce(Object var1, Object var2);

    public Object reduce(List vals) {
        Object v = null;
        for (Object u : vals) {
            if (v == null) {
                v = u;
                continue;
            }
            v = this.reduce(v, u);
        }
        return v;
    }

    public void reduce(int reduceTaskID) {
        for (int i = 0; i < this._numMapTasks; ++i) {
            Map keyvalPairs = this._intermediate[i][reduceTaskID];
            for (Object key : keyvalPairs.keySet()) {
                Object finalVal = this.reduce((List)keyvalPairs.get(key));
                this.emitFinal(reduceTaskID, key, finalVal);
            }
        }
    }

    public void emitIntermediate(int mapTaskID, Object key, Object val) {
        Map keyvalPairs;
        LinkedList<Object> valsList;
        int reduceTaskID = key.hashCode() % this._numReduceTasks;
        if (reduceTaskID < 0) {
            reduceTaskID += this._numReduceTasks;
        }
        if ((valsList = (LinkedList<Object>)(keyvalPairs = this._intermediate[mapTaskID][reduceTaskID]).get(key)) == null) {
            valsList = new LinkedList<Object>();
            keyvalPairs.put(key, valsList);
        }
        valsList.add(val);
    }

    public void emitFinal(int reduceTaskID, Object key, Object val) {
        Map keyvalPairs = this._final[reduceTaskID];
        if (keyvalPairs.containsKey(key)) {
            keyvalPairs.put(key, this.reduce(keyvalPairs.get(key), val));
        } else {
            keyvalPairs.put(key, val);
        }
    }

    public void merge() {
        for (int i = 0; i < this._numReduceTasks; ++i) {
            this._result.putAll(this._final[i]);
        }
    }

    public Map getResult() {
        return this._result;
    }

    public Set getKeys() {
        return this._result.keySet();
    }

    public Object query(Object key) {
        return this._result.get(key);
    }
}

