/*
 * Decompiled with CFR 0.152.
 */
package hj.runtime.common.util.binding;

import hj.runtime.common.Configuration;
import hj.runtime.common.ConfigurationError;
import java.io.LineNumberReader;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;

public class ThreadBindingConfiguration {
    public static List<Integer>[][] THREAD_BINDING_MAPPING = null;

    public static void loadThreadBindingConfigurationFile(LineNumberReader reader) throws ConfigurationError {
        try {
            int val;
            String line;
            do {
                if ((line = reader.readLine()) != null) continue;
                throw new ConfigurationError("Unexpected end-of-file in mapping file");
            } while ((line = line.trim()).startsWith("#"));
            int p = line.indexOf(32);
            if (p < 0) {
                throw new ConfigurationError("Line #" + reader.getLineNumber() + ": <#_of_Places> <#_of_Workers>");
            }
            Configuration.NUMBER_OF_LOCAL_PLACES = val = Integer.parseInt(line.substring(0, p));
            Configuration.INIT_THREADS_PER_PLACE = val = Integer.parseInt(line.substring(p).trim());
            THREAD_BINDING_MAPPING = new LinkedList[Configuration.NUMBER_OF_LOCAL_PLACES][Configuration.INIT_THREADS_PER_PLACE];
            int nbLineToRead = Configuration.NUMBER_OF_LOCAL_PLACES;
            if (Configuration.isWorkStealingRuntime()) {
                nbLineToRead *= Configuration.INIT_THREADS_PER_PLACE;
            }
            int i = 0;
            while (i < nbLineToRead) {
                line = reader.readLine();
                if (line == null) {
                    throw new ConfigurationError("Unexpected end-of-file in mapping file");
                }
                if ((line = line.trim()).startsWith("#")) continue;
                int semi = p = line.indexOf(58);
                if (p >= 0) {
                    int pid = Integer.parseInt(line.substring(0, p).trim());
                    p = line.indexOf("->");
                    if (p >= 0) {
                        int wid;
                        if (line.contains("any")) {
                            if (Configuration.isWorkStealingRuntime()) {
                                throw new ConfigurationError("Cannot use 'any' when targeting the work-stealing runtime ");
                            }
                            wid = 0;
                        } else {
                            if (Configuration.isWorkSharingRuntime()) {
                                throw new ConfigurationError("Must use 'any' in place of worker ids when targeting the work-sharing runtime");
                            }
                            wid = Integer.parseInt(line.substring(semi + 1, line.indexOf("->")).trim());
                        }
                        line = line.substring(p + 2).trim();
                        ThreadBindingConfiguration.THREAD_BINDING_MAPPING[pid][wid] = new LinkedList<Integer>();
                        StringTokenizer tokens = new StringTokenizer(line, " ;\t\r");
                        while (tokens.hasMoreTokens()) {
                            THREAD_BINDING_MAPPING[pid][wid].add(Integer.parseInt(tokens.nextToken()));
                        }
                    } else {
                        throw new ConfigurationError("Line #" + reader.getLineNumber() + " : <placeID> @ <workerID> -> <cpu_id_list ... >");
                    }
                    ++i;
                    continue;
                }
                throw new ConfigurationError("Line #" + reader.getLineNumber() + " : <placeID> @ <workerID> -> <cpu_id_list ... >");
            }
        }
        catch (Exception e) {
            throw new ConfigurationError("Thread binding config file line " + reader.getLineNumber() + ": " + e.getMessage());
        }
    }
}

