/*
 * Decompiled with CFR 0.152.
 */
package hj.runtime.graphics;

import hj.runtime.graphics.SourceInfo;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.util.Stack;

public class DCG {
    private static boolean DEBUG = false;
    public static SourceInfo info;
    public static Stack<Integer> finishStack;
    public static Stack<Integer> taskStack;
    public static Stack<Integer> contStack;
    public static int finish_count;
    public static int async_count;
    public static int global_count;
    public static int step_count;
    public static int current_parent;
    public static FileWriter fstream;
    public static BufferedWriter out;
    public static String fileName;

    public static void init(String fName) {
        info = new SourceInfo();
        finishStack = new Stack();
        contStack = new Stack();
        taskStack = new Stack();
        fileName = fName;
        try {
            fstream = fileName == null ? new FileWriter("graph.dot") : new FileWriter(fileName + ".dot");
            out = new BufferedWriter(fstream);
            out.write("digraph taskgraph\n{\n");
            out.write(global_count + " [label = \"Start\"][shape = box][color = red]\n");
            current_parent = global_count++;
            taskStack.push(async_count);
            int taskId = 0;
            taskId = taskStack.peek();
            out.write(global_count + " [label = \"Step-" + step_count + "-T" + taskId + "\"][shape = circle][color = blue]\n");
            ++step_count;
            out.write(current_parent + "->" + global_count + "\n");
            current_parent = global_count++;
        }
        catch (Exception e) {
            System.err.println("Error: " + e.getMessage());
        }
    }

    public static void end() {
        try {
            out.write(global_count + " [label = \"End\"][shape = box][color = red]\n");
            out.write(current_parent + "->" + global_count + "\n");
            current_parent = global_count++;
            out.write("}");
            out.close();
        }
        catch (Exception e) {
            System.err.println("Error: " + e.getMessage());
        }
    }

    public static void startStep() {
    }

    public static void endStep() {
    }

    public static void startFinish() {
        if (DEBUG) {
            System.out.println("StartFinish");
        }
        try {
            int taskId = 0;
            taskId = taskStack.peek();
            out.write(global_count + " [label = \"SF-" + finish_count + "-T" + taskId + "\"][shape = box][color = red]\n");
            out.write(current_parent + "->" + global_count + "\n");
            current_parent = global_count++;
            out.write(global_count + " [label = \"Step-" + step_count + "-T" + taskId + "\"][shape = circle][color = blue]\n");
            ++step_count;
            out.write(current_parent + "->" + global_count + "\n");
            current_parent = global_count++;
            out.write(global_count + " [label = \"EF-" + finish_count + "-T" + taskId + "\"][shape = box][color = red]\n");
            finishStack.add(global_count);
            ++global_count;
            ++finish_count;
        }
        catch (Exception e) {
            System.err.println("Error: " + e.getMessage());
        }
    }

    public static void endFinish() {
        try {
            if (DEBUG) {
                System.out.println("endFinish");
            }
            Integer child = finishStack.pop();
            out.write(current_parent + "->" + child + "\n");
            current_parent = child;
            int taskId = 0;
            taskId = taskStack.peek();
            out.write(global_count + " [label = \"Step-" + step_count + "-T" + taskId + "\"][shape = circle][color = blue]\n");
            ++step_count;
            out.write(current_parent + "->" + global_count + "\n");
            current_parent = global_count++;
        }
        catch (Exception e) {
            System.err.println("Error: " + e.getMessage());
        }
    }

    public static void startAsync() {
        if (DEBUG) {
            System.out.println("StartAsync");
        }
        try {
            out.write(global_count + " [label = \"aStep-" + step_count + "-T" + ++async_count + "\"][shape = circle][color = blue]\n");
            ++step_count;
            int parent = current_parent;
            out.write(parent + "->" + global_count + "[style=bold penwidth=6 color=green]\n");
            current_parent = global_count++;
            int taskId = 0;
            taskId = taskStack.peek();
            out.write(global_count + " [label = \"Step-" + step_count + "-T" + taskId + "\"][shape = circle][color = blue]\n");
            out.write(parent + "->" + global_count + "\n");
            contStack.push(global_count);
            taskStack.push(async_count);
            ++global_count;
            ++step_count;
        }
        catch (Exception e) {
            System.err.println("Error: " + e.getMessage());
        }
    }

    public static void endAsync() {
        if (DEBUG) {
            System.out.println("endAsync");
        }
        taskStack.pop();
        try {
            if (!finishStack.empty()) {
                Integer endFinish = finishStack.peek();
                out.write(current_parent + "->" + endFinish + "\n[style=dotted color=red]");
            }
            current_parent = contStack.pop();
        }
        catch (Exception e) {
            System.err.println("Error: " + e.getMessage());
        }
    }

    static {
        finish_count = 0;
        async_count = 0;
        global_count = 0;
        step_count = 0;
        current_parent = 0;
    }
}

