/*
 * Decompiled with CFR 0.152.
 */
package hj.runtime.wsh;

import hj.lang.MultipleExceptions;
import hj.lang.PhaserAbst;
import hj.lang.PhaserException;
import hj.lang.activity;
import hj.runtime.common.Configuration;
import hj.runtime.wsh.FinishState;
import hj.runtime.wsh.HjRunnable;
import hj.runtime.wsh.Place;
import hj.runtime.wsh.Report;
import hj.runtime.wsh.WshConfiguration;
import hj.runtime.wsh.WshFuture;
import hj.runtime.wsh.abstractmetrics.AbstractMetrics;
import hj.runtime.wsh.abstractmetrics.AbstractMetricsFactory;
import hj.runtime.wsh.ovd.OVDInfo;
import hj.runtime.wsh.phaser.PhaserRegModeImpl;
import hj.runtime.wsh.util.DataDrivenFutureList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Activity
extends activity
implements HjRunnable,
AbstractMetrics {
    protected Place place_;
    protected FinishState finishState_ = null;
    protected Stack<FinishState> finishStack_ = null;
    protected FinishState rootNode_;
    protected WshFuture future;
    public DataDrivenFutureList waitList;
    private AbstractMetrics abstractMetricsManager;
    private boolean notFinished = true;
    protected boolean success = true;
    private final String name;
    private OVDInfo ovdInfo;
    protected HashSet<Object> lockSet = new HashSet();
    protected int writeLockCount = 0;
    protected int readLockCount = 0;

    protected Activity(String name) {
        this.name = name;
        if (Configuration.ABSTRACT_EXECUTION_STATS) {
            this.abstractMetricsManager = AbstractMetricsFactory.getAbstractMetricsManager();
        }
    }

    protected abstract void prepareToRunInFinish();

    public void setDDF(Collection l) {
        assert (this.waitList == null);
        this.waitList = new DataDrivenFutureList(this);
        this.waitList.setList(l);
    }

    @Override
    public abstract boolean isHjTaskReady();

    public synchronized void join() throws InterruptedException {
        while (this.notFinished) {
            this.wait();
        }
    }

    protected synchronized void setFinished() {
        this.notFinished = false;
        this.notifyAll();
    }

    public void setRootActivityFinishState(FinishState root) {
        this.rootNode_ = root;
    }

    public void setPlace(Place p) {
        this.place_ = p;
    }

    public Place getPlace() {
        return this.place_;
    }

    public void setAsyncReturn(Object asyncResult) {
        this.future.setResult(asyncResult);
    }

    protected abstract WshFuture initializeFuture();

    protected abstract FinishState newFinishState();

    public void startFinish() {
        if (this.finishState_ != null) {
            this.getFinishStack().push(this.finishState_);
        }
        this.finishState_ = this.newFinishState();
        if (Report.should_report("activity", 3)) {
            Report.report(3, this + " starts finish " + this.finishState_);
        }
    }

    public void startFinish(Object accums) {
        if (this.finishState_ != null) {
            this.getFinishStack().push(this.finishState_);
        }
        this.finishState_ = this.newFinishState();
        this.finishState_.initializeFinishAccumulatorManager((List)accums);
        if (Report.should_report("activity", 3)) {
            Report.report(3, this + " starts finish " + this.finishState_);
        }
    }

    protected final void postWaitForFinishProcessing() {
        if (Report.should_report("activity", 5)) {
            Report.report(5, this + " continues stopfinish ");
        }
        this.finishState_.finalizeFinishAccumulatorManager();
        FinishState state = this.finishState_;
        if (this.finishStack_ == null) {
            this.finishState_ = null;
        } else if (!this.finishStack_.isEmpty()) {
            this.finishState_ = this.finishStack_.pop();
        }
        Stack result = state.exceptions();
        if (result != null && !result.empty()) {
            if (result.size() == 1) {
                Throwable t = (Throwable)result.pop();
                if (Report.should_report("activity", 3)) {
                    Report.report(3, this + " throws  " + t);
                }
                if (t instanceof Error) {
                    throw (Error)t;
                }
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
            }
            throw new MultipleExceptions(result);
        }
        if (Report.should_report("activity", 3)) {
            Report.report(3, this + " exits from finish.");
        }
    }

    private Stack<FinishState> getFinishStack() {
        if (this.finishStack_ == null) {
            this.finishStack_ = new Stack();
        }
        return this.finishStack_;
    }

    protected boolean inFinish() {
        return this.finishState_ != null;
    }

    public void pushException(Throwable t) {
        if (Report.should_report("activity", 3)) {
            Report.report(3, this + " pushing exception " + t + " onto " + this.finishState_);
        }
        this.finishState_.pushException(t);
    }

    @Override
    public long getTotalOps() {
        if (Configuration.ABSTRACT_EXECUTION_STATS) {
            return this.abstractMetricsManager.getTotalOps();
        }
        return 0L;
    }

    @Override
    public long getCritPathOps() {
        if (Configuration.ABSTRACT_EXECUTION_STATS) {
            return this.abstractMetricsManager.getCritPathOps();
        }
        return 0L;
    }

    @Override
    public void addLocalOps(long n) {
        if (Configuration.ABSTRACT_EXECUTION_STATS) {
            this.abstractMetricsManager.addLocalOps(n);
        }
    }

    @Override
    public void addCritPathOps(long n) {
        if (Configuration.ABSTRACT_EXECUTION_STATS) {
            this.abstractMetricsManager.addCritPathOps(n);
        }
    }

    @Override
    public void maxCritPathOps(long n) {
        if (Configuration.ABSTRACT_EXECUTION_STATS) {
            this.abstractMetricsManager.maxCritPathOps(n);
        }
    }

    @Override
    public long getTotalUnblockedTime() {
        if (Configuration.ABSTRACT_EXECUTION_STATS) {
            return this.abstractMetricsManager.getTotalUnblockedTime();
        }
        return 0L;
    }

    @Override
    public long getCritPathTime() {
        if (Configuration.ABSTRACT_EXECUTION_STATS) {
            return this.abstractMetricsManager.getCritPathTime();
        }
        return 0L;
    }

    @Override
    public void maxCritPathTime(long t) {
        if (Configuration.ABSTRACT_EXECUTION_STATS) {
            this.abstractMetricsManager.maxCritPathTime(t);
        }
    }

    @Override
    public long getResumeTime() {
        if (Configuration.ABSTRACT_EXECUTION_STATS) {
            return this.abstractMetricsManager.getResumeTime();
        }
        return 0L;
    }

    @Override
    public void setResumeTime() {
        if (Configuration.ABSTRACT_EXECUTION_STATS) {
            this.abstractMetricsManager.setResumeTime();
        }
    }

    @Override
    public void updateIdealTime() {
        if (Configuration.ABSTRACT_EXECUTION_STATS) {
            this.abstractMetricsManager.updateIdealTime();
        }
    }

    @Override
    public long getCurrentTime() {
        if (Configuration.ABSTRACT_EXECUTION_STATS) {
            return this.abstractMetricsManager.getCurrentTime();
        }
        return 0L;
    }

    @Override
    public void addUnblockedTime(long t) {
        if (Configuration.ABSTRACT_EXECUTION_STATS) {
            this.abstractMetricsManager.addUnblockedTime(t);
        }
    }

    @Override
    public void maxOverheads(long n) {
        if (Configuration.ABSTRACT_EXECUTION_STATS) {
            this.abstractMetricsManager.maxOverheads(n);
        }
    }

    @Override
    public long getOverheads() {
        if (Configuration.ABSTRACT_EXECUTION_STATS) {
            return this.abstractMetricsManager.getOverheads();
        }
        return 0L;
    }

    public Activity finalizeActivitySpawn(Activity child) {
        if (Report.should_report("activity", 3)) {
            Report.report(3, this + " spawns " + child);
        }
        FinishState target = this.finishState_ == null ? this.rootNode_ : this.finishState_;
        child.setRootActivityFinishState(target);
        target.notifySubActivitySpawn();
        if (Configuration.ABSTRACT_EXECUTION_STATS) {
            child.maxCritPathOps(this.getCritPathOps());
            child.maxOverheads(this.getOverheads() + WshConfiguration.ABSTRACT_EXECUTION_OVERHEAD);
        }
        if (Configuration.isOVDEnabled()) {
            this.getOVDInfo().prepareSpawn(this, child.getOVDInfo());
        }
        return child;
    }

    public void finalizeTermination() {
        if (Report.should_report("activity", 5)) {
            Report.report(5, this + "terminates.");
        }
        this.finalizeTerminationCleanup();
        if (this.rootNode_ != null) {
            if (this.future != null && this.future.getException() != null) {
                this.rootNode_.registerFailedFuture(this.future);
            }
            this.rootNode_.notifySubActivityTermination();
        }
    }

    public void registerFailedSeqFuture(WshFuture f) {
        if (this.finishState_ == null) {
            this.rootNode_.registerFailedFuture(f);
        } else {
            this.finishState_.registerFailedFuture(f);
        }
    }

    public void finalizeTermination(Throwable t) {
        if (Report.should_report("activity", 5)) {
            Report.report(5, Thread.currentThread() + " " + this + " terminates abruptly with " + t);
        }
        if (this.future != null) {
            this.future.setException(t);
            this.finalizeTermination();
        } else {
            this.finalizeTerminationCleanup();
            if (this.rootNode_ != null) {
                this.rootNode_.notifySubActivityTermination(t);
            }
        }
    }

    protected abstract void finalizeTerminationCleanup();

    public String myName() {
        return this.name != null ? this.name : "Activity " + Long.toHexString(System.identityHashCode(this));
    }

    public String toString() {
        String rv = "<" + this.myName();
        rv = rv + " " + this.finishState_ + "," + this.rootNode_;
        rv = rv + ">";
        return rv;
    }

    public String shortString() {
        return "<" + this.myName() + ">";
    }

    public FinishState getFinishState() {
        return this.finishState_;
    }

    public boolean hasFinishState(FinishState fs) {
        if (this.finishState_ == fs && fs != null) {
            return true;
        }
        if (this.finishStack_ != null) {
            for (int i = this.finishStack_.size() - 1; i >= 0; --i) {
                if (this.finishStack_.get(i) != fs) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isReady() {
        return this.waitList == null || this.waitList.isReady();
    }

    public OVDInfo getOVDInfo() {
        if (this.ovdInfo == null) {
            this.ovdInfo = new OVDInfo();
        }
        return this.ovdInfo;
    }

    public void registerPhaserToIEF(PhaserAbst ph) {
        if (this.finishState_ != null) {
            this.finishState_.addPhaser(ph);
        }
    }

    private void checkPhaserUse(PhaserRegModeImpl prm) {
        Object ph = prm.getPhaser();
        if (((PhaserAbst)ph).dropped()) {
            throw new PhaserException("Cannot transmit dropped phaser.");
        }
        if (((PhaserAbst)ph).quiescent()) {
            throw new PhaserException("Cannot transmit sent (resumed) phaser.");
        }
        if (this.inFinish() && !this.finishState_.containsPhaser((PhaserAbst)ph)) {
            throw new PhaserException("IEF scope rule violation: The innermost finish doesn't include this phaser.");
        }
    }

    public void checkPhaserUse(List<PhaserRegModeImpl> prmList) {
        for (PhaserRegModeImpl phaserRegModeImpl : prmList) {
            this.checkPhaserUse(phaserRegModeImpl);
        }
    }

    public boolean registerLockObject(Object lockObject) {
        if (this.writeLockCount > 0) {
            if (lockObject == null) {
                ++this.writeLockCount;
            } else {
                ++this.readLockCount;
            }
        } else if (this.readLockCount > 0) {
            if (lockObject == null) {
                System.out.println("Try to allocate more lock in inner isolation region!");
                throw new RuntimeException("Isolation error!!");
            }
            if (!this.lockSet.contains(lockObject)) {
                System.out.println("Try to allocate more lock in inner isolation region!");
                throw new RuntimeException("Isolation error!!");
            }
        } else {
            if (lockObject == null) {
                ++this.writeLockCount;
            } else {
                ++this.readLockCount;
                this.lockSet.add(lockObject);
            }
            return true;
        }
        return false;
    }

    public boolean registerLockObjects(Object[] lockObjects) {
        if (this.writeLockCount > 0) {
            if (lockObjects == null) {
                ++this.writeLockCount;
            } else {
                ++this.readLockCount;
            }
        } else if (this.readLockCount > 0) {
            if (lockObjects == null) {
                System.out.println("Try to allocate more lock in inner isolation region!");
                throw new RuntimeException("Isolation error!!");
            }
            for (Object lockObject : lockObjects) {
                if (this.lockSet.contains(lockObject)) continue;
                System.out.println("Try to allocate more lock in inner isolation region!");
                throw new RuntimeException("Isolation error!!");
            }
        } else {
            if (lockObjects == null) {
                ++this.writeLockCount;
            } else {
                ++this.readLockCount;
                Collections.addAll(this.lockSet, lockObjects);
            }
            return true;
        }
        return false;
    }

    public void releaseLockObjects(Object lockObject) {
        if (lockObject != null) {
            --this.readLockCount;
        } else {
            --this.writeLockCount;
        }
        this.lockSet.clear();
    }
}

