/*
 * Decompiled with CFR 0.152.
 */
package hj.runtime.wsh;

import hj.lang.BlockedException;
import hj.lang.PhaserAbst;
import hj.lang.accumulator;
import hj.runtime.wsh.WshFuture;
import hj.runtime.wsh.finishAccumulator.FinishAccumulatorManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FinishState {
    protected Stack<Throwable> finish_;
    protected List<PhaserAbst> phaserList = new ArrayList<PhaserAbst>();
    protected FinishAccumulatorManager accumManager = null;
    private List<WshFuture> futureList;

    protected FinishState() {
    }

    public abstract void notifySubActivitySpawn();

    public abstract void notifySubActivityTermination();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushException(Throwable t) {
        if (t instanceof BlockedException) {
            return;
        }
        FinishState finishState = this;
        synchronized (finishState) {
            t.printStackTrace();
            this.getFinishStack().push(t);
        }
    }

    private Stack<Throwable> getFinishStack() {
        if (this.finish_ == null) {
            this.finish_ = new Stack();
        }
        return this.finish_;
    }

    public void notifySubActivityTermination(Throwable t) {
        this.pushException(t);
        this.notifySubActivityTermination();
    }

    public Stack exceptions() {
        if (this.futureList != null) {
            for (WshFuture promise : this.futureList) {
                Throwable exception;
                if (promise.finished() || (exception = promise.getException()) == null) continue;
                this.getFinishStack().push(exception);
            }
        }
        return this.finish_;
    }

    public boolean containsPhaser(PhaserAbst ph) {
        return this.phaserList.contains(ph);
    }

    public boolean addPhaser(PhaserAbst ph) {
        return this.phaserList.add(ph);
    }

    public <P extends PhaserAbst> P[] getPhasers(P[] seedArray) {
        return (PhaserAbst[])this.phaserList.toArray(seedArray);
    }

    public void initializeFinishAccumulatorManager(List<accumulator> accums) {
        this.accumManager = new FinishAccumulatorManager(accums);
        this.accumManager.openFinishAccumulators();
    }

    public void finalizeFinishAccumulatorManager() {
        if (this.accumManager != null) {
            this.accumManager.closeFinishAccumulators();
        }
    }

    public void registerFailedFuture(WshFuture future) {
        if (this.futureList == null) {
            this.futureList = new ArrayList<WshFuture>();
        }
        this.futureList.add(future);
    }
}

