/*
 * Decompiled with CFR 0.152.
 */
package hj.runtime.wsh;

import hj.lang.Future;
import hj.runtime.wsh.Activity;
import hj.runtime.wsh.VMInterface;
import hj.runtime.wsh.WshRuntime_c;
import hj.runtime.wsh.abstractmetrics.AbstractMetrics;

public abstract class WshFuture
extends Future {
    private Throwable exception_;
    private long critPathOps = 0L;
    private long overheads = 0L;
    private long curIdealTime = 0L;

    public void setException(Throwable th) {
        this.exception_ = th;
    }

    public final Throwable getException() {
        return this.exception_;
    }

    protected void rethrowIfExceptionAvailable() {
        if (this.exception_ != null) {
            if (this.exception_ instanceof Error) {
                throw (Error)this.exception_;
            }
            if (this.exception_ instanceof RuntimeException) {
                throw (RuntimeException)this.exception_;
            }
            assert (false);
        }
    }

    public abstract void setResult(Object var1);

    protected final void storeExecutionStats() {
        this.maxCritPathOps(((AbstractMetrics)((Object)WshRuntime_c.getCurrentActivity())).getCritPathOps());
        this.maxOverheads(((AbstractMetrics)((Object)WshRuntime_c.getCurrentActivity())).getOverheads());
        if (VMInterface.ABSTRACT_EXECUTION_TIMES) {
            ((AbstractMetrics)((Object)WshRuntime_c.getCurrentActivity())).updateIdealTime();
            this.maxIdealTime(((AbstractMetrics)((Object)WshRuntime_c.getCurrentActivity())).getCritPathTime());
        }
    }

    protected final void restoreExecutionStats() {
        ((Activity)WshRuntime_c.getCurrentActivity()).maxCritPathOps(this.getCritPathOps());
        ((Activity)WshRuntime_c.getCurrentActivity()).maxOverheads(this.getOverheads());
        if (VMInterface.ABSTRACT_EXECUTION_TIMES) {
            ((Activity)WshRuntime_c.getCurrentActivity()).maxCritPathTime(this.getIdealTime());
            ((Activity)WshRuntime_c.getCurrentActivity()).setResumeTime();
        }
    }

    public synchronized void maxCritPathOps(long n) {
        this.critPathOps = Math.max(this.critPathOps, n);
    }

    public long getCritPathOps() {
        return this.critPathOps;
    }

    public synchronized void maxOverheads(long n) {
        this.overheads = Math.max(this.overheads, n);
    }

    public long getOverheads() {
        return this.overheads;
    }

    public synchronized void maxIdealTime(long t) {
        this.curIdealTime = Math.max(this.curIdealTime, t);
    }

    public long getIdealTime() {
        return this.curIdealTime;
    }
}

