/*
 * Decompiled with CFR 0.152.
 */
package hj.runtime.wsh.actor;

import hj.runtime.common.Configuration;
import hj.runtime.wsh.Activity;
import hj.runtime.wsh.Place;
import hj.runtime.wsh.WshRuntime_c;
import hj.runtime.wsh.actor.LingeringActivity;
import hj.runtime.wsh.actor.LingeringBlockingActivity;
import hj.runtime.wsh.actor.LingeringSuspendableActivity;
import hj.runtime.wsh.actor.RunnableBlockingActivity;
import hj.runtime.wsh.actor.RunnableSuspendableActivity;

public class ActorRuntimeHelper {
    private ActorRuntimeHelper() {
    }

    public static Activity newRunnableActivity(LingeringActivity parentActivity, Place place2, String name, Runnable runnable) {
        Activity childActivity;
        if (Configuration.isWorkSharingBlockingRuntime()) {
            childActivity = new RunnableBlockingActivity(name, runnable);
        } else if (Configuration.isWorkSharingCooperativeRuntime()) {
            childActivity = new RunnableSuspendableActivity(name, runnable);
        } else {
            throw new IllegalStateException("Current runtime unsupported for actors!");
        }
        childActivity.setPlace(place2);
        parentActivity.finalizeActorActivitySpawn(childActivity);
        return childActivity;
    }

    public static LingeringActivity newLingeringActivity(String name) {
        Activity activity2;
        Place place2 = (Place)WshRuntime_c.here();
        if (Configuration.isWorkSharingBlockingRuntime()) {
            activity2 = new LingeringBlockingActivity(name);
        } else if (Configuration.isWorkSharingCooperativeRuntime()) {
            activity2 = new LingeringSuspendableActivity(name);
        } else {
            throw new IllegalStateException("Current runtime unsupported for actors!");
        }
        place2.runAsync(activity2);
        return activity2;
    }

    public static void resumeLingeringActivity(LingeringActivity activity2) {
        if (!activity2.isReady()) {
            activity2.forceReady();
            activity2.finalizeTermination();
        }
    }
}

