/*
 * Decompiled with CFR 0.152.
 */
package hj.runtime.wsh.actor;

import hj.runtime.wsh.actor.IsolationWorker;
import hj.runtime.wsh.cooperative.DataDrivenControl;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class IsolatedMessage {
    public static Object EXIT_MSG = new Object();
    private final List<IsolationWorker> workers;
    private final Runnable block;
    private final List<DataDrivenControl<Boolean>> futures;
    private final CountDownLatch latch = new CountDownLatch(1);
    private int progressIndex;

    IsolatedMessage(List<IsolationWorker> workers, Runnable block) {
        this.workers = workers;
        this.block = block;
        this.futures = new ArrayList<DataDrivenControl<Boolean>>(workers.size());
        this.progressIndex = 0;
    }

    protected int progressIndex() {
        return this.progressIndex;
    }

    protected void addDdf(DataDrivenControl<Boolean> ddf) {
        this.futures.add(ddf);
    }

    protected void await() {
        try {
            this.latch.await();
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
    }

    protected void release() {
        for (DataDrivenControl<Boolean> dataDrivenControl : this.futures) {
            dataDrivenControl.setValue(Boolean.TRUE);
        }
        this.latch.countDown();
    }

    protected IsolationWorker nextActor() {
        if (this.progressIndex >= this.workers.size()) {
            return null;
        }
        IsolationWorker actor = this.workers.get(this.progressIndex);
        ++this.progressIndex;
        return actor;
    }

    protected void executeTask() {
        if (this.progressIndex < this.workers.size()) {
            throw new IllegalStateException("Insufficient locks attained! Expected " + this.workers.size() + ", obtained: " + this.progressIndex);
        }
        this.block.run();
    }
}

