/*
 * Decompiled with CFR 0.152.
 */
package hj.runtime.wsh.actor;

import hj.runtime.wsh.actor.IsolatedMessage;
import hj.runtime.wsh.actor.IsolationManager;
import hj.runtime.wsh.actor.IsolationWorker;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IsolationHelper {
    private static int numberOfBins = 10;
    private final IsolationWorker[] isolationWorkers;
    private final IsolationManager isolationManager;
    private final AtomicBoolean active = new AtomicBoolean(true);

    public IsolationHelper() {
        this.isolationWorkers = new IsolationWorker[numberOfBins];
        IsolationWorker prevWorker = null;
        for (int i = numberOfBins; i > 0; --i) {
            IsolationWorker loopWorker;
            this.isolationWorkers[i - 1] = loopWorker = new IsolationWorker(i, prevWorker);
            loopWorker.start();
            prevWorker = loopWorker;
        }
        this.isolationManager = new IsolationManager(prevWorker);
        this.isolationManager.start();
    }

    public void shutdown() {
        this.active.set(false);
        this.isolationManager.send(IsolatedMessage.EXIT_MSG);
    }

    public void asynchronousAtomicBlock(Runnable block) {
        if (!this.active.get()) {
            throw new IllegalStateException("Isolation helper has been shutdown!");
        }
        this.executeAtomicBlock(false, block, Collections.<Object>emptyList());
    }

    public void asynchronousAtomicBlock(Runnable block, List<Object> locks) {
        if (!this.active.get()) {
            throw new IllegalStateException("Isolation helper has been shutdown!");
        }
        this.executeAtomicBlock(false, block, locks);
    }

    public void synchronousAtomicBlock(Runnable block) {
        if (!this.active.get()) {
            throw new IllegalStateException("Isolation helper has been shutdown!");
        }
        this.executeAtomicBlock(true, block, Collections.<Object>emptyList());
    }

    public void synchronousAtomicBlock(Runnable block, List<Object> locks) {
        if (!this.active.get()) {
            throw new IllegalStateException("Isolation helper has been shutdown!");
        }
        this.executeAtomicBlock(true, block, locks);
    }

    private void executeAtomicBlock(boolean synchronous, Runnable block, List<Object> locks) {
        List<IsolationWorker> workers;
        if (locks.size() > 0) {
            HashSet<Integer> objectBinSet = new HashSet<Integer>();
            for (Object lock : locks) {
                objectBinSet.add(Math.abs(lock.hashCode() % numberOfBins));
            }
            ArrayList objectBinList = new ArrayList(objectBinSet);
            Collections.sort(objectBinList);
            workers = new ArrayList<IsolationWorker>(objectBinList.size());
            for (Integer binNumber : objectBinList) {
                workers.add(this.isolationWorkers[binNumber]);
            }
        } else {
            workers = Arrays.asList(this.isolationWorkers);
        }
        IsolatedMessage message = new IsolatedMessage(workers, block);
        if (this.active.get()) {
            this.isolationManager.send(message);
            if (synchronous) {
                message.await();
            }
        } else {
            throw new IllegalStateException("Isolation helper has been shutdown!");
        }
    }
}

