/*
 * Decompiled with CFR 0.152.
 */
package hj.runtime.wsh.actor;

import hj.lang.Actor;
import hj.runtime.wsh.actor.IsolatedMessage;
import hj.runtime.wsh.actor.ResumableBlock;
import hj.runtime.wsh.cooperative.DataDrivenControl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class IsolationWorker
extends Actor<Object> {
    private final int id;
    private final IsolationWorker nextActor;

    IsolationWorker(int id, IsolationWorker nextActor) {
        this.id = id;
        this.nextActor = nextActor;
    }

    @Override
    protected void process(Object theMsg) {
        if (theMsg instanceof IsolatedMessage) {
            IsolatedMessage message = (IsolatedMessage)theMsg;
            IsolationWorker nextWorker = message.nextActor();
            if (nextWorker == null) {
                message.executeTask();
                message.release();
            } else {
                DataDrivenControl<Boolean> ddc = new DataDrivenControl<Boolean>();
                message.addDdf(ddc);
                this.pause();
                ddc.addResumable(new ResumableBlock(new Runnable(){

                    public void run() {
                        IsolationWorker.this.resume();
                    }
                }));
                nextWorker.send(theMsg);
            }
        } else if (theMsg == IsolatedMessage.EXIT_MSG) {
            if (this.nextActor != null) {
                this.nextActor.send(IsolatedMessage.EXIT_MSG);
            }
            this.exit();
        }
    }
}

