/*
 * Decompiled with CFR 0.152.
 */
package hj.runtime.wsh.blocking;

import hj.lang.Runtime;
import hj.runtime.common.Configuration;
import hj.runtime.wsh.Activity;
import hj.runtime.wsh.Place;
import hj.runtime.wsh.PoolRunner;
import hj.runtime.wsh.Report;
import hj.runtime.wsh.VMInterface;
import hj.runtime.wsh.WshFuture;
import hj.runtime.wsh.blocking.BlockingFinishState;
import hj.runtime.wsh.blocking.InvocationStrategy;
import hj.runtime.wsh.blocking.WshBlockingRuntime;
import hj.runtime.wsh.phaser.PhaserImpl;
import hj.runtime.wsh.phaser.PhaserManager;
import hj.runtime.wsh.phaser.PhaserManagerFactory;
import hj.runtime.wsh.phaser.PhaserManagerImpl;
import hj.runtime.wsh.phaser.PhaserRegModeImpl;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BlockingActivity
extends Activity {
    public volatile PhaserManagerImpl phaserManager;
    private InvocationStrategy invocationStrategy = InvocationStrategy.ASYNC;

    protected BlockingActivity(String name) {
        super(name);
    }

    protected BlockingActivity(List<PhaserRegModeImpl> phaserRegModeList, String name) {
        super(name);
        if (!phaserRegModeList.isEmpty()) {
            this.phaserManager = (PhaserManagerImpl)PhaserManagerFactory.getPhaserManager(this, phaserRegModeList);
        }
        this.initializeActivity();
    }

    @Override
    protected BlockingFinishState newFinishState() {
        return new BlockingFinishState(this);
    }

    public PhaserManager getPhaserManager() {
        return this.phaserManager;
    }

    private void initializeActivity() {
        if (Report.should_report("activity", 5)) {
            Report.report(5, "Activity: initializing " + this);
        }
        this.registerPhasers();
        if (VMInterface.ABSTRACT_EXECUTION_TIMES) {
            this.setResumeTime();
        }
    }

    @Override
    protected void prepareToRunInFinish() {
        this.invocationStrategy = InvocationStrategy.ASYNC_IN_FINISH;
    }

    @Override
    protected WshFuture initializeFuture() {
        WshFuture wshFuture;
        this.future = wshFuture = WshBlockingRuntime.createFuture();
        return wshFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        PoolRunner activityRunner = (PoolRunner)((Object)Thread.currentThread());
        if (Report.should_report("activity", 5)) {
            Report.report(5, activityRunner + " is running " + this);
        }
        activityRunner.setActivity(this);
        activityRunner.setPlace(this.getPlace());
        try {
            this.invocationStrategy.invokeHjTask(this);
        }
        catch (Throwable t) {
            this.success = false;
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
        }
        finally {
            if (this.waitList != null) {
                this.waitList.clear();
            }
            this.setFinished();
        }
    }

    public abstract void runHjTask();

    public void stopFinish() {
        this.preWaitForFinishProcessing();
        ((BlockingFinishState)this.finishState_).waitForFinish();
        this.postWaitForFinishProcessing();
    }

    protected final void preWaitForFinishProcessing() {
        if (this.phaserManager != null && this.phaserManager.hasAcyclicPhaser) {
            this.phaserManager.detectAcyclicPhasersOnCycle();
        }
        if (this.getPhaserManager() != null) {
            PhaserImpl.dropAllPhasers((PhaserImpl[])this.finishState_.getPhasers(new PhaserImpl[0]), this);
        }
        if (Report.should_report("activity", 5)) {
            Report.report(5, this + " enters stopfinish ");
        }
    }

    @Override
    protected void finalizeTerminationCleanup() {
        if (Configuration.ABSTRACT_EXECUTION_STATS) {
            ((Place)Runtime.here()).maxCritPathOps(this.getCritPathOps());
            ((Place)Runtime.here()).addLocalOps(this.getTotalOps());
            ((Place)Runtime.here()).maxOverheads(this.getOverheads());
            if (VMInterface.ABSTRACT_EXECUTION_TIMES) {
                this.updateIdealTime();
                ((Place)Runtime.here()).addUnblockedTime(this.getTotalUnblockedTime());
                ((Place)Runtime.here()).maxCritPathTime(this.getCritPathTime());
            }
        }
        if (this.phaserManager != null && this.phaserManager.hasAcyclicPhaser) {
            this.phaserManager.detectAcyclicPhasersOnCycle();
        }
        this.dropAllPhasers();
        if (Report.should_report("activity", 5)) {
            Report.report(5, Thread.currentThread() + " " + this + " drops phasers, has rootNode_ " + this.rootNode_);
        }
    }

    public void addPhaser(PhaserRegModeImpl pr) {
        if (this.phaserManager != null) {
            this.phaserManager.addPhaser(pr);
        } else {
            this.phaserManager = (PhaserManagerImpl)PhaserManagerFactory.getPhaserManager(this, pr);
        }
    }

    public void dropPhaser(PhaserImpl ph) {
        if (this.phaserManager != null) {
            this.phaserManager.dropPhaser(ph);
            if (this.phaserManager.getNbRegisteredPhasers() == 0) {
                this.phaserManager = null;
            }
        } else if (Report.should_report("Phaser", 3)) {
            Report.report(3, this + " dropPhaser attempt failed because no phasers are registered in this activity " + ph + ".");
        }
    }

    protected void dropAllPhasers() {
        if (this.phaserManager != null) {
            this.phaserManager.dropAllPhasers();
            this.phaserManager = null;
        } else if (Report.should_report("Phaser", 3)) {
            Report.report(3, "dropAllPhasers attempt failed because no phasers are registered in this activity ");
        }
    }

    public void doNext() {
        if (this.phaserManager != null) {
            this.phaserManager.doNext();
        } else if (Report.should_report("Phaser", 3)) {
            Report.report(3, "doNext attempt failed because no phasers are registered in this activity ");
        }
    }

    public void doSignal() {
        if (this.phaserManager != null) {
            this.phaserManager.doSignal();
        } else if (Report.should_report("Phaser", 3)) {
            Report.report(3, "signal attempt failed because no phasers are registered in this activity ");
        }
    }

    public void doWait() {
        if (this.phaserManager != null) {
            this.phaserManager.doWait();
        } else if (Report.should_report("Phaser", 3)) {
            Report.report(3, "doWait attempt failed because no phasers are registered in this activity ");
        }
    }

    public int doNext1(String loc) {
        int ret = 0;
        if (this.phaserManager != null) {
            ret = this.phaserManager.doNext1(loc);
        } else {
            if (Report.should_report("Phaser", 3)) {
                Report.report(3, "doNext1 attempt failed because no phasers are registered in this activity ");
            }
            assert (false);
        }
        return ret;
    }

    public void doNext2() {
        if (this.phaserManager != null) {
            this.phaserManager.doNext2();
        } else {
            if (Report.should_report("Phaser", 3)) {
                Report.report(3, "doNext2 attempt failed because no phasers are registered in this activity ");
            }
            assert (false);
        }
    }

    public List<PhaserRegModeImpl> getPhaserRegModeList() {
        if (this.phaserManager != null) {
            return this.phaserManager.getPhaserRegModeList();
        }
        return Collections.emptyList();
    }

    public int getNbRegisteredPhasers() {
        if (this.phaserManager == null) {
            return 0;
        }
        return this.phaserManager.getNbRegisteredPhasers();
    }

    public void registerPhasers() {
        if (this.phaserManager != null) {
            this.phaserManager.registerPhasers();
        }
    }
}

