/*
 * Decompiled with CFR 0.152.
 */
package hj.runtime.wsh.blocking;

import hj.runtime.common.Configuration;
import hj.runtime.wsh.Activity;
import hj.runtime.wsh.FinishState;
import hj.runtime.wsh.HjManagedBlocker;
import hj.runtime.wsh.PoolRunner;
import hj.runtime.wsh.Report;
import hj.runtime.wsh.VMInterface;
import hj.runtime.wsh.WshRuntime_c;
import hj.runtime.wsh.blocking.ModCountDownLatch;

public class BlockingFinishState
extends FinishState
implements HjManagedBlocker {
    protected ModCountDownLatch mcdl = new ModCountDownLatch(0);
    private final Activity activity;

    public BlockingFinishState(Activity activity2) {
        this.activity = activity2;
    }

    public void waitForFinish() {
        if (this.mcdl.getCount() > 0L) {
            PoolRunner activityRunner = (PoolRunner)((Object)Thread.currentThread());
            activityRunner.getPlace().threadBlockedNotification(this);
        }
        if (Configuration.ABSTRACT_EXECUTION_STATS) {
            ((Activity)WshRuntime_c.getCurrentActivity()).maxCritPathOps(this.mcdl.getCritPathOps());
            ((Activity)WshRuntime_c.getCurrentActivity()).maxOverheads(this.mcdl.getOverheads());
            if (VMInterface.ABSTRACT_EXECUTION_TIMES) {
                ((Activity)WshRuntime_c.getCurrentActivity()).maxCritPathTime(this.mcdl.getIdealTime());
                ((Activity)WshRuntime_c.getCurrentActivity()).setResumeTime();
            }
        }
    }

    public void notifySubActivitySpawn() {
        this.mcdl.updateCount();
        if (Report.should_report("activity", 5)) {
            Report.report(5, " updating " + this.toString());
        }
    }

    public void notifySubActivityTermination() {
        this.mcdl.countDown();
    }

    public boolean block() throws InterruptedException {
        try {
            this.mcdl.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return true;
    }

    public boolean isReleasable() {
        return this.mcdl.getCount() == 0L;
    }

    public synchronized String toString() {
        return "<BlockingFinishState " + this.hashCode() + " " + this.mcdl.getCount() + "," + this.activity.shortString() + "," + this.finish_ + ">";
    }
}

