/*
 * Decompiled with CFR 0.152.
 */
package hj.runtime.wsh.blocking;

import hj.runtime.common.Configuration;
import hj.runtime.wsh.PoolRunner;
import hj.runtime.wsh.WshFuture;
import hj.runtime.wsh.blocking.ModCountDownLatch;

public final class Future_c
extends WshFuture {
    private Object result_;
    private boolean completed_;
    private boolean forced_;
    private ModCountDownLatch cdl = new ModCountDownLatch(1);

    public void setResult(Object result) {
        this.result_ = result;
        this.setCompleted();
    }

    public void setException(Throwable t) {
        super.setException(t);
        this.setCompleted();
    }

    protected void setCompleted() {
        this.completed_ = true;
        if (this.cdl.getCount() > 0L) {
            if (Configuration.ABSTRACT_EXECUTION_STATS) {
                this.storeExecutionStats();
            }
            this.cdl.countDown();
        }
    }

    public Object get() {
        PoolRunner t = (PoolRunner)((Object)Thread.currentThread());
        if (this.cdl.getCount() > 0L) {
            t.getPlace().threadBlockedNotification();
            try {
                this.cdl.await();
            }
            catch (InterruptedException ie) {
                System.err.println("Future_c::get - unexpected exception e" + ie);
                throw new Error(ie);
            }
            t.getPlace().threadUnblockedNotification();
        }
        if (Configuration.ABSTRACT_EXECUTION_STATS) {
            this.restoreExecutionStats();
        }
        this.forced_ = true;
        this.rethrowIfExceptionAvailable();
        return this.result_;
    }

    protected boolean completed() {
        return this.completed_;
    }

    public boolean finished() {
        return this.forced_;
    }
}

